/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverAction;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.regex.Pattern;
import oracle.pg.rdbms.AdbGraphClient;
import oracle.pg.rdbms.AdbGraphClientConfiguration;
import oracle.pg.rdbms.GraphServer;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.ServerInstance;
import oracle.pgx.jdbc.PgxConnection;
import oracle.pgx.jdbc.Util;
import oracle.pgx.jdbc.compat.CompatMode;
import oracle.pgx.jdbc.compat.OracleJdbc19CompatMode;
import oracle.pgx.jdbc.compat.OracleJdbc23CompatMode;
import oracle.pgx.jdbc.compat.PgxCompatMode;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgxJdbcDriver
implements Driver,
DriverAction {
    private static final Logger log = LoggerFactory.getLogger(PgxJdbcDriver.class);
    static final String JDBC_URL_PREFIX = "jdbc:oracle:pgx:";
    static final String EMBEDDED_IDENTIFIER = "embedded";
    static final String SESSION_IDENTIFIER = "PGX-JDBC";
    static final String DEFAULT_PGX_MEMORY = "16";
    static final Properties DRIVER_PROPERTIES = new Properties();

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)info);
        ServerInstance instance = PgxJdbcDriver.createServerInstance(url, properties);
        String userName = properties.getProperty("user");
        PgxConnection connection = Util.invokePgxApi(() -> {
            PgxSession session = instance.createSession(SESSION_IDENTIFIER);
            return new PgxConnection(this, url, userName, instance, session);
        });
        connection.setCompatMode(PgxJdbcDriver.createCompatMode(properties));
        AdbGraphClient client = (AdbGraphClient)properties.get(AdbGraphClient.class.getName());
        connection.setAdbGraphClient(client);
        String stopValue = properties.getProperty("adbgraphclient_stop_on_close", "false");
        connection.setStopEnvUponClose(stopValue.equalsIgnoreCase("true"));
        return connection;
    }

    private static void startEnvironment(AdbGraphClient client, Properties properties) throws SQLException {
        String memoryValue = properties.getProperty("adbgraphclient_memory", DEFAULT_PGX_MEMORY);
        try {
            int memory = Integer.parseInt(memoryValue);
            if (!client.isAttached()) {
                client.startEnvironment(memory).get();
            }
        }
        catch (NumberFormatException e) {
            throw new SQLException("cannot parse given adbgraphclient_memory value: " + memoryValue, e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SQLException("failed to start environment", e);
        }
        properties.put(AdbGraphClient.class.getName(), client);
    }

    private static CompatMode createCompatMode(Properties info) {
        String value;
        switch (value = info.getProperty("compat_mode", "pgx")) {
            case "oracle_jdbc19": {
                return new OracleJdbc19CompatMode();
            }
            case "oracle_jdbc23": {
                return new OracleJdbc23CompatMode();
            }
            case "pgx": {
                return new PgxCompatMode();
            }
        }
        throw new IllegalArgumentException("unknown compatibility mode: " + value);
    }

    private static ServerInstance createServerInstance(String url, Properties properties) throws SQLException {
        String database;
        String databaseOcid;
        String urlWithoutPrefix = url.substring(JDBC_URL_PREFIX.length());
        if (urlWithoutPrefix.equalsIgnoreCase(EMBEDDED_IDENTIFIER)) {
            return GraphServer.getEmbeddedInstance();
        }
        String userName = properties.getProperty("user");
        String password = properties.getProperty("password");
        if (StringUtils.isEmpty((CharSequence)password)) {
            throw new SQLException("password is missing");
        }
        if (urlWithoutPrefix.startsWith("@")) {
            String adbUrl = url.replaceFirst(Pattern.quote(JDBC_URL_PREFIX), "jdbc:oracle:thin:");
            AdbGraphClientConfiguration config = AdbGraphClientConfiguration.fromCredentials((String)adbUrl, (String)userName, (String)password);
            AdbGraphClient client = new AdbGraphClient(config);
            PgxJdbcDriver.startEnvironment(client, properties);
            return client.getPgxInstance();
        }
        if (!urlWithoutPrefix.toLowerCase().startsWith("http:") && !urlWithoutPrefix.toLowerCase().startsWith("https:")) {
            throw new SQLException("unsupported URL format " + url);
        }
        String tenancyOcid = properties.getProperty("tenancy_ocid");
        if (StringUtils.isAllEmpty((CharSequence[])new CharSequence[]{tenancyOcid, databaseOcid = properties.getProperty("database_ocid"), database = properties.getProperty("database")})) {
            try {
                return GraphServer.getInstance((String)urlWithoutPrefix, (String)userName, (char[])password.toCharArray());
            }
            catch (IOException e) {
                throw new SQLException(e);
            }
        }
        AdbGraphClientConfiguration config = AdbGraphClientConfiguration.builder().endpoint(urlWithoutPrefix).tenancyOcid(tenancyOcid).databaseOcid(databaseOcid).database(database).username(userName).password(password).build();
        AdbGraphClient client = new AdbGraphClient(config);
        PgxJdbcDriver.startEnvironment(client, properties);
        return client.getPgxInstance();
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        if (url == null) {
            throw new SQLException("null is not a valid url");
        }
        return url.split(":").length > 3 && url.startsWith(JDBC_URL_PREFIX);
    }

    @Override
    public int getMajorVersion() {
        return Integer.parseInt(DRIVER_PROPERTIES.getProperty("major"));
    }

    @Override
    public int getMinorVersion() {
        return Integer.parseInt(DRIVER_PROPERTIES.getProperty("minor"));
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void deregister() {
        try {
            GraphServer.getEmbeddedInstance().shutdownEngineNowIfRunning();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("failed to shut down embedded instance", (Throwable)e);
        }
    }

    static {
        try (InputStream is = PgxJdbcDriver.class.getResourceAsStream("/driver.properties");){
            PgxJdbcDriver pgxDriver = new PgxJdbcDriver();
            DriverManager.registerDriver(pgxDriver, pgxDriver);
            DRIVER_PROPERTIES.load(is);
        }
        catch (IOException | SQLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

