/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.net.URI;
import oracle.pgx.common.hypermedia.uri.UriBuilder;
import oracle.pgx.config.PgxConfig;

public class LinkTemplateUtils {
    private static PgxConfig pgxConfig;

    public static void initConfig(PgxConfig pgxConfig) {
        LinkTemplateUtils.pgxConfig = pgxConfig;
    }

    public static URI generateLink(URI baseURI, String text, Object ... params) {
        UriBuilder builder = baseURI != null ? UriBuilder.fromUri(baseURI).path(text) : UriBuilder.fromPath(text);
        return builder.build(params);
    }

    public static URI generateLink(String text, Object ... params) {
        if (pgxConfig == null) {
            return LinkTemplateUtils.generateLink(null, text, params);
        }
        String pgxServerBaseUrl = pgxConfig.getPgxServerBaseUrl();
        if (pgxServerBaseUrl != null) {
            return LinkTemplateUtils.generateLink(URI.create(pgxServerBaseUrl), text, params);
        }
        return LinkTemplateUtils.generateLink(null, text, params);
    }

    public static URI createUri(String path) {
        return LinkTemplateUtils.generateLink(path, new Object[0]);
    }
}

