/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.types.internal;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.common.types.Edge;
import oracle.pgx.common.types.Node;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.Type;
import oracle.pgx.common.types.Types;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.TemporalTypeUtils;

public enum ValueType implements Type
{
    PATH(List.class, new ArrayList<E>()),
    ARRAY(List.class, new ArrayList<E>()),
    INTEGER(Integer.class, 0),
    LONG(Long.class, 0L),
    FLOAT(Float.class, Float.valueOf(0.0f)),
    DOUBLE(Double.class, 0.0),
    BOOLEAN(Boolean.class, false),
    VERTEX(Node.class, -1),
    EDGE(Edge.class, -1L),
    STRING(String.class, ""),
    LOCAL_DATE(LocalDate.class, LocalDate.ofEpochDay(0L)),
    TIME(LocalTime.class, LocalTime.ofNanoOfDay(0L)),
    TIMESTAMP(LocalDateTime.class, TemporalTypeUtils.parseTimestamp((long)0L)),
    TIME_WITH_TIMEZONE(OffsetTime.class, TemporalTypeUtils.parseTimeWithTimezone((int)0, (int)0)),
    TIMESTAMP_WITH_TIMEZONE(OffsetDateTime.class, TemporalTypeUtils.parseTimestampWithTimezone((long)0L, (int)0)),
    RO_STRING_SET(Set.class, Collections.emptySet()),
    POINT2D(Point2D.class, new Point2D(0.0, 0.0)),
    INTERVAL(QueryExpression.Interval.class, new QueryExpression.Interval("0", QueryExpression.DateTimeField.SECOND));

    private final Class<?> typeClass;
    private final Object defaultValue;
    private static final Map<String, ValueType> ALIASES;

    private ValueType(Class<?> typeClass, Object defaultValue) {
        this.typeClass = typeClass;
        this.defaultValue = defaultValue;
    }

    public static PropertyType getPropertyType(ValueType valueType) {
        if (valueType == null) {
            return null;
        }
        switch (valueType) {
            case INTEGER: {
                return PropertyType.INTEGER;
            }
            case LONG: {
                return PropertyType.LONG;
            }
            case FLOAT: {
                return PropertyType.FLOAT;
            }
            case DOUBLE: {
                return PropertyType.DOUBLE;
            }
            case BOOLEAN: {
                return PropertyType.BOOLEAN;
            }
            case VERTEX: {
                return PropertyType.VERTEX;
            }
            case EDGE: {
                return PropertyType.EDGE;
            }
            case STRING: {
                return PropertyType.STRING;
            }
            case LOCAL_DATE: {
                return PropertyType.LOCAL_DATE;
            }
            case TIME: {
                return PropertyType.TIME;
            }
            case TIMESTAMP: {
                return PropertyType.TIMESTAMP;
            }
            case TIME_WITH_TIMEZONE: {
                return PropertyType.TIME_WITH_TIMEZONE;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return PropertyType.TIMESTAMP_WITH_TIMEZONE;
            }
            case RO_STRING_SET: {
                return PropertyType.RO_STRING_SET;
            }
            case POINT2D: {
                return PropertyType.POINT2D;
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_TYPE", (Object[])new Object[]{valueType}));
    }

    public static ValueType fromPropertyType(PropertyType propertyType) {
        if (propertyType == null) {
            return null;
        }
        switch (propertyType) {
            case INTEGER: {
                return INTEGER;
            }
            case LONG: {
                return LONG;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case BOOLEAN: {
                return BOOLEAN;
            }
            case VERTEX: {
                return VERTEX;
            }
            case EDGE: {
                return EDGE;
            }
            case STRING: {
                return STRING;
            }
            case LOCAL_DATE: {
                return LOCAL_DATE;
            }
            case TIME: {
                return TIME;
            }
            case TIMESTAMP: {
                return TIMESTAMP;
            }
            case TIME_WITH_TIMEZONE: {
                return TIME_WITH_TIMEZONE;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return TIMESTAMP_WITH_TIMEZONE;
            }
            case RO_STRING_SET: {
                return RO_STRING_SET;
            }
            case POINT2D: {
                return POINT2D;
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_TYPE", (Object[])new Object[]{propertyType}));
    }

    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @JsonValue
    public String toKey() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.toKey();
    }

    public boolean isNumericType() {
        switch (this) {
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isTemporalType() {
        switch (this) {
            case LOCAL_DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP_WITH_TIMEZONE: {
                return true;
            }
        }
        return false;
    }

    public boolean isTimeType() {
        switch (this) {
            case TIME: 
            case TIME_WITH_TIMEZONE: {
                return true;
            }
        }
        return false;
    }

    public boolean isTimestampType() {
        switch (this) {
            case TIMESTAMP: 
            case TIMESTAMP_WITH_TIMEZONE: {
                return true;
            }
        }
        return false;
    }

    public boolean isIntervalType() {
        return this == INTERVAL;
    }

    @JsonCreator
    public static ValueType parsePropertyType(String input) {
        return (ValueType)Types.parse(ValueType.class, (String)input, ALIASES);
    }

    private static int valueTypeToNumeral(ValueType type) {
        switch (type) {
            case INTEGER: {
                return 0;
            }
            case LONG: {
                return 1;
            }
            case FLOAT: {
                return 2;
            }
            case DOUBLE: {
                return 3;
            }
            case TIME: {
                return 4;
            }
            case TIME_WITH_TIMEZONE: {
                return 5;
            }
            case TIMESTAMP: {
                return 6;
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return 7;
            }
        }
        throw new IllegalArgumentException("type");
    }

    public static ValueType getCombinedType(ValueType leftType, ValueType rightType) {
        int ordRight;
        boolean bothTypesAreTimestamp;
        if (leftType == null || rightType == null) {
            if (rightType != null && rightType.isIntervalType()) {
                return null;
            }
            if (leftType != null && leftType.isIntervalType()) {
                return null;
            }
            ValueType otherType = leftType == null ? rightType : leftType;
            return otherType;
        }
        if (leftType == VERTEX || rightType == VERTEX) {
            return VERTEX;
        }
        if (leftType.isIntervalType()) {
            return rightType;
        }
        if (rightType.isIntervalType()) {
            return leftType;
        }
        boolean bothTypesAreNumeric = leftType.isNumericType() && rightType.isNumericType();
        boolean bothTypesAreTime = leftType.isTimeType() && rightType.isTimeType();
        boolean bl = bothTypesAreTimestamp = leftType.isTimestampType() && rightType.isTimestampType();
        if (!(bothTypesAreNumeric || bothTypesAreTime || bothTypesAreTimestamp)) {
            return leftType;
        }
        int ordLeft = ValueType.valueTypeToNumeral(leftType);
        return ordLeft > (ordRight = ValueType.valueTypeToNumeral(rightType)) ? leftType : rightType;
    }

    static {
        ALIASES = new HashMap<String, ValueType>();
        ALIASES.put("INT", INTEGER);
        ALIASES.put("NODE", VERTEX);
        ALIASES.put("TIME WITH TIMEZONE", TIME_WITH_TIMEZONE);
        ALIASES.put("TIMESTAMP WITH TIMEZONE", TIMESTAMP_WITH_TIMEZONE);
    }
}

