/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;

public abstract class Entity
extends Self {
    protected final PgxId graphId;
    protected final String tableName;
    protected final Object key;
    protected final IdType keyType;

    protected static Object adaptKey(IdType keyType, Object origKey) {
        if (origKey == null) {
            return null;
        }
        switch (keyType) {
            case INTEGER: {
                if (origKey instanceof Integer) {
                    return origKey;
                }
                if (origKey instanceof Long) {
                    return Math.toIntExact((Long)origKey);
                }
                if (origKey instanceof String) {
                    return Integer.parseInt((String)origKey);
                }
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_KEY_TYPE", (Object[])new Object[]{origKey.getClass().getSimpleName()}));
            }
            case LONG: {
                if (origKey instanceof Integer) {
                    return (long)((Integer)origKey).intValue();
                }
                if (origKey instanceof Long) {
                    return origKey;
                }
                if (origKey instanceof String) {
                    return Long.parseLong((String)origKey);
                }
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_KEY_TYPE", (Object[])new Object[]{origKey.getClass().getSimpleName()}));
            }
            case STRING: {
                if (origKey instanceof Integer) {
                    return ((Integer)origKey).toString();
                }
                if (origKey instanceof Long) {
                    return ((Long)origKey).toString();
                }
                if (origKey instanceof String) {
                    return origKey;
                }
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_KEY_TYPE", (Object[])new Object[]{origKey.getClass().getSimpleName()}));
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_KEY_TYPE", (Object[])new Object[]{origKey.getClass().getSimpleName()}));
    }

    protected Entity(PgxId graphId, String tableName, IdType keyType, Object key) {
        super(key);
        this.graphId = graphId;
        this.tableName = tableName;
        this.keyType = keyType;
        this.key = Entity.adaptKey(keyType, key);
        this.injectLinks();
    }

    public PgxId getGraphId() {
        return this.graphId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public IdType getIdType() {
        return this.keyType;
    }

    public Object getKey() {
        return this.key;
    }

    public abstract void injectLinks();

    public abstract EntityType getEntityType();

    @JsonIgnore
    public abstract boolean isFromDefaultTable();
}

