# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class CategoryType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of the diagnostic settings category.
    """

    METRICS = "Metrics"
    LOGS = "Logs"

class ComparisonOperationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """the operator that is used to compare the metric data and the threshold.
    """

    EQUALS = "Equals"
    NOT_EQUALS = "NotEquals"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    LESS_THAN = "LessThan"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"

class CreatedByType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class MetricStatisticType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """the metric statistic type. How the metrics from multiple instances are combined.
    """

    AVERAGE = "Average"
    MIN = "Min"
    MAX = "Max"
    SUM = "Sum"
    COUNT = "Count"

class PredictiveAutoscalePolicyScaleMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """the predictive autoscale mode
    """

    DISABLED = "Disabled"
    FORECAST_ONLY = "ForecastOnly"
    ENABLED = "Enabled"

class RecurrenceFrequency(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """the recurrence frequency. How often the schedule profile should take effect. This value must be
    Week, meaning each week will have the same set of profiles. For example, to set a daily
    schedule, set **schedule** to every day of the week. The frequency property specifies that the
    schedule is repeated weekly.
    """

    NONE = "None"
    SECOND = "Second"
    MINUTE = "Minute"
    HOUR = "Hour"
    DAY = "Day"
    WEEK = "Week"
    MONTH = "Month"
    YEAR = "Year"

class ScaleDirection(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """the scale direction. Whether the scaling action increases or decreases the number of instances.
    """

    NONE = "None"
    INCREASE = "Increase"
    DECREASE = "Decrease"

class ScaleRuleMetricDimensionOperationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """the dimension operator. Only 'Equals' and 'NotEquals' are supported. 'Equals' being equal to
    any of the values. 'NotEquals' being not equal to all of the values
    """

    EQUALS = "Equals"
    NOT_EQUALS = "NotEquals"

class ScaleType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """the type of action that should occur when the scale rule fires.
    """

    CHANGE_COUNT = "ChangeCount"
    PERCENT_CHANGE_COUNT = "PercentChangeCount"
    EXACT_COUNT = "ExactCount"
    SERVICE_ALLOWED_NEXT_VALUE = "ServiceAllowedNextValue"

class TimeAggregationType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """time aggregation type. How the data that is collected should be combined over time. The default
    value is Average.
    """

    AVERAGE = "Average"
    MINIMUM = "Minimum"
    MAXIMUM = "Maximum"
    TOTAL = "Total"
    COUNT = "Count"
    LAST = "Last"
