# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class AutoscaleErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param error: The error object.
    :type error: ~$(python-base-namespace).v2021_05_01_preview.models.AutoscaleErrorResponseError
    :ivar system_data: The system metadata related to the response.
    :vartype system_data: ~$(python-base-namespace).v2021_05_01_preview.models.SystemData
    """

    _validation = {
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'AutoscaleErrorResponseError'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)
        self.system_data = None


class AutoscaleErrorResponseError(msrest.serialization.Model):
    """The error object.

    :param code: One of a server-defined set of error codes.
    :type code: str
    :param message: A human-readable representation of the error.
    :type message: str
    :param target: The target of the particular error.
    :type target: str
    :param details: A human-readable representation of the error's details.
    :type details: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleErrorResponseError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class AutoscaleNotification(msrest.serialization.Model):
    """Autoscale notification.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar operation: the operation associated with the notification and its value must be "scale".
     Has constant value: "Scale".
    :vartype operation: str
    :param email: the email notification.
    :type email: ~$(python-base-namespace).v2021_05_01_preview.models.EmailNotification
    :param webhooks: the collection of webhook notifications.
    :type webhooks: list[~$(python-base-namespace).v2021_05_01_preview.models.WebhookNotification]
    """

    _validation = {
        'operation': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'email': {'key': 'email', 'type': 'EmailNotification'},
        'webhooks': {'key': 'webhooks', 'type': '[WebhookNotification]'},
    }

    operation = "Scale"

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleNotification, self).__init__(**kwargs)
        self.email = kwargs.get('email', None)
        self.webhooks = kwargs.get('webhooks', None)


class AutoscaleProfile(msrest.serialization.Model):
    """Autoscale profile.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. the name of the profile.
    :type name: str
    :param capacity: Required. the number of instances that can be used during this profile.
    :type capacity: ~$(python-base-namespace).v2021_05_01_preview.models.ScaleCapacity
    :param rules: Required. the collection of rules that provide the triggers and parameters for
     the scaling action. A maximum of 10 rules can be specified.
    :type rules: list[~$(python-base-namespace).v2021_05_01_preview.models.ScaleRule]
    :param fixed_date: the specific date-time for the profile. This element is not used if the
     Recurrence element is used.
    :type fixed_date: ~$(python-base-namespace).v2021_05_01_preview.models.TimeWindow
    :param recurrence: the repeating times at which this profile begins. This element is not used
     if the FixedDate element is used.
    :type recurrence: ~$(python-base-namespace).v2021_05_01_preview.models.Recurrence
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'required': True},
        'rules': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'ScaleCapacity'},
        'rules': {'key': 'rules', 'type': '[ScaleRule]'},
        'fixed_date': {'key': 'fixedDate', 'type': 'TimeWindow'},
        'recurrence': {'key': 'recurrence', 'type': 'Recurrence'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleProfile, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.capacity = kwargs['capacity']
        self.rules = kwargs['rules']
        self.fixed_date = kwargs.get('fixed_date', None)
        self.recurrence = kwargs.get('recurrence', None)


class AutoscaleSettingResource(msrest.serialization.Model):
    """The autoscale setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Gets or sets a list of key value pairs that describe the resource.
     These tags can be used in viewing and grouping this resource (across resource groups). A
     maximum of 15 tags can be provided for a resource. Each tag must have a key no greater in
     length than 128 characters and a value no greater in length than 256 characters.
    :type tags: dict[str, str]
    :ivar system_data: The system metadata related to the response.
    :vartype system_data: ~$(python-base-namespace).v2021_05_01_preview.models.SystemData
    :param profiles: Required. the collection of automatic scaling profiles that specify different
     scaling parameters for different time periods. A maximum of 20 profiles can be specified.
    :type profiles: list[~$(python-base-namespace).v2021_05_01_preview.models.AutoscaleProfile]
    :param notifications: the collection of notifications.
    :type notifications:
     list[~$(python-base-namespace).v2021_05_01_preview.models.AutoscaleNotification]
    :param enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'true'.
    :type enabled: bool
    :param predictive_autoscale_policy: the predictive autoscale policy mode.
    :type predictive_autoscale_policy:
     ~$(python-base-namespace).v2021_05_01_preview.models.PredictiveAutoscalePolicy
    :param name_properties_name: the name of the autoscale setting.
    :type name_properties_name: str
    :param target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :type target_resource_uri: str
    :param target_resource_location: the location of the resource that the autoscale setting should
     be added to.
    :type target_resource_location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'profiles': {'required': True, 'max_items': 20, 'min_items': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'profiles': {'key': 'properties.profiles', 'type': '[AutoscaleProfile]'},
        'notifications': {'key': 'properties.notifications', 'type': '[AutoscaleNotification]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'predictive_autoscale_policy': {'key': 'properties.predictiveAutoscalePolicy', 'type': 'PredictiveAutoscalePolicy'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'target_resource_uri': {'key': 'properties.targetResourceUri', 'type': 'str'},
        'target_resource_location': {'key': 'properties.targetResourceLocation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleSettingResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)
        self.system_data = None
        self.profiles = kwargs['profiles']
        self.notifications = kwargs.get('notifications', None)
        self.enabled = kwargs.get('enabled', True)
        self.predictive_autoscale_policy = kwargs.get('predictive_autoscale_policy', None)
        self.name_properties_name = kwargs.get('name_properties_name', None)
        self.target_resource_uri = kwargs.get('target_resource_uri', None)
        self.target_resource_location = kwargs.get('target_resource_location', None)


class AutoscaleSettingResourceCollection(msrest.serialization.Model):
    """Represents a collection of autoscale setting resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the values for the autoscale setting resources.
    :type value:
     list[~$(python-base-namespace).v2021_05_01_preview.models.AutoscaleSettingResource]
    :param next_link: URL to get the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AutoscaleSettingResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleSettingResourceCollection, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.next_link = kwargs.get('next_link', None)


class AutoscaleSettingResourcePatch(msrest.serialization.Model):
    """The autoscale setting object for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param profiles: the collection of automatic scaling profiles that specify different scaling
     parameters for different time periods. A maximum of 20 profiles can be specified.
    :type profiles: list[~$(python-base-namespace).v2021_05_01_preview.models.AutoscaleProfile]
    :param notifications: the collection of notifications.
    :type notifications:
     list[~$(python-base-namespace).v2021_05_01_preview.models.AutoscaleNotification]
    :param enabled: the enabled flag. Specifies whether automatic scaling is enabled for the
     resource. The default value is 'true'.
    :type enabled: bool
    :param predictive_autoscale_policy: the predictive autoscale policy mode.
    :type predictive_autoscale_policy:
     ~$(python-base-namespace).v2021_05_01_preview.models.PredictiveAutoscalePolicy
    :param name: the name of the autoscale setting.
    :type name: str
    :param target_resource_uri: the resource identifier of the resource that the autoscale setting
     should be added to.
    :type target_resource_uri: str
    :param target_resource_location: the location of the resource that the autoscale setting should
     be added to.
    :type target_resource_location: str
    """

    _validation = {
        'profiles': {'max_items': 20, 'min_items': 0},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'profiles': {'key': 'properties.profiles', 'type': '[AutoscaleProfile]'},
        'notifications': {'key': 'properties.notifications', 'type': '[AutoscaleNotification]'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'predictive_autoscale_policy': {'key': 'properties.predictiveAutoscalePolicy', 'type': 'PredictiveAutoscalePolicy'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'target_resource_uri': {'key': 'properties.targetResourceUri', 'type': 'str'},
        'target_resource_location': {'key': 'properties.targetResourceLocation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AutoscaleSettingResourcePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.profiles = kwargs.get('profiles', None)
        self.notifications = kwargs.get('notifications', None)
        self.enabled = kwargs.get('enabled', True)
        self.predictive_autoscale_policy = kwargs.get('predictive_autoscale_policy', None)
        self.name = kwargs.get('name', None)
        self.target_resource_uri = kwargs.get('target_resource_uri', None)
        self.target_resource_location = kwargs.get('target_resource_location', None)


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DiagnosticSettingsCategoryResource(Resource):
    """The diagnostic settings category resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~$(python-base-namespace).v2021_05_01_preview.models.SystemData
    :param category_type: The type of the diagnostic settings category. Possible values include:
     "Metrics", "Logs".
    :type category_type: str or ~$(python-base-namespace).v2021_05_01_preview.models.CategoryType
    :param category_groups: the collection of what category groups are supported.
    :type category_groups: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'category_type': {'key': 'properties.categoryType', 'type': 'str'},
        'category_groups': {'key': 'properties.categoryGroups', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticSettingsCategoryResource, self).__init__(**kwargs)
        self.system_data = None
        self.category_type = kwargs.get('category_type', None)
        self.category_groups = kwargs.get('category_groups', None)


class DiagnosticSettingsCategoryResourceCollection(msrest.serialization.Model):
    """Represents a collection of diagnostic setting category resources.

    :param value: The collection of diagnostic settings category resources.
    :type value:
     list[~$(python-base-namespace).v2021_05_01_preview.models.DiagnosticSettingsCategoryResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiagnosticSettingsCategoryResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticSettingsCategoryResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class DiagnosticSettingsResource(Resource):
    """The diagnostic setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~$(python-base-namespace).v2021_05_01_preview.models.SystemData
    :param storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :type storage_account_id: str
    :param service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here to
     maintain backwards compatibility.
    :type service_bus_rule_id: str
    :param event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
    :type event_hub_authorization_rule_id: str
    :param event_hub_name: The name of the event hub. If none is specified, the default event hub
     will be selected.
    :type event_hub_name: str
    :param metrics: The list of metric settings.
    :type metrics: list[~$(python-base-namespace).v2021_05_01_preview.models.MetricSettings]
    :param logs: The list of logs settings.
    :type logs: list[~$(python-base-namespace).v2021_05_01_preview.models.LogSettings]
    :param workspace_id: The full ARM resource ID of the Log Analytics workspace to which you would
     like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :type workspace_id: str
    :param marketplace_partner_id: The full ARM resource ID of the Marketplace resource to which
     you would like to send Diagnostic Logs.
    :type marketplace_partner_id: str
    :param log_analytics_destination_type: A string indicating whether the export to Log Analytics
     should use the default destination type, i.e. AzureDiagnostics, or use a destination type
     constructed as follows: :code:`<normalized service identity>`_:code:`<normalized category
     name>`. Possible values are: Dedicated and null (null is default.).
    :type log_analytics_destination_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'event_hub_authorization_rule_id': {'key': 'properties.eventHubAuthorizationRuleId', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'metrics': {'key': 'properties.metrics', 'type': '[MetricSettings]'},
        'logs': {'key': 'properties.logs', 'type': '[LogSettings]'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'marketplace_partner_id': {'key': 'properties.marketplacePartnerId', 'type': 'str'},
        'log_analytics_destination_type': {'key': 'properties.logAnalyticsDestinationType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticSettingsResource, self).__init__(**kwargs)
        self.system_data = None
        self.storage_account_id = kwargs.get('storage_account_id', None)
        self.service_bus_rule_id = kwargs.get('service_bus_rule_id', None)
        self.event_hub_authorization_rule_id = kwargs.get('event_hub_authorization_rule_id', None)
        self.event_hub_name = kwargs.get('event_hub_name', None)
        self.metrics = kwargs.get('metrics', None)
        self.logs = kwargs.get('logs', None)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.marketplace_partner_id = kwargs.get('marketplace_partner_id', None)
        self.log_analytics_destination_type = kwargs.get('log_analytics_destination_type', None)


class DiagnosticSettingsResourceCollection(msrest.serialization.Model):
    """Represents a collection of alert rule resources.

    :param value: The collection of diagnostic settings resources;.
    :type value:
     list[~$(python-base-namespace).v2021_05_01_preview.models.DiagnosticSettingsResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DiagnosticSettingsResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DiagnosticSettingsResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class EmailNotification(msrest.serialization.Model):
    """Email notification of an autoscale event.

    :param send_to_subscription_administrator: a value indicating whether to send email to
     subscription administrator.
    :type send_to_subscription_administrator: bool
    :param send_to_subscription_co_administrators: a value indicating whether to send email to
     subscription co-administrators.
    :type send_to_subscription_co_administrators: bool
    :param custom_emails: the custom e-mails list. This value can be null or empty, in which case
     this attribute will be ignored.
    :type custom_emails: list[str]
    """

    _attribute_map = {
        'send_to_subscription_administrator': {'key': 'sendToSubscriptionAdministrator', 'type': 'bool'},
        'send_to_subscription_co_administrators': {'key': 'sendToSubscriptionCoAdministrators', 'type': 'bool'},
        'custom_emails': {'key': 'customEmails', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EmailNotification, self).__init__(**kwargs)
        self.send_to_subscription_administrator = kwargs.get('send_to_subscription_administrator', False)
        self.send_to_subscription_co_administrators = kwargs.get('send_to_subscription_co_administrators', False)
        self.custom_emails = kwargs.get('custom_emails', None)


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class LogSettings(msrest.serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to Azure.

    :param category: Name of a Diagnostic Log category for a resource type this setting is applied
     to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
     diagnostic settings operation.
    :type category: str
    :param category_group: Name of a Diagnostic Log category group for a resource type this setting
     is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a
     GET diagnostic settings operation.
    :type category_group: str
    :param enabled: Required. a value indicating whether this log is enabled.
    :type enabled: bool
    :param retention_policy: the retention policy for this log.
    :type retention_policy: ~$(python-base-namespace).v2021_05_01_preview.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'category_group': {'key': 'categoryGroup', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSettings, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.category_group = kwargs.get('category_group', None)
        self.enabled = kwargs['enabled']
        self.retention_policy = kwargs.get('retention_policy', None)


class ManagementGroupDiagnosticSettingsResource(Resource):
    """The management group diagnostic setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~$(python-base-namespace).v2021_05_01_preview.models.SystemData
    :param storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :type storage_account_id: str
    :param service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here to
     maintain backwards compatibility.
    :type service_bus_rule_id: str
    :param event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
    :type event_hub_authorization_rule_id: str
    :param event_hub_name: The name of the event hub. If none is specified, the default event hub
     will be selected.
    :type event_hub_name: str
    :param logs: The list of logs settings.
    :type logs:
     list[~$(python-base-namespace).v2021_05_01_preview.models.ManagementGroupLogSettings]
    :param workspace_id: The full ARM resource ID of the Log Analytics workspace to which you would
     like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :type workspace_id: str
    :param marketplace_partner_id: The full ARM resource ID of the Marketplace resource to which
     you would like to send Diagnostic Logs.
    :type marketplace_partner_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'event_hub_authorization_rule_id': {'key': 'properties.eventHubAuthorizationRuleId', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'logs': {'key': 'properties.logs', 'type': '[ManagementGroupLogSettings]'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'marketplace_partner_id': {'key': 'properties.marketplacePartnerId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroupDiagnosticSettingsResource, self).__init__(**kwargs)
        self.system_data = None
        self.storage_account_id = kwargs.get('storage_account_id', None)
        self.service_bus_rule_id = kwargs.get('service_bus_rule_id', None)
        self.event_hub_authorization_rule_id = kwargs.get('event_hub_authorization_rule_id', None)
        self.event_hub_name = kwargs.get('event_hub_name', None)
        self.logs = kwargs.get('logs', None)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.marketplace_partner_id = kwargs.get('marketplace_partner_id', None)


class ManagementGroupDiagnosticSettingsResourceCollection(msrest.serialization.Model):
    """Represents a collection of management group diagnostic settings resources.

    :param value: The collection of management group diagnostic settings resources.
    :type value:
     list[~$(python-base-namespace).v2021_05_01_preview.models.ManagementGroupDiagnosticSettingsResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ManagementGroupDiagnosticSettingsResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroupDiagnosticSettingsResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ManagementGroupLogSettings(msrest.serialization.Model):
    """Part of Management Group diagnostic setting. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to Azure.

    :param category: Name of a Management Group Diagnostic Log category for a resource type this
     setting is applied to.
    :type category: str
    :param category_group: Name of a Management Group Diagnostic Log category group for a resource
     type this setting is applied to.
    :type category_group: str
    :param enabled: Required. a value indicating whether this log is enabled.
    :type enabled: bool
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'category_group': {'key': 'categoryGroup', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementGroupLogSettings, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.category_group = kwargs.get('category_group', None)
        self.enabled = kwargs['enabled']


class MetricSettings(msrest.serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.

    All required parameters must be populated in order to send to Azure.

    :param time_grain: the timegrain of the metric in ISO8601 format.
    :type time_grain: ~datetime.timedelta
    :param category: Name of a Diagnostic Metric category for a resource type this setting is
     applied to. To obtain the list of Diagnostic metric categories for a resource, first perform a
     GET diagnostic settings operation.
    :type category: str
    :param enabled: Required. a value indicating whether this category is enabled.
    :type enabled: bool
    :param retention_policy: the retention policy for this category.
    :type retention_policy: ~$(python-base-namespace).v2021_05_01_preview.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'category': {'key': 'category', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSettings, self).__init__(**kwargs)
        self.time_grain = kwargs.get('time_grain', None)
        self.category = kwargs.get('category', None)
        self.enabled = kwargs['enabled']
        self.retention_policy = kwargs.get('retention_policy', None)


class MetricTrigger(msrest.serialization.Model):
    """The trigger that results in a scaling action.

    All required parameters must be populated in order to send to Azure.

    :param metric_name: Required. the name of the metric that defines what the rule monitors.
    :type metric_name: str
    :param metric_namespace: the namespace of the metric that defines what the rule monitors.
    :type metric_namespace: str
    :param metric_resource_uri: Required. the resource identifier of the resource the rule
     monitors.
    :type metric_resource_uri: str
    :param metric_resource_location: the location of the resource the rule monitors.
    :type metric_resource_location: str
    :param time_grain: Required. the granularity of metrics the rule monitors. Must be one of the
     predefined values returned from metric definitions for the metric. Must be between 12 hours and
     1 minute.
    :type time_grain: ~datetime.timedelta
    :param statistic: Required. the metric statistic type. How the metrics from multiple instances
     are combined. Possible values include: "Average", "Min", "Max", "Sum", "Count".
    :type statistic: str or
     ~$(python-base-namespace).v2021_05_01_preview.models.MetricStatisticType
    :param time_window: Required. the range of time in which instance data is collected. This value
     must be greater than the delay in metric collection, which can vary from resource-to-resource.
     Must be between 12 hours and 5 minutes.
    :type time_window: ~datetime.timedelta
    :param time_aggregation: Required. time aggregation type. How the data that is collected should
     be combined over time. The default value is Average. Possible values include: "Average",
     "Minimum", "Maximum", "Total", "Count", "Last".
    :type time_aggregation: str or
     ~$(python-base-namespace).v2021_05_01_preview.models.TimeAggregationType
    :param operator: Required. the operator that is used to compare the metric data and the
     threshold. Possible values include: "Equals", "NotEquals", "GreaterThan", "GreaterThanOrEqual",
     "LessThan", "LessThanOrEqual".
    :type operator: str or
     ~$(python-base-namespace).v2021_05_01_preview.models.ComparisonOperationType
    :param threshold: Required. the threshold of the metric that triggers the scale action.
    :type threshold: float
    :param dimensions: List of dimension conditions. For example:
     [{"DimensionName":"AppName","Operator":"Equals","Values":["App1"]},{"DimensionName":"Deployment","Operator":"Equals","Values":["default"]}].
    :type dimensions:
     list[~$(python-base-namespace).v2021_05_01_preview.models.ScaleRuleMetricDimension]
    :param divide_per_instance: a value indicating whether metric should divide per instance.
    :type divide_per_instance: bool
    """

    _validation = {
        'metric_name': {'required': True},
        'metric_resource_uri': {'required': True},
        'time_grain': {'required': True},
        'statistic': {'required': True},
        'time_window': {'required': True},
        'time_aggregation': {'required': True},
        'operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'metric_resource_uri': {'key': 'metricResourceUri', 'type': 'str'},
        'metric_resource_location': {'key': 'metricResourceLocation', 'type': 'str'},
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'statistic': {'key': 'statistic', 'type': 'str'},
        'time_window': {'key': 'timeWindow', 'type': 'duration'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'dimensions': {'key': 'dimensions', 'type': '[ScaleRuleMetricDimension]'},
        'divide_per_instance': {'key': 'dividePerInstance', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricTrigger, self).__init__(**kwargs)
        self.metric_name = kwargs['metric_name']
        self.metric_namespace = kwargs.get('metric_namespace', None)
        self.metric_resource_uri = kwargs['metric_resource_uri']
        self.metric_resource_location = kwargs.get('metric_resource_location', None)
        self.time_grain = kwargs['time_grain']
        self.statistic = kwargs['statistic']
        self.time_window = kwargs['time_window']
        self.time_aggregation = kwargs['time_aggregation']
        self.operator = kwargs['operator']
        self.threshold = kwargs['threshold']
        self.dimensions = kwargs.get('dimensions', None)
        self.divide_per_instance = kwargs.get('divide_per_instance', None)


class PredictiveAutoscalePolicy(msrest.serialization.Model):
    """The parameters for enabling predictive autoscale.

    All required parameters must be populated in order to send to Azure.

    :param scale_mode: Required. the predictive autoscale mode. Possible values include:
     "Disabled", "ForecastOnly", "Enabled".
    :type scale_mode: str or
     ~$(python-base-namespace).v2021_05_01_preview.models.PredictiveAutoscalePolicyScaleMode
    :param scale_look_ahead_time: the amount of time to specify by which instances are launched in
     advance. It must be between 1 minute and 60 minutes in ISO 8601 format.
    :type scale_look_ahead_time: ~datetime.timedelta
    """

    _validation = {
        'scale_mode': {'required': True},
    }

    _attribute_map = {
        'scale_mode': {'key': 'scaleMode', 'type': 'str'},
        'scale_look_ahead_time': {'key': 'scaleLookAheadTime', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PredictiveAutoscalePolicy, self).__init__(**kwargs)
        self.scale_mode = kwargs['scale_mode']
        self.scale_look_ahead_time = kwargs.get('scale_look_ahead_time', None)


class PredictiveResponse(msrest.serialization.Model):
    """The response to a metrics query.

    :param timespan: The timespan for which the data was retrieved. Its value consists of two
     datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back
     from what was originally requested.
    :type timespan: str
    :param interval: The interval (window size) for which the metric data was returned in.  This
     may be adjusted in the future and returned back from what was originally requested.  This is
     not present if a metadata request was made.
    :type interval: ~datetime.timedelta
    :param metric_name: The metrics being queried.
    :type metric_name: str
    :param target_resource_id: resource of the predictive metric.
    :type target_resource_id: str
    :param data: the value of the collection.
    :type data: list[~$(python-base-namespace).v2021_05_01_preview.models.PredictiveValue]
    """

    _attribute_map = {
        'timespan': {'key': 'timespan', 'type': 'str'},
        'interval': {'key': 'interval', 'type': 'duration'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'target_resource_id': {'key': 'targetResourceId', 'type': 'str'},
        'data': {'key': 'data', 'type': '[PredictiveValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PredictiveResponse, self).__init__(**kwargs)
        self.timespan = kwargs.get('timespan', None)
        self.interval = kwargs.get('interval', None)
        self.metric_name = kwargs.get('metric_name', None)
        self.target_resource_id = kwargs.get('target_resource_id', None)
        self.data = kwargs.get('data', None)


class PredictiveValue(msrest.serialization.Model):
    """Represents a predictive metric value in the given bucket.

    All required parameters must be populated in order to send to Azure.

    :param time_stamp: Required. the timestamp for the metric value in ISO 8601 format.
    :type time_stamp: ~datetime.datetime
    :param value: Required. Predictive value in this time bucket.
    :type value: float
    """

    _validation = {
        'time_stamp': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'time_stamp': {'key': 'timeStamp', 'type': 'iso-8601'},
        'value': {'key': 'value', 'type': 'float'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PredictiveValue, self).__init__(**kwargs)
        self.time_stamp = kwargs['time_stamp']
        self.value = kwargs['value']


class Recurrence(msrest.serialization.Model):
    """The repeating times at which this profile begins. This element is not used if the FixedDate element is used.

    All required parameters must be populated in order to send to Azure.

    :param frequency: Required. the recurrence frequency. How often the schedule profile should
     take effect. This value must be Week, meaning each week will have the same set of profiles. For
     example, to set a daily schedule, set **schedule** to every day of the week. The frequency
     property specifies that the schedule is repeated weekly. Possible values include: "None",
     "Second", "Minute", "Hour", "Day", "Week", "Month", "Year".
    :type frequency: str or
     ~$(python-base-namespace).v2021_05_01_preview.models.RecurrenceFrequency
    :param schedule: Required. the scheduling constraints for when the profile begins.
    :type schedule: ~$(python-base-namespace).v2021_05_01_preview.models.RecurrentSchedule
    """

    _validation = {
        'frequency': {'required': True},
        'schedule': {'required': True},
    }

    _attribute_map = {
        'frequency': {'key': 'frequency', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'RecurrentSchedule'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Recurrence, self).__init__(**kwargs)
        self.frequency = kwargs['frequency']
        self.schedule = kwargs['schedule']


class RecurrentSchedule(msrest.serialization.Model):
    """The scheduling constraints for when the profile begins.

    All required parameters must be populated in order to send to Azure.

    :param time_zone: Required. the timezone for the hours of the profile. Some examples of valid
     time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard Time,
     Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time, Mountain
     Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central Standard
     Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific Standard Time,
     Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time, Paraguay Standard
     Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western Standard Time,
     Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard Time, Argentina
     Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo Standard Time,
     Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time, Cape Verde
     Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard Time, W.
     Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central European
     Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard Time,
     GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time, E.
     Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
     Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
     Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time.
    :type time_zone: str
    :param days: Required. the collection of days that the profile takes effect on. Possible values
     are Sunday through Saturday.
    :type days: list[str]
    :param hours: Required. A collection of hours that the profile takes effect on. Values
     supported are 0 to 23 on the 24-hour clock (AM/PM times are not supported).
    :type hours: list[int]
    :param minutes: Required. A collection of minutes at which the profile takes effect at.
    :type minutes: list[int]
    """

    _validation = {
        'time_zone': {'required': True},
        'days': {'required': True},
        'hours': {'required': True},
        'minutes': {'required': True},
    }

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'days': {'key': 'days', 'type': '[str]'},
        'hours': {'key': 'hours', 'type': '[int]'},
        'minutes': {'key': 'minutes', 'type': '[int]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecurrentSchedule, self).__init__(**kwargs)
        self.time_zone = kwargs['time_zone']
        self.days = kwargs['days']
        self.hours = kwargs['hours']
        self.minutes = kwargs['minutes']


class RetentionPolicy(msrest.serialization.Model):
    """Specifies the retention policy for the log.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. a value indicating whether the retention policy is enabled.
    :type enabled: bool
    :param days: Required. the number of days for the retention in days. A value of 0 will retain
     the events indefinitely.
    :type days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.days = kwargs['days']


class ScaleAction(msrest.serialization.Model):
    """The parameters for the scaling action.

    All required parameters must be populated in order to send to Azure.

    :param direction: Required. the scale direction. Whether the scaling action increases or
     decreases the number of instances. Possible values include: "None", "Increase", "Decrease".
    :type direction: str or ~$(python-base-namespace).v2021_05_01_preview.models.ScaleDirection
    :param type: Required. the type of action that should occur when the scale rule fires. Possible
     values include: "ChangeCount", "PercentChangeCount", "ExactCount", "ServiceAllowedNextValue".
    :type type: str or ~$(python-base-namespace).v2021_05_01_preview.models.ScaleType
    :param value: the number of instances that are involved in the scaling action. This value must
     be 1 or greater. The default value is 1.
    :type value: str
    :param cooldown: Required. the amount of time to wait since the last scaling action before this
     action occurs. It must be between 1 week and 1 minute in ISO 8601 format.
    :type cooldown: ~datetime.timedelta
    """

    _validation = {
        'direction': {'required': True},
        'type': {'required': True},
        'cooldown': {'required': True},
    }

    _attribute_map = {
        'direction': {'key': 'direction', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'cooldown': {'key': 'cooldown', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScaleAction, self).__init__(**kwargs)
        self.direction = kwargs['direction']
        self.type = kwargs['type']
        self.value = kwargs.get('value', "1")
        self.cooldown = kwargs['cooldown']


class ScaleCapacity(msrest.serialization.Model):
    """The number of instances that can be used during this profile.

    All required parameters must be populated in order to send to Azure.

    :param minimum: Required. the minimum number of instances for the resource.
    :type minimum: str
    :param maximum: Required. the maximum number of instances for the resource. The actual maximum
     number of instances is limited by the cores that are available in the subscription.
    :type maximum: str
    :param default: Required. the number of instances that will be set if metrics are not available
     for evaluation. The default is only used if the current instance count is lower than the
     default.
    :type default: str
    """

    _validation = {
        'minimum': {'required': True},
        'maximum': {'required': True},
        'default': {'required': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'str'},
        'maximum': {'key': 'maximum', 'type': 'str'},
        'default': {'key': 'default', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScaleCapacity, self).__init__(**kwargs)
        self.minimum = kwargs['minimum']
        self.maximum = kwargs['maximum']
        self.default = kwargs['default']


class ScaleRule(msrest.serialization.Model):
    """A rule that provide the triggers and parameters for the scaling action.

    All required parameters must be populated in order to send to Azure.

    :param metric_trigger: Required. the trigger that results in a scaling action.
    :type metric_trigger: ~$(python-base-namespace).v2021_05_01_preview.models.MetricTrigger
    :param scale_action: Required. the parameters for the scaling action.
    :type scale_action: ~$(python-base-namespace).v2021_05_01_preview.models.ScaleAction
    """

    _validation = {
        'metric_trigger': {'required': True},
        'scale_action': {'required': True},
    }

    _attribute_map = {
        'metric_trigger': {'key': 'metricTrigger', 'type': 'MetricTrigger'},
        'scale_action': {'key': 'scaleAction', 'type': 'ScaleAction'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScaleRule, self).__init__(**kwargs)
        self.metric_trigger = kwargs['metric_trigger']
        self.scale_action = kwargs['scale_action']


class ScaleRuleMetricDimension(msrest.serialization.Model):
    """Specifies an auto scale rule metric dimension.

    All required parameters must be populated in order to send to Azure.

    :param dimension_name: Required. Name of the dimension.
    :type dimension_name: str
    :param operator: Required. the dimension operator. Only 'Equals' and 'NotEquals' are supported.
     'Equals' being equal to any of the values. 'NotEquals' being not equal to all of the values.
     Possible values include: "Equals", "NotEquals".
    :type operator: str or
     ~$(python-base-namespace).v2021_05_01_preview.models.ScaleRuleMetricDimensionOperationType
    :param values: Required. list of dimension values. For example: ["App1","App2"].
    :type values: list[str]
    """

    _validation = {
        'dimension_name': {'required': True},
        'operator': {'required': True},
        'values': {'required': True},
    }

    _attribute_map = {
        'dimension_name': {'key': 'DimensionName', 'type': 'str'},
        'operator': {'key': 'Operator', 'type': 'str'},
        'values': {'key': 'Values', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ScaleRuleMetricDimension, self).__init__(**kwargs)
        self.dimension_name = kwargs['dimension_name']
        self.operator = kwargs['operator']
        self.values = kwargs['values']


class SubscriptionDiagnosticSettingsResource(Resource):
    """The subscription diagnostic setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~$(python-base-namespace).v2021_05_01_preview.models.SystemData
    :param storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :type storage_account_id: str
    :param service_bus_rule_id: The service bus rule Id of the diagnostic setting. This is here to
     maintain backwards compatibility.
    :type service_bus_rule_id: str
    :param event_hub_authorization_rule_id: The resource Id for the event hub authorization rule.
    :type event_hub_authorization_rule_id: str
    :param event_hub_name: The name of the event hub. If none is specified, the default event hub
     will be selected.
    :type event_hub_name: str
    :param logs: The list of logs settings.
    :type logs: list[~$(python-base-namespace).v2021_05_01_preview.models.SubscriptionLogSettings]
    :param workspace_id: The full ARM resource ID of the Log Analytics workspace to which you would
     like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :type workspace_id: str
    :param marketplace_partner_id: The full ARM resource ID of the Marketplace resource to which
     you would like to send Diagnostic Logs.
    :type marketplace_partner_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'event_hub_authorization_rule_id': {'key': 'properties.eventHubAuthorizationRuleId', 'type': 'str'},
        'event_hub_name': {'key': 'properties.eventHubName', 'type': 'str'},
        'logs': {'key': 'properties.logs', 'type': '[SubscriptionLogSettings]'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
        'marketplace_partner_id': {'key': 'properties.marketplacePartnerId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionDiagnosticSettingsResource, self).__init__(**kwargs)
        self.system_data = None
        self.storage_account_id = kwargs.get('storage_account_id', None)
        self.service_bus_rule_id = kwargs.get('service_bus_rule_id', None)
        self.event_hub_authorization_rule_id = kwargs.get('event_hub_authorization_rule_id', None)
        self.event_hub_name = kwargs.get('event_hub_name', None)
        self.logs = kwargs.get('logs', None)
        self.workspace_id = kwargs.get('workspace_id', None)
        self.marketplace_partner_id = kwargs.get('marketplace_partner_id', None)


class SubscriptionDiagnosticSettingsResourceCollection(msrest.serialization.Model):
    """Represents a collection of subscription diagnostic settings resources.

    :param value: The collection of subscription diagnostic settings resources.
    :type value:
     list[~$(python-base-namespace).v2021_05_01_preview.models.SubscriptionDiagnosticSettingsResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubscriptionDiagnosticSettingsResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionDiagnosticSettingsResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class SubscriptionLogSettings(msrest.serialization.Model):
    """Part of Subscription diagnostic setting. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to Azure.

    :param category: Name of a Subscription Diagnostic Log category for a resource type this
     setting is applied to.
    :type category: str
    :param category_group: Name of a Subscription Diagnostic Log category group for a resource type
     this setting is applied to.
    :type category_group: str
    :param enabled: Required. a value indicating whether this log is enabled.
    :type enabled: bool
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'category_group': {'key': 'categoryGroup', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubscriptionLogSettings, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.category_group = kwargs.get('category_group', None)
        self.enabled = kwargs['enabled']


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or
     ~$(python-base-namespace).v2021_05_01_preview.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or
     ~$(python-base-namespace).v2021_05_01_preview.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class TimeWindow(msrest.serialization.Model):
    """A specific date-time for the profile.

    All required parameters must be populated in order to send to Azure.

    :param time_zone: the timezone of the start and end times for the profile. Some examples of
     valid time zones are: Dateline Standard Time, UTC-11, Hawaiian Standard Time, Alaskan Standard
     Time, Pacific Standard Time (Mexico), Pacific Standard Time, US Mountain Standard Time,
     Mountain Standard Time (Mexico), Mountain Standard Time, Central America Standard Time, Central
     Standard Time, Central Standard Time (Mexico), Canada Central Standard Time, SA Pacific
     Standard Time, Eastern Standard Time, US Eastern Standard Time, Venezuela Standard Time,
     Paraguay Standard Time, Atlantic Standard Time, Central Brazilian Standard Time, SA Western
     Standard Time, Pacific SA Standard Time, Newfoundland Standard Time, E. South America Standard
     Time, Argentina Standard Time, SA Eastern Standard Time, Greenland Standard Time, Montevideo
     Standard Time, Bahia Standard Time, UTC-02, Mid-Atlantic Standard Time, Azores Standard Time,
     Cape Verde Standard Time, Morocco Standard Time, UTC, GMT Standard Time, Greenwich Standard
     Time, W. Europe Standard Time, Central Europe Standard Time, Romance Standard Time, Central
     European Standard Time, W. Central Africa Standard Time, Namibia Standard Time, Jordan Standard
     Time, GTB Standard Time, Middle East Standard Time, Egypt Standard Time, Syria Standard Time,
     E. Europe Standard Time, South Africa Standard Time, FLE Standard Time, Turkey Standard Time,
     Israel Standard Time, Kaliningrad Standard Time, Libya Standard Time, Arabic Standard Time,
     Arab Standard Time, Belarus Standard Time, Russian Standard Time, E. Africa Standard Time, Iran
     Standard Time, Arabian Standard Time, Azerbaijan Standard Time, Russia Time Zone 3, Mauritius
     Standard Time, Georgian Standard Time, Caucasus Standard Time, Afghanistan Standard Time, West
     Asia Standard Time, Ekaterinburg Standard Time, Pakistan Standard Time, India Standard Time,
     Sri Lanka Standard Time, Nepal Standard Time, Central Asia Standard Time, Bangladesh Standard
     Time, N. Central Asia Standard Time, Myanmar Standard Time, SE Asia Standard Time, North Asia
     Standard Time, China Standard Time, North Asia East Standard Time, Singapore Standard Time, W.
     Australia Standard Time, Taipei Standard Time, Ulaanbaatar Standard Time, Tokyo Standard Time,
     Korea Standard Time, Yakutsk Standard Time, Cen. Australia Standard Time, AUS Central Standard
     Time, E. Australia Standard Time, AUS Eastern Standard Time, West Pacific Standard Time,
     Tasmania Standard Time, Magadan Standard Time, Vladivostok Standard Time, Russia Time Zone 10,
     Central Pacific Standard Time, Russia Time Zone 11, New Zealand Standard Time, UTC+12, Fiji
     Standard Time, Kamchatka Standard Time, Tonga Standard Time, Samoa Standard Time, Line Islands
     Standard Time.
    :type time_zone: str
    :param start: Required. the start time for the profile in ISO 8601 format.
    :type start: ~datetime.datetime
    :param end: Required. the end time for the profile in ISO 8601 format.
    :type end: ~datetime.datetime
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'start': {'key': 'start', 'type': 'iso-8601'},
        'end': {'key': 'end', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TimeWindow, self).__init__(**kwargs)
        self.time_zone = kwargs.get('time_zone', None)
        self.start = kwargs['start']
        self.end = kwargs['end']


class WebhookNotification(msrest.serialization.Model):
    """Webhook notification of an autoscale event.

    :param service_uri: the service address to receive the notification.
    :type service_uri: str
    :param properties: a property bag of settings. This value can be empty.
    :type properties: dict[str, str]
    """

    _attribute_map = {
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(WebhookNotification, self).__init__(**kwargs)
        self.service_uri = kwargs.get('service_uri', None)
        self.properties = kwargs.get('properties', None)
