# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_management_client_enums import *


class AzureMonitorMetricsDestination(msrest.serialization.Model):
    """Azure Monitor Metrics destination.

    :param name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(AzureMonitorMetricsDestination, self).__init__(**kwargs)
        self.name = name


class ConfigurationAccessEndpointSpec(msrest.serialization.Model):
    """Definition of the endpoint used for accessing configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """

    _validation = {
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ConfigurationAccessEndpointSpec, self).__init__(**kwargs)
        self.endpoint = None


class DataCollectionEndpoint(msrest.serialization.Model):
    """Definition of data collection endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the data collection endpoint.
    :type description: str
    :param immutable_id: The immutable ID of this data collection endpoint resource. This property
     is READ-ONLY.
    :type immutable_id: str
    :param configuration_access: The endpoint used by agents to access their configuration.
    :type configuration_access:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointConfigurationAccess
    :param logs_ingestion: The endpoint used by clients to ingest logs.
    :type logs_ingestion:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointLogsIngestion
    :param network_acls: Network access control rules for the endpoints.
    :type network_acls:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointNetworkAcls
    :ivar provisioning_state: The resource provisioning state. This property is READ-ONLY. Possible
     values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionEndpointProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'immutable_id': {'key': 'immutableId', 'type': 'str'},
        'configuration_access': {'key': 'configurationAccess', 'type': 'DataCollectionEndpointConfigurationAccess'},
        'logs_ingestion': {'key': 'logsIngestion', 'type': 'DataCollectionEndpointLogsIngestion'},
        'network_acls': {'key': 'networkAcls', 'type': 'DataCollectionEndpointNetworkAcls'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        immutable_id: Optional[str] = None,
        configuration_access: Optional["DataCollectionEndpointConfigurationAccess"] = None,
        logs_ingestion: Optional["DataCollectionEndpointLogsIngestion"] = None,
        network_acls: Optional["DataCollectionEndpointNetworkAcls"] = None,
        **kwargs
    ):
        super(DataCollectionEndpoint, self).__init__(**kwargs)
        self.description = description
        self.immutable_id = immutable_id
        self.configuration_access = configuration_access
        self.logs_ingestion = logs_ingestion
        self.network_acls = network_acls
        self.provisioning_state = None


class DataCollectionEndpointConfigurationAccess(ConfigurationAccessEndpointSpec):
    """The endpoint used by agents to access their configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """

    _validation = {
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataCollectionEndpointConfigurationAccess, self).__init__(**kwargs)


class LogsIngestionEndpointSpec(msrest.serialization.Model):
    """Definition of the endpoint used for ingesting logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """

    _validation = {
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogsIngestionEndpointSpec, self).__init__(**kwargs)
        self.endpoint = None


class DataCollectionEndpointLogsIngestion(LogsIngestionEndpointSpec):
    """The endpoint used by clients to ingest logs.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar endpoint: The endpoint. This property is READ-ONLY.
    :vartype endpoint: str
    """

    _validation = {
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataCollectionEndpointLogsIngestion, self).__init__(**kwargs)


class NetworkRuleSet(msrest.serialization.Model):
    """Definition of the network rules.

    :param public_network_access: The configuration to set whether network access from public
     internet to the endpoints are allowed. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownPublicNetworkAccessOptions
    """

    _attribute_map = {
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "KnownPublicNetworkAccessOptions"]] = None,
        **kwargs
    ):
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.public_network_access = public_network_access


class DataCollectionEndpointNetworkAcls(NetworkRuleSet):
    """Network access control rules for the endpoints.

    :param public_network_access: The configuration to set whether network access from public
     internet to the endpoints are allowed. Possible values include: "Enabled", "Disabled".
    :type public_network_access: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownPublicNetworkAccessOptions
    """

    _attribute_map = {
        'public_network_access': {'key': 'publicNetworkAccess', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        public_network_access: Optional[Union[str, "KnownPublicNetworkAccessOptions"]] = None,
        **kwargs
    ):
        super(DataCollectionEndpointNetworkAcls, self).__init__(public_network_access=public_network_access, **kwargs)


class DataCollectionEndpointResource(msrest.serialization.Model):
    """Definition of ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: The kind of the resource. Possible values include: "Linux", "Windows".
    :type kind: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionEndpointResourceKind
    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointResourceSystemData
    :param description: Description of the data collection endpoint.
    :type description: str
    :param immutable_id: The immutable ID of this data collection endpoint resource. This property
     is READ-ONLY.
    :type immutable_id: str
    :param configuration_access: The endpoint used by agents to access their configuration.
    :type configuration_access:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointConfigurationAccess
    :param logs_ingestion: The endpoint used by clients to ingest logs.
    :type logs_ingestion:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointLogsIngestion
    :param network_acls: Network access control rules for the endpoints.
    :type network_acls:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointNetworkAcls
    :ivar provisioning_state: The resource provisioning state. This property is READ-ONLY. Possible
     values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionEndpointProvisioningState
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'DataCollectionEndpointResourceSystemData'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'immutable_id': {'key': 'properties.immutableId', 'type': 'str'},
        'configuration_access': {'key': 'properties.configurationAccess', 'type': 'DataCollectionEndpointConfigurationAccess'},
        'logs_ingestion': {'key': 'properties.logsIngestion', 'type': 'DataCollectionEndpointLogsIngestion'},
        'network_acls': {'key': 'properties.networkAcls', 'type': 'DataCollectionEndpointNetworkAcls'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "KnownDataCollectionEndpointResourceKind"]] = None,
        description: Optional[str] = None,
        immutable_id: Optional[str] = None,
        configuration_access: Optional["DataCollectionEndpointConfigurationAccess"] = None,
        logs_ingestion: Optional["DataCollectionEndpointLogsIngestion"] = None,
        network_acls: Optional["DataCollectionEndpointNetworkAcls"] = None,
        **kwargs
    ):
        super(DataCollectionEndpointResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.kind = kind
        self.id = None
        self.name = None
        self.type = None
        self.etag = None
        self.system_data = None
        self.description = description
        self.immutable_id = immutable_id
        self.configuration_access = configuration_access
        self.logs_ingestion = logs_ingestion
        self.network_acls = network_acls
        self.provisioning_state = None


class DataCollectionEndpointResourceListResult(msrest.serialization.Model):
    """A pageable list of resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of resources.
    :type value: list[~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointResource]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataCollectionEndpointResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DataCollectionEndpointResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DataCollectionEndpointResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataCollectionEndpointResourceProperties(DataCollectionEndpoint):
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the data collection endpoint.
    :type description: str
    :param immutable_id: The immutable ID of this data collection endpoint resource. This property
     is READ-ONLY.
    :type immutable_id: str
    :param configuration_access: The endpoint used by agents to access their configuration.
    :type configuration_access:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointConfigurationAccess
    :param logs_ingestion: The endpoint used by clients to ingest logs.
    :type logs_ingestion:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointLogsIngestion
    :param network_acls: Network access control rules for the endpoints.
    :type network_acls:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionEndpointNetworkAcls
    :ivar provisioning_state: The resource provisioning state. This property is READ-ONLY. Possible
     values include: "Creating", "Updating", "Deleting", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionEndpointProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'immutable_id': {'key': 'immutableId', 'type': 'str'},
        'configuration_access': {'key': 'configurationAccess', 'type': 'DataCollectionEndpointConfigurationAccess'},
        'logs_ingestion': {'key': 'logsIngestion', 'type': 'DataCollectionEndpointLogsIngestion'},
        'network_acls': {'key': 'networkAcls', 'type': 'DataCollectionEndpointNetworkAcls'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        immutable_id: Optional[str] = None,
        configuration_access: Optional["DataCollectionEndpointConfigurationAccess"] = None,
        logs_ingestion: Optional["DataCollectionEndpointLogsIngestion"] = None,
        network_acls: Optional["DataCollectionEndpointNetworkAcls"] = None,
        **kwargs
    ):
        super(DataCollectionEndpointResourceProperties, self).__init__(description=description, immutable_id=immutable_id, configuration_access=configuration_access, logs_ingestion=logs_ingestion, network_acls=network_acls, **kwargs)


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~$(python-base-namespace).v2021_04_01.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~$(python-base-namespace).v2021_04_01.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class DataCollectionEndpointResourceSystemData(SystemData):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~$(python-base-namespace).v2021_04_01.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~$(python-base-namespace).v2021_04_01.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(DataCollectionEndpointResourceSystemData, self).__init__(created_by=created_by, created_by_type=created_by_type, created_at=created_at, last_modified_by=last_modified_by, last_modified_by_type=last_modified_by_type, last_modified_at=last_modified_at, **kwargs)


class DataCollectionRule(msrest.serialization.Model):
    """Definition of what monitoring data to collect and where that data should be sent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the data collection rule.
    :type description: str
    :ivar immutable_id: The immutable ID of this data collection rule. This property is READ-ONLY.
    :vartype immutable_id: str
    :param data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be used via direct calls
     to the provisioned endpoint.
    :type data_sources: ~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleDataSources
    :param destinations: The specification of destinations.
    :type destinations: ~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleDestinations
    :param data_flows: The specification of data flows.
    :type data_flows: list[~$(python-base-namespace).v2021_04_01.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionRuleProvisioningState
    """

    _validation = {
        'immutable_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'immutable_id': {'key': 'immutableId', 'type': 'str'},
        'data_sources': {'key': 'dataSources', 'type': 'DataCollectionRuleDataSources'},
        'destinations': {'key': 'destinations', 'type': 'DataCollectionRuleDestinations'},
        'data_flows': {'key': 'dataFlows', 'type': '[DataFlow]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_sources: Optional["DataCollectionRuleDataSources"] = None,
        destinations: Optional["DataCollectionRuleDestinations"] = None,
        data_flows: Optional[List["DataFlow"]] = None,
        **kwargs
    ):
        super(DataCollectionRule, self).__init__(**kwargs)
        self.description = description
        self.immutable_id = None
        self.data_sources = data_sources
        self.destinations = destinations
        self.data_flows = data_flows
        self.provisioning_state = None


class DataCollectionRuleAssociation(msrest.serialization.Model):
    """Definition of association of a data collection rule with a monitored Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the association.
    :type description: str
    :param data_collection_rule_id: The resource ID of the data collection rule that is to be
     associated.
    :type data_collection_rule_id: str
    :param data_collection_endpoint_id: The resource ID of the data collection endpoint that is to
     be associated.
    :type data_collection_endpoint_id: str
    :ivar provisioning_state: The resource provisioning state. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionRuleAssociationProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'data_collection_rule_id': {'key': 'dataCollectionRuleId', 'type': 'str'},
        'data_collection_endpoint_id': {'key': 'dataCollectionEndpointId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_collection_rule_id: Optional[str] = None,
        data_collection_endpoint_id: Optional[str] = None,
        **kwargs
    ):
        super(DataCollectionRuleAssociation, self).__init__(**kwargs)
        self.description = description
        self.data_collection_rule_id = data_collection_rule_id
        self.data_collection_endpoint_id = data_collection_endpoint_id
        self.provisioning_state = None


class DataCollectionRuleAssociationProxyOnlyResource(msrest.serialization.Model):
    """Definition of generic ARM proxy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleAssociationProxyOnlyResourceSystemData
    :param description: Description of the association.
    :type description: str
    :param data_collection_rule_id: The resource ID of the data collection rule that is to be
     associated.
    :type data_collection_rule_id: str
    :param data_collection_endpoint_id: The resource ID of the data collection endpoint that is to
     be associated.
    :type data_collection_endpoint_id: str
    :ivar provisioning_state: The resource provisioning state. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionRuleAssociationProvisioningState
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'DataCollectionRuleAssociationProxyOnlyResourceSystemData'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'data_collection_rule_id': {'key': 'properties.dataCollectionRuleId', 'type': 'str'},
        'data_collection_endpoint_id': {'key': 'properties.dataCollectionEndpointId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_collection_rule_id: Optional[str] = None,
        data_collection_endpoint_id: Optional[str] = None,
        **kwargs
    ):
        super(DataCollectionRuleAssociationProxyOnlyResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None
        self.system_data = None
        self.description = description
        self.data_collection_rule_id = data_collection_rule_id
        self.data_collection_endpoint_id = data_collection_endpoint_id
        self.provisioning_state = None


class DataCollectionRuleAssociationProxyOnlyResourceListResult(msrest.serialization.Model):
    """A pageable list of resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of resources.
    :type value:
     list[~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleAssociationProxyOnlyResource]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataCollectionRuleAssociationProxyOnlyResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DataCollectionRuleAssociationProxyOnlyResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DataCollectionRuleAssociationProxyOnlyResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataCollectionRuleAssociationProxyOnlyResourceProperties(DataCollectionRuleAssociation):
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the association.
    :type description: str
    :param data_collection_rule_id: The resource ID of the data collection rule that is to be
     associated.
    :type data_collection_rule_id: str
    :param data_collection_endpoint_id: The resource ID of the data collection endpoint that is to
     be associated.
    :type data_collection_endpoint_id: str
    :ivar provisioning_state: The resource provisioning state. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionRuleAssociationProvisioningState
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'data_collection_rule_id': {'key': 'dataCollectionRuleId', 'type': 'str'},
        'data_collection_endpoint_id': {'key': 'dataCollectionEndpointId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_collection_rule_id: Optional[str] = None,
        data_collection_endpoint_id: Optional[str] = None,
        **kwargs
    ):
        super(DataCollectionRuleAssociationProxyOnlyResourceProperties, self).__init__(description=description, data_collection_rule_id=data_collection_rule_id, data_collection_endpoint_id=data_collection_endpoint_id, **kwargs)


class DataCollectionRuleAssociationProxyOnlyResourceSystemData(SystemData):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~$(python-base-namespace).v2021_04_01.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~$(python-base-namespace).v2021_04_01.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(DataCollectionRuleAssociationProxyOnlyResourceSystemData, self).__init__(created_by=created_by, created_by_type=created_by_type, created_at=created_at, last_modified_by=last_modified_by, last_modified_by_type=last_modified_by_type, last_modified_at=last_modified_at, **kwargs)


class DataSourcesSpec(msrest.serialization.Model):
    """Specification of data sources that will be collected.

    :param performance_counters: The list of performance counter data source configurations.
    :type performance_counters:
     list[~$(python-base-namespace).v2021_04_01.models.PerfCounterDataSource]
    :param windows_event_logs: The list of Windows Event Log data source configurations.
    :type windows_event_logs:
     list[~$(python-base-namespace).v2021_04_01.models.WindowsEventLogDataSource]
    :param syslog: The list of Syslog data source configurations.
    :type syslog: list[~$(python-base-namespace).v2021_04_01.models.SyslogDataSource]
    :param extensions: The list of Azure VM extension data source configurations.
    :type extensions: list[~$(python-base-namespace).v2021_04_01.models.ExtensionDataSource]
    """

    _attribute_map = {
        'performance_counters': {'key': 'performanceCounters', 'type': '[PerfCounterDataSource]'},
        'windows_event_logs': {'key': 'windowsEventLogs', 'type': '[WindowsEventLogDataSource]'},
        'syslog': {'key': 'syslog', 'type': '[SyslogDataSource]'},
        'extensions': {'key': 'extensions', 'type': '[ExtensionDataSource]'},
    }

    def __init__(
        self,
        *,
        performance_counters: Optional[List["PerfCounterDataSource"]] = None,
        windows_event_logs: Optional[List["WindowsEventLogDataSource"]] = None,
        syslog: Optional[List["SyslogDataSource"]] = None,
        extensions: Optional[List["ExtensionDataSource"]] = None,
        **kwargs
    ):
        super(DataSourcesSpec, self).__init__(**kwargs)
        self.performance_counters = performance_counters
        self.windows_event_logs = windows_event_logs
        self.syslog = syslog
        self.extensions = extensions


class DataCollectionRuleDataSources(DataSourcesSpec):
    """The specification of data sources. 
This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.

    :param performance_counters: The list of performance counter data source configurations.
    :type performance_counters:
     list[~$(python-base-namespace).v2021_04_01.models.PerfCounterDataSource]
    :param windows_event_logs: The list of Windows Event Log data source configurations.
    :type windows_event_logs:
     list[~$(python-base-namespace).v2021_04_01.models.WindowsEventLogDataSource]
    :param syslog: The list of Syslog data source configurations.
    :type syslog: list[~$(python-base-namespace).v2021_04_01.models.SyslogDataSource]
    :param extensions: The list of Azure VM extension data source configurations.
    :type extensions: list[~$(python-base-namespace).v2021_04_01.models.ExtensionDataSource]
    """

    _attribute_map = {
        'performance_counters': {'key': 'performanceCounters', 'type': '[PerfCounterDataSource]'},
        'windows_event_logs': {'key': 'windowsEventLogs', 'type': '[WindowsEventLogDataSource]'},
        'syslog': {'key': 'syslog', 'type': '[SyslogDataSource]'},
        'extensions': {'key': 'extensions', 'type': '[ExtensionDataSource]'},
    }

    def __init__(
        self,
        *,
        performance_counters: Optional[List["PerfCounterDataSource"]] = None,
        windows_event_logs: Optional[List["WindowsEventLogDataSource"]] = None,
        syslog: Optional[List["SyslogDataSource"]] = None,
        extensions: Optional[List["ExtensionDataSource"]] = None,
        **kwargs
    ):
        super(DataCollectionRuleDataSources, self).__init__(performance_counters=performance_counters, windows_event_logs=windows_event_logs, syslog=syslog, extensions=extensions, **kwargs)


class DestinationsSpec(msrest.serialization.Model):
    """Specification of destinations that can be used in data flows.

    :param log_analytics: List of Log Analytics destinations.
    :type log_analytics: list[~$(python-base-namespace).v2021_04_01.models.LogAnalyticsDestination]
    :param azure_monitor_metrics: Azure Monitor Metrics destination.
    :type azure_monitor_metrics:
     ~$(python-base-namespace).v2021_04_01.models.DestinationsSpecAzureMonitorMetrics
    """

    _attribute_map = {
        'log_analytics': {'key': 'logAnalytics', 'type': '[LogAnalyticsDestination]'},
        'azure_monitor_metrics': {'key': 'azureMonitorMetrics', 'type': 'DestinationsSpecAzureMonitorMetrics'},
    }

    def __init__(
        self,
        *,
        log_analytics: Optional[List["LogAnalyticsDestination"]] = None,
        azure_monitor_metrics: Optional["DestinationsSpecAzureMonitorMetrics"] = None,
        **kwargs
    ):
        super(DestinationsSpec, self).__init__(**kwargs)
        self.log_analytics = log_analytics
        self.azure_monitor_metrics = azure_monitor_metrics


class DataCollectionRuleDestinations(DestinationsSpec):
    """The specification of destinations.

    :param log_analytics: List of Log Analytics destinations.
    :type log_analytics: list[~$(python-base-namespace).v2021_04_01.models.LogAnalyticsDestination]
    :param azure_monitor_metrics: Azure Monitor Metrics destination.
    :type azure_monitor_metrics:
     ~$(python-base-namespace).v2021_04_01.models.DestinationsSpecAzureMonitorMetrics
    """

    _attribute_map = {
        'log_analytics': {'key': 'logAnalytics', 'type': '[LogAnalyticsDestination]'},
        'azure_monitor_metrics': {'key': 'azureMonitorMetrics', 'type': 'DestinationsSpecAzureMonitorMetrics'},
    }

    def __init__(
        self,
        *,
        log_analytics: Optional[List["LogAnalyticsDestination"]] = None,
        azure_monitor_metrics: Optional["DestinationsSpecAzureMonitorMetrics"] = None,
        **kwargs
    ):
        super(DataCollectionRuleDestinations, self).__init__(log_analytics=log_analytics, azure_monitor_metrics=azure_monitor_metrics, **kwargs)


class DataCollectionRuleResource(msrest.serialization.Model):
    """Definition of ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param kind: The kind of the resource. Possible values include: "Linux", "Windows".
    :type kind: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionRuleResourceKind
    :ivar id: Fully qualified ID of the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar etag: Resource entity tag (ETag).
    :vartype etag: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data:
     ~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleResourceSystemData
    :param description: Description of the data collection rule.
    :type description: str
    :ivar immutable_id: The immutable ID of this data collection rule. This property is READ-ONLY.
    :vartype immutable_id: str
    :param data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be used via direct calls
     to the provisioned endpoint.
    :type data_sources: ~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleDataSources
    :param destinations: The specification of destinations.
    :type destinations: ~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleDestinations
    :param data_flows: The specification of data flows.
    :type data_flows: list[~$(python-base-namespace).v2021_04_01.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionRuleProvisioningState
    """

    _validation = {
        'location': {'required': True},
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'system_data': {'readonly': True},
        'immutable_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'kind': {'key': 'kind', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'DataCollectionRuleResourceSystemData'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'immutable_id': {'key': 'properties.immutableId', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': 'DataCollectionRuleDataSources'},
        'destinations': {'key': 'properties.destinations', 'type': 'DataCollectionRuleDestinations'},
        'data_flows': {'key': 'properties.dataFlows', 'type': '[DataFlow]'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kind: Optional[Union[str, "KnownDataCollectionRuleResourceKind"]] = None,
        description: Optional[str] = None,
        data_sources: Optional["DataCollectionRuleDataSources"] = None,
        destinations: Optional["DataCollectionRuleDestinations"] = None,
        data_flows: Optional[List["DataFlow"]] = None,
        **kwargs
    ):
        super(DataCollectionRuleResource, self).__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.kind = kind
        self.id = None
        self.name = None
        self.type = None
        self.etag = None
        self.system_data = None
        self.description = description
        self.immutable_id = None
        self.data_sources = data_sources
        self.destinations = destinations
        self.data_flows = data_flows
        self.provisioning_state = None


class DataCollectionRuleResourceListResult(msrest.serialization.Model):
    """A pageable list of resources.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of resources.
    :type value: list[~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleResource]
    :param next_link: The URL to use for getting the next set of results.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[DataCollectionRuleResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["DataCollectionRuleResource"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DataCollectionRuleResourceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DataCollectionRuleResourceProperties(DataCollectionRule):
    """Resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param description: Description of the data collection rule.
    :type description: str
    :ivar immutable_id: The immutable ID of this data collection rule. This property is READ-ONLY.
    :vartype immutable_id: str
    :param data_sources: The specification of data sources.
     This property is optional and can be omitted if the rule is meant to be used via direct calls
     to the provisioned endpoint.
    :type data_sources: ~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleDataSources
    :param destinations: The specification of destinations.
    :type destinations: ~$(python-base-namespace).v2021_04_01.models.DataCollectionRuleDestinations
    :param data_flows: The specification of data flows.
    :type data_flows: list[~$(python-base-namespace).v2021_04_01.models.DataFlow]
    :ivar provisioning_state: The resource provisioning state. Possible values include: "Creating",
     "Updating", "Deleting", "Succeeded", "Failed".
    :vartype provisioning_state: str or
     ~$(python-base-namespace).v2021_04_01.models.KnownDataCollectionRuleProvisioningState
    """

    _validation = {
        'immutable_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'description': {'key': 'description', 'type': 'str'},
        'immutable_id': {'key': 'immutableId', 'type': 'str'},
        'data_sources': {'key': 'dataSources', 'type': 'DataCollectionRuleDataSources'},
        'destinations': {'key': 'destinations', 'type': 'DataCollectionRuleDestinations'},
        'data_flows': {'key': 'dataFlows', 'type': '[DataFlow]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: Optional[str] = None,
        data_sources: Optional["DataCollectionRuleDataSources"] = None,
        destinations: Optional["DataCollectionRuleDestinations"] = None,
        data_flows: Optional[List["DataFlow"]] = None,
        **kwargs
    ):
        super(DataCollectionRuleResourceProperties, self).__init__(description=description, data_sources=data_sources, destinations=destinations, data_flows=data_flows, **kwargs)


class DataCollectionRuleResourceSystemData(SystemData):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~$(python-base-namespace).v2021_04_01.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~$(python-base-namespace).v2021_04_01.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(DataCollectionRuleResourceSystemData, self).__init__(created_by=created_by, created_by_type=created_by_type, created_at=created_at, last_modified_by=last_modified_by, last_modified_by_type=last_modified_by_type, last_modified_at=last_modified_at, **kwargs)


class DataFlow(msrest.serialization.Model):
    """Definition of which streams are sent to which destinations.

    :param streams: List of streams for this data flow.
    :type streams: list[str or ~$(python-base-namespace).v2021_04_01.models.KnownDataFlowStreams]
    :param destinations: List of destinations for this data flow.
    :type destinations: list[str]
    """

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'destinations': {'key': 'destinations', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        streams: Optional[List[Union[str, "KnownDataFlowStreams"]]] = None,
        destinations: Optional[List[str]] = None,
        **kwargs
    ):
        super(DataFlow, self).__init__(**kwargs)
        self.streams = streams
        self.destinations = destinations


class DestinationsSpecAzureMonitorMetrics(AzureMonitorMetricsDestination):
    """Azure Monitor Metrics destination.

    :param name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :type name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        **kwargs
    ):
        super(DestinationsSpecAzureMonitorMetrics, self).__init__(name=name, **kwargs)


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~$(python-base-namespace).v2021_04_01.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~$(python-base-namespace).v2021_04_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponseCommonV2(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~$(python-base-namespace).v2021_04_01.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        super(ErrorResponseCommonV2, self).__init__(**kwargs)
        self.error = error


class ExtensionDataSource(msrest.serialization.Model):
    """Definition of which data will be collected from a separate VM extension that integrates with the Azure Monitor Agent.
Collected from either Windows and Linux machines, depending on which extension is defined.

    All required parameters must be populated in order to send to Azure.

    :param streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :type streams: list[str or
     ~$(python-base-namespace).v2021_04_01.models.KnownExtensionDataSourceStreams]
    :param extension_name: Required. The name of the VM extension.
    :type extension_name: str
    :param extension_settings: The extension settings. The format is specific for particular
     extension.
    :type extension_settings: any
    :param input_data_sources: The list of data sources this extension needs data from.
    :type input_data_sources: list[str]
    :param name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :type name: str
    """

    _validation = {
        'extension_name': {'required': True},
    }

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'extension_name': {'key': 'extensionName', 'type': 'str'},
        'extension_settings': {'key': 'extensionSettings', 'type': 'object'},
        'input_data_sources': {'key': 'inputDataSources', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        extension_name: str,
        streams: Optional[List[Union[str, "KnownExtensionDataSourceStreams"]]] = None,
        extension_settings: Optional[Any] = None,
        input_data_sources: Optional[List[str]] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(ExtensionDataSource, self).__init__(**kwargs)
        self.streams = streams
        self.extension_name = extension_name
        self.extension_settings = extension_settings
        self.input_data_sources = input_data_sources
        self.name = name


class LogAnalyticsDestination(msrest.serialization.Model):
    """Log Analytics destination.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param workspace_resource_id: The resource ID of the Log Analytics workspace.
    :type workspace_resource_id: str
    :ivar workspace_id: The Customer ID of the Log Analytics workspace.
    :vartype workspace_id: str
    :param name: A friendly name for the destination.
     This name should be unique across all destinations (regardless of type) within the data
     collection rule.
    :type name: str
    """

    _validation = {
        'workspace_id': {'readonly': True},
    }

    _attribute_map = {
        'workspace_resource_id': {'key': 'workspaceResourceId', 'type': 'str'},
        'workspace_id': {'key': 'workspaceId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        workspace_resource_id: Optional[str] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(LogAnalyticsDestination, self).__init__(**kwargs)
        self.workspace_resource_id = workspace_resource_id
        self.workspace_id = None
        self.name = name


class PerfCounterDataSource(msrest.serialization.Model):
    """Definition of which performance counters will be collected and how they will be collected by this data collection rule.
Collected from both Windows and Linux machines where the counter is present.

    :param streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :type streams: list[str or
     ~$(python-base-namespace).v2021_04_01.models.KnownPerfCounterDataSourceStreams]
    :param sampling_frequency_in_seconds: The number of seconds between consecutive counter
     measurements (samples).
    :type sampling_frequency_in_seconds: int
    :param counter_specifiers: A list of specifier names of the performance counters you want to
     collect.
     Use a wildcard (*) to collect a counter for all instances.
     To get a list of performance counters on Windows, run the command 'typeperf'.
    :type counter_specifiers: list[str]
    :param name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :type name: str
    """

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'sampling_frequency_in_seconds': {'key': 'samplingFrequencyInSeconds', 'type': 'int'},
        'counter_specifiers': {'key': 'counterSpecifiers', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        streams: Optional[List[Union[str, "KnownPerfCounterDataSourceStreams"]]] = None,
        sampling_frequency_in_seconds: Optional[int] = None,
        counter_specifiers: Optional[List[str]] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(PerfCounterDataSource, self).__init__(**kwargs)
        self.streams = streams
        self.sampling_frequency_in_seconds = sampling_frequency_in_seconds
        self.counter_specifiers = counter_specifiers
        self.name = name


class ResourceForUpdate(msrest.serialization.Model):
    """Definition of ARM tracked top level resource properties for update operation.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ResourceForUpdate, self).__init__(**kwargs)
        self.tags = tags


class SyslogDataSource(msrest.serialization.Model):
    """Definition of which syslog data will be collected and how it will be collected.
Only collected from Linux machines.

    :param streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :type streams: list[str or
     ~$(python-base-namespace).v2021_04_01.models.KnownSyslogDataSourceStreams]
    :param facility_names: The list of facility names.
    :type facility_names: list[str or
     ~$(python-base-namespace).v2021_04_01.models.KnownSyslogDataSourceFacilityNames]
    :param log_levels: The log levels to collect.
    :type log_levels: list[str or
     ~$(python-base-namespace).v2021_04_01.models.KnownSyslogDataSourceLogLevels]
    :param name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :type name: str
    """

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'facility_names': {'key': 'facilityNames', 'type': '[str]'},
        'log_levels': {'key': 'logLevels', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        streams: Optional[List[Union[str, "KnownSyslogDataSourceStreams"]]] = None,
        facility_names: Optional[List[Union[str, "KnownSyslogDataSourceFacilityNames"]]] = None,
        log_levels: Optional[List[Union[str, "KnownSyslogDataSourceLogLevels"]]] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(SyslogDataSource, self).__init__(**kwargs)
        self.streams = streams
        self.facility_names = facility_names
        self.log_levels = log_levels
        self.name = name


class WindowsEventLogDataSource(msrest.serialization.Model):
    """Definition of which Windows Event Log events will be collected and how they will be collected.
Only collected from Windows machines.

    :param streams: List of streams that this data source will be sent to.
     A stream indicates what schema will be used for this data and usually what table in Log
     Analytics the data will be sent to.
    :type streams: list[str or
     ~$(python-base-namespace).v2021_04_01.models.KnownWindowsEventLogDataSourceStreams]
    :param x_path_queries: A list of Windows Event Log queries in XPATH format.
    :type x_path_queries: list[str]
    :param name: A friendly name for the data source.
     This name should be unique across all data sources (regardless of type) within the data
     collection rule.
    :type name: str
    """

    _attribute_map = {
        'streams': {'key': 'streams', 'type': '[str]'},
        'x_path_queries': {'key': 'xPathQueries', 'type': '[str]'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        streams: Optional[List[Union[str, "KnownWindowsEventLogDataSourceStreams"]]] = None,
        x_path_queries: Optional[List[str]] = None,
        name: Optional[str] = None,
        **kwargs
    ):
        super(WindowsEventLogDataSource, self).__init__(**kwargs)
        self.streams = streams
        self.x_path_queries = x_path_queries
        self.name = name
