# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class ActionGroup(msrest.serialization.Model):
    """A pointer to an Azure Action Group.

    All required parameters must be populated in order to send to Azure.

    :param action_group_id: Required. The resource ID of the Action Group. This cannot be null or
     empty.
    :type action_group_id: str
    :param webhook_properties: the dictionary of custom properties to include with the post
     operation. These data are appended to the webhook payload.
    :type webhook_properties: dict[str, str]
    """

    _validation = {
        'action_group_id': {'required': True},
    }

    _attribute_map = {
        'action_group_id': {'key': 'actionGroupId', 'type': 'str'},
        'webhook_properties': {'key': 'webhookProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        action_group_id: str,
        webhook_properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ActionGroup, self).__init__(**kwargs)
        self.action_group_id = action_group_id
        self.webhook_properties = webhook_properties


class ActionList(msrest.serialization.Model):
    """A list of Activity Log Alert rule actions.

    :param action_groups: The list of the Action Groups.
    :type action_groups: list[~$(python-base-namespace).v2020_10_01.models.ActionGroup]
    """

    _attribute_map = {
        'action_groups': {'key': 'actionGroups', 'type': '[ActionGroup]'},
    }

    def __init__(
        self,
        *,
        action_groups: Optional[List["ActionGroup"]] = None,
        **kwargs
    ):
        super(ActionList, self).__init__(**kwargs)
        self.action_groups = action_groups


class AzureResource(msrest.serialization.Model):
    """An Azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource Id.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource. Since Azure Activity Log Alerts is a global
     service, the location of the rules should always be 'global'.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = "global",
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(AzureResource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ActivityLogAlertResource(AzureResource):
    """An Activity Log Alert rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource Id.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param location: The location of the resource. Since Azure Activity Log Alerts is a global
     service, the location of the rules should always be 'global'.
    :type location: str
    :param tags: A set of tags. The tags of the resource.
    :type tags: dict[str, str]
    :param scopes: A list of resource IDs that will be used as prefixes. The alert will only apply
     to Activity Log events with resource IDs that fall under one of these prefixes. This list must
     include at least one item.
    :type scopes: list[str]
    :param condition: The condition that will cause this alert to activate.
    :type condition: ~$(python-base-namespace).v2020_10_01.models.AlertRuleAllOfCondition
    :param actions: The actions that will activate when the condition is met.
    :type actions: ~$(python-base-namespace).v2020_10_01.models.ActionList
    :param enabled: Indicates whether this Activity Log Alert rule is enabled. If an Activity Log
     Alert rule is not enabled, then none of its actions will be activated.
    :type enabled: bool
    :param description: A description of this Activity Log Alert rule.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'scopes': {'key': 'properties.scopes', 'type': '[str]'},
        'condition': {'key': 'properties.condition', 'type': 'AlertRuleAllOfCondition'},
        'actions': {'key': 'properties.actions', 'type': 'ActionList'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = "global",
        tags: Optional[Dict[str, str]] = None,
        scopes: Optional[List[str]] = None,
        condition: Optional["AlertRuleAllOfCondition"] = None,
        actions: Optional["ActionList"] = None,
        enabled: Optional[bool] = True,
        description: Optional[str] = None,
        **kwargs
    ):
        super(ActivityLogAlertResource, self).__init__(location=location, tags=tags, **kwargs)
        self.scopes = scopes
        self.condition = condition
        self.actions = actions
        self.enabled = enabled
        self.description = description


class AlertRuleAllOfCondition(msrest.serialization.Model):
    """An Activity Log Alert rule condition that is met when all its member conditions are met.

    All required parameters must be populated in order to send to Azure.

    :param all_of: Required. The list of Activity Log Alert rule conditions.
    :type all_of: list[~$(python-base-namespace).v2020_10_01.models.AlertRuleAnyOfOrLeafCondition]
    """

    _validation = {
        'all_of': {'required': True},
    }

    _attribute_map = {
        'all_of': {'key': 'allOf', 'type': '[AlertRuleAnyOfOrLeafCondition]'},
    }

    def __init__(
        self,
        *,
        all_of: List["AlertRuleAnyOfOrLeafCondition"],
        **kwargs
    ):
        super(AlertRuleAllOfCondition, self).__init__(**kwargs)
        self.all_of = all_of


class AlertRuleLeafCondition(msrest.serialization.Model):
    """An Activity Log Alert rule condition that is met by comparing the field and value of an Activity Log event.
This condition must contain 'field' and either 'equals' or 'containsAny'.

    :param field: The name of the Activity Log event's field that this condition will examine.
     The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller',
     'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus',
     'resourceType', or anything beginning with 'properties'.
    :type field: str
    :param equals: The value of the event's field will be compared to this value (case-insensitive)
     to determine if the condition is met.
    :type equals: str
    :param contains_any: The value of the event's field will be compared to the values in this
     array (case-insensitive) to determine if the condition is met.
    :type contains_any: list[str]
    """

    _attribute_map = {
        'field': {'key': 'field', 'type': 'str'},
        'equals': {'key': 'equals', 'type': 'str'},
        'contains_any': {'key': 'containsAny', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        field: Optional[str] = None,
        equals: Optional[str] = None,
        contains_any: Optional[List[str]] = None,
        **kwargs
    ):
        super(AlertRuleLeafCondition, self).__init__(**kwargs)
        self.field = field
        self.equals = equals
        self.contains_any = contains_any


class AlertRuleAnyOfOrLeafCondition(AlertRuleLeafCondition):
    """An Activity Log Alert rule condition that is met when all its member conditions are met.
Each condition can be of one of the following types:
**Important**\ : Each type has its unique subset of properties. Properties from different types CANNOT exist in one condition.


* **Leaf Condition -** must contain 'field' and either 'equals' or 'containsAny'.
  *Please note, 'anyOf' should **not** be set in a Leaf Condition.*

  * **AnyOf Condition -** must contain **only** 'anyOf' (which is an array of Leaf Conditions).
    *Please note, 'field', 'equals' and 'containsAny' should **not** be set in an AnyOf Condition.*.

    :param field: The name of the Activity Log event's field that this condition will examine.
     The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller',
     'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus',
     'resourceType', or anything beginning with 'properties'.
    :type field: str
    :param equals: The value of the event's field will be compared to this value (case-insensitive)
     to determine if the condition is met.
    :type equals: str
    :param contains_any: The value of the event's field will be compared to the values in this
     array (case-insensitive) to determine if the condition is met.
    :type contains_any: list[str]
    :param any_of: An Activity Log Alert rule condition that is met when at least one of its member
     leaf conditions are met.
    :type any_of: list[~$(python-base-namespace).v2020_10_01.models.AlertRuleLeafCondition]
    """

    _attribute_map = {
        'field': {'key': 'field', 'type': 'str'},
        'equals': {'key': 'equals', 'type': 'str'},
        'contains_any': {'key': 'containsAny', 'type': '[str]'},
        'any_of': {'key': 'anyOf', 'type': '[AlertRuleLeafCondition]'},
    }

    def __init__(
        self,
        *,
        field: Optional[str] = None,
        equals: Optional[str] = None,
        contains_any: Optional[List[str]] = None,
        any_of: Optional[List["AlertRuleLeafCondition"]] = None,
        **kwargs
    ):
        super(AlertRuleAnyOfOrLeafCondition, self).__init__(field=field, equals=equals, contains_any=contains_any, **kwargs)
        self.any_of = any_of


class AlertRuleList(msrest.serialization.Model):
    """A list of Activity Log Alert rules.

    :param value: The list of Activity Log Alert rules.
    :type value: list[~$(python-base-namespace).v2020_10_01.models.ActivityLogAlertResource]
    :param next_link: Provides the link to retrieve the next set of elements.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ActivityLogAlertResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ActivityLogAlertResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AlertRuleList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AlertRulePatchObject(msrest.serialization.Model):
    """An Activity Log Alert rule object for the body of patch operations.

    :param tags: A set of tags. The resource tags.
    :type tags: dict[str, str]
    :param enabled: Indicates whether this Activity Log Alert rule is enabled. If an Activity Log
     Alert rule is not enabled, then none of its actions will be activated.
    :type enabled: bool
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'enabled': {'key': 'properties.enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        enabled: Optional[bool] = True,
        **kwargs
    ):
        super(AlertRulePatchObject, self).__init__(**kwargs)
        self.tags = tags
        self.enabled = enabled


class ErrorResponse(msrest.serialization.Model):
    """The error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
