# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ErrorType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The error type of the baseline.
    """

    ZERO = "0"
    ONE = "1"
    TWO = "2"
    THREE = "3"
    FOUR = "4"
    ONE_HUNDRED = "100"
    TWO_HUNDRED = "200"

class PredictionResultType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The prediction result type of the baseline.
    """

    ZERO = "0"
    ONE = "1"
    TWO = "2"

class ReceiverStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Indicates the status of the receiver. Receivers that are not Enabled will not receive any
    communications.
    """

    NOT_SPECIFIED = "NotSpecified"
    ENABLED = "Enabled"
    DISABLED = "Disabled"

class ResultType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):

    DATA = "Data"
    METADATA = "Metadata"

class Sensitivity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The sensitivity of the baseline.
    """

    LOW = "Low"
    MEDIUM = "Medium"
    HIGH = "High"
