# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class DataSource(msrest.serialization.Model):
    """Data source object contains configuration to collect telemetry and one or more sinks to send that telemetry data to.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Datasource kind. Possible values include: "PerformanceCounter",
     "ETWProviders", "WindowsEventLogs".
    :type kind: str or ~$(python-base-namespace).v2018_06_01_preview.models.DataSourceKind
    :param configuration: Required.
    :type configuration:
     ~$(python-base-namespace).v2018_06_01_preview.models.DataSourceConfiguration
    :param sinks: Required.
    :type sinks: list[~$(python-base-namespace).v2018_06_01_preview.models.SinkConfiguration]
    """

    _validation = {
        'kind': {'required': True},
        'configuration': {'required': True},
        'sinks': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': 'DataSourceConfiguration'},
        'sinks': {'key': 'sinks', 'type': '[SinkConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataSource, self).__init__(**kwargs)
        self.kind = kwargs['kind']
        self.configuration = kwargs['configuration']
        self.sinks = kwargs['sinks']


class DataSourceConfiguration(msrest.serialization.Model):
    """DataSourceConfiguration.

    :param providers: ETW providers configuration.
    :type providers:
     list[~$(python-base-namespace).v2018_06_01_preview.models.EtwProviderConfiguration]
    :param perf_counters: Performance counter configuration.
    :type perf_counters:
     list[~$(python-base-namespace).v2018_06_01_preview.models.PerformanceCounterConfiguration]
    :param event_logs: Windows event logs configuration.
    :type event_logs:
     list[~$(python-base-namespace).v2018_06_01_preview.models.EventLogConfiguration]
    """

    _attribute_map = {
        'providers': {'key': 'providers', 'type': '[EtwProviderConfiguration]'},
        'perf_counters': {'key': 'perfCounters', 'type': '[PerformanceCounterConfiguration]'},
        'event_logs': {'key': 'eventLogs', 'type': '[EventLogConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataSourceConfiguration, self).__init__(**kwargs)
        self.providers = kwargs.get('providers', None)
        self.perf_counters = kwargs.get('perf_counters', None)
        self.event_logs = kwargs.get('event_logs', None)


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class EtwEventConfiguration(msrest.serialization.Model):
    """EtwEventConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param id: Required.
    :type id: int
    :param filter:
    :type filter: str
    """

    _validation = {
        'name': {'required': True},
        'id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'int'},
        'filter': {'key': 'filter', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EtwEventConfiguration, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.id = kwargs['id']
        self.filter = kwargs.get('filter', None)


class EtwProviderConfiguration(msrest.serialization.Model):
    """EtwProviderConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param events: Required.
    :type events: list[~$(python-base-namespace).v2018_06_01_preview.models.EtwEventConfiguration]
    """

    _validation = {
        'id': {'required': True},
        'events': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'events': {'key': 'events', 'type': '[EtwEventConfiguration]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EtwProviderConfiguration, self).__init__(**kwargs)
        self.id = kwargs['id']
        self.events = kwargs['events']


class EventLogConfiguration(msrest.serialization.Model):
    """EventLogConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param log_name: Required.
    :type log_name: str
    :param filter:
    :type filter: str
    """

    _validation = {
        'log_name': {'required': True},
    }

    _attribute_map = {
        'log_name': {'key': 'logName', 'type': 'str'},
        'filter': {'key': 'filter', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(EventLogConfiguration, self).__init__(**kwargs)
        self.log_name = kwargs['log_name']
        self.filter = kwargs.get('filter', None)


class GuestDiagnosticSettingsAssociationList(msrest.serialization.Model):
    """A list of guest diagnostic settings association.

    :param value: The list of guest diagnostic settings association.
    :type value:
     list[~$(python-base-namespace).v2018_06_01_preview.models.GuestDiagnosticSettingsAssociationResource]
    :param next_link: Provides the link to retrieve the next set of elements.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GuestDiagnosticSettingsAssociationResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestDiagnosticSettingsAssociationList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class GuestDiagnosticSettingsAssociationResource(Resource):
    """Virtual machine guest diagnostic settings resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param guest_diagnostic_settings_name: Required. The guest diagnostic settings name.
    :type guest_diagnostic_settings_name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'guest_diagnostic_settings_name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'guest_diagnostic_settings_name': {'key': 'properties.guestDiagnosticSettingsName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestDiagnosticSettingsAssociationResource, self).__init__(**kwargs)
        self.guest_diagnostic_settings_name = kwargs['guest_diagnostic_settings_name']


class GuestDiagnosticSettingsAssociationResourcePatch(msrest.serialization.Model):
    """Guest diagnostic setting resource for patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param guest_diagnostic_settings_name: The guest diagnostic settings name.
    :type guest_diagnostic_settings_name: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'guest_diagnostic_settings_name': {'key': 'properties.guestDiagnosticSettingsName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestDiagnosticSettingsAssociationResourcePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.guest_diagnostic_settings_name = kwargs.get('guest_diagnostic_settings_name', None)


class GuestDiagnosticSettingsList(msrest.serialization.Model):
    """A list of guest diagnostic settings.

    :param value: The list of guest diagnostic settings.
    :type value:
     list[~$(python-base-namespace).v2018_06_01_preview.models.GuestDiagnosticSettingsResource]
    :param next_link: Provides the link to retrieve the next set of elements.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[GuestDiagnosticSettingsResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestDiagnosticSettingsList, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class GuestDiagnosticSettingsPatchResource(msrest.serialization.Model):
    """An diagnostic settings object for the body of patch operations.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param os_type: Operating system type for the configuration. Possible values include:
     "Windows", "Linux".
    :type os_type: str or
     ~$(python-base-namespace).v2018_06_01_preview.models.GuestDiagnosticSettingsOsType
    :param data_sources: the array of data source object which are configured to collect and send
     data.
    :type data_sources: list[~$(python-base-namespace).v2018_06_01_preview.models.DataSource]
    :param proxy_setting:
    :type proxy_setting: str
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': '[DataSource]'},
        'proxy_setting': {'key': 'properties.proxySetting', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestDiagnosticSettingsPatchResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.os_type = kwargs.get('os_type', None)
        self.data_sources = kwargs.get('data_sources', None)
        self.proxy_setting = kwargs.get('proxy_setting', None)


class GuestDiagnosticSettingsResource(Resource):
    """Virtual machine guest diagnostics settings resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param os_type: Operating system type for the configuration. Possible values include:
     "Windows", "Linux".
    :type os_type: str or
     ~$(python-base-namespace).v2018_06_01_preview.models.GuestDiagnosticSettingsOsType
    :param data_sources: the array of data source object which are configured to collect and send
     data.
    :type data_sources: list[~$(python-base-namespace).v2018_06_01_preview.models.DataSource]
    :param proxy_setting:
    :type proxy_setting: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'data_sources': {'key': 'properties.dataSources', 'type': '[DataSource]'},
        'proxy_setting': {'key': 'properties.proxySetting', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(GuestDiagnosticSettingsResource, self).__init__(**kwargs)
        self.os_type = kwargs.get('os_type', None)
        self.data_sources = kwargs.get('data_sources', None)
        self.proxy_setting = kwargs.get('proxy_setting', None)


class PerformanceCounterConfiguration(msrest.serialization.Model):
    """PerformanceCounterConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param sampling_period: Required.
    :type sampling_period: str
    :param instance:
    :type instance: str
    """

    _validation = {
        'name': {'required': True},
        'sampling_period': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'sampling_period': {'key': 'samplingPeriod', 'type': 'str'},
        'instance': {'key': 'instance', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(PerformanceCounterConfiguration, self).__init__(**kwargs)
        self.name = kwargs['name']
        self.sampling_period = kwargs['sampling_period']
        self.instance = kwargs.get('instance', None)


class SinkConfiguration(msrest.serialization.Model):
    """SinkConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required.  Possible values include: "EventHub", "ApplicationInsights",
     "LogAnalytics".
    :type kind: str or ~$(python-base-namespace).v2018_06_01_preview.models.SinkConfigurationKind
    """

    _validation = {
        'kind': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SinkConfiguration, self).__init__(**kwargs)
        self.kind = kwargs['kind']
