# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class AlertSeverity(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Severity Level of Alert
    """

    ZERO = "0"
    ONE = "1"
    TWO = "2"
    THREE = "3"
    FOUR = "4"

class ConditionalOperator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Result Condition Evaluation criteria. Supported Values - 'GreaterThan' or 'LessThan' or
    'Equal'.
    """

    GREATER_THAN_OR_EQUAL = "GreaterThanOrEqual"
    LESS_THAN_OR_EQUAL = "LessThanOrEqual"
    GREATER_THAN = "GreaterThan"
    LESS_THAN = "LessThan"
    EQUAL = "Equal"

class Enabled(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The flag which indicates whether the Log Search rule is enabled. Value should be true or false
    """

    TRUE = "true"
    FALSE = "false"

class MetricTriggerType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Metric Trigger Evaluation Type
    """

    CONSECUTIVE = "Consecutive"
    TOTAL = "Total"

class Operator(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Operator for dimension values
    """

    INCLUDE = "Include"

class ProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Provisioning state of the scheduled query rule
    """

    SUCCEEDED = "Succeeded"
    DEPLOYING = "Deploying"
    CANCELED = "Canceled"
    FAILED = "Failed"

class QueryType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Set value to 'ResultAccount'
    """

    RESULT_COUNT = "ResultCount"
