# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._monitor_management_client_enums import *


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = code
        self.message = message


class MetricNamespace(msrest.serialization.Model):
    """Metric namespace class specifies the metadata for a metric namespace.

    :param id: The ID of the metric namespace.
    :type id: str
    :param type: The type of the namespace.
    :type type: str
    :param name: The escaped name of the namespace.
    :type name: str
    :param classification: Kind of namespace. Possible values include: "Platform", "Custom", "Qos".
    :type classification: str or
     ~$(python-base-namespace).v2017_12_01_preview.models.NamespaceClassification
    :param properties: Properties which include the fully qualified namespace name.
    :type properties: ~$(python-base-namespace).v2017_12_01_preview.models.MetricNamespaceName
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'classification': {'key': 'classification', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'MetricNamespaceName'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        type: Optional[str] = None,
        name: Optional[str] = None,
        classification: Optional[Union[str, "NamespaceClassification"]] = None,
        properties: Optional["MetricNamespaceName"] = None,
        **kwargs
    ):
        super(MetricNamespace, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.name = name
        self.classification = classification
        self.properties = properties


class MetricNamespaceCollection(msrest.serialization.Model):
    """Represents collection of metric namespaces.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The values for the metric namespaces.
    :type value: list[~$(python-base-namespace).v2017_12_01_preview.models.MetricNamespace]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[MetricNamespace]'},
    }

    def __init__(
        self,
        *,
        value: List["MetricNamespace"],
        **kwargs
    ):
        super(MetricNamespaceCollection, self).__init__(**kwargs)
        self.value = value


class MetricNamespaceName(msrest.serialization.Model):
    """The fully qualified metric namespace name.

    :param metric_namespace_name: The metric namespace name.
    :type metric_namespace_name: str
    """

    _attribute_map = {
        'metric_namespace_name': {'key': 'metricNamespaceName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        metric_namespace_name: Optional[str] = None,
        **kwargs
    ):
        super(MetricNamespaceName, self).__init__(**kwargs)
        self.metric_namespace_name = metric_namespace_name
