# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.core.exceptions import HttpResponseError
import msrest.serialization


class Resource(msrest.serialization.Model):
    """An azure resource object.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = kwargs['location']
        self.tags = kwargs.get('tags', None)


class AlertRuleResource(Resource):
    """The alert rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param name_properties_name: Required. the name of the alert rule.
    :type name_properties_name: str
    :param description: the description of the alert rule that will be included in the alert email.
    :type description: str
    :param provisioning_state: the provisioning state.
    :type provisioning_state: str
    :param is_enabled: Required. the flag that indicates whether the alert rule is enabled.
    :type is_enabled: bool
    :param condition: Required. the condition that results in the alert rule being activated.
    :type condition: ~$(python-base-namespace).v2015_07_01.models.RuleCondition
    :param action: action that is performed when the alert rule becomes active, and when an alert
     condition is resolved.
    :type action: ~$(python-base-namespace).v2015_07_01.models.RuleAction
    :param actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :type actions: list[~$(python-base-namespace).v2015_07_01.models.RuleAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'name_properties_name': {'required': True},
        'is_enabled': {'required': True},
        'condition': {'required': True},
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'name_properties_name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'condition': {'key': 'properties.condition', 'type': 'RuleCondition'},
        'action': {'key': 'properties.action', 'type': 'RuleAction'},
        'actions': {'key': 'properties.actions', 'type': '[RuleAction]'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertRuleResource, self).__init__(**kwargs)
        self.name_properties_name = kwargs['name_properties_name']
        self.description = kwargs.get('description', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.is_enabled = kwargs['is_enabled']
        self.condition = kwargs['condition']
        self.action = kwargs.get('action', None)
        self.actions = kwargs.get('actions', None)
        self.last_updated_time = None


class AlertRuleResourceCollection(msrest.serialization.Model):
    """Represents a collection of alert rule resources.

    :param value: the values for the alert rule resources.
    :type value: list[~$(python-base-namespace).v2015_07_01.models.AlertRuleResource]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AlertRuleResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertRuleResourceCollection, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class AlertRuleResourcePatch(msrest.serialization.Model):
    """The alert rule object for patch operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param name: the name of the alert rule.
    :type name: str
    :param description: the description of the alert rule that will be included in the alert email.
    :type description: str
    :param provisioning_state: the provisioning state.
    :type provisioning_state: str
    :param is_enabled: the flag that indicates whether the alert rule is enabled.
    :type is_enabled: bool
    :param condition: the condition that results in the alert rule being activated.
    :type condition: ~$(python-base-namespace).v2015_07_01.models.RuleCondition
    :param action: action that is performed when the alert rule becomes active, and when an alert
     condition is resolved.
    :type action: ~$(python-base-namespace).v2015_07_01.models.RuleAction
    :param actions: the array of actions that are performed when the alert rule becomes active, and
     when an alert condition is resolved.
    :type actions: list[~$(python-base-namespace).v2015_07_01.models.RuleAction]
    :ivar last_updated_time: Last time the rule was updated in ISO8601 format.
    :vartype last_updated_time: ~datetime.datetime
    """

    _validation = {
        'last_updated_time': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'condition': {'key': 'properties.condition', 'type': 'RuleCondition'},
        'action': {'key': 'properties.action', 'type': 'RuleAction'},
        'actions': {'key': 'properties.actions', 'type': '[RuleAction]'},
        'last_updated_time': {'key': 'properties.lastUpdatedTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AlertRuleResourcePatch, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.name = kwargs.get('name', None)
        self.description = kwargs.get('description', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.is_enabled = kwargs.get('is_enabled', None)
        self.condition = kwargs.get('condition', None)
        self.action = kwargs.get('action', None)
        self.actions = kwargs.get('actions', None)
        self.last_updated_time = None


class DimensionProperties(msrest.serialization.Model):
    """Type of operation: get, read, delete, etc.

    :param name: Name of dimension.
    :type name: str
    :param display_name: Display name of dimension.
    :type display_name: str
    :param to_be_exported_for_shoebox: Legacy usage, should not set.
    :type to_be_exported_for_shoebox: bool
    :param is_hidden: When set, the dimension is hidden from the customer, used in conjunction with
     the defaultDimensionValues field below.
    :type is_hidden: bool
    :param default_dimension_values: Default dimension value to be sent down for the hidden
     dimension during query.
    :type default_dimension_values: any
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'to_be_exported_for_shoebox': {'key': 'toBeExportedForShoebox', 'type': 'bool'},
        'is_hidden': {'key': 'isHidden', 'type': 'bool'},
        'default_dimension_values': {'key': 'defaultDimensionValues', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DimensionProperties, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.to_be_exported_for_shoebox = kwargs.get('to_be_exported_for_shoebox', None)
        self.is_hidden = kwargs.get('is_hidden', None)
        self.default_dimension_values = kwargs.get('default_dimension_values', None)


class ErrorContract(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~$(python-base-namespace).v2015_07_01.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorContract, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponse(msrest.serialization.Model):
    """Describes the format of Error response.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class LocalizableString(msrest.serialization.Model):
    """The localizable string class.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. the invariant value.
    :type value: str
    :param localized_value: the locale specific value.
    :type localized_value: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocalizableString, self).__init__(**kwargs)
        self.value = kwargs['value']
        self.localized_value = kwargs.get('localized_value', None)


class RuleCondition(msrest.serialization.Model):
    """The condition that results in the alert rule being activated.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: LocationThresholdRuleCondition, ManagementEventRuleCondition, ThresholdRuleCondition.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric).Constant filled by server.
    :type odata_type: str
    :param data_source: the resource from which the rule collects its data. For this type
     dataSource will always be of type RuleMetricDataSource.
    :type data_source: ~$(python-base-namespace).v2015_07_01.models.RuleDataSource
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
    }

    _subtype_map = {
        'odata_type': {'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition': 'LocationThresholdRuleCondition', 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition': 'ManagementEventRuleCondition', 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition': 'ThresholdRuleCondition'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleCondition, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.data_source = kwargs.get('data_source', None)


class LocationThresholdRuleCondition(RuleCondition):
    """A rule condition based on a certain number of locations failing.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric).Constant filled by server.
    :type odata_type: str
    :param data_source: the resource from which the rule collects its data. For this type
     dataSource will always be of type RuleMetricDataSource.
    :type data_source: ~$(python-base-namespace).v2015_07_01.models.RuleDataSource
    :param window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. If specified then it must be between 5 minutes and 1
     day.
    :type window_size: ~datetime.timedelta
    :param failed_location_count: Required. the number of locations that must fail to activate the
     alert.
    :type failed_location_count: int
    """

    _validation = {
        'odata_type': {'required': True},
        'failed_location_count': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'window_size': {'key': 'windowSize', 'type': 'duration'},
        'failed_location_count': {'key': 'failedLocationCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LocationThresholdRuleCondition, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.LocationThresholdRuleCondition'  # type: str
        self.window_size = kwargs.get('window_size', None)
        self.failed_location_count = kwargs['failed_location_count']


class LogSettings(msrest.serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.

    All required parameters must be populated in order to send to Azure.

    :param category: Name of a Diagnostic Log category for a resource type this setting is applied
     to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET
     diagnostic settings operation.
    :type category: str
    :param enabled: Required. a value indicating whether this log is enabled.
    :type enabled: bool
    :param retention_policy: the retention policy for this log.
    :type retention_policy: ~$(python-base-namespace).v2015_07_01.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSettings, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.enabled = kwargs['enabled']
        self.retention_policy = kwargs.get('retention_policy', None)


class LogSpecification(msrest.serialization.Model):
    """Log specification of operation.

    :param name: Name of log specification.
    :type name: str
    :param display_name: Display name of log specification.
    :type display_name: str
    :param blob_duration: Blob duration of specification.
    :type blob_duration: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'blob_duration': {'key': 'blobDuration', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.blob_duration = kwargs.get('blob_duration', None)


class ManagementEventAggregationCondition(msrest.serialization.Model):
    """How the data that is collected should be combined over time.

    :param operator: the condition operator. Possible values include: "GreaterThan",
     "GreaterThanOrEqual", "LessThan", "LessThanOrEqual".
    :type operator: str or ~$(python-base-namespace).v2015_07_01.models.ConditionOperator
    :param threshold: The threshold value that activates the alert.
    :type threshold: float
    :param window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. If specified then it must be between 5 minutes and 1
     day.
    :type window_size: ~datetime.timedelta
    """

    _attribute_map = {
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'window_size': {'key': 'windowSize', 'type': 'duration'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementEventAggregationCondition, self).__init__(**kwargs)
        self.operator = kwargs.get('operator', None)
        self.threshold = kwargs.get('threshold', None)
        self.window_size = kwargs.get('window_size', None)


class ManagementEventRuleCondition(RuleCondition):
    """A management event rule condition.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric).Constant filled by server.
    :type odata_type: str
    :param data_source: the resource from which the rule collects its data. For this type
     dataSource will always be of type RuleMetricDataSource.
    :type data_source: ~$(python-base-namespace).v2015_07_01.models.RuleDataSource
    :param aggregation: How the data that is collected should be combined over time and when the
     alert is activated. Note that for management event alerts aggregation is optional – if it is
     not provided then any event will cause the alert to activate.
    :type aggregation:
     ~$(python-base-namespace).v2015_07_01.models.ManagementEventAggregationCondition
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'aggregation': {'key': 'aggregation', 'type': 'ManagementEventAggregationCondition'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ManagementEventRuleCondition, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.ManagementEventRuleCondition'  # type: str
        self.aggregation = kwargs.get('aggregation', None)


class MetricAvailability(msrest.serialization.Model):
    """Metric availability specifies the time grain (aggregation interval or frequency) and the retention period for that time grain.

    :param time_grain: the time grain specifies the aggregation interval for the metric. Expressed
     as a duration 'PT1M', 'P1D', etc.
    :type time_grain: ~datetime.timedelta
    :param retention: the retention period for the metric at the specified timegrain.  Expressed as
     a duration 'PT1M', 'P1D', etc.
    :type retention: ~datetime.timedelta
    :param location: Info about where the metric data is stored.
    :type location: ~$(python-base-namespace).v2015_07_01.models.MetricAvailabilityLocation
    """

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'retention': {'key': 'retention', 'type': 'duration'},
        'location': {'key': 'location', 'type': 'MetricAvailabilityLocation'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAvailability, self).__init__(**kwargs)
        self.time_grain = kwargs.get('time_grain', None)
        self.retention = kwargs.get('retention', None)
        self.location = kwargs.get('location', None)


class MetricAvailabilityLocation(msrest.serialization.Model):
    """Info about where the metric data is stored.

    :param table_endpoint: The url for the storage account.
    :type table_endpoint: str
    :param table_info: Info about the storage tables storing this resources metrics.
    :type table_info: list[~$(python-base-namespace).v2015_07_01.models.TableInfoEntry]
    :param partition_key: partition key in the table where the metrics for this resource are
     stored.
    :type partition_key: str
    """

    _attribute_map = {
        'table_endpoint': {'key': 'tableEndpoint', 'type': 'str'},
        'table_info': {'key': 'tableInfo', 'type': '[TableInfoEntry]'},
        'partition_key': {'key': 'partitionKey', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricAvailabilityLocation, self).__init__(**kwargs)
        self.table_endpoint = kwargs.get('table_endpoint', None)
        self.table_info = kwargs.get('table_info', None)
        self.partition_key = kwargs.get('partition_key', None)


class MetricDefinition(msrest.serialization.Model):
    """Metric definition class specifies the metadata for a metric.

    :param resource_id: The resource identifier of the resource that emitted the metric.
    :type resource_id: str
    :param resource_uri: The resource identifier of the resource that emitted the metric.
    :type resource_uri: str
    :param name: the name and the display name of the metric, i.e. it is a localizable string.
    :type name: ~$(python-base-namespace).v2015_07_01.models.LocalizableString
    :param category: The category of this metric.
    :type category: str
    :param unit: the unit of the metric. Possible values include: "Count", "Bytes", "Seconds",
     "CountPerSecond", "BytesPerSecond", "Percent", "MilliSeconds".
    :type unit: str or ~$(python-base-namespace).v2015_07_01.models.Unit
    :param start_time: Start time of the metadata request timespan.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the metadata request timespan.
    :type end_time: ~datetime.datetime
    :param primary_aggregation_type: the primary aggregation type value defining how to use the
     values for display. Possible values include: "None", "Average", "Count", "Minimum", "Maximum",
     "Total".
    :type primary_aggregation_type: str or
     ~$(python-base-namespace).v2015_07_01.models.AggregationType
    :param supported_aggregation_types: List of all aggregations that are applicable for this
     metric.
    :type supported_aggregation_types: list[str or
     ~$(python-base-namespace).v2015_07_01.models.AggregationType]
    :param metric_availabilities: the collection of what aggregation intervals are available to be
     queried.
    :type metric_availabilities:
     list[~$(python-base-namespace).v2015_07_01.models.MetricAvailability]
    :param id: the resource identifier of the metric definition.
    :type id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'name': {'key': 'name', 'type': 'LocalizableString'},
        'category': {'key': 'category', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'primary_aggregation_type': {'key': 'primaryAggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'metric_availabilities': {'key': 'metricAvailabilities', 'type': '[MetricAvailability]'},
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDefinition, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.resource_uri = kwargs.get('resource_uri', None)
        self.name = kwargs.get('name', None)
        self.category = kwargs.get('category', None)
        self.unit = kwargs.get('unit', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.primary_aggregation_type = kwargs.get('primary_aggregation_type', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)
        self.metric_availabilities = kwargs.get('metric_availabilities', None)
        self.id = kwargs.get('id', None)


class MetricDefinitionCollection(msrest.serialization.Model):
    """Represents collection of metric definitions.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id for these metric definitions.
    :type id: str
    :param value: Required. the values for the metric definitions.
    :type value: list[~$(python-base-namespace).v2015_07_01.models.MetricDefinition]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'value': {'key': 'value', 'type': '[MetricDefinition]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricDefinitionCollection, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.value = kwargs['value']


class MetricSettings(msrest.serialization.Model):
    """Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular metric.

    All required parameters must be populated in order to send to Azure.

    :param time_grain: Required. the timegrain of the metric in ISO8601 format.
    :type time_grain: ~datetime.timedelta
    :param enabled: Required. a value indicating whether this timegrain is enabled.
    :type enabled: bool
    :param retention_policy: the retention policy for this timegrain.
    :type retention_policy: ~$(python-base-namespace).v2015_07_01.models.RetentionPolicy
    """

    _validation = {
        'time_grain': {'required': True},
        'enabled': {'required': True},
    }

    _attribute_map = {
        'time_grain': {'key': 'timeGrain', 'type': 'duration'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'retention_policy': {'key': 'retentionPolicy', 'type': 'RetentionPolicy'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSettings, self).__init__(**kwargs)
        self.time_grain = kwargs['time_grain']
        self.enabled = kwargs['enabled']
        self.retention_policy = kwargs.get('retention_policy', None)


class MetricSpecification(msrest.serialization.Model):
    """Metric specification of operation.

    :param name: The name of the metric.
    :type name: str
    :param display_name: Display name of the metric.
    :type display_name: str
    :param display_description: Display description of the metric.
    :type display_description: str
    :param unit: The metric unit. Possible values include:
     Count,Bytes,Seconds,Percent,CountPerSecond,BytesPerSecond,MilliSeconds,ByteSeconds,Unspecified,BitsPerSecond,Cores,MilliCores,NanoCores.
    :type unit: str
    :param aggregation_type: The default metric aggregation type. Possible values include:
     Total,Average,Maximum,Minimum,Count.
    :type aggregation_type: str
    :param supported_aggregation_types: The supported aggregation types for the metrics.
    :type supported_aggregation_types: list[str]
    :param supported_time_grain_types: The supported time grain types for the metrics.
    :type supported_time_grain_types: list[str]
    :param availabilities: The supported time grain types for the metrics.
    :type availabilities: list[str]
    :param lock_aggregation_type: The metric lock aggregation type.
    :type lock_aggregation_type: str
    :param category: Category or type of metric.
    :type category: str
    :param dimensions: The dimensions of metric.
    :type dimensions: list[~$(python-base-namespace).v2015_07_01.models.DimensionProperties]
    :param fill_gap_with_zero: Property to specify whether to fill empty gaps with zero.
    :type fill_gap_with_zero: bool
    :param internal_metric_name: The internal metric name.
    :type internal_metric_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'display_description': {'key': 'displayDescription', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'aggregation_type': {'key': 'aggregationType', 'type': 'str'},
        'supported_aggregation_types': {'key': 'supportedAggregationTypes', 'type': '[str]'},
        'supported_time_grain_types': {'key': 'supportedTimeGrainTypes', 'type': '[str]'},
        'availabilities': {'key': 'availabilities', 'type': '[str]'},
        'lock_aggregation_type': {'key': 'lockAggregationType', 'type': 'str'},
        'category': {'key': 'category', 'type': 'str'},
        'dimensions': {'key': 'dimensions', 'type': '[DimensionProperties]'},
        'fill_gap_with_zero': {'key': 'fillGapWithZero', 'type': 'bool'},
        'internal_metric_name': {'key': 'internalMetricName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(MetricSpecification, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display_name = kwargs.get('display_name', None)
        self.display_description = kwargs.get('display_description', None)
        self.unit = kwargs.get('unit', None)
        self.aggregation_type = kwargs.get('aggregation_type', None)
        self.supported_aggregation_types = kwargs.get('supported_aggregation_types', None)
        self.supported_time_grain_types = kwargs.get('supported_time_grain_types', None)
        self.availabilities = kwargs.get('availabilities', None)
        self.lock_aggregation_type = kwargs.get('lock_aggregation_type', None)
        self.category = kwargs.get('category', None)
        self.dimensions = kwargs.get('dimensions', None)
        self.fill_gap_with_zero = kwargs.get('fill_gap_with_zero', None)
        self.internal_metric_name = kwargs.get('internal_metric_name', None)


class Operation(msrest.serialization.Model):
    """Microsoft Insights API operation definition.

    :param name: Operation name: {provider}/{resource}/{operation}.
    :type name: str
    :param is_data_action: Property to specify whether the action is a data action.
    :type is_data_action: bool
    :param display: Display metadata associated with the operation.
    :type display: ~$(python-base-namespace).v2015_07_01.models.OperationDisplay
    :param service_specification: One property of operation, include metric specifications.
    :type service_specification: ~$(python-base-namespace).v2015_07_01.models.ServiceSpecification
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'service_specification': {'key': 'properties.serviceSpecification', 'type': 'ServiceSpecification'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_data_action = kwargs.get('is_data_action', None)
        self.display = kwargs.get('display', None)
        self.service_specification = kwargs.get('service_specification', None)


class OperationDisplay(msrest.serialization.Model):
    """Display metadata associated with the operation.

    :param publisher: The publisher of this operation.
    :type publisher: str
    :param provider: Service provider: Microsoft.Insights.
    :type provider: str
    :param resource: Resource on which the operation is performed: AlertRules, Autoscale, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    :param description: The description of the operation.
    :type description: str
    """

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationDisplay, self).__init__(**kwargs)
        self.publisher = kwargs.get('publisher', None)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)
        self.description = kwargs.get('description', None)


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list Microsoft.Insights operations. It contains a list of operations and a URL link to get the next set of results.

    :param value: List of operations supported by the Microsoft.Insights provider.
    :type value: list[~$(python-base-namespace).v2015_07_01.models.Operation]
    :param next_link: URL to get the next set of operation list results if there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RetentionPolicy(msrest.serialization.Model):
    """Specifies the retention policy for the log.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. a value indicating whether the retention policy is enabled.
    :type enabled: bool
    :param days: Required. the number of days for the retention in days. A value of 0 will retain
     the events indefinitely.
    :type days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'days': {'key': 'days', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = kwargs['enabled']
        self.days = kwargs['days']


class RuleAction(msrest.serialization.Model):
    """The action that is performed when the alert rule becomes active, and when an alert condition is resolved.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RuleEmailAction, RuleWebhookAction.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of the action. There are two types of actions:
     RuleEmailAction and RuleWebhookAction.Constant filled by server.
    :type odata_type: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'Microsoft.Azure.Management.Insights.Models.RuleEmailAction': 'RuleEmailAction', 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction': 'RuleWebhookAction'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleAction, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]


class RuleDataSource(msrest.serialization.Model):
    """The resource from which the rule collects its data.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: RuleManagementEventDataSource, RuleMetricDataSource.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of data source. There are two types of rule
     data sources: RuleMetricDataSource and RuleManagementEventDataSource.Constant filled by server.
    :type odata_type: str
    :param resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ :
     this property cannot be updated for an existing rule.
    :type resource_uri: str
    :param legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
     **NOTE**\ : this property cannot be updated for an existing rule.
    :type legacy_resource_id: str
    :param resource_location: the location of the resource.
    :type resource_location: str
    :param metric_namespace: the namespace of the metric.
    :type metric_namespace: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'legacy_resource_id': {'key': 'legacyResourceId', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
    }

    _subtype_map = {
        'odata_type': {'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource': 'RuleManagementEventDataSource', 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource': 'RuleMetricDataSource'}
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleDataSource, self).__init__(**kwargs)
        self.odata_type = None  # type: Optional[str]
        self.resource_uri = kwargs.get('resource_uri', None)
        self.legacy_resource_id = kwargs.get('legacy_resource_id', None)
        self.resource_location = kwargs.get('resource_location', None)
        self.metric_namespace = kwargs.get('metric_namespace', None)


class RuleEmailAction(RuleAction):
    """Specifies the action to send email when the rule condition is evaluated. The discriminator is always RuleEmailAction in this case.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of the action. There are two types of actions:
     RuleEmailAction and RuleWebhookAction.Constant filled by server.
    :type odata_type: str
    :param send_to_service_owners: Whether the administrators (service and co-administrators) of
     the service should be notified when the alert is activated.
    :type send_to_service_owners: bool
    :param custom_emails: the list of administrator's custom email addresses to notify of the
     activation of the alert.
    :type custom_emails: list[str]
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'send_to_service_owners': {'key': 'sendToServiceOwners', 'type': 'bool'},
        'custom_emails': {'key': 'customEmails', 'type': '[str]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleEmailAction, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.RuleEmailAction'  # type: str
        self.send_to_service_owners = kwargs.get('send_to_service_owners', None)
        self.custom_emails = kwargs.get('custom_emails', None)


class RuleManagementEventClaimsDataSource(msrest.serialization.Model):
    """The claims for a rule management event data source.

    :param email_address: the email address.
    :type email_address: str
    """

    _attribute_map = {
        'email_address': {'key': 'emailAddress', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleManagementEventClaimsDataSource, self).__init__(**kwargs)
        self.email_address = kwargs.get('email_address', None)


class RuleManagementEventDataSource(RuleDataSource):
    """A rule management event data source. The discriminator fields is always RuleManagementEventDataSource in this case.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of data source. There are two types of rule
     data sources: RuleMetricDataSource and RuleManagementEventDataSource.Constant filled by server.
    :type odata_type: str
    :param resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ :
     this property cannot be updated for an existing rule.
    :type resource_uri: str
    :param legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
     **NOTE**\ : this property cannot be updated for an existing rule.
    :type legacy_resource_id: str
    :param resource_location: the location of the resource.
    :type resource_location: str
    :param metric_namespace: the namespace of the metric.
    :type metric_namespace: str
    :param event_name: the event name.
    :type event_name: str
    :param event_source: the event source.
    :type event_source: str
    :param level: the level.
    :type level: str
    :param operation_name: The name of the operation that should be checked for. If no name is
     provided, any operation will match.
    :type operation_name: str
    :param resource_group_name: the resource group name.
    :type resource_group_name: str
    :param resource_provider_name: the resource provider name.
    :type resource_provider_name: str
    :param status: The status of the operation that should be checked for. If no status is
     provided, any status will match.
    :type status: str
    :param sub_status: the substatus.
    :type sub_status: str
    :param claims: the claims.
    :type claims: ~$(python-base-namespace).v2015_07_01.models.RuleManagementEventClaimsDataSource
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'legacy_resource_id': {'key': 'legacyResourceId', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'event_name': {'key': 'eventName', 'type': 'str'},
        'event_source': {'key': 'eventSource', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'operation_name': {'key': 'operationName', 'type': 'str'},
        'resource_group_name': {'key': 'resourceGroupName', 'type': 'str'},
        'resource_provider_name': {'key': 'resourceProviderName', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'sub_status': {'key': 'subStatus', 'type': 'str'},
        'claims': {'key': 'claims', 'type': 'RuleManagementEventClaimsDataSource'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleManagementEventDataSource, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.RuleManagementEventDataSource'  # type: str
        self.event_name = kwargs.get('event_name', None)
        self.event_source = kwargs.get('event_source', None)
        self.level = kwargs.get('level', None)
        self.operation_name = kwargs.get('operation_name', None)
        self.resource_group_name = kwargs.get('resource_group_name', None)
        self.resource_provider_name = kwargs.get('resource_provider_name', None)
        self.status = kwargs.get('status', None)
        self.sub_status = kwargs.get('sub_status', None)
        self.claims = kwargs.get('claims', None)


class RuleMetricDataSource(RuleDataSource):
    """A rule metric data source. The discriminator value is always RuleMetricDataSource in this case.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of data source. There are two types of rule
     data sources: RuleMetricDataSource and RuleManagementEventDataSource.Constant filled by server.
    :type odata_type: str
    :param resource_uri: the resource identifier of the resource the rule monitors. **NOTE**\ :
     this property cannot be updated for an existing rule.
    :type resource_uri: str
    :param legacy_resource_id: the legacy resource identifier of the resource the rule monitors.
     **NOTE**\ : this property cannot be updated for an existing rule.
    :type legacy_resource_id: str
    :param resource_location: the location of the resource.
    :type resource_location: str
    :param metric_namespace: the namespace of the metric.
    :type metric_namespace: str
    :param metric_name: the name of the metric that defines what the rule monitors.
    :type metric_name: str
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'resource_uri': {'key': 'resourceUri', 'type': 'str'},
        'legacy_resource_id': {'key': 'legacyResourceId', 'type': 'str'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleMetricDataSource, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.RuleMetricDataSource'  # type: str
        self.metric_name = kwargs.get('metric_name', None)


class RuleWebhookAction(RuleAction):
    """Specifies the action to post to service when the rule condition is evaluated. The discriminator is always RuleWebhookAction in this case.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of the action. There are two types of actions:
     RuleEmailAction and RuleWebhookAction.Constant filled by server.
    :type odata_type: str
    :param service_uri: the service uri to Post the notification when the alert activates or
     resolves.
    :type service_uri: str
    :param properties: the dictionary of custom properties to include with the post operation.
     These data are appended to the webhook payload.
    :type properties: dict[str, str]
    """

    _validation = {
        'odata_type': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RuleWebhookAction, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'  # type: str
        self.service_uri = kwargs.get('service_uri', None)
        self.properties = kwargs.get('properties', None)


class ServiceDiagnosticSettingsResource(Resource):
    """Description of a service diagnostic setting.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure resource Id.
    :vartype id: str
    :ivar name: Azure resource name.
    :vartype name: str
    :ivar type: Azure resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param storage_account_id: The resource ID of the storage account to which you would like to
     send Diagnostic Logs.
    :type storage_account_id: str
    :param service_bus_rule_id: The service bus rule ID of the service bus namespace in which you
     would like to have Event Hubs created for streaming Diagnostic Logs. The rule ID is of the
     format: '{service bus resource ID}/authorizationrules/{key name}'.
    :type service_bus_rule_id: str
    :param metrics: the list of metric settings.
    :type metrics: list[~$(python-base-namespace).v2015_07_01.models.MetricSettings]
    :param logs: the list of logs settings.
    :type logs: list[~$(python-base-namespace).v2015_07_01.models.LogSettings]
    :param workspace_id: The workspace ID (resource ID of a Log Analytics workspace) for a Log
     Analytics workspace to which you would like to send Diagnostic Logs. Example:
     /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2.
    :type workspace_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'storage_account_id': {'key': 'properties.storageAccountId', 'type': 'str'},
        'service_bus_rule_id': {'key': 'properties.serviceBusRuleId', 'type': 'str'},
        'metrics': {'key': 'properties.metrics', 'type': '[MetricSettings]'},
        'logs': {'key': 'properties.logs', 'type': '[LogSettings]'},
        'workspace_id': {'key': 'properties.workspaceId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceDiagnosticSettingsResource, self).__init__(**kwargs)
        self.storage_account_id = kwargs.get('storage_account_id', None)
        self.service_bus_rule_id = kwargs.get('service_bus_rule_id', None)
        self.metrics = kwargs.get('metrics', None)
        self.logs = kwargs.get('logs', None)
        self.workspace_id = kwargs.get('workspace_id', None)


class ServiceSpecification(msrest.serialization.Model):
    """One property of operation, include log specifications.

    :param log_specifications: Log specifications of operation.
    :type log_specifications: list[~$(python-base-namespace).v2015_07_01.models.LogSpecification]
    :param metric_specifications: Metric specifications of operation.
    :type metric_specifications:
     list[~$(python-base-namespace).v2015_07_01.models.MetricSpecification]
    :param legacy_metric_specifications: Legacy Metric specifications for operation. Deprecated, do
     not use.
    :type legacy_metric_specifications: any
    """

    _attribute_map = {
        'log_specifications': {'key': 'logSpecifications', 'type': '[LogSpecification]'},
        'metric_specifications': {'key': 'metricSpecifications', 'type': '[MetricSpecification]'},
        'legacy_metric_specifications': {'key': 'legacyMetricSpecifications', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ServiceSpecification, self).__init__(**kwargs)
        self.log_specifications = kwargs.get('log_specifications', None)
        self.metric_specifications = kwargs.get('metric_specifications', None)
        self.legacy_metric_specifications = kwargs.get('legacy_metric_specifications', None)


class TableInfoEntry(msrest.serialization.Model):
    """Info about a storage table with metric data.

    :param table_name: Name of a table with metric data for this resource.
    :type table_name: str
    :param start_time: Start time of the metrics in this table.
    :type start_time: ~datetime.datetime
    :param end_time: End time of the metrics in this table.
    :type end_time: ~datetime.datetime
    :param sas_token: For the storage account with metrics.
    :type sas_token: str
    :param sas_token_expiration_time: For the storage account with metrics.
    :type sas_token_expiration_time: ~datetime.datetime
    """

    _attribute_map = {
        'table_name': {'key': 'tableName', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'sas_token': {'key': 'sasToken', 'type': 'str'},
        'sas_token_expiration_time': {'key': 'sasTokenExpirationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(TableInfoEntry, self).__init__(**kwargs)
        self.table_name = kwargs.get('table_name', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.sas_token = kwargs.get('sas_token', None)
        self.sas_token_expiration_time = kwargs.get('sas_token_expiration_time', None)


class ThresholdRuleCondition(RuleCondition):
    """A rule condition based on a metric crossing a threshold.

    All required parameters must be populated in order to send to Azure.

    :param odata_type: Required. specifies the type of condition. This can be one of three types:
     ManagementEventRuleCondition (occurrences of management events), LocationThresholdRuleCondition
     (based on the number of failures of a web test), and ThresholdRuleCondition (based on the
     threshold of a metric).Constant filled by server.
    :type odata_type: str
    :param data_source: the resource from which the rule collects its data. For this type
     dataSource will always be of type RuleMetricDataSource.
    :type data_source: ~$(python-base-namespace).v2015_07_01.models.RuleDataSource
    :param operator: Required. the operator used to compare the data and the threshold. Possible
     values include: "GreaterThan", "GreaterThanOrEqual", "LessThan", "LessThanOrEqual".
    :type operator: str or ~$(python-base-namespace).v2015_07_01.models.ConditionOperator
    :param threshold: Required. the threshold value that activates the alert.
    :type threshold: float
    :param window_size: the period of time (in ISO 8601 duration format) that is used to monitor
     alert activity based on the threshold. If specified then it must be between 5 minutes and 1
     day.
    :type window_size: ~datetime.timedelta
    :param time_aggregation: the time aggregation operator. How the data that are collected should
     be combined over time. The default value is the PrimaryAggregationType of the Metric. Possible
     values include: "Average", "Minimum", "Maximum", "Total", "Last".
    :type time_aggregation: str or
     ~$(python-base-namespace).v2015_07_01.models.TimeAggregationOperator
    """

    _validation = {
        'odata_type': {'required': True},
        'operator': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'odata_type': {'key': 'odata\\.type', 'type': 'str'},
        'data_source': {'key': 'dataSource', 'type': 'RuleDataSource'},
        'operator': {'key': 'operator', 'type': 'str'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'window_size': {'key': 'windowSize', 'type': 'duration'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ThresholdRuleCondition, self).__init__(**kwargs)
        self.odata_type = 'Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition'  # type: str
        self.operator = kwargs['operator']
        self.threshold = kwargs['threshold']
        self.window_size = kwargs.get('window_size', None)
        self.time_aggregation = kwargs.get('time_aggregation', None)
