# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import resources_pb2 as resources__pb2


class ResourcesStub(object):
    """Resources are databases, servers, clusters, websites, or clouds that strongDM
    delegates access to.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.EnumerateTags = channel.unary_unary(
                '/v1.Resources/EnumerateTags',
                request_serializer=resources__pb2.EnumerateTagsRequest.SerializeToString,
                response_deserializer=resources__pb2.EnumerateTagsResponse.FromString,
                )
        self.Create = channel.unary_unary(
                '/v1.Resources/Create',
                request_serializer=resources__pb2.ResourceCreateRequest.SerializeToString,
                response_deserializer=resources__pb2.ResourceCreateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.Resources/Get',
                request_serializer=resources__pb2.ResourceGetRequest.SerializeToString,
                response_deserializer=resources__pb2.ResourceGetResponse.FromString,
                )
        self.Update = channel.unary_unary(
                '/v1.Resources/Update',
                request_serializer=resources__pb2.ResourceUpdateRequest.SerializeToString,
                response_deserializer=resources__pb2.ResourceUpdateResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.Resources/Delete',
                request_serializer=resources__pb2.ResourceDeleteRequest.SerializeToString,
                response_deserializer=resources__pb2.ResourceDeleteResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.Resources/List',
                request_serializer=resources__pb2.ResourceListRequest.SerializeToString,
                response_deserializer=resources__pb2.ResourceListResponse.FromString,
                )


class ResourcesServicer(object):
    """Resources are databases, servers, clusters, websites, or clouds that strongDM
    delegates access to.
    """

    def EnumerateTags(self, request, context):
        """EnumerateTags gets a list of the filter matching tags.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Create(self, request, context):
        """Create registers a new Resource.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one Resource by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Update(self, request, context):
        """Update replaces all the fields of a Resource by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete removes a Resource by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of Resources matching a given set of criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_ResourcesServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'EnumerateTags': grpc.unary_unary_rpc_method_handler(
                    servicer.EnumerateTags,
                    request_deserializer=resources__pb2.EnumerateTagsRequest.FromString,
                    response_serializer=resources__pb2.EnumerateTagsResponse.SerializeToString,
            ),
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=resources__pb2.ResourceCreateRequest.FromString,
                    response_serializer=resources__pb2.ResourceCreateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=resources__pb2.ResourceGetRequest.FromString,
                    response_serializer=resources__pb2.ResourceGetResponse.SerializeToString,
            ),
            'Update': grpc.unary_unary_rpc_method_handler(
                    servicer.Update,
                    request_deserializer=resources__pb2.ResourceUpdateRequest.FromString,
                    response_serializer=resources__pb2.ResourceUpdateResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=resources__pb2.ResourceDeleteRequest.FromString,
                    response_serializer=resources__pb2.ResourceDeleteResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=resources__pb2.ResourceListRequest.FromString,
                    response_serializer=resources__pb2.ResourceListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.Resources', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class Resources(object):
    """Resources are databases, servers, clusters, websites, or clouds that strongDM
    delegates access to.
    """

    @staticmethod
    def EnumerateTags(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Resources/EnumerateTags',
            resources__pb2.EnumerateTagsRequest.SerializeToString,
            resources__pb2.EnumerateTagsResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Resources/Create',
            resources__pb2.ResourceCreateRequest.SerializeToString,
            resources__pb2.ResourceCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Resources/Get',
            resources__pb2.ResourceGetRequest.SerializeToString,
            resources__pb2.ResourceGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Update(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Resources/Update',
            resources__pb2.ResourceUpdateRequest.SerializeToString,
            resources__pb2.ResourceUpdateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Resources/Delete',
            resources__pb2.ResourceDeleteRequest.SerializeToString,
            resources__pb2.ResourceDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.Resources/List',
            resources__pb2.ResourceListRequest.SerializeToString,
            resources__pb2.ResourceListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
