# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class ActionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
    """

    INTERNAL = "Internal"

class AuthType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The authentication type.
    """

    SYSTEM_ASSIGNED_IDENTITY = "systemAssignedIdentity"
    USER_ASSIGNED_IDENTITY = "userAssignedIdentity"
    SERVICE_PRINCIPAL_SECRET = "servicePrincipalSecret"
    SERVICE_PRINCIPAL_CERTIFICATE = "servicePrincipalCertificate"
    SECRET = "secret"

class ClientType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The application client type
    """

    NONE = "none"
    DOTNET = "dotnet"
    JAVA = "java"
    PYTHON = "python"
    GO = "go"
    PHP = "php"
    RUBY = "ruby"
    DJANGO = "django"
    NODEJS = "nodejs"
    SPRING_BOOT = "springBoot"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class Origin(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system"
    """

    USER = "user"
    SYSTEM = "system"
    USER_SYSTEM = "user,system"

class SecretType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The secret type.
    """

    RAW_VALUE = "rawValue"
    KEY_VAULT_SECRET_URI = "keyVaultSecretUri"
    KEY_VAULT_SECRET_REFERENCE = "keyVaultSecretReference"

class Type(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The target service type.
    """

    AZURE_RESOURCE = "AzureResource"
    CONFLUENT_BOOTSTRAP_SERVER = "ConfluentBootstrapServer"
    CONFLUENT_SCHEMA_REGISTRY = "ConfluentSchemaRegistry"
    KEY_VAULT = "KeyVault"

class ValidationResultStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The result of validation
    """

    SUCCESS = "success"
    FAILED = "failed"
    WARNING = "warning"

class VNetSolutionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Type of VNet solution.
    """

    SERVICE_ENDPOINT = "serviceEndpoint"
    PRIVATE_LINK = "privateLink"
