/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.io;

import be.fedict.eid.applet.View;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Arrays;
import javax.net.SocketFactory;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class AppletSSLSocketFactory
extends SSLSocketFactory
implements HandshakeCompletedListener {
    private View view;
    private final SSLSocketFactory originalSslSocketFactory;
    private byte[] sslSessionId;
    private byte[] encodedPeerCertificate;

    public AppletSSLSocketFactory(View view, SSLSocketFactory originalSslSocketFactory) {
        this.view = view;
        this.originalSslSocketFactory = originalSslSocketFactory;
    }

    private void setView(View view) {
        this.view = view;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
        Socket socket = this.originalSslSocketFactory.createSocket(s, host, port, autoClose);
        this.installHandshakeCompletedListener(socket);
        return socket;
    }

    private void installHandshakeCompletedListener(Socket socket) throws IOException {
        SSLSocket sslSocket = (SSLSocket)socket;
        sslSocket.addHandshakeCompletedListener(this);
    }

    public String[] getDefaultCipherSuites() {
        return this.originalSslSocketFactory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.originalSslSocketFactory.getSupportedCipherSuites();
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.originalSslSocketFactory.createSocket(host, port);
        this.installHandshakeCompletedListener(socket);
        return socket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.originalSslSocketFactory.createSocket(host, port);
        this.installHandshakeCompletedListener(socket);
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.originalSslSocketFactory.createSocket(host, port, localHost, localPort);
        this.installHandshakeCompletedListener(socket);
        return socket;
    }

    public Socket createSocket(InetAddress host, int port, InetAddress localHost, int localPort) throws IOException {
        Socket socket = this.originalSslSocketFactory.createSocket(host, port, localHost, localPort);
        this.installHandshakeCompletedListener(socket);
        return socket;
    }

    public byte[] getSessionId() {
        if (null == this.sslSessionId) {
            throw new IllegalStateException("SSL session identifier unknown");
        }
        return this.sslSessionId;
    }

    public byte[] getEncodedPeerCertificate() {
        if (null == this.encodedPeerCertificate) {
            throw new IllegalStateException("SSL peer certificate unknown");
        }
        return this.encodedPeerCertificate;
    }

    public Socket createSocket() throws IOException {
        Socket socket = this.originalSslSocketFactory.createSocket();
        this.installHandshakeCompletedListener(socket);
        return socket;
    }

    public void handshakeCompleted(HandshakeCompletedEvent event) {
        String cipherSuite = event.getCipherSuite();
        this.view.addDetailMessage("SSL handshake finish cipher suite: " + cipherSuite);
        SSLSession sslSession = event.getSession();
        byte[] sslSessionId = sslSession.getId();
        if (null != this.sslSessionId && !Arrays.equals(this.sslSessionId, sslSessionId)) {
            this.view.addDetailMessage("SSL session Id mismatch");
        }
        this.sslSessionId = sslSessionId;
        try {
            Certificate[] peerCertificates = sslSession.getPeerCertificates();
            this.encodedPeerCertificate = peerCertificates[0].getEncoded();
        }
        catch (SSLPeerUnverifiedException e) {
            this.view.addDetailMessage("SSL peer unverified");
        }
        catch (CertificateEncodingException e) {
            this.view.addDetailMessage("certificate encoding error: " + e.getMessage());
        }
    }

    public static SocketFactory getDefault() {
        SSLSocketFactory sslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        return sslSocketFactory;
    }

    public static void installSocketFactory(View view) {
        SSLSocketFactory sslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        if (!(sslSocketFactory instanceof AppletSSLSocketFactory)) {
            AppletSSLSocketFactory appletSslSocketFactory = new AppletSSLSocketFactory(view, sslSocketFactory);
            HttpsURLConnection.setDefaultSSLSocketFactory(appletSslSocketFactory);
        } else {
            AppletSSLSocketFactory appletSslSocketFactory = (AppletSSLSocketFactory)sslSocketFactory;
            appletSslSocketFactory.setView(view);
        }
    }

    public static byte[] getActualSessionId() {
        AppletSSLSocketFactory appletSslSocketFactory = AppletSSLSocketFactory.getAppletSSLSocketFactory();
        byte[] sessionId = appletSslSocketFactory.getSessionId();
        return sessionId;
    }

    private static AppletSSLSocketFactory getAppletSSLSocketFactory() {
        SSLSocketFactory sslSocketFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
        if (!(sslSocketFactory instanceof AppletSSLSocketFactory)) {
            throw new SecurityException("wrong SSL socket factory");
        }
        AppletSSLSocketFactory appletSslSocketFactory = (AppletSSLSocketFactory)sslSocketFactory;
        return appletSslSocketFactory;
    }

    public static byte[] getActualEncodedServerCertificate() {
        AppletSSLSocketFactory appletSslSocketFactory = AppletSSLSocketFactory.getAppletSSLSocketFactory();
        byte[] encodedPeerCertificate = appletSslSocketFactory.getEncodedPeerCertificate();
        return encodedPeerCertificate;
    }
}

