/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet;

import be.fedict.eid.applet.Controller;
import be.fedict.eid.applet.DiagnosticTests;
import be.fedict.eid.applet.JStatusLabel;
import be.fedict.eid.applet.Messages;
import be.fedict.eid.applet.Runtime;
import be.fedict.eid.applet.Status;
import be.fedict.eid.applet.View;
import java.applet.AppletContext;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Applet
extends JApplet {
    private static final long serialVersionUID = 1L;
    public static final String TARGET_PAGE_PARAM = "TargetPage";
    public static final String BACKGROUND_COLOR_PARAM = "BackgroundColor";
    public static final String FOREGROUND_COLOR_PARAM = "ForegroundColor";
    public static final String LANGUAGE_PARAM = "Language";
    public static final String MESSAGE_CALLBACK_PARAM = "MessageCallback";
    public static final String MESSAGE_CALLBACK_EX_PARAM = "MessageCallbackEx";
    public static final String DIAGNOSTIC_TEST_CALLBACK_PARAM = "DiagnosticTestCallback";
    public static final String HIDE_DETAILS_BUTTON_PARAM = "HideDetailsButton";
    private JStatusLabel statusLabel;
    private JTextArea detailMessages;
    private JProgressBar progressBar;
    private boolean securityConditionTrustedWebApp;
    private Thread workerThread;
    private Messages messages;
    private String messageCallbackParam;
    private String messageCallbackExParam;
    private String diagnosticTestCallbackParam;
    private boolean hideDetailsButtonParam;
    private int progress;

    private void setStatusMessage(final Status status, Messages.MESSAGE_ID messageId) {
        final String statusMessage = this.messages.getMessage(messageId);
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Applet.this.statusLabel.setText(statusMessage);
                    Applet.this.statusLabel.getAccessibleContext().setAccessibleName(statusMessage);
                    if (Status.ERROR == status) {
                        Applet.this.statusLabel.setForeground(Color.RED);
                        Applet.this.progressBar.setIndeterminate(false);
                    }
                    Applet.this.statusLabel.invalidate();
                    if (!Applet.this.hideDetailsButtonParam) {
                        Applet.this.detailMessages.append(statusMessage + "\n");
                        Applet.this.detailMessages.setCaretPosition(Applet.this.detailMessages.getDocument().getLength());
                    } else {
                        System.out.println(statusMessage);
                    }
                }
            });
            this.invokeMessageCallback(status, messageId);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void invokeMessageCallback(Status status, Messages.MESSAGE_ID messageId) {
        Class<?> jsObjectClass;
        if (null == this.messageCallbackParam && null == this.messageCallbackExParam) {
            return;
        }
        ClassLoader classLoader = Applet.class.getClassLoader();
        try {
            jsObjectClass = classLoader.loadClass("netscape.javascript.JSObject");
        }
        catch (ClassNotFoundException e) {
            String msg = "JSObject class not found";
            if (!this.hideDetailsButtonParam) {
                this.detailMessages.append(msg + "\n");
                this.detailMessages.setCaretPosition(this.detailMessages.getDocument().getLength());
            } else {
                System.out.println(msg);
            }
            return;
        }
        try {
            String statusMessage;
            Method getWindowMethod = jsObjectClass.getMethod("getWindow", java.applet.Applet.class);
            Object jsObject = getWindowMethod.invoke(null, this);
            Method callMethod = jsObjectClass.getMethod("call", String.class, Class.forName("[Ljava.lang.Object;"));
            if (null != this.messageCallbackParam) {
                this.addDetailMessage("invoking Javascript message callback: " + this.messageCallbackParam);
                statusMessage = this.messages.getMessage(messageId);
                callMethod.invoke(jsObject, this.messageCallbackParam, new Object[]{status.name(), statusMessage});
            }
            if (null != this.messageCallbackExParam) {
                this.addDetailMessage("invoking Javascript message callback (ex): " + this.messageCallbackExParam);
                statusMessage = this.messages.getMessage(messageId);
                callMethod.invoke(jsObject, this.messageCallbackExParam, new Object[]{status.name(), messageId.name(), statusMessage});
            }
        }
        catch (Exception e) {
            String msg = "error locating: JSObject.getWindow().call: " + e.getMessage();
            if (!this.hideDetailsButtonParam) {
                this.detailMessages.append(msg + "\n");
                this.detailMessages.setCaretPosition(this.detailMessages.getDocument().getLength());
            } else {
                System.out.println(msg);
            }
            return;
        }
    }

    public void init() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Applet.this.initUI();
                }
            });
        }
        catch (Exception e) {
            StackTraceElement[] stackTrace;
            System.err.println("initUI didn't successfully complete: " + e.getMessage());
            for (StackTraceElement stackTraceElement : stackTrace = e.getStackTrace()) {
                System.err.println(stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber());
            }
        }
    }

    public void start() {
        if (null == this.workerThread) {
            this.workerThread = new Thread(new AppletThread());
            this.workerThread.start();
        } else {
            this.addDetailMessage("Restart detected.");
        }
    }

    private void gotoTargetPage() {
        String targetPageParam = this.getParameter(TARGET_PAGE_PARAM);
        if (null != targetPageParam) {
            AppletContext appletContext = this.getAppletContext();
            URL documentBase = this.getDocumentBase();
            try {
                URL targetUrl = new URL(documentBase, targetPageParam);
                this.addDetailMessage("Navigating to: " + targetUrl);
                appletContext.showDocument(targetUrl, "_self");
            }
            catch (MalformedURLException e) {
                this.addDetailMessage("URL error: " + e.getMessage());
            }
        }
    }

    private void addDetailMessage(final String detailMessage) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (!Applet.this.hideDetailsButtonParam) {
                        Applet.this.detailMessages.append(detailMessage + "\n");
                        Applet.this.detailMessages.setCaretPosition(Applet.this.detailMessages.getDocument().getLength());
                    } else {
                        System.out.println(detailMessage);
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public AppletContext getAppletContext() {
        if (!this.securityConditionTrustedWebApp) {
            throw new SecurityException("web application not trusted");
        }
        return super.getAppletContext();
    }

    public String getParameter(String name) {
        if (!this.securityConditionTrustedWebApp) {
            throw new SecurityException("web application not trusted");
        }
        return super.getParameter(name);
    }

    private void setBackgroundColor(Container container, Color backgroundColor) {
        for (Component component : container.getComponents()) {
            component.setBackground(backgroundColor);
            if (!(component instanceof Container)) continue;
            this.setBackgroundColor((Container)component, backgroundColor);
        }
        container.setBackground(backgroundColor);
    }

    private void initUI() {
        this.loadMessages();
        this.initStyle();
        this.messageCallbackParam = super.getParameter(MESSAGE_CALLBACK_PARAM);
        this.messageCallbackExParam = super.getParameter(MESSAGE_CALLBACK_EX_PARAM);
        this.diagnosticTestCallbackParam = super.getParameter(DIAGNOSTIC_TEST_CALLBACK_PARAM);
        String hideDetailsButtonParam = super.getParameter(HIDE_DETAILS_BUTTON_PARAM);
        this.hideDetailsButtonParam = null != hideDetailsButtonParam ? Boolean.parseBoolean(hideDetailsButtonParam) : false;
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 3));
        this.initStatusPanel(contentPane);
        contentPane.add(Box.createVerticalStrut(10));
        this.initProgressBar(contentPane);
        if (!this.hideDetailsButtonParam) {
            contentPane.add(Box.createVerticalStrut(10));
            this.initDetailPanel(contentPane);
        }
        this.setupColors(contentPane);
    }

    private void initStyle() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void loadMessages() {
        String languageParam = super.getParameter(LANGUAGE_PARAM);
        Locale locale = null != languageParam ? new Locale(languageParam) : this.getLocale();
        JRootPane.setDefaultLocale(locale);
        this.messages = new Messages(locale);
    }

    private void initDetailPanel(Container container) {
        CardLayout cardLayout = new CardLayout();
        JPanel detailPanel = new JPanel(cardLayout);
        this.initDetailButton(detailPanel, cardLayout);
        this.initDetailMessages(detailPanel);
        container.add(detailPanel);
    }

    private void initDetailButton(final Container container, final CardLayout cardLayout) {
        JPanel panel = new JPanel(new FlowLayout(0));
        String msg = this.messages.getMessage(Messages.MESSAGE_ID.DETAILS_BUTTON);
        JButton detailButton = new JButton(msg + " >>");
        detailButton.getAccessibleContext().setAccessibleName(msg);
        detailButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                cardLayout.next(container);
            }
        });
        panel.add(detailButton);
        container.add((Component)panel, "button");
    }

    private void initDetailMessages(Container container) {
        this.detailMessages = new JTextArea(10, 80);
        this.detailMessages.setEditable(false);
        this.detailMessages.setLocale(Locale.ENGLISH);
        this.detailMessages.getAccessibleContext().setAccessibleDescription("Detailed log messages");
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem copyMenuItem = new JMenuItem(this.messages.getMessage(Messages.MESSAGE_ID.COPY_ALL));
        copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Clipboard clipboard = toolkit.getSystemClipboard();
                StringSelection stringSelection = new StringSelection(Applet.this.detailMessages.getText());
                clipboard.setContents(stringSelection, null);
            }
        });
        popupMenu.add(copyMenuItem);
        this.addMailMenuItem(popupMenu);
        this.detailMessages.setComponentPopupMenu(popupMenu);
        JScrollPane scrollPane = new JScrollPane(this.detailMessages, 22, 30);
        container.add((Component)scrollPane, "details");
    }

    private void initProgressBar(Container container) {
        this.progressBar = new JProgressBar();
        this.progressBar.setIndeterminate(true);
        container.add(this.progressBar);
    }

    private void initStatusPanel(Container container) {
        JPanel statusPanel = new JPanel();
        statusPanel.setLayout(new BoxLayout(statusPanel, 2));
        String msg = this.messages.getMessage(Messages.MESSAGE_ID.LOADING);
        this.statusLabel = new JStatusLabel(msg);
        this.statusLabel.getAccessibleContext().setAccessibleName(msg);
        statusPanel.add(this.statusLabel);
        statusPanel.add(Box.createHorizontalGlue());
        container.add(statusPanel);
    }

    private void setupColors(Container container) {
        String backgroundColorParam = super.getParameter(BACKGROUND_COLOR_PARAM);
        Color backgroundColor = null != backgroundColorParam ? Color.decode(backgroundColorParam) : Color.WHITE;
        this.setBackgroundColor(container, backgroundColor);
        String foregroundColorParam = super.getParameter(FOREGROUND_COLOR_PARAM);
        if (null != foregroundColorParam) {
            Color foregroundColor = Color.decode(foregroundColorParam);
            this.statusLabel.setForeground(foregroundColor);
            if (!this.hideDetailsButtonParam) {
                this.detailMessages.setForeground(foregroundColor);
            }
        }
    }

    private void addMailMenuItem(JPopupMenu popupMenu) {
        Class<?> desktopClass;
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        try {
            desktopClass = classLoader.loadClass("java.awt.Desktop");
        }
        catch (ClassNotFoundException e) {
            return;
        }
        try {
            Method isDesktopSupportedMethod = desktopClass.getMethod("isDesktopSupported", new Class[0]);
            Boolean desktopSupported = (Boolean)isDesktopSupportedMethod.invoke(null, new Object[0]);
            if (!desktopSupported.booleanValue()) {
                return;
            }
            Method getDesktopMethod = desktopClass.getMethod("getDesktop", new Class[0]);
            final Object desktop = getDesktopMethod.invoke(null, new Object[0]);
            final Method mailMethod = desktopClass.getMethod("mail", URI.class);
            JMenuItem emailMenuItem = new JMenuItem(this.messages.getMessage(Messages.MESSAGE_ID.MAIL));
            emailMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String message = Applet.this.detailMessages.getText();
                    try {
                        URI mailUri = new URI("mailto:" + URLEncoder.encode("eid-applet@googlegroups.com", "UTF-8") + "?subject=" + URLEncoder.encode("eID Applet Feedback", "UTF-8").replaceAll("\\+", "%20") + "&body=" + URLEncoder.encode(message, "UTF-8").replaceAll("\\+", "%20"));
                        mailMethod.invoke(desktop, mailUri);
                    }
                    catch (Exception mailException) {
                        Applet.this.addDetailMessage("error mailing message: " + mailException.getMessage());
                    }
                }
            });
            popupMenu.add(emailMenuItem);
        }
        catch (Exception e) {
            return;
        }
    }

    private boolean privacyQuestion(boolean includeAddress, boolean includePhoto, String identityDataUsage) {
        int response;
        String msg = this.messages.getMessage(Messages.MESSAGE_ID.PRIVACY_QUESTION) + "\n" + this.messages.getMessage(Messages.MESSAGE_ID.IDENTITY_INFO) + ": " + this.messages.getMessage(Messages.MESSAGE_ID.IDENTITY_IDENTITY);
        if (includeAddress) {
            msg = msg + ", " + this.messages.getMessage(Messages.MESSAGE_ID.IDENTITY_ADDRESS);
        }
        if (includePhoto) {
            msg = msg + ", " + this.messages.getMessage(Messages.MESSAGE_ID.IDENTITY_PHOTO);
        }
        if (null != identityDataUsage) {
            msg = msg + "\nUsage: " + identityDataUsage;
        }
        return (response = JOptionPane.showConfirmDialog(this, msg, "Privacy", 0)) == 0;
    }

    private void resetProgress(int max) {
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(max);
        this.progressBar.setIndeterminate(false);
        this.progressBar.setValue(0);
        this.progress = 0;
    }

    private void setProgressIndetermintate() {
        this.progressBar.setIndeterminate(true);
    }

    private void increaseProgress() {
        ++this.progress;
        this.progressBar.setValue(this.progress);
    }

    private void addTestResult(DiagnosticTests diagnosticTest, boolean success, String description) {
        Class<?> jsObjectClass;
        if (null == this.diagnosticTestCallbackParam) {
            this.addDetailMessage("no DiagnosticTestCallback applet param set");
            return;
        }
        ClassLoader classLoader = Applet.class.getClassLoader();
        try {
            jsObjectClass = classLoader.loadClass("netscape.javascript.JSObject");
        }
        catch (ClassNotFoundException e) {
            this.addDetailMessage("JSObject class not found");
            return;
        }
        try {
            Method getWindowMethod = jsObjectClass.getMethod("getWindow", java.applet.Applet.class);
            Object jsObject = getWindowMethod.invoke(null, this);
            Method callMethod = jsObjectClass.getMethod("call", String.class, Class.forName("[Ljava.lang.Object;"));
            this.addDetailMessage("invoking Javascript message callback: " + this.diagnosticTestCallbackParam);
            if (null == callMethod) {
                throw new RuntimeException("no call method available");
            }
            if (null == jsObject) {
                throw new RuntimeException("no jsObject available");
            }
            callMethod.invoke(jsObject, this.diagnosticTestCallbackParam, new Object[]{diagnosticTest.name(), diagnosticTest.getDescription(), success, description});
        }
        catch (Exception e) {
            this.addDetailMessage("error locating: JSObject.getWindow().call: " + e.getMessage());
            return;
        }
    }

    private Component getParentComponent() {
        return this;
    }

    private class AppletView
    implements View {
        private AppletView() {
        }

        public void addDetailMessage(String detailMessage) {
            Applet.this.addDetailMessage(detailMessage);
        }

        public Component getParentComponent() {
            return Applet.this.getParentComponent();
        }

        public boolean privacyQuestion(boolean includeAddress, boolean includePhoto, String identityDataUsage) {
            return Applet.this.privacyQuestion(includeAddress, includePhoto, identityDataUsage);
        }

        public void setStatusMessage(Status status, Messages.MESSAGE_ID messageId) {
            Applet.this.setStatusMessage(status, messageId);
        }

        public void addTestResult(DiagnosticTests diagnosticTest, boolean success, String description) {
            Applet.this.addTestResult(diagnosticTest, success, description);
        }

        public void setProgressIndeterminate() {
            Applet.this.setProgressIndetermintate();
        }

        public void resetProgress(int max) {
            Applet.this.resetProgress(max);
        }

        public void increaseProgress() {
            Applet.this.increaseProgress();
        }
    }

    private class AppletRuntime
    implements Runtime {
        private AppletRuntime() {
        }

        public URL getDocumentBase() {
            return Applet.this.getDocumentBase();
        }

        public String getParameter(String name) {
            return Applet.this.getParameter(name);
        }

        public void gotoTargetPage() {
            Applet.this.gotoTargetPage();
        }

        public Applet getApplet() {
            return Applet.this;
        }
    }

    private class AppletThread
    implements Runnable {
        private AppletThread() {
        }

        public void run() {
            URL codeBase;
            Applet.this.addDetailMessage("eID Applet - Copyright (C) 2008-2011 FedICT.");
            Applet.this.addDetailMessage("Released under GNU LGPL version 3.0 license.");
            Applet.this.addDetailMessage("More info: http://code.google.com/p/eid-applet/");
            Applet.this.addDetailMessage("checking applet privileges...");
            SecurityManager securityManager = System.getSecurityManager();
            if (null == securityManager) {
                Applet.this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.SECURITY_ERROR);
                Applet.this.addDetailMessage("no security manager found. not running as an applet?");
                return;
            }
            Object securityContext = securityManager.getSecurityContext();
            String javaVersion = System.getProperty("java.version");
            if (!javaVersion.startsWith("1.5")) {
                Permission permission;
                Applet.this.addDetailMessage("security manager permission check for java 1.6...");
                try {
                    Class<?> cardPermissionClass = Class.forName("javax.smartcardio.CardPermission");
                    Constructor<?> cardPermissionConstructor = cardPermissionClass.getConstructor(String.class, String.class);
                    permission = (Permission)cardPermissionConstructor.newInstance("*", "*");
                }
                catch (Exception e) {
                    Applet.this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.GENERIC_ERROR);
                    Applet.this.addDetailMessage("javax.smartcardio not available: " + e.getMessage());
                    return;
                }
                try {
                    securityManager.checkPermission(permission, securityContext);
                }
                catch (SecurityException e) {
                    Applet.this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.SECURITY_ERROR);
                    Applet.this.addDetailMessage("applet not authorized to access smart card. applet not signed?");
                    return;
                }
            }
            Applet.this.addDetailMessage("checking web application trust...");
            URL documentBase = Applet.this.getDocumentBase();
            if (!"https".equals(documentBase.getProtocol())) {
                if (!"localhost".equals(documentBase.getHost())) {
                    Applet.this.setStatusMessage(Status.ERROR, Messages.MESSAGE_ID.SECURITY_ERROR);
                    Applet.this.addDetailMessage("web application not trusted.");
                    Applet.this.addDetailMessage("use the web application via \"https\" instead of \"http\"");
                    return;
                }
                Applet.this.addDetailMessage("trusting localhost web applications");
            }
            if (!"https".equals((codeBase = Applet.this.getCodeBase()).getProtocol())) {
                Applet.this.addDetailMessage("warning: web application (applet resource) not trusted.");
            }
            Applet.this.securityConditionTrustedWebApp = true;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Applet.this.addDetailMessage("running privileged code...");
                    Controller controller = new Controller(new AppletView(), new AppletRuntime(), Applet.this.messages);
                    controller.run();
                    return null;
                }
            });
        }
    }
}

