# PII Selectors

Selectors allow you to restrict rules to certain parts of the event. This is useful to unconditionally remove certain data by variable/field name from the event, but can also be used to conservatively test rules on real data.

Data scrubbing always works on the raw event payload. Keep in mind that some fields in the UI may be called differently in the JSON schema. When looking at an event there should always be a link called "JSON" present that allows you to see what the data scrubber sees.

For example, what is called "Additional Data" in the UI is called `extra` in the event payload. To remove a specific key called `foo`, you would write:

```
[Remove] [Anything] from [extra.foo]
```

Another example. Sentry knows about two kinds of error messages: The exception message, and the top-level log message. Here is an example of how such an event payload as sent by the SDK (and downloadable from the UI) would look like:

```json
{
  "logentry": {
    "formatted": "Failed to roll out the dinglebop"
  },
  "exceptions": {
    "values": [
      {
        "type": "ZeroDivisionError",
        "value": "integer division or modulo by zero",
      }
    ]
  }
}
```

Since the "error message" is taken from the `exception`'s `value`, and the "message" is taken from `logentry`, we would have to write the following to remove both from the event:

```
[Remove] [Anything] from [exception.value]
[Remove] [Anything] from [logentry.formatted]
```

### Boolean Logic

You can combine selectors using boolean logic.

* Prefix with `!` to invert the selector. `foo` matches the JSON key `foo`, while `!foo` matches everything but `foo`.
* Build the conjunction (AND) using `&&`, such as: `foo && !extra.foo` to match the key `foo` except when inside of `extra`.
* Build the disjunction (OR) using `||`, such as: `foo || bar` to match `foo` or `bar`.

### Wildcards

* `**` matches all subpaths, so that `foo.**` matches all JSON keys within `foo`.
* `*` matches a single path item, so that `foo.*` matches all JSON keys one level below `foo`.

### Value Types

Select subsections by JSON-type using the following:

* `$string` matches any string value
* `$number` matches any integer or float value
* `$datetime` matches any field in the event that represents a timestamp
* `$array` matches any JSON array value
* `$object` matches any JSON object

Select known parts of the schema using the following:

* `$exception` matches a single exception instance in `{"exception": {"values": [...]}}`
* `$stacktrace` matches a stack trace instance
* `$frame` matches a frame
* `$request` matches the HTTP request context of an event
* `$user` matches the user context of an event
* `$logentry` (also applies to the `message` attribute)
* `$thread` matches a single thread instance in `{"threads": {"values": [...]}}`
* `$breadcrumb` matches a single breadcrumb in `{"breadcrumbs": [...]}`
* `$span` matches a [trace span]
* `$sdk` matches the SDK context in `{"sdk": ...}`

#### Examples

* Delete `event.user`:

  ```
  [Remove] [Anything] from [$user]
  ```

* Delete all frame-local variables:

  ```
  [Remove] [Anything] from [$frame.vars]
  ```

### Escaping Specal Characters

If the object key you want to match contains whitespace or special characters, you can use quotes to escape it:

```
[Remove] [Anything] from [extra.'my special value']
```

This matches the key `my special value` in _Additional Data_.

To escape `'` (single quote) within the quotes, replace it with `''` (two quotes):

```
[Remove] [Anything] from [extra.'my special '' value']
```

This matches the key `my special ' value` in _Additional Data_.

[trace span]: https://docs.sentry.io/performance-monitoring/distributed-tracing/#spans
