# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class Resource(Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for a Azure Resource Manager resource with an
    etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ErrorDetail(Model):
    """Error details.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. The error's code.
    :type code: str
    :param message: Required. A human readable error message.
    :type message: str
    :param target: Indicates which property in the request is responsible for
     the error.
    :type target: str
    :param details: Additional error details.
    :type details: list[~azure.mgmt.hybridcompute.models.ErrorDetail]
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
    }

    def __init__(self, **kwargs):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.target = kwargs.get('target', None)
        self.details = kwargs.get('details', None)


class ErrorResponse(Model):
    """Error response.

    Contains details when the response code indicates an error.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. The error details.
    :type error: ~azure.mgmt.hybridcompute.models.ErrorDetail
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class Identity(Model):
    """Managed Identity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param type: The identity type.
    :type type: str
    :ivar principal_id: The identity's principal id.
    :vartype principal_id: str
    :ivar tenant_id: The identity's tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Identity, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.principal_id = None
        self.tenant_id = None


class LocationData(Model):
    """Metadata pertaining to the geographic location of the resource.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. A canonical name for the geographic or physical
     location.
    :type name: str
    :param city: The city or locality where the resource is located.
    :type city: str
    :param district: The district, state, or province where the resource is
     located.
    :type district: str
    :param country_or_region: The country or region where the resource is
     located
    :type country_or_region: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 256},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'district': {'key': 'district', 'type': 'str'},
        'country_or_region': {'key': 'countryOrRegion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LocationData, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.city = kwargs.get('city', None)
        self.district = kwargs.get('district', None)
        self.country_or_region = kwargs.get('country_or_region', None)


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)
        self.location = kwargs.get('location', None)


class Machine(TrackedResource):
    """Describes a hybrid machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param location_data:
    :type location_data: ~azure.mgmt.hybridcompute.models.LocationData
    :param os_profile: Specifies the operating system settings for the hybrid
     machine.
    :type os_profile:
     ~azure.mgmt.hybridcompute.models.MachinePropertiesOsProfile
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar status: The status of the hybrid machine agent. Possible values
     include: 'Connected', 'Disconnected', 'Error'
    :vartype status: str or ~azure.mgmt.hybridcompute.models.StatusTypes
    :ivar last_status_change: The time of the last status change.
    :vartype last_status_change: datetime
    :ivar error_details: Details about the error state.
    :vartype error_details: list[~azure.mgmt.hybridcompute.models.ErrorDetail]
    :ivar agent_version: The hybrid machine agent full version.
    :vartype agent_version: str
    :param vm_id: Specifies the hybrid machine unique ID.
    :type vm_id: str
    :ivar display_name: Specifies the hybrid machine display name.
    :vartype display_name: str
    :ivar machine_fqdn: Specifies the hybrid machine FQDN.
    :vartype machine_fqdn: str
    :param client_public_key: Public Key that the client provides to be used
     during initial resource onboarding
    :type client_public_key: str
    :ivar os_name: The Operating System running on the hybrid machine.
    :vartype os_name: str
    :ivar os_version: The version of Operating System running on the hybrid
     machine.
    :vartype os_version: str
    :ivar vm_uuid: Specifies the Arc Machine's unique SMBIOS ID
    :vartype vm_uuid: str
    :ivar extensions: Machine Extensions information
    :vartype extensions:
     list[~azure.mgmt.hybridcompute.models.MachineExtensionInstanceView]
    :ivar os_sku: Specifies the Operating System product SKU.
    :vartype os_sku: str
    :ivar domain_name: Specifies the Windows domain name.
    :vartype domain_name: str
    :ivar ad_fqdn: Specifies the AD fully qualified display name.
    :vartype ad_fqdn: str
    :ivar dns_fqdn: Specifies the DNS fully qualified display name.
    :vartype dns_fqdn: str
    :param identity:
    :type identity: ~azure.mgmt.hybridcompute.models.MachineIdentity
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'last_status_change': {'readonly': True},
        'error_details': {'readonly': True},
        'agent_version': {'readonly': True},
        'display_name': {'readonly': True},
        'machine_fqdn': {'readonly': True},
        'os_name': {'readonly': True},
        'os_version': {'readonly': True},
        'vm_uuid': {'readonly': True},
        'extensions': {'readonly': True},
        'os_sku': {'readonly': True},
        'domain_name': {'readonly': True},
        'ad_fqdn': {'readonly': True},
        'dns_fqdn': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'location_data': {'key': 'properties.locationData', 'type': 'LocationData'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'MachinePropertiesOsProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'last_status_change': {'key': 'properties.lastStatusChange', 'type': 'iso-8601'},
        'error_details': {'key': 'properties.errorDetails', 'type': '[ErrorDetail]'},
        'agent_version': {'key': 'properties.agentVersion', 'type': 'str'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'machine_fqdn': {'key': 'properties.machineFqdn', 'type': 'str'},
        'client_public_key': {'key': 'properties.clientPublicKey', 'type': 'str'},
        'os_name': {'key': 'properties.osName', 'type': 'str'},
        'os_version': {'key': 'properties.osVersion', 'type': 'str'},
        'vm_uuid': {'key': 'properties.vmUuid', 'type': 'str'},
        'extensions': {'key': 'properties.extensions', 'type': '[MachineExtensionInstanceView]'},
        'os_sku': {'key': 'properties.osSku', 'type': 'str'},
        'domain_name': {'key': 'properties.domainName', 'type': 'str'},
        'ad_fqdn': {'key': 'properties.adFqdn', 'type': 'str'},
        'dns_fqdn': {'key': 'properties.dnsFqdn', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'MachineIdentity'},
    }

    def __init__(self, **kwargs):
        super(Machine, self).__init__(**kwargs)
        self.location_data = kwargs.get('location_data', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.provisioning_state = None
        self.status = None
        self.last_status_change = None
        self.error_details = None
        self.agent_version = None
        self.vm_id = kwargs.get('vm_id', None)
        self.display_name = None
        self.machine_fqdn = None
        self.client_public_key = kwargs.get('client_public_key', None)
        self.os_name = None
        self.os_version = None
        self.vm_uuid = None
        self.extensions = None
        self.os_sku = None
        self.domain_name = None
        self.ad_fqdn = None
        self.dns_fqdn = None
        self.identity = kwargs.get('identity', None)


class MachineExtension(TrackedResource):
    """Describes a Machine Extension.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param force_update_tag: How the extension handler should be forced to
     update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param machine_extension_type: Specifies the type of the extension; an
     example is "CustomScriptExtension".
    :type machine_extension_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should
     use a newer minor version if one is available at deployment time. Once
     deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either
     protectedSettings or protectedSettingsFromKeyVault or no protected
     settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param instance_view: The machine extension instance view.
    :type instance_view:
     ~azure.mgmt.hybridcompute.models.MachineExtensionPropertiesInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'machine_extension_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'MachineExtensionPropertiesInstanceView'},
    }

    def __init__(self, **kwargs):
        super(MachineExtension, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.machine_extension_type = kwargs.get('machine_extension_type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
        self.instance_view = kwargs.get('instance_view', None)


class MachineExtensionInstanceView(Model):
    """Describes the Machine Extension Instance View.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The machine extension name.
    :vartype name: str
    :ivar type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :param status: Instance view status.
    :type status:
     ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceViewStatus
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'type_handler_version': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'MachineExtensionInstanceViewStatus'},
    }

    def __init__(self, **kwargs):
        super(MachineExtensionInstanceView, self).__init__(**kwargs)
        self.name = None
        self.type = None
        self.type_handler_version = None
        self.status = kwargs.get('status', None)


class MachineExtensionInstanceViewStatus(Model):
    """Instance view status.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The status code.
    :vartype code: str
    :ivar level: The level code. Possible values include: 'Info', 'Warning',
     'Error'
    :vartype level: str or ~azure.mgmt.hybridcompute.models.StatusLevelTypes
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error
     messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: datetime
    """

    _validation = {
        'code': {'readonly': True},
        'level': {'readonly': True},
        'display_status': {'readonly': True},
        'message': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(MachineExtensionInstanceViewStatus, self).__init__(**kwargs)
        self.code = None
        self.level = None
        self.display_status = None
        self.message = None
        self.time = None


class MachineExtensionPropertiesInstanceView(MachineExtensionInstanceView):
    """The machine extension instance view.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: The machine extension name.
    :vartype name: str
    :ivar type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :vartype type: str
    :ivar type_handler_version: Specifies the version of the script handler.
    :vartype type_handler_version: str
    :param status: Instance view status.
    :type status:
     ~azure.mgmt.hybridcompute.models.MachineExtensionInstanceViewStatus
    """

    _validation = {
        'name': {'readonly': True},
        'type': {'readonly': True},
        'type_handler_version': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'MachineExtensionInstanceViewStatus'},
    }

    def __init__(self, **kwargs):
        super(MachineExtensionPropertiesInstanceView, self).__init__(**kwargs)


class MachineExtensionPropertiesModel(Model):
    """Describes the properties of a Machine Extension.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param force_update_tag: How the extension handler should be forced to
     update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should
     use a newer minor version if one is available at deployment time. Once
     deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either
     protectedSettings or protectedSettingsFromKeyVault or no protected
     settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param instance_view: The machine extension instance view.
    :type instance_view:
     ~azure.mgmt.hybridcompute.models.MachineExtensionPropertiesInstanceView
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'force_update_tag': {'key': 'forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'settings', 'type': 'object'},
        'protected_settings': {'key': 'protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'instance_view': {'key': 'instanceView', 'type': 'MachineExtensionPropertiesInstanceView'},
    }

    def __init__(self, **kwargs):
        super(MachineExtensionPropertiesModel, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)
        self.provisioning_state = None
        self.instance_view = kwargs.get('instance_view', None)


class UpdateResource(Model):
    """The Update Resource model definition.

    :param tags: Resource tags
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(UpdateResource, self).__init__(**kwargs)
        self.tags = kwargs.get('tags', None)


class MachineExtensionUpdate(UpdateResource):
    """Describes a Machine Extension Update.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to
     update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should
     use a newer minor version if one is available at deployment time. Once
     deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either
     protectedSettings or protectedSettingsFromKeyVault or no protected
     settings at all.
    :type protected_settings: object
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(MachineExtensionUpdate, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)


class MachineExtensionUpdatePropertiesModel(Model):
    """Describes the properties of a Machine Extension.

    :param force_update_tag: How the extension handler should be forced to
     update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should
     use a newer minor version if one is available at deployment time. Once
     deployed, however, the extension will not upgrade minor versions unless
     redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either
     protectedSettings or protectedSettingsFromKeyVault or no protected
     settings at all.
    :type protected_settings: object
    """

    _attribute_map = {
        'force_update_tag': {'key': 'forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'settings', 'type': 'object'},
        'protected_settings': {'key': 'protectedSettings', 'type': 'object'},
    }

    def __init__(self, **kwargs):
        super(MachineExtensionUpdatePropertiesModel, self).__init__(**kwargs)
        self.force_update_tag = kwargs.get('force_update_tag', None)
        self.publisher = kwargs.get('publisher', None)
        self.type = kwargs.get('type', None)
        self.type_handler_version = kwargs.get('type_handler_version', None)
        self.auto_upgrade_minor_version = kwargs.get('auto_upgrade_minor_version', None)
        self.settings = kwargs.get('settings', None)
        self.protected_settings = kwargs.get('protected_settings', None)


class MachineIdentity(Identity):
    """MachineIdentity.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param type: The identity type.
    :type type: str
    :ivar principal_id: The identity's principal id.
    :vartype principal_id: str
    :ivar tenant_id: The identity's tenant id.
    :vartype tenant_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MachineIdentity, self).__init__(**kwargs)


class MachineProperties(Model):
    """Describes the properties of a hybrid machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param location_data:
    :type location_data: ~azure.mgmt.hybridcompute.models.LocationData
    :param os_profile: Specifies the operating system settings for the hybrid
     machine.
    :type os_profile:
     ~azure.mgmt.hybridcompute.models.MachinePropertiesOsProfile
    :ivar provisioning_state: The provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar status: The status of the hybrid machine agent. Possible values
     include: 'Connected', 'Disconnected', 'Error'
    :vartype status: str or ~azure.mgmt.hybridcompute.models.StatusTypes
    :ivar last_status_change: The time of the last status change.
    :vartype last_status_change: datetime
    :ivar error_details: Details about the error state.
    :vartype error_details: list[~azure.mgmt.hybridcompute.models.ErrorDetail]
    :ivar agent_version: The hybrid machine agent full version.
    :vartype agent_version: str
    :param vm_id: Specifies the hybrid machine unique ID.
    :type vm_id: str
    :ivar display_name: Specifies the hybrid machine display name.
    :vartype display_name: str
    :ivar machine_fqdn: Specifies the hybrid machine FQDN.
    :vartype machine_fqdn: str
    :param client_public_key: Public Key that the client provides to be used
     during initial resource onboarding
    :type client_public_key: str
    :ivar os_name: The Operating System running on the hybrid machine.
    :vartype os_name: str
    :ivar os_version: The version of Operating System running on the hybrid
     machine.
    :vartype os_version: str
    :ivar vm_uuid: Specifies the Arc Machine's unique SMBIOS ID
    :vartype vm_uuid: str
    :ivar extensions: Machine Extensions information
    :vartype extensions:
     list[~azure.mgmt.hybridcompute.models.MachineExtensionInstanceView]
    :ivar os_sku: Specifies the Operating System product SKU.
    :vartype os_sku: str
    :ivar domain_name: Specifies the Windows domain name.
    :vartype domain_name: str
    :ivar ad_fqdn: Specifies the AD fully qualified display name.
    :vartype ad_fqdn: str
    :ivar dns_fqdn: Specifies the DNS fully qualified display name.
    :vartype dns_fqdn: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'last_status_change': {'readonly': True},
        'error_details': {'readonly': True},
        'agent_version': {'readonly': True},
        'display_name': {'readonly': True},
        'machine_fqdn': {'readonly': True},
        'os_name': {'readonly': True},
        'os_version': {'readonly': True},
        'vm_uuid': {'readonly': True},
        'extensions': {'readonly': True},
        'os_sku': {'readonly': True},
        'domain_name': {'readonly': True},
        'ad_fqdn': {'readonly': True},
        'dns_fqdn': {'readonly': True},
    }

    _attribute_map = {
        'location_data': {'key': 'locationData', 'type': 'LocationData'},
        'os_profile': {'key': 'osProfile', 'type': 'MachinePropertiesOsProfile'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'last_status_change': {'key': 'lastStatusChange', 'type': 'iso-8601'},
        'error_details': {'key': 'errorDetails', 'type': '[ErrorDetail]'},
        'agent_version': {'key': 'agentVersion', 'type': 'str'},
        'vm_id': {'key': 'vmId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'machine_fqdn': {'key': 'machineFqdn', 'type': 'str'},
        'client_public_key': {'key': 'clientPublicKey', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'vm_uuid': {'key': 'vmUuid', 'type': 'str'},
        'extensions': {'key': 'extensions', 'type': '[MachineExtensionInstanceView]'},
        'os_sku': {'key': 'osSku', 'type': 'str'},
        'domain_name': {'key': 'domainName', 'type': 'str'},
        'ad_fqdn': {'key': 'adFqdn', 'type': 'str'},
        'dns_fqdn': {'key': 'dnsFqdn', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MachineProperties, self).__init__(**kwargs)
        self.location_data = kwargs.get('location_data', None)
        self.os_profile = kwargs.get('os_profile', None)
        self.provisioning_state = None
        self.status = None
        self.last_status_change = None
        self.error_details = None
        self.agent_version = None
        self.vm_id = kwargs.get('vm_id', None)
        self.display_name = None
        self.machine_fqdn = None
        self.client_public_key = kwargs.get('client_public_key', None)
        self.os_name = None
        self.os_version = None
        self.vm_uuid = None
        self.extensions = None
        self.os_sku = None
        self.domain_name = None
        self.ad_fqdn = None
        self.dns_fqdn = None


class OSProfile(Model):
    """Specifies the operating system settings for the hybrid machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar computer_name: Specifies the host OS name of the hybrid machine.
    :vartype computer_name: str
    """

    _validation = {
        'computer_name': {'readonly': True},
    }

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OSProfile, self).__init__(**kwargs)
        self.computer_name = None


class MachinePropertiesOsProfile(OSProfile):
    """Specifies the operating system settings for the hybrid machine.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar computer_name: Specifies the host OS name of the hybrid machine.
    :vartype computer_name: str
    """

    _validation = {
        'computer_name': {'readonly': True},
    }

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MachinePropertiesOsProfile, self).__init__(**kwargs)


class MachineUpdate(UpdateResource):
    """Describes a hybrid machine Update.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param tags: Resource tags
    :type tags: dict[str, str]
    :param type: The identity type.
    :type type: str
    :ivar principal_id: The identity's principal id.
    :vartype principal_id: str
    :ivar tenant_id: The identity's tenant id.
    :vartype tenant_id: str
    :param location_data:
    :type location_data: ~azure.mgmt.hybridcompute.models.LocationData
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'type': {'key': 'identity.type', 'type': 'str'},
        'principal_id': {'key': 'identity.principalId', 'type': 'str'},
        'tenant_id': {'key': 'identity.tenantId', 'type': 'str'},
        'location_data': {'key': 'properties.locationData', 'type': 'LocationData'},
    }

    def __init__(self, **kwargs):
        super(MachineUpdate, self).__init__(**kwargs)
        self.type = kwargs.get('type', None)
        self.principal_id = None
        self.tenant_id = None
        self.location_data = kwargs.get('location_data', None)


class MachineUpdateProperties(Model):
    """Describes the ARM updatable properties of a hybrid machine.

    :param location_data:
    :type location_data: ~azure.mgmt.hybridcompute.models.LocationData
    """

    _attribute_map = {
        'location_data': {'key': 'locationData', 'type': 'LocationData'},
    }

    def __init__(self, **kwargs):
        super(MachineUpdateProperties, self).__init__(**kwargs)
        self.location_data = kwargs.get('location_data', None)


class OperationValue(Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class OperationValueDisplayModel(Model):
    """Describes the properties of a Hybrid Compute Operation Value Display.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'provider': {'key': 'provider', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationValueDisplayModel, self).__init__(**kwargs)
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ProxyResource, self).__init__(**kwargs)
