# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class FeatureSupportRequest(_serialization.Model):
    """Base class for feature request.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBackupGoalFeatureSupportRequest, AzureVMResourceFeatureSupportRequest

    All required parameters must be populated in order to send to Azure.

    :ivar feature_type: backup support feature type. Required.
    :vartype feature_type: str
    """

    _validation = {
        "feature_type": {"required": True},
    }

    _attribute_map = {
        "feature_type": {"key": "featureType", "type": "str"},
    }

    _subtype_map = {
        "feature_type": {
            "AzureBackupGoals": "AzureBackupGoalFeatureSupportRequest",
            "AzureVMResourceBackup": "AzureVMResourceFeatureSupportRequest",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.feature_type: Optional[str] = None


class AzureBackupGoalFeatureSupportRequest(FeatureSupportRequest):
    """Azure backup goal feature specific request.

    All required parameters must be populated in order to send to Azure.

    :ivar feature_type: backup support feature type. Required.
    :vartype feature_type: str
    """

    _validation = {
        "feature_type": {"required": True},
    }

    _attribute_map = {
        "feature_type": {"key": "featureType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.feature_type: str = "AzureBackupGoals"


class ProtectionContainer(_serialization.Model):
    """Base class for container with backup items. Containers with specific workloads are derived from
    this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureSqlContainer, AzureWorkloadContainer, DpmContainer, GenericContainer, IaaSVMContainer,
    AzureStorageContainer, MabContainer

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
    }

    _subtype_map = {
        "container_type": {
            "AzureSqlContainer": "AzureSqlContainer",
            "AzureWorkloadContainer": "AzureWorkloadContainer",
            "DPMContainer": "DpmContainer",
            "GenericContainer": "GenericContainer",
            "IaasVMContainer": "IaaSVMContainer",
            "StorageContainer": "AzureStorageContainer",
            "Windows": "MabContainer",
        }
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.backup_management_type = backup_management_type
        self.registration_status = registration_status
        self.health_status = health_status
        self.container_type: Optional[str] = None
        self.protectable_object_type = protectable_object_type


class DpmContainer(ProtectionContainer):  # pylint: disable=too-many-instance-attributes
    """DPM workload-specific protection container.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBackupServerContainer

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar can_re_register: Specifies whether the container is re-registrable.
    :vartype can_re_register: bool
    :ivar container_id: ID of container.
    :vartype container_id: str
    :ivar protected_item_count: Number of protected items in the BackupEngine.
    :vartype protected_item_count: int
    :ivar dpm_agent_version: Backup engine Agent version.
    :vartype dpm_agent_version: str
    :ivar dpm_servers: List of BackupEngines protecting the container.
    :vartype dpm_servers: list[str]
    :ivar upgrade_available: To check if upgrade available.
    :vartype upgrade_available: bool
    :ivar protection_status: Protection status of the container.
    :vartype protection_status: str
    :ivar extended_info: Extended Info of the container.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DPMContainerExtendedInfo
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "can_re_register": {"key": "canReRegister", "type": "bool"},
        "container_id": {"key": "containerId", "type": "str"},
        "protected_item_count": {"key": "protectedItemCount", "type": "int"},
        "dpm_agent_version": {"key": "dpmAgentVersion", "type": "str"},
        "dpm_servers": {"key": "dpmServers", "type": "[str]"},
        "upgrade_available": {"key": "upgradeAvailable", "type": "bool"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "DPMContainerExtendedInfo"},
    }

    _subtype_map = {"container_type": {"AzureBackupServerContainer": "AzureBackupServerContainer"}}

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        can_re_register: Optional[bool] = None,
        container_id: Optional[str] = None,
        protected_item_count: Optional[int] = None,
        dpm_agent_version: Optional[str] = None,
        dpm_servers: Optional[List[str]] = None,
        upgrade_available: Optional[bool] = None,
        protection_status: Optional[str] = None,
        extended_info: Optional["_models.DPMContainerExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword can_re_register: Specifies whether the container is re-registrable.
        :paramtype can_re_register: bool
        :keyword container_id: ID of container.
        :paramtype container_id: str
        :keyword protected_item_count: Number of protected items in the BackupEngine.
        :paramtype protected_item_count: int
        :keyword dpm_agent_version: Backup engine Agent version.
        :paramtype dpm_agent_version: str
        :keyword dpm_servers: List of BackupEngines protecting the container.
        :paramtype dpm_servers: list[str]
        :keyword upgrade_available: To check if upgrade available.
        :paramtype upgrade_available: bool
        :keyword protection_status: Protection status of the container.
        :paramtype protection_status: str
        :keyword extended_info: Extended Info of the container.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DPMContainerExtendedInfo
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            **kwargs
        )
        self.container_type: str = "DPMContainer"
        self.can_re_register = can_re_register
        self.container_id = container_id
        self.protected_item_count = protected_item_count
        self.dpm_agent_version = dpm_agent_version
        self.dpm_servers = dpm_servers
        self.upgrade_available = upgrade_available
        self.protection_status = protection_status
        self.extended_info = extended_info


class AzureBackupServerContainer(DpmContainer):  # pylint: disable=too-many-instance-attributes
    """AzureBackupServer (DPMVenus) workload-specific protection container.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar can_re_register: Specifies whether the container is re-registrable.
    :vartype can_re_register: bool
    :ivar container_id: ID of container.
    :vartype container_id: str
    :ivar protected_item_count: Number of protected items in the BackupEngine.
    :vartype protected_item_count: int
    :ivar dpm_agent_version: Backup engine Agent version.
    :vartype dpm_agent_version: str
    :ivar dpm_servers: List of BackupEngines protecting the container.
    :vartype dpm_servers: list[str]
    :ivar upgrade_available: To check if upgrade available.
    :vartype upgrade_available: bool
    :ivar protection_status: Protection status of the container.
    :vartype protection_status: str
    :ivar extended_info: Extended Info of the container.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DPMContainerExtendedInfo
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "can_re_register": {"key": "canReRegister", "type": "bool"},
        "container_id": {"key": "containerId", "type": "str"},
        "protected_item_count": {"key": "protectedItemCount", "type": "int"},
        "dpm_agent_version": {"key": "dpmAgentVersion", "type": "str"},
        "dpm_servers": {"key": "dpmServers", "type": "[str]"},
        "upgrade_available": {"key": "upgradeAvailable", "type": "bool"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "DPMContainerExtendedInfo"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        can_re_register: Optional[bool] = None,
        container_id: Optional[str] = None,
        protected_item_count: Optional[int] = None,
        dpm_agent_version: Optional[str] = None,
        dpm_servers: Optional[List[str]] = None,
        upgrade_available: Optional[bool] = None,
        protection_status: Optional[str] = None,
        extended_info: Optional["_models.DPMContainerExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword can_re_register: Specifies whether the container is re-registrable.
        :paramtype can_re_register: bool
        :keyword container_id: ID of container.
        :paramtype container_id: str
        :keyword protected_item_count: Number of protected items in the BackupEngine.
        :paramtype protected_item_count: int
        :keyword dpm_agent_version: Backup engine Agent version.
        :paramtype dpm_agent_version: str
        :keyword dpm_servers: List of BackupEngines protecting the container.
        :paramtype dpm_servers: list[str]
        :keyword upgrade_available: To check if upgrade available.
        :paramtype upgrade_available: bool
        :keyword protection_status: Protection status of the container.
        :paramtype protection_status: str
        :keyword extended_info: Extended Info of the container.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DPMContainerExtendedInfo
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            can_re_register=can_re_register,
            container_id=container_id,
            protected_item_count=protected_item_count,
            dpm_agent_version=dpm_agent_version,
            dpm_servers=dpm_servers,
            upgrade_available=upgrade_available,
            protection_status=protection_status,
            extended_info=extended_info,
            **kwargs
        )
        self.container_type: str = "AzureBackupServerContainer"


class BackupEngineBase(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The base backup engine class. All workload specific backup engines derive from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureBackupServerEngine, DpmBackupEngine

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the backup engine.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the backup engine. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Registration status of the backup engine with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar backup_engine_state: Status of the backup engine with the Recovery Services Vault. =
     {Active/Deleting/DeleteFailed}.
    :vartype backup_engine_state: str
    :ivar health_status: Backup status of the backup engine.
    :vartype health_status: str
    :ivar backup_engine_type: Type of the backup engine. Required. Known values are: "Invalid",
     "DpmBackupEngine", and "AzureBackupServerEngine".
    :vartype backup_engine_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineType
    :ivar can_re_register: Flag indicating if the backup engine be registered, once already
     registered.
    :vartype can_re_register: bool
    :ivar backup_engine_id: ID of the backup engine.
    :vartype backup_engine_id: str
    :ivar dpm_version: Backup engine version.
    :vartype dpm_version: str
    :ivar azure_backup_agent_version: Backup agent version.
    :vartype azure_backup_agent_version: str
    :ivar is_azure_backup_agent_upgrade_available: To check if backup agent upgrade available.
    :vartype is_azure_backup_agent_upgrade_available: bool
    :ivar is_dpm_upgrade_available: To check if backup engine upgrade available.
    :vartype is_dpm_upgrade_available: bool
    :ivar extended_info: Extended info of the backupengine.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineExtendedInfo
    """

    _validation = {
        "backup_engine_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "backup_engine_state": {"key": "backupEngineState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "backup_engine_type": {"key": "backupEngineType", "type": "str"},
        "can_re_register": {"key": "canReRegister", "type": "bool"},
        "backup_engine_id": {"key": "backupEngineId", "type": "str"},
        "dpm_version": {"key": "dpmVersion", "type": "str"},
        "azure_backup_agent_version": {"key": "azureBackupAgentVersion", "type": "str"},
        "is_azure_backup_agent_upgrade_available": {"key": "isAzureBackupAgentUpgradeAvailable", "type": "bool"},
        "is_dpm_upgrade_available": {"key": "isDpmUpgradeAvailable", "type": "bool"},
        "extended_info": {"key": "extendedInfo", "type": "BackupEngineExtendedInfo"},
    }

    _subtype_map = {
        "backup_engine_type": {
            "AzureBackupServerEngine": "AzureBackupServerEngine",
            "DpmBackupEngine": "DpmBackupEngine",
        }
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        backup_engine_state: Optional[str] = None,
        health_status: Optional[str] = None,
        can_re_register: Optional[bool] = None,
        backup_engine_id: Optional[str] = None,
        dpm_version: Optional[str] = None,
        azure_backup_agent_version: Optional[str] = None,
        is_azure_backup_agent_upgrade_available: Optional[bool] = None,
        is_dpm_upgrade_available: Optional[bool] = None,
        extended_info: Optional["_models.BackupEngineExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the backup engine.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the backup engine. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Registration status of the backup engine with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword backup_engine_state: Status of the backup engine with the Recovery Services Vault. =
         {Active/Deleting/DeleteFailed}.
        :paramtype backup_engine_state: str
        :keyword health_status: Backup status of the backup engine.
        :paramtype health_status: str
        :keyword can_re_register: Flag indicating if the backup engine be registered, once already
         registered.
        :paramtype can_re_register: bool
        :keyword backup_engine_id: ID of the backup engine.
        :paramtype backup_engine_id: str
        :keyword dpm_version: Backup engine version.
        :paramtype dpm_version: str
        :keyword azure_backup_agent_version: Backup agent version.
        :paramtype azure_backup_agent_version: str
        :keyword is_azure_backup_agent_upgrade_available: To check if backup agent upgrade available.
        :paramtype is_azure_backup_agent_upgrade_available: bool
        :keyword is_dpm_upgrade_available: To check if backup engine upgrade available.
        :paramtype is_dpm_upgrade_available: bool
        :keyword extended_info: Extended info of the backupengine.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineExtendedInfo
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.backup_management_type = backup_management_type
        self.registration_status = registration_status
        self.backup_engine_state = backup_engine_state
        self.health_status = health_status
        self.backup_engine_type: Optional[str] = None
        self.can_re_register = can_re_register
        self.backup_engine_id = backup_engine_id
        self.dpm_version = dpm_version
        self.azure_backup_agent_version = azure_backup_agent_version
        self.is_azure_backup_agent_upgrade_available = is_azure_backup_agent_upgrade_available
        self.is_dpm_upgrade_available = is_dpm_upgrade_available
        self.extended_info = extended_info


class AzureBackupServerEngine(BackupEngineBase):  # pylint: disable=too-many-instance-attributes
    """Backup engine type when Azure Backup Server is used to manage the backups.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the backup engine.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the backup engine. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Registration status of the backup engine with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar backup_engine_state: Status of the backup engine with the Recovery Services Vault. =
     {Active/Deleting/DeleteFailed}.
    :vartype backup_engine_state: str
    :ivar health_status: Backup status of the backup engine.
    :vartype health_status: str
    :ivar backup_engine_type: Type of the backup engine. Required. Known values are: "Invalid",
     "DpmBackupEngine", and "AzureBackupServerEngine".
    :vartype backup_engine_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineType
    :ivar can_re_register: Flag indicating if the backup engine be registered, once already
     registered.
    :vartype can_re_register: bool
    :ivar backup_engine_id: ID of the backup engine.
    :vartype backup_engine_id: str
    :ivar dpm_version: Backup engine version.
    :vartype dpm_version: str
    :ivar azure_backup_agent_version: Backup agent version.
    :vartype azure_backup_agent_version: str
    :ivar is_azure_backup_agent_upgrade_available: To check if backup agent upgrade available.
    :vartype is_azure_backup_agent_upgrade_available: bool
    :ivar is_dpm_upgrade_available: To check if backup engine upgrade available.
    :vartype is_dpm_upgrade_available: bool
    :ivar extended_info: Extended info of the backupengine.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineExtendedInfo
    """

    _validation = {
        "backup_engine_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "backup_engine_state": {"key": "backupEngineState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "backup_engine_type": {"key": "backupEngineType", "type": "str"},
        "can_re_register": {"key": "canReRegister", "type": "bool"},
        "backup_engine_id": {"key": "backupEngineId", "type": "str"},
        "dpm_version": {"key": "dpmVersion", "type": "str"},
        "azure_backup_agent_version": {"key": "azureBackupAgentVersion", "type": "str"},
        "is_azure_backup_agent_upgrade_available": {"key": "isAzureBackupAgentUpgradeAvailable", "type": "bool"},
        "is_dpm_upgrade_available": {"key": "isDpmUpgradeAvailable", "type": "bool"},
        "extended_info": {"key": "extendedInfo", "type": "BackupEngineExtendedInfo"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        backup_engine_state: Optional[str] = None,
        health_status: Optional[str] = None,
        can_re_register: Optional[bool] = None,
        backup_engine_id: Optional[str] = None,
        dpm_version: Optional[str] = None,
        azure_backup_agent_version: Optional[str] = None,
        is_azure_backup_agent_upgrade_available: Optional[bool] = None,
        is_dpm_upgrade_available: Optional[bool] = None,
        extended_info: Optional["_models.BackupEngineExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the backup engine.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the backup engine. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Registration status of the backup engine with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword backup_engine_state: Status of the backup engine with the Recovery Services Vault. =
         {Active/Deleting/DeleteFailed}.
        :paramtype backup_engine_state: str
        :keyword health_status: Backup status of the backup engine.
        :paramtype health_status: str
        :keyword can_re_register: Flag indicating if the backup engine be registered, once already
         registered.
        :paramtype can_re_register: bool
        :keyword backup_engine_id: ID of the backup engine.
        :paramtype backup_engine_id: str
        :keyword dpm_version: Backup engine version.
        :paramtype dpm_version: str
        :keyword azure_backup_agent_version: Backup agent version.
        :paramtype azure_backup_agent_version: str
        :keyword is_azure_backup_agent_upgrade_available: To check if backup agent upgrade available.
        :paramtype is_azure_backup_agent_upgrade_available: bool
        :keyword is_dpm_upgrade_available: To check if backup engine upgrade available.
        :paramtype is_dpm_upgrade_available: bool
        :keyword extended_info: Extended info of the backupengine.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineExtendedInfo
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            backup_engine_state=backup_engine_state,
            health_status=health_status,
            can_re_register=can_re_register,
            backup_engine_id=backup_engine_id,
            dpm_version=dpm_version,
            azure_backup_agent_version=azure_backup_agent_version,
            is_azure_backup_agent_upgrade_available=is_azure_backup_agent_upgrade_available,
            is_dpm_upgrade_available=is_dpm_upgrade_available,
            extended_info=extended_info,
            **kwargs
        )
        self.backup_engine_type: str = "AzureBackupServerEngine"


class BackupRequest(_serialization.Model):
    """Base class for backup request. Workload-specific backup requests are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileShareBackupRequest, AzureWorkloadBackupRequest, IaasVMBackupRequest

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureFileShareBackupRequest": "AzureFileShareBackupRequest",
            "AzureWorkloadBackupRequest": "AzureWorkloadBackupRequest",
            "IaasVMBackupRequest": "IaasVMBackupRequest",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class AzureFileShareBackupRequest(BackupRequest):
    """AzureFileShare workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_expiry_time_in_utc: Backup copy will expire after the time specified
     (UTC).
    :vartype recovery_point_expiry_time_in_utc: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_expiry_time_in_utc": {"key": "recoveryPointExpiryTimeInUTC", "type": "iso-8601"},
    }

    def __init__(self, *, recovery_point_expiry_time_in_utc: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword recovery_point_expiry_time_in_utc: Backup copy will expire after the time specified
         (UTC).
        :paramtype recovery_point_expiry_time_in_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureFileShareBackupRequest"
        self.recovery_point_expiry_time_in_utc = recovery_point_expiry_time_in_utc


class WorkloadProtectableItem(_serialization.Model):
    """Base class for backup item. Workload-specific backup items are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileShareProtectableItem, AzureVmWorkloadProtectableItem, IaaSVMProtectableItem

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
    }

    _subtype_map = {
        "protectable_item_type": {
            "AzureFileShare": "AzureFileShareProtectableItem",
            "AzureVmWorkloadProtectableItem": "AzureVmWorkloadProtectableItem",
            "IaaSVMProtectableItem": "IaaSVMProtectableItem",
        }
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type
        self.protectable_item_type: Optional[str] = None
        self.friendly_name = friendly_name
        self.protection_state = protection_state


class AzureFileShareProtectableItem(WorkloadProtectableItem):
    """Protectable item for Azure Fileshare workloads.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_container_fabric_id: Full Fabric ID of container to which this protectable item
     belongs. For example, ARM ID.
    :vartype parent_container_fabric_id: str
    :ivar parent_container_friendly_name: Friendly name of container to which this protectable item
     belongs.
    :vartype parent_container_friendly_name: str
    :ivar azure_file_share_type: File Share type XSync or XSMB. Known values are: "Invalid",
     "XSMB", and "XSync".
    :vartype azure_file_share_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureFileShareType
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_container_fabric_id": {"key": "parentContainerFabricId", "type": "str"},
        "parent_container_friendly_name": {"key": "parentContainerFriendlyName", "type": "str"},
        "azure_file_share_type": {"key": "azureFileShareType", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_container_fabric_id: Optional[str] = None,
        parent_container_friendly_name: Optional[str] = None,
        azure_file_share_type: Optional[Union[str, "_models.AzureFileShareType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_container_fabric_id: Full Fabric ID of container to which this protectable item
         belongs. For example, ARM ID.
        :paramtype parent_container_fabric_id: str
        :keyword parent_container_friendly_name: Friendly name of container to which this protectable
         item belongs.
        :paramtype parent_container_friendly_name: str
        :keyword azure_file_share_type: File Share type XSync or XSMB. Known values are: "Invalid",
         "XSMB", and "XSync".
        :paramtype azure_file_share_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureFileShareType
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            **kwargs
        )
        self.protectable_item_type: str = "AzureFileShare"
        self.parent_container_fabric_id = parent_container_fabric_id
        self.parent_container_friendly_name = parent_container_friendly_name
        self.azure_file_share_type = azure_file_share_type


class ProtectedItem(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Base class for backup items.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileshareProtectedItem, AzureIaaSVMProtectedItem, AzureVmWorkloadProtectedItem,
    DPMProtectedItem, GenericProtectedItem, MabFileFolderProtectedItem, AzureSqlProtectedItem

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
    }

    _subtype_map = {
        "protected_item_type": {
            "AzureFileShareProtectedItem": "AzureFileshareProtectedItem",
            "AzureIaaSVMProtectedItem": "AzureIaaSVMProtectedItem",
            "AzureVmWorkloadProtectedItem": "AzureVmWorkloadProtectedItem",
            "DPMProtectedItem": "DPMProtectedItem",
            "GenericProtectedItem": "GenericProtectedItem",
            "MabFileFolderProtectedItem": "MabFileFolderProtectedItem",
            "Microsoft.Sql/servers/databases": "AzureSqlProtectedItem",
        }
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        """
        super().__init__(**kwargs)
        self.protected_item_type: Optional[str] = None
        self.backup_management_type = None
        self.workload_type = None
        self.container_name = container_name
        self.source_resource_id = source_resource_id
        self.policy_id = policy_id
        self.last_recovery_point = last_recovery_point
        self.backup_set_name = backup_set_name
        self.create_mode = create_mode
        self.deferred_delete_time_in_utc = deferred_delete_time_in_utc
        self.is_scheduled_for_deferred_delete = is_scheduled_for_deferred_delete
        self.deferred_delete_time_remaining = deferred_delete_time_remaining
        self.is_deferred_delete_schedule_upcoming = is_deferred_delete_schedule_upcoming
        self.is_rehydrate = is_rehydrate
        self.resource_guard_operation_requests = resource_guard_operation_requests
        self.is_archive_enabled = is_archive_enabled
        self.policy_name = policy_name
        self.soft_delete_retention_period = soft_delete_retention_period


class AzureFileshareProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Azure File Share workload-specific backup item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the fileshare represented by this backup item.
    :vartype friendly_name: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
    :ivar extended_info: Additional information with this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureFileshareProtectedItemExtendedInfo
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
        "extended_info": {"key": "extendedInfo", "type": "AzureFileshareProtectedItemExtendedInfo"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        friendly_name: Optional[str] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[str] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        extended_info: Optional["_models.AzureFileshareProtectedItemExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword friendly_name: Friendly name of the fileshare represented by this backup item.
        :paramtype friendly_name: str
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
        :paramtype last_backup_status: str
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
        :keyword extended_info: Additional information with this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureFileshareProtectedItemExtendedInfo
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            **kwargs
        )
        self.protected_item_type: str = "AzureFileShareProtectedItem"
        self.friendly_name = friendly_name
        self.protection_status = protection_status
        self.protection_state = protection_state
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.kpis_healths = kpis_healths
        self.extended_info = extended_info


class AzureFileshareProtectedItemExtendedInfo(_serialization.Model):
    """Additional information about Azure File Share backup item.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar oldest_recovery_point: The oldest backup copy available for this item in the service.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: Number of available backup copies associated with this backup item.
    :vartype recovery_point_count: int
    :ivar policy_state: Indicates consistency of policy object and policy applied to this backup
     item.
    :vartype policy_state: str
    :ivar resource_state: Indicates the state of this resource. Possible values are from enum
     ResourceState {Invalid, Active, SoftDeleted, Deleted}.
    :vartype resource_state: str
    :ivar resource_state_sync_time: The resource state sync time for this backup item.
    :vartype resource_state_sync_time: ~datetime.datetime
    """

    _validation = {
        "resource_state": {"readonly": True},
        "resource_state_sync_time": {"readonly": True},
    }

    _attribute_map = {
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "policy_state": {"key": "policyState", "type": "str"},
        "resource_state": {"key": "resourceState", "type": "str"},
        "resource_state_sync_time": {"key": "resourceStateSyncTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        policy_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword oldest_recovery_point: The oldest backup copy available for this item in the service.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: Number of available backup copies associated with this backup
         item.
        :paramtype recovery_point_count: int
        :keyword policy_state: Indicates consistency of policy object and policy applied to this backup
         item.
        :paramtype policy_state: str
        """
        super().__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_state = policy_state
        self.resource_state = None
        self.resource_state_sync_time = None


class ProtectionPolicy(_serialization.Model):
    """Base class for backup policy. Workload-specific backup policies are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureIaaSVMProtectionPolicy, AzureSqlProtectionPolicy, AzureFileShareProtectionPolicy,
    AzureVmWorkloadProtectionPolicy, GenericProtectionPolicy, MabProtectionPolicy

    All required parameters must be populated in order to send to Azure.

    :ivar protected_items_count: Number of items associated with this policy.
    :vartype protected_items_count: int
    :ivar backup_management_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype backup_management_type: str
    :ivar resource_guard_operation_requests: ResourceGuard Operation Requests.
    :vartype resource_guard_operation_requests: list[str]
    """

    _validation = {
        "backup_management_type": {"required": True},
    }

    _attribute_map = {
        "protected_items_count": {"key": "protectedItemsCount", "type": "int"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
    }

    _subtype_map = {
        "backup_management_type": {
            "AzureIaasVM": "AzureIaaSVMProtectionPolicy",
            "AzureSql": "AzureSqlProtectionPolicy",
            "AzureStorage": "AzureFileShareProtectionPolicy",
            "AzureWorkload": "AzureVmWorkloadProtectionPolicy",
            "GenericProtectionPolicy": "GenericProtectionPolicy",
            "MAB": "MabProtectionPolicy",
        }
    }

    def __init__(
        self,
        *,
        protected_items_count: Optional[int] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protected_items_count: Number of items associated with this policy.
        :paramtype protected_items_count: int
        :keyword resource_guard_operation_requests: ResourceGuard Operation Requests.
        :paramtype resource_guard_operation_requests: list[str]
        """
        super().__init__(**kwargs)
        self.protected_items_count = protected_items_count
        self.backup_management_type: Optional[str] = None
        self.resource_guard_operation_requests = resource_guard_operation_requests


class AzureFileShareProtectionPolicy(ProtectionPolicy):
    """AzureStorage backup policy.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_items_count: Number of items associated with this policy.
    :vartype protected_items_count: int
    :ivar backup_management_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype backup_management_type: str
    :ivar resource_guard_operation_requests: ResourceGuard Operation Requests.
    :vartype resource_guard_operation_requests: list[str]
    :ivar work_load_type: Type of workload for the backup management. Known values are: "Invalid",
     "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype work_load_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    :ivar schedule_policy: Backup schedule specified as part of backup policy.
    :vartype schedule_policy: ~azure.mgmt.recoveryservicesbackup.activestamp.models.SchedulePolicy
    :ivar retention_policy: Retention policy with the details on backup copy retention ranges.
    :vartype retention_policy:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionPolicy
    :ivar time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard
     Time".
    :vartype time_zone: str
    """

    _validation = {
        "backup_management_type": {"required": True},
    }

    _attribute_map = {
        "protected_items_count": {"key": "protectedItemsCount", "type": "int"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "work_load_type": {"key": "workLoadType", "type": "str"},
        "schedule_policy": {"key": "schedulePolicy", "type": "SchedulePolicy"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
        "time_zone": {"key": "timeZone", "type": "str"},
    }

    def __init__(
        self,
        *,
        protected_items_count: Optional[int] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        work_load_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        schedule_policy: Optional["_models.SchedulePolicy"] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        time_zone: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protected_items_count: Number of items associated with this policy.
        :paramtype protected_items_count: int
        :keyword resource_guard_operation_requests: ResourceGuard Operation Requests.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword work_load_type: Type of workload for the backup management. Known values are:
         "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
         "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
         "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype work_load_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        :keyword schedule_policy: Backup schedule specified as part of backup policy.
        :paramtype schedule_policy:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.SchedulePolicy
        :keyword retention_policy: Retention policy with the details on backup copy retention ranges.
        :paramtype retention_policy:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionPolicy
        :keyword time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific
         Standard Time".
        :paramtype time_zone: str
        """
        super().__init__(
            protected_items_count=protected_items_count,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.backup_management_type: str = "AzureStorage"
        self.work_load_type = work_load_type
        self.schedule_policy = schedule_policy
        self.retention_policy = retention_policy
        self.time_zone = time_zone


class ILRRequest(_serialization.Model):
    """Parameters to Provision ILR API.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileShareProvisionILRRequest, IaasVMILRRegistrationRequest

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureFileShareProvisionILRRequest": "AzureFileShareProvisionILRRequest",
            "IaasVMILRRegistrationRequest": "IaasVMILRRegistrationRequest",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class AzureFileShareProvisionILRRequest(ILRRequest):
    """Update snapshot Uri with the correct friendly Name of the source Azure file share.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_id: Recovery point ID.
    :vartype recovery_point_id: str
    :ivar source_resource_id: Source Storage account ARM Id.
    :vartype source_resource_id: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
    }

    def __init__(
        self, *, recovery_point_id: Optional[str] = None, source_resource_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_id: Recovery point ID.
        :paramtype recovery_point_id: str
        :keyword source_resource_id: Source Storage account ARM Id.
        :paramtype source_resource_id: str
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureFileShareProvisionILRRequest"
        self.recovery_point_id = recovery_point_id
        self.source_resource_id = source_resource_id


class RecoveryPoint(_serialization.Model):
    """Base class for backup copies. Workload-specific backup copies are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileShareRecoveryPoint, AzureWorkloadRecoveryPoint, GenericRecoveryPoint,
    IaasVMRecoveryPoint

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureFileShareRecoveryPoint": "AzureFileShareRecoveryPoint",
            "AzureWorkloadRecoveryPoint": "AzureWorkloadRecoveryPoint",
            "GenericRecoveryPoint": "GenericRecoveryPoint",
            "IaasVMRecoveryPoint": "IaasVMRecoveryPoint",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class AzureFileShareRecoveryPoint(RecoveryPoint):
    """Azure File Share workload specific backup copy.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_type: Type of the backup copy. Specifies whether it is a crash consistent
     backup or app consistent.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar file_share_snapshot_uri: Contains Url to the snapshot of fileshare, if applicable.
    :vartype file_share_snapshot_uri: str
    :ivar recovery_point_size_in_gb: Contains recovery point size.
    :vartype recovery_point_size_in_gb: int
    :ivar recovery_point_properties: Properties of Recovery Point.
    :vartype recovery_point_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "file_share_snapshot_uri": {"key": "fileShareSnapshotUri", "type": "str"},
        "recovery_point_size_in_gb": {"key": "recoveryPointSizeInGB", "type": "int"},
        "recovery_point_properties": {"key": "recoveryPointProperties", "type": "RecoveryPointProperties"},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Optional[str] = None,
        recovery_point_time: Optional[datetime.datetime] = None,
        file_share_snapshot_uri: Optional[str] = None,
        recovery_point_size_in_gb: Optional[int] = None,
        recovery_point_properties: Optional["_models.RecoveryPointProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_type: Type of the backup copy. Specifies whether it is a crash
         consistent backup or app consistent.
        :paramtype recovery_point_type: str
        :keyword recovery_point_time: Time at which this backup copy was created.
        :paramtype recovery_point_time: ~datetime.datetime
        :keyword file_share_snapshot_uri: Contains Url to the snapshot of fileshare, if applicable.
        :paramtype file_share_snapshot_uri: str
        :keyword recovery_point_size_in_gb: Contains recovery point size.
        :paramtype recovery_point_size_in_gb: int
        :keyword recovery_point_properties: Properties of Recovery Point.
        :paramtype recovery_point_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureFileShareRecoveryPoint"
        self.recovery_point_type = recovery_point_type
        self.recovery_point_time = recovery_point_time
        self.file_share_snapshot_uri = file_share_snapshot_uri
        self.recovery_point_size_in_gb = recovery_point_size_in_gb
        self.recovery_point_properties = recovery_point_properties


class RestoreRequest(_serialization.Model):
    """Base class for restore request. Workload-specific restore requests are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureFileShareRestoreRequest, AzureWorkloadRestoreRequest, IaasVMRestoreRequest

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureFileShareRestoreRequest": "AzureFileShareRestoreRequest",
            "AzureWorkloadRestoreRequest": "AzureWorkloadRestoreRequest",
            "IaasVMRestoreRequest": "IaasVMRestoreRequest",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class AzureFileShareRestoreRequest(RestoreRequest):
    """AzureFileShare Restore Request.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Source storage account ARM Id.
    :vartype source_resource_id: str
    :ivar copy_options: Options to resolve copy conflicts. Known values are: "Invalid",
     "CreateCopy", "Skip", "Overwrite", and "FailOnConflict".
    :vartype copy_options: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CopyOptions
    :ivar restore_request_type: Restore Type (FullShareRestore or ItemLevelRestore). Known values
     are: "Invalid", "FullShareRestore", and "ItemLevelRestore".
    :vartype restore_request_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestoreRequestType
    :ivar restore_file_specs: List of Source Files/Folders(which need to recover) and
     TargetFolderPath details.
    :vartype restore_file_specs:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RestoreFileSpecs]
    :ivar target_details: Target File Share Details.
    :vartype target_details:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetAFSRestoreInfo
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "copy_options": {"key": "copyOptions", "type": "str"},
        "restore_request_type": {"key": "restoreRequestType", "type": "str"},
        "restore_file_specs": {"key": "restoreFileSpecs", "type": "[RestoreFileSpecs]"},
        "target_details": {"key": "targetDetails", "type": "TargetAFSRestoreInfo"},
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        copy_options: Optional[Union[str, "_models.CopyOptions"]] = None,
        restore_request_type: Optional[Union[str, "_models.RestoreRequestType"]] = None,
        restore_file_specs: Optional[List["_models.RestoreFileSpecs"]] = None,
        target_details: Optional["_models.TargetAFSRestoreInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Source storage account ARM Id.
        :paramtype source_resource_id: str
        :keyword copy_options: Options to resolve copy conflicts. Known values are: "Invalid",
         "CreateCopy", "Skip", "Overwrite", and "FailOnConflict".
        :paramtype copy_options: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.CopyOptions
        :keyword restore_request_type: Restore Type (FullShareRestore or ItemLevelRestore). Known
         values are: "Invalid", "FullShareRestore", and "ItemLevelRestore".
        :paramtype restore_request_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestoreRequestType
        :keyword restore_file_specs: List of Source Files/Folders(which need to recover) and
         TargetFolderPath details.
        :paramtype restore_file_specs:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RestoreFileSpecs]
        :keyword target_details: Target File Share Details.
        :paramtype target_details:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetAFSRestoreInfo
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureFileShareRestoreRequest"
        self.recovery_type = recovery_type
        self.source_resource_id = source_resource_id
        self.copy_options = copy_options
        self.restore_request_type = restore_request_type
        self.restore_file_specs = restore_file_specs
        self.target_details = target_details


class IaaSVMContainer(ProtectionContainer):
    """IaaS VM workload-specific container.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureIaaSClassicComputeVMContainer, AzureIaaSComputeVMContainer

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this
     Azure IaaS VM container.
    :vartype virtual_machine_id: str
    :ivar virtual_machine_version: Specifies whether the container represents a Classic or an Azure
     Resource Manager VM.
    :vartype virtual_machine_version: str
    :ivar resource_group: Resource group name of Recovery Services Vault.
    :vartype resource_group: str
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "virtual_machine_version": {"key": "virtualMachineVersion", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
    }

    _subtype_map = {
        "container_type": {
            "Microsoft.ClassicCompute/virtualMachines": "AzureIaaSClassicComputeVMContainer",
            "Microsoft.Compute/virtualMachines": "AzureIaaSComputeVMContainer",
        }
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        virtual_machine_id: Optional[str] = None,
        virtual_machine_version: Optional[str] = None,
        resource_group: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this
         Azure IaaS VM container.
        :paramtype virtual_machine_id: str
        :keyword virtual_machine_version: Specifies whether the container represents a Classic or an
         Azure Resource Manager VM.
        :paramtype virtual_machine_version: str
        :keyword resource_group: Resource group name of Recovery Services Vault.
        :paramtype resource_group: str
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            **kwargs
        )
        self.container_type: str = "IaasVMContainer"
        self.virtual_machine_id = virtual_machine_id
        self.virtual_machine_version = virtual_machine_version
        self.resource_group = resource_group


class AzureIaaSClassicComputeVMContainer(IaaSVMContainer):
    """IaaS VM workload-specific backup item representing a classic virtual machine.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this
     Azure IaaS VM container.
    :vartype virtual_machine_id: str
    :ivar virtual_machine_version: Specifies whether the container represents a Classic or an Azure
     Resource Manager VM.
    :vartype virtual_machine_version: str
    :ivar resource_group: Resource group name of Recovery Services Vault.
    :vartype resource_group: str
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "virtual_machine_version": {"key": "virtualMachineVersion", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        virtual_machine_id: Optional[str] = None,
        virtual_machine_version: Optional[str] = None,
        resource_group: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this
         Azure IaaS VM container.
        :paramtype virtual_machine_id: str
        :keyword virtual_machine_version: Specifies whether the container represents a Classic or an
         Azure Resource Manager VM.
        :paramtype virtual_machine_version: str
        :keyword resource_group: Resource group name of Recovery Services Vault.
        :paramtype resource_group: str
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            virtual_machine_id=virtual_machine_id,
            virtual_machine_version=virtual_machine_version,
            resource_group=resource_group,
            **kwargs
        )
        self.container_type: str = "Microsoft.ClassicCompute/virtualMachines"


class IaaSVMProtectableItem(WorkloadProtectableItem):
    """IaaS VM workload-specific backup item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureIaaSClassicComputeVMProtectableItem, AzureIaaSComputeVMProtectableItem

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine.
    :vartype virtual_machine_id: str
    :ivar virtual_machine_version: Specifies whether the container represents a Classic or an Azure
     Resource Manager VM.
    :vartype virtual_machine_version: str
    :ivar resource_group: Resource group name of Recovery Services Vault.
    :vartype resource_group: str
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "virtual_machine_version": {"key": "virtualMachineVersion", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
    }

    _subtype_map = {
        "protectable_item_type": {
            "Microsoft.ClassicCompute/virtualMachines": "AzureIaaSClassicComputeVMProtectableItem",
            "Microsoft.Compute/virtualMachines": "AzureIaaSComputeVMProtectableItem",
        }
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        virtual_machine_id: Optional[str] = None,
        virtual_machine_version: Optional[str] = None,
        resource_group: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword virtual_machine_id: Fully qualified ARM ID of the virtual machine.
        :paramtype virtual_machine_id: str
        :keyword virtual_machine_version: Specifies whether the container represents a Classic or an
         Azure Resource Manager VM.
        :paramtype virtual_machine_version: str
        :keyword resource_group: Resource group name of Recovery Services Vault.
        :paramtype resource_group: str
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            **kwargs
        )
        self.protectable_item_type: str = "IaaSVMProtectableItem"
        self.virtual_machine_id = virtual_machine_id
        self.virtual_machine_version = virtual_machine_version
        self.resource_group = resource_group


class AzureIaaSClassicComputeVMProtectableItem(IaaSVMProtectableItem):
    """IaaS VM workload-specific backup item representing the Classic Compute VM.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine.
    :vartype virtual_machine_id: str
    :ivar virtual_machine_version: Specifies whether the container represents a Classic or an Azure
     Resource Manager VM.
    :vartype virtual_machine_version: str
    :ivar resource_group: Resource group name of Recovery Services Vault.
    :vartype resource_group: str
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "virtual_machine_version": {"key": "virtualMachineVersion", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        virtual_machine_id: Optional[str] = None,
        virtual_machine_version: Optional[str] = None,
        resource_group: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword virtual_machine_id: Fully qualified ARM ID of the virtual machine.
        :paramtype virtual_machine_id: str
        :keyword virtual_machine_version: Specifies whether the container represents a Classic or an
         Azure Resource Manager VM.
        :paramtype virtual_machine_version: str
        :keyword resource_group: Resource group name of Recovery Services Vault.
        :paramtype resource_group: str
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            virtual_machine_id=virtual_machine_id,
            virtual_machine_version=virtual_machine_version,
            resource_group=resource_group,
            **kwargs
        )
        self.protectable_item_type: str = "Microsoft.ClassicCompute/virtualMachines"


class AzureIaaSVMProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload-specific backup item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureIaaSClassicComputeVMProtectedItem, AzureIaaSComputeVMProtectedItem

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the VM represented by this backup item.
    :vartype friendly_name: str
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this
     item.
    :vartype virtual_machine_id: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar health_status: Health status of protected item. Known values are: "Passed",
     "ActionRequired", "ActionSuggested", and "Invalid".
    :vartype health_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.HealthStatus
    :ivar health_details: Health details on this backup item.
    :vartype health_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMHealthDetails]
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
    :ivar last_backup_status: Last backup operation status.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar protected_item_data_id: Data ID of the protected item.
    :vartype protected_item_data_id: str
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMProtectedItemExtendedInfo
    :ivar extended_properties: Extended Properties for Azure IaasVM Backup.
    :vartype extended_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedProperties
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "virtual_machine_id": {"readonly": True},
        "health_status": {"readonly": True},
        "last_backup_time": {"readonly": True},
        "protected_item_data_id": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "health_details": {"key": "healthDetails", "type": "[AzureIaaSVMHealthDetails]"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "protected_item_data_id": {"key": "protectedItemDataId", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureIaaSVMProtectedItemExtendedInfo"},
        "extended_properties": {"key": "extendedProperties", "type": "ExtendedProperties"},
    }

    _subtype_map = {
        "protected_item_type": {
            "Microsoft.ClassicCompute/virtualMachines": "AzureIaaSClassicComputeVMProtectedItem",
            "Microsoft.Compute/virtualMachines": "AzureIaaSComputeVMProtectedItem",
        }
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        health_details: Optional[List["_models.AzureIaaSVMHealthDetails"]] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        last_backup_status: Optional[str] = None,
        extended_info: Optional["_models.AzureIaaSVMProtectedItemExtendedInfo"] = None,
        extended_properties: Optional["_models.ExtendedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword health_details: Health details on this backup item.
        :paramtype health_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMHealthDetails]
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
        :keyword last_backup_status: Last backup operation status.
        :paramtype last_backup_status: str
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMProtectedItemExtendedInfo
        :keyword extended_properties: Extended Properties for Azure IaasVM Backup.
        :paramtype extended_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedProperties
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            **kwargs
        )
        self.protected_item_type: str = "AzureIaaSVMProtectedItem"
        self.friendly_name = None
        self.virtual_machine_id = None
        self.protection_status = protection_status
        self.protection_state = protection_state
        self.health_status = None
        self.health_details = health_details
        self.kpis_healths = kpis_healths
        self.last_backup_status = last_backup_status
        self.last_backup_time = None
        self.protected_item_data_id = None
        self.extended_info = extended_info
        self.extended_properties = extended_properties


class AzureIaaSClassicComputeVMProtectedItem(AzureIaaSVMProtectedItem):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload-specific backup item representing the Classic Compute VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the VM represented by this backup item.
    :vartype friendly_name: str
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this
     item.
    :vartype virtual_machine_id: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar health_status: Health status of protected item. Known values are: "Passed",
     "ActionRequired", "ActionSuggested", and "Invalid".
    :vartype health_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.HealthStatus
    :ivar health_details: Health details on this backup item.
    :vartype health_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMHealthDetails]
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
    :ivar last_backup_status: Last backup operation status.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar protected_item_data_id: Data ID of the protected item.
    :vartype protected_item_data_id: str
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMProtectedItemExtendedInfo
    :ivar extended_properties: Extended Properties for Azure IaasVM Backup.
    :vartype extended_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedProperties
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "virtual_machine_id": {"readonly": True},
        "health_status": {"readonly": True},
        "last_backup_time": {"readonly": True},
        "protected_item_data_id": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "health_details": {"key": "healthDetails", "type": "[AzureIaaSVMHealthDetails]"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "protected_item_data_id": {"key": "protectedItemDataId", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureIaaSVMProtectedItemExtendedInfo"},
        "extended_properties": {"key": "extendedProperties", "type": "ExtendedProperties"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        health_details: Optional[List["_models.AzureIaaSVMHealthDetails"]] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        last_backup_status: Optional[str] = None,
        extended_info: Optional["_models.AzureIaaSVMProtectedItemExtendedInfo"] = None,
        extended_properties: Optional["_models.ExtendedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword health_details: Health details on this backup item.
        :paramtype health_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMHealthDetails]
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
        :keyword last_backup_status: Last backup operation status.
        :paramtype last_backup_status: str
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMProtectedItemExtendedInfo
        :keyword extended_properties: Extended Properties for Azure IaasVM Backup.
        :paramtype extended_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedProperties
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            protection_status=protection_status,
            protection_state=protection_state,
            health_details=health_details,
            kpis_healths=kpis_healths,
            last_backup_status=last_backup_status,
            extended_info=extended_info,
            extended_properties=extended_properties,
            **kwargs
        )
        self.protected_item_type: str = "Microsoft.ClassicCompute/virtualMachines"


class AzureIaaSComputeVMContainer(IaaSVMContainer):
    """IaaS VM workload-specific backup item representing an Azure Resource Manager virtual machine.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this
     Azure IaaS VM container.
    :vartype virtual_machine_id: str
    :ivar virtual_machine_version: Specifies whether the container represents a Classic or an Azure
     Resource Manager VM.
    :vartype virtual_machine_version: str
    :ivar resource_group: Resource group name of Recovery Services Vault.
    :vartype resource_group: str
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "virtual_machine_version": {"key": "virtualMachineVersion", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        virtual_machine_id: Optional[str] = None,
        virtual_machine_version: Optional[str] = None,
        resource_group: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword virtual_machine_id: Fully qualified ARM url of the virtual machine represented by this
         Azure IaaS VM container.
        :paramtype virtual_machine_id: str
        :keyword virtual_machine_version: Specifies whether the container represents a Classic or an
         Azure Resource Manager VM.
        :paramtype virtual_machine_version: str
        :keyword resource_group: Resource group name of Recovery Services Vault.
        :paramtype resource_group: str
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            virtual_machine_id=virtual_machine_id,
            virtual_machine_version=virtual_machine_version,
            resource_group=resource_group,
            **kwargs
        )
        self.container_type: str = "Microsoft.Compute/virtualMachines"


class AzureIaaSComputeVMProtectableItem(IaaSVMProtectableItem):
    """IaaS VM workload-specific backup item representing the Azure Resource Manager VM.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine.
    :vartype virtual_machine_id: str
    :ivar virtual_machine_version: Specifies whether the container represents a Classic or an Azure
     Resource Manager VM.
    :vartype virtual_machine_version: str
    :ivar resource_group: Resource group name of Recovery Services Vault.
    :vartype resource_group: str
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "virtual_machine_version": {"key": "virtualMachineVersion", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        virtual_machine_id: Optional[str] = None,
        virtual_machine_version: Optional[str] = None,
        resource_group: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword virtual_machine_id: Fully qualified ARM ID of the virtual machine.
        :paramtype virtual_machine_id: str
        :keyword virtual_machine_version: Specifies whether the container represents a Classic or an
         Azure Resource Manager VM.
        :paramtype virtual_machine_version: str
        :keyword resource_group: Resource group name of Recovery Services Vault.
        :paramtype resource_group: str
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            virtual_machine_id=virtual_machine_id,
            virtual_machine_version=virtual_machine_version,
            resource_group=resource_group,
            **kwargs
        )
        self.protectable_item_type: str = "Microsoft.Compute/virtualMachines"


class AzureIaaSComputeVMProtectedItem(AzureIaaSVMProtectedItem):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload-specific backup item representing the Azure Resource Manager VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the VM represented by this backup item.
    :vartype friendly_name: str
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine represented by this
     item.
    :vartype virtual_machine_id: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar health_status: Health status of protected item. Known values are: "Passed",
     "ActionRequired", "ActionSuggested", and "Invalid".
    :vartype health_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.HealthStatus
    :ivar health_details: Health details on this backup item.
    :vartype health_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMHealthDetails]
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
    :ivar last_backup_status: Last backup operation status.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar protected_item_data_id: Data ID of the protected item.
    :vartype protected_item_data_id: str
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMProtectedItemExtendedInfo
    :ivar extended_properties: Extended Properties for Azure IaasVM Backup.
    :vartype extended_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedProperties
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "virtual_machine_id": {"readonly": True},
        "health_status": {"readonly": True},
        "last_backup_time": {"readonly": True},
        "protected_item_data_id": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "health_details": {"key": "healthDetails", "type": "[AzureIaaSVMHealthDetails]"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "protected_item_data_id": {"key": "protectedItemDataId", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureIaaSVMProtectedItemExtendedInfo"},
        "extended_properties": {"key": "extendedProperties", "type": "ExtendedProperties"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        protection_status: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        health_details: Optional[List["_models.AzureIaaSVMHealthDetails"]] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        last_backup_status: Optional[str] = None,
        extended_info: Optional["_models.AzureIaaSVMProtectedItemExtendedInfo"] = None,
        extended_properties: Optional["_models.ExtendedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword protection_status: Backup status of this backup item.
        :paramtype protection_status: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword health_details: Health details on this backup item.
        :paramtype health_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMHealthDetails]
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
        :keyword last_backup_status: Last backup operation status.
        :paramtype last_backup_status: str
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMProtectedItemExtendedInfo
        :keyword extended_properties: Extended Properties for Azure IaasVM Backup.
        :paramtype extended_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedProperties
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            protection_status=protection_status,
            protection_state=protection_state,
            health_details=health_details,
            kpis_healths=kpis_healths,
            last_backup_status=last_backup_status,
            extended_info=extended_info,
            extended_properties=extended_properties,
            **kwargs
        )
        self.protected_item_type: str = "Microsoft.Compute/virtualMachines"


class AzureIaaSVMErrorInfo(_serialization.Model):
    """Azure IaaS VM workload-specific error information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_code: Error code.
    :vartype error_code: int
    :ivar error_title: Title: Typically, the entity that the error pertains to.
    :vartype error_title: str
    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations for above error code.
    :vartype recommendations: list[str]
    """

    _validation = {
        "error_code": {"readonly": True},
        "error_title": {"readonly": True},
        "error_string": {"readonly": True},
        "recommendations": {"readonly": True},
    }

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "int"},
        "error_title": {"key": "errorTitle", "type": "str"},
        "error_string": {"key": "errorString", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_code = None
        self.error_title = None
        self.error_string = None
        self.recommendations = None


class ResourceHealthDetails(_serialization.Model):
    """Health Details for backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Health Code.
    :vartype code: int
    :ivar title: Health Title.
    :vartype title: str
    :ivar message: Health Message.
    :vartype message: str
    :ivar recommendations: Health Recommended Actions.
    :vartype recommendations: list[str]
    """

    _validation = {
        "code": {"readonly": True},
        "title": {"readonly": True},
        "message": {"readonly": True},
        "recommendations": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "int"},
        "title": {"key": "title", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.title = None
        self.message = None
        self.recommendations = None


class AzureIaaSVMHealthDetails(ResourceHealthDetails):
    """Azure IaaS VM workload-specific Health Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Health Code.
    :vartype code: int
    :ivar title: Health Title.
    :vartype title: str
    :ivar message: Health Message.
    :vartype message: str
    :ivar recommendations: Health Recommended Actions.
    :vartype recommendations: list[str]
    """

    _validation = {
        "code": {"readonly": True},
        "title": {"readonly": True},
        "message": {"readonly": True},
        "recommendations": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "int"},
        "title": {"key": "title", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class Job(_serialization.Model):
    """Defines workload agnostic properties for a job.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureIaaSVMJob, AzureIaaSVMJobV2, AzureStorageJob, AzureWorkloadJob, DpmJob, MabJob, VaultJob

    All required parameters must be populated in order to send to Azure.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
    }

    _subtype_map = {
        "job_type": {
            "AzureIaaSVMJob": "AzureIaaSVMJob",
            "AzureIaaSVMJobV2": "AzureIaaSVMJobV2",
            "AzureStorageJob": "AzureStorageJob",
            "AzureWorkloadJob": "AzureWorkloadJob",
            "DpmJob": "DpmJob",
            "MabJob": "MabJob",
            "VaultJob": "VaultJob",
        }
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        """
        super().__init__(**kwargs)
        self.entity_friendly_name = entity_friendly_name
        self.backup_management_type = backup_management_type
        self.operation = operation
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.activity_id = activity_id
        self.job_type: Optional[str] = None


class AzureIaaSVMJob(Job):  # pylint: disable=too-many-instance-attributes
    """Azure IaaS VM workload-specific job object.

    All required parameters must be populated in order to send to Azure.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar duration: Time elapsed during the execution of this job.
    :vartype duration: ~datetime.timedelta
    :ivar actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
    :ivar error_details: Error details on execution of this job.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMErrorInfo]
    :ivar virtual_machine_version: Specifies whether the backup item is a Classic or an Azure
     Resource Manager VM.
    :vartype virtual_machine_version: str
    :ivar extended_info: Additional information for this job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMJobExtendedInfo
    :ivar container_name: Container name of the entity on which the current job is executing.
    :vartype container_name: str
    :ivar is_user_triggered: Indicated that whether the job is adhoc(true) or scheduled(false).
    :vartype is_user_triggered: bool
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "error_details": {"key": "errorDetails", "type": "[AzureIaaSVMErrorInfo]"},
        "virtual_machine_version": {"key": "virtualMachineVersion", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureIaaSVMJobExtendedInfo"},
        "container_name": {"key": "containerName", "type": "str"},
        "is_user_triggered": {"key": "isUserTriggered", "type": "bool"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        error_details: Optional[List["_models.AzureIaaSVMErrorInfo"]] = None,
        virtual_machine_version: Optional[str] = None,
        extended_info: Optional["_models.AzureIaaSVMJobExtendedInfo"] = None,
        container_name: Optional[str] = None,
        is_user_triggered: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword duration: Time elapsed during the execution of this job.
        :paramtype duration: ~datetime.timedelta
        :keyword actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
        :keyword error_details: Error details on execution of this job.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMErrorInfo]
        :keyword virtual_machine_version: Specifies whether the backup item is a Classic or an Azure
         Resource Manager VM.
        :paramtype virtual_machine_version: str
        :keyword extended_info: Additional information for this job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMJobExtendedInfo
        :keyword container_name: Container name of the entity on which the current job is executing.
        :paramtype container_name: str
        :keyword is_user_triggered: Indicated that whether the job is adhoc(true) or scheduled(false).
        :paramtype is_user_triggered: bool
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "AzureIaaSVMJob"
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.virtual_machine_version = virtual_machine_version
        self.extended_info = extended_info
        self.container_name = container_name
        self.is_user_triggered = is_user_triggered


class AzureIaaSVMJobExtendedInfo(_serialization.Model):
    """Azure IaaS VM workload-specific additional information for job.

    :ivar tasks_list: List of tasks associated with this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMJobTaskDetails]
    :ivar property_bag: Job properties.
    :vartype property_bag: dict[str, str]
    :ivar internal_property_bag: Job internal properties.
    :vartype internal_property_bag: dict[str, str]
    :ivar progress_percentage: Indicates progress of the job. Null if it has not started or
     completed.
    :vartype progress_percentage: float
    :ivar estimated_remaining_duration: Time remaining for execution of this job.
    :vartype estimated_remaining_duration: str
    :ivar dynamic_error_message: Non localized error message on job execution.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[AzureIaaSVMJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "internal_property_bag": {"key": "internalPropertyBag", "type": "{str}"},
        "progress_percentage": {"key": "progressPercentage", "type": "float"},
        "estimated_remaining_duration": {"key": "estimatedRemainingDuration", "type": "str"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.AzureIaaSVMJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        internal_property_bag: Optional[Dict[str, str]] = None,
        progress_percentage: Optional[float] = None,
        estimated_remaining_duration: Optional[str] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks associated with this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMJobTaskDetails]
        :keyword property_bag: Job properties.
        :paramtype property_bag: dict[str, str]
        :keyword internal_property_bag: Job internal properties.
        :paramtype internal_property_bag: dict[str, str]
        :keyword progress_percentage: Indicates progress of the job. Null if it has not started or
         completed.
        :paramtype progress_percentage: float
        :keyword estimated_remaining_duration: Time remaining for execution of this job.
        :paramtype estimated_remaining_duration: str
        :keyword dynamic_error_message: Non localized error message on job execution.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.internal_property_bag = internal_property_bag
        self.progress_percentage = progress_percentage
        self.estimated_remaining_duration = estimated_remaining_duration
        self.dynamic_error_message = dynamic_error_message


class AzureIaaSVMJobTaskDetails(_serialization.Model):
    """Azure IaaS VM workload-specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar instance_id: The instanceId.
    :vartype instance_id: str
    :ivar duration: Time elapsed for task.
    :vartype duration: ~datetime.timedelta
    :ivar status: The status.
    :vartype status: str
    :ivar progress_percentage: Progress of the task.
    :vartype progress_percentage: float
    :ivar task_execution_details: Details about execution of the task.
     eg: number of bytes transferred etc.
    :vartype task_execution_details: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "instance_id": {"key": "instanceId", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "status": {"key": "status", "type": "str"},
        "progress_percentage": {"key": "progressPercentage", "type": "float"},
        "task_execution_details": {"key": "taskExecutionDetails", "type": "str"},
    }

    def __init__(
        self,
        *,
        task_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        instance_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        status: Optional[str] = None,
        progress_percentage: Optional[float] = None,
        task_execution_details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword instance_id: The instanceId.
        :paramtype instance_id: str
        :keyword duration: Time elapsed for task.
        :paramtype duration: ~datetime.timedelta
        :keyword status: The status.
        :paramtype status: str
        :keyword progress_percentage: Progress of the task.
        :paramtype progress_percentage: float
        :keyword task_execution_details: Details about execution of the task.
         eg: number of bytes transferred etc.
        :paramtype task_execution_details: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.instance_id = instance_id
        self.duration = duration
        self.status = status
        self.progress_percentage = progress_percentage
        self.task_execution_details = task_execution_details


class AzureIaaSVMJobV2(Job):  # pylint: disable=too-many-instance-attributes
    """Azure IaaS VM workload-specific job object.

    All required parameters must be populated in order to send to Azure.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
    :ivar container_name: Container name of the entity on which the current job is executing.
    :vartype container_name: str
    :ivar duration: Time elapsed during the execution of this job.
    :vartype duration: ~datetime.timedelta
    :ivar error_details: Error details on execution of this job.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMErrorInfo]
    :ivar virtual_machine_version: Specifies whether the backup item is a Classic or an Azure
     Resource Manager VM.
    :vartype virtual_machine_version: str
    :ivar extended_info: Additional information for this job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMJobExtendedInfo
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "container_name": {"key": "containerName", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "error_details": {"key": "errorDetails", "type": "[AzureIaaSVMErrorInfo]"},
        "virtual_machine_version": {"key": "virtualMachineVersion", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureIaaSVMJobExtendedInfo"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        container_name: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        error_details: Optional[List["_models.AzureIaaSVMErrorInfo"]] = None,
        virtual_machine_version: Optional[str] = None,
        extended_info: Optional["_models.AzureIaaSVMJobExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
        :keyword container_name: Container name of the entity on which the current job is executing.
        :paramtype container_name: str
        :keyword duration: Time elapsed during the execution of this job.
        :paramtype duration: ~datetime.timedelta
        :keyword error_details: Error details on execution of this job.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMErrorInfo]
        :keyword virtual_machine_version: Specifies whether the backup item is a Classic or an Azure
         Resource Manager VM.
        :paramtype virtual_machine_version: str
        :keyword extended_info: Additional information for this job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureIaaSVMJobExtendedInfo
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "AzureIaaSVMJobV2"
        self.actions_info = actions_info
        self.container_name = container_name
        self.duration = duration
        self.error_details = error_details
        self.virtual_machine_version = virtual_machine_version
        self.extended_info = extended_info


class AzureIaaSVMProtectedItemExtendedInfo(_serialization.Model):
    """Additional information on Azure IaaS VM specific backup item.

    :ivar oldest_recovery_point: The oldest backup copy available for this backup item across all
     tiers.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar oldest_recovery_point_in_vault: The oldest backup copy available for this backup item in
     vault tier.
    :vartype oldest_recovery_point_in_vault: ~datetime.datetime
    :ivar oldest_recovery_point_in_archive: The oldest backup copy available for this backup item
     in archive tier.
    :vartype oldest_recovery_point_in_archive: ~datetime.datetime
    :ivar newest_recovery_point_in_archive: The latest backup copy available for this backup item
     in archive tier.
    :vartype newest_recovery_point_in_archive: ~datetime.datetime
    :ivar recovery_point_count: Number of backup copies available for this backup item.
    :vartype recovery_point_count: int
    :ivar policy_inconsistent: Specifies if backup policy associated with the backup item is
     inconsistent.
    :vartype policy_inconsistent: bool
    """

    _attribute_map = {
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "oldest_recovery_point_in_vault": {"key": "oldestRecoveryPointInVault", "type": "iso-8601"},
        "oldest_recovery_point_in_archive": {"key": "oldestRecoveryPointInArchive", "type": "iso-8601"},
        "newest_recovery_point_in_archive": {"key": "newestRecoveryPointInArchive", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "policy_inconsistent": {"key": "policyInconsistent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        oldest_recovery_point_in_vault: Optional[datetime.datetime] = None,
        oldest_recovery_point_in_archive: Optional[datetime.datetime] = None,
        newest_recovery_point_in_archive: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        policy_inconsistent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword oldest_recovery_point: The oldest backup copy available for this backup item across
         all tiers.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword oldest_recovery_point_in_vault: The oldest backup copy available for this backup item
         in vault tier.
        :paramtype oldest_recovery_point_in_vault: ~datetime.datetime
        :keyword oldest_recovery_point_in_archive: The oldest backup copy available for this backup
         item in archive tier.
        :paramtype oldest_recovery_point_in_archive: ~datetime.datetime
        :keyword newest_recovery_point_in_archive: The latest backup copy available for this backup
         item in archive tier.
        :paramtype newest_recovery_point_in_archive: ~datetime.datetime
        :keyword recovery_point_count: Number of backup copies available for this backup item.
        :paramtype recovery_point_count: int
        :keyword policy_inconsistent: Specifies if backup policy associated with the backup item is
         inconsistent.
        :paramtype policy_inconsistent: bool
        """
        super().__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.oldest_recovery_point_in_vault = oldest_recovery_point_in_vault
        self.oldest_recovery_point_in_archive = oldest_recovery_point_in_archive
        self.newest_recovery_point_in_archive = newest_recovery_point_in_archive
        self.recovery_point_count = recovery_point_count
        self.policy_inconsistent = policy_inconsistent


class AzureIaaSVMProtectionPolicy(ProtectionPolicy):
    """IaaS VM workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_items_count: Number of items associated with this policy.
    :vartype protected_items_count: int
    :ivar backup_management_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype backup_management_type: str
    :ivar resource_guard_operation_requests: ResourceGuard Operation Requests.
    :vartype resource_guard_operation_requests: list[str]
    :ivar instant_rp_details:
    :vartype instant_rp_details:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.InstantRPAdditionalDetails
    :ivar schedule_policy: Backup schedule specified as part of backup policy.
    :vartype schedule_policy: ~azure.mgmt.recoveryservicesbackup.activestamp.models.SchedulePolicy
    :ivar retention_policy: Retention policy with the details on backup copy retention ranges.
    :vartype retention_policy:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionPolicy
    :ivar tiering_policy: Tiering policy to automatically move RPs to another tier
     Key is Target Tier, defined in RecoveryPointTierType enum.
     Tiering policy specifies the criteria to move RP to the target tier.
    :vartype tiering_policy: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.TieringPolicy]
    :ivar instant_rp_retention_range_in_days: Instant RP retention policy range in days.
    :vartype instant_rp_retention_range_in_days: int
    :ivar time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard
     Time".
    :vartype time_zone: str
    :ivar policy_type: Known values are: "Invalid", "V1", and "V2".
    :vartype policy_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.IAASVMPolicyType
    """

    _validation = {
        "backup_management_type": {"required": True},
    }

    _attribute_map = {
        "protected_items_count": {"key": "protectedItemsCount", "type": "int"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "instant_rp_details": {"key": "instantRPDetails", "type": "InstantRPAdditionalDetails"},
        "schedule_policy": {"key": "schedulePolicy", "type": "SchedulePolicy"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
        "tiering_policy": {"key": "tieringPolicy", "type": "{TieringPolicy}"},
        "instant_rp_retention_range_in_days": {"key": "instantRpRetentionRangeInDays", "type": "int"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "policy_type": {"key": "policyType", "type": "str"},
    }

    def __init__(
        self,
        *,
        protected_items_count: Optional[int] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        instant_rp_details: Optional["_models.InstantRPAdditionalDetails"] = None,
        schedule_policy: Optional["_models.SchedulePolicy"] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        tiering_policy: Optional[Dict[str, "_models.TieringPolicy"]] = None,
        instant_rp_retention_range_in_days: Optional[int] = None,
        time_zone: Optional[str] = None,
        policy_type: Optional[Union[str, "_models.IAASVMPolicyType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protected_items_count: Number of items associated with this policy.
        :paramtype protected_items_count: int
        :keyword resource_guard_operation_requests: ResourceGuard Operation Requests.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword instant_rp_details:
        :paramtype instant_rp_details:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.InstantRPAdditionalDetails
        :keyword schedule_policy: Backup schedule specified as part of backup policy.
        :paramtype schedule_policy:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.SchedulePolicy
        :keyword retention_policy: Retention policy with the details on backup copy retention ranges.
        :paramtype retention_policy:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionPolicy
        :keyword tiering_policy: Tiering policy to automatically move RPs to another tier
         Key is Target Tier, defined in RecoveryPointTierType enum.
         Tiering policy specifies the criteria to move RP to the target tier.
        :paramtype tiering_policy: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.TieringPolicy]
        :keyword instant_rp_retention_range_in_days: Instant RP retention policy range in days.
        :paramtype instant_rp_retention_range_in_days: int
        :keyword time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific
         Standard Time".
        :paramtype time_zone: str
        :keyword policy_type: Known values are: "Invalid", "V1", and "V2".
        :paramtype policy_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.IAASVMPolicyType
        """
        super().__init__(
            protected_items_count=protected_items_count,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.backup_management_type: str = "AzureIaasVM"
        self.instant_rp_details = instant_rp_details
        self.schedule_policy = schedule_policy
        self.retention_policy = retention_policy
        self.tiering_policy = tiering_policy
        self.instant_rp_retention_range_in_days = instant_rp_retention_range_in_days
        self.time_zone = time_zone
        self.policy_type = policy_type


class ProtectionIntent(_serialization.Model):
    """Base class for backup ProtectionIntent.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureResourceProtectionIntent, AzureWorkloadContainerAutoProtectionIntent,
    AzureRecoveryServiceVaultProtectionIntent

    All required parameters must be populated in order to send to Azure.

    :ivar protection_intent_item_type: backup protectionIntent type. Required. Known values are:
     "Invalid", "AzureResourceItem", "RecoveryServiceVaultItem",
     "AzureWorkloadContainerAutoProtectionIntent", "AzureWorkloadAutoProtectionIntent", and
     "AzureWorkloadSQLAutoProtectionIntent".
    :vartype protection_intent_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntentItemType
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar item_id: ID of the item which is getting protected, In case of Azure Vm , it is
     ProtectedItemId.
    :vartype item_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    """

    _validation = {
        "protection_intent_item_type": {"required": True},
    }

    _attribute_map = {
        "protection_intent_item_type": {"key": "protectionIntentItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "item_id": {"key": "itemId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
    }

    _subtype_map = {
        "protection_intent_item_type": {
            "AzureResourceItem": "AzureResourceProtectionIntent",
            "AzureWorkloadContainerAutoProtectionIntent": "AzureWorkloadContainerAutoProtectionIntent",
            "RecoveryServiceVaultItem": "AzureRecoveryServiceVaultProtectionIntent",
        }
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        source_resource_id: Optional[str] = None,
        item_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword item_id: ID of the item which is getting protected, In case of Azure Vm , it is
         ProtectedItemId.
        :paramtype item_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        """
        super().__init__(**kwargs)
        self.protection_intent_item_type: Optional[str] = None
        self.backup_management_type = backup_management_type
        self.source_resource_id = source_resource_id
        self.item_id = item_id
        self.policy_id = policy_id
        self.protection_state = protection_state


class AzureRecoveryServiceVaultProtectionIntent(ProtectionIntent):
    """Azure Recovery Services Vault specific protection intent item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadAutoProtectionIntent

    All required parameters must be populated in order to send to Azure.

    :ivar protection_intent_item_type: backup protectionIntent type. Required. Known values are:
     "Invalid", "AzureResourceItem", "RecoveryServiceVaultItem",
     "AzureWorkloadContainerAutoProtectionIntent", "AzureWorkloadAutoProtectionIntent", and
     "AzureWorkloadSQLAutoProtectionIntent".
    :vartype protection_intent_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntentItemType
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar item_id: ID of the item which is getting protected, In case of Azure Vm , it is
     ProtectedItemId.
    :vartype item_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    """

    _validation = {
        "protection_intent_item_type": {"required": True},
    }

    _attribute_map = {
        "protection_intent_item_type": {"key": "protectionIntentItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "item_id": {"key": "itemId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
    }

    _subtype_map = {
        "protection_intent_item_type": {"AzureWorkloadAutoProtectionIntent": "AzureWorkloadAutoProtectionIntent"}
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        source_resource_id: Optional[str] = None,
        item_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword item_id: ID of the item which is getting protected, In case of Azure Vm , it is
         ProtectedItemId.
        :paramtype item_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        """
        super().__init__(
            backup_management_type=backup_management_type,
            source_resource_id=source_resource_id,
            item_id=item_id,
            policy_id=policy_id,
            protection_state=protection_state,
            **kwargs
        )
        self.protection_intent_item_type: str = "RecoveryServiceVaultItem"


class AzureResourceProtectionIntent(ProtectionIntent):
    """IaaS VM specific backup protection intent item.

    All required parameters must be populated in order to send to Azure.

    :ivar protection_intent_item_type: backup protectionIntent type. Required. Known values are:
     "Invalid", "AzureResourceItem", "RecoveryServiceVaultItem",
     "AzureWorkloadContainerAutoProtectionIntent", "AzureWorkloadAutoProtectionIntent", and
     "AzureWorkloadSQLAutoProtectionIntent".
    :vartype protection_intent_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntentItemType
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar item_id: ID of the item which is getting protected, In case of Azure Vm , it is
     ProtectedItemId.
    :vartype item_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar friendly_name: Friendly name of the VM represented by this backup item.
    :vartype friendly_name: str
    """

    _validation = {
        "protection_intent_item_type": {"required": True},
    }

    _attribute_map = {
        "protection_intent_item_type": {"key": "protectionIntentItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "item_id": {"key": "itemId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        source_resource_id: Optional[str] = None,
        item_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        friendly_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword item_id: ID of the item which is getting protected, In case of Azure Vm , it is
         ProtectedItemId.
        :paramtype item_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword friendly_name: Friendly name of the VM represented by this backup item.
        :paramtype friendly_name: str
        """
        super().__init__(
            backup_management_type=backup_management_type,
            source_resource_id=source_resource_id,
            item_id=item_id,
            policy_id=policy_id,
            protection_state=protection_state,
            **kwargs
        )
        self.protection_intent_item_type: str = "AzureResourceItem"
        self.friendly_name = friendly_name


class AzureWorkloadContainer(ProtectionContainer):  # pylint: disable=too-many-instance-attributes
    """Container for the workloads running inside Azure Compute or Classic Compute.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureSQLAGWorkloadContainerProtectionContainer, AzureVMAppContainerProtectionContainer

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar source_resource_id: ARM ID of the virtual machine represented by this Azure Workload
     Container.
    :vartype source_resource_id: str
    :ivar last_updated_time: Time stamp when this container was updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar extended_info: Additional details of a workload container.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadContainerExtendedInfo
    :ivar workload_type: Workload type for which registration was sent. Known values are:
     "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
     "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
     "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    :ivar operation_type: Re-Do Operation. Known values are: "Invalid", "Register", and
     "Reregister".
    :vartype operation_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationType
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "iso-8601"},
        "extended_info": {"key": "extendedInfo", "type": "AzureWorkloadContainerExtendedInfo"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
    }

    _subtype_map = {
        "container_type": {
            "SQLAGWorkLoadContainer": "AzureSQLAGWorkloadContainerProtectionContainer",
            "VMAppContainer": "AzureVMAppContainerProtectionContainer",
        }
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        extended_info: Optional["_models.AzureWorkloadContainerExtendedInfo"] = None,
        workload_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        operation_type: Optional[Union[str, "_models.OperationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword source_resource_id: ARM ID of the virtual machine represented by this Azure Workload
         Container.
        :paramtype source_resource_id: str
        :keyword last_updated_time: Time stamp when this container was updated.
        :paramtype last_updated_time: ~datetime.datetime
        :keyword extended_info: Additional details of a workload container.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadContainerExtendedInfo
        :keyword workload_type: Workload type for which registration was sent. Known values are:
         "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
         "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
         "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        :keyword operation_type: Re-Do Operation. Known values are: "Invalid", "Register", and
         "Reregister".
        :paramtype operation_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationType
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            **kwargs
        )
        self.container_type: str = "AzureWorkloadContainer"
        self.source_resource_id = source_resource_id
        self.last_updated_time = last_updated_time
        self.extended_info = extended_info
        self.workload_type = workload_type
        self.operation_type = operation_type


class AzureSQLAGWorkloadContainerProtectionContainer(
    AzureWorkloadContainer
):  # pylint: disable=too-many-instance-attributes
    """Container for SQL workloads under SQL Availability Group.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar source_resource_id: ARM ID of the virtual machine represented by this Azure Workload
     Container.
    :vartype source_resource_id: str
    :ivar last_updated_time: Time stamp when this container was updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar extended_info: Additional details of a workload container.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadContainerExtendedInfo
    :ivar workload_type: Workload type for which registration was sent. Known values are:
     "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
     "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
     "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    :ivar operation_type: Re-Do Operation. Known values are: "Invalid", "Register", and
     "Reregister".
    :vartype operation_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationType
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "iso-8601"},
        "extended_info": {"key": "extendedInfo", "type": "AzureWorkloadContainerExtendedInfo"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        extended_info: Optional["_models.AzureWorkloadContainerExtendedInfo"] = None,
        workload_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        operation_type: Optional[Union[str, "_models.OperationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword source_resource_id: ARM ID of the virtual machine represented by this Azure Workload
         Container.
        :paramtype source_resource_id: str
        :keyword last_updated_time: Time stamp when this container was updated.
        :paramtype last_updated_time: ~datetime.datetime
        :keyword extended_info: Additional details of a workload container.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadContainerExtendedInfo
        :keyword workload_type: Workload type for which registration was sent. Known values are:
         "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
         "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
         "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        :keyword operation_type: Re-Do Operation. Known values are: "Invalid", "Register", and
         "Reregister".
        :paramtype operation_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationType
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            source_resource_id=source_resource_id,
            last_updated_time=last_updated_time,
            extended_info=extended_info,
            workload_type=workload_type,
            operation_type=operation_type,
            **kwargs
        )
        self.container_type: str = "SQLAGWorkLoadContainer"


class AzureSqlContainer(ProtectionContainer):
    """Azure Sql workload-specific container.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            **kwargs
        )
        self.container_type: str = "AzureSqlContainer"


class AzureSqlProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Azure SQL workload-specific backup item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar protected_item_data_id: Internal ID of a backup item. Used by Azure SQL Backup engine to
     contact Recovery Services.
    :vartype protected_item_data_id: str
    :ivar protection_state: Backup state of the backed up item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemState
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureSqlProtectedItemExtendedInfo
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "protected_item_data_id": {"key": "protectedItemDataId", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureSqlProtectedItemExtendedInfo"},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        protected_item_data_id: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectedItemState"]] = None,
        extended_info: Optional["_models.AzureSqlProtectedItemExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword protected_item_data_id: Internal ID of a backup item. Used by Azure SQL Backup engine
         to contact Recovery Services.
        :paramtype protected_item_data_id: str
        :keyword protection_state: Backup state of the backed up item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemState
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureSqlProtectedItemExtendedInfo
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            **kwargs
        )
        self.protected_item_type: str = "Microsoft.Sql/servers/databases"
        self.protected_item_data_id = protected_item_data_id
        self.protection_state = protection_state
        self.extended_info = extended_info


class AzureSqlProtectedItemExtendedInfo(_serialization.Model):
    """Additional information on Azure Sql specific protected item.

    :ivar oldest_recovery_point: The oldest backup copy available for this item in the service.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: Number of available backup copies associated with this backup item.
    :vartype recovery_point_count: int
    :ivar policy_state: State of the backup policy associated with this backup item.
    :vartype policy_state: str
    """

    _attribute_map = {
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "policy_state": {"key": "policyState", "type": "str"},
    }

    def __init__(
        self,
        *,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        policy_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword oldest_recovery_point: The oldest backup copy available for this item in the service.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: Number of available backup copies associated with this backup
         item.
        :paramtype recovery_point_count: int
        :keyword policy_state: State of the backup policy associated with this backup item.
        :paramtype policy_state: str
        """
        super().__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.policy_state = policy_state


class AzureSqlProtectionPolicy(ProtectionPolicy):
    """Azure SQL workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_items_count: Number of items associated with this policy.
    :vartype protected_items_count: int
    :ivar backup_management_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype backup_management_type: str
    :ivar resource_guard_operation_requests: ResourceGuard Operation Requests.
    :vartype resource_guard_operation_requests: list[str]
    :ivar retention_policy: Retention policy details.
    :vartype retention_policy:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionPolicy
    """

    _validation = {
        "backup_management_type": {"required": True},
    }

    _attribute_map = {
        "protected_items_count": {"key": "protectedItemsCount", "type": "int"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        protected_items_count: Optional[int] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protected_items_count: Number of items associated with this policy.
        :paramtype protected_items_count: int
        :keyword resource_guard_operation_requests: ResourceGuard Operation Requests.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword retention_policy: Retention policy details.
        :paramtype retention_policy:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionPolicy
        """
        super().__init__(
            protected_items_count=protected_items_count,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.backup_management_type: str = "AzureSql"
        self.retention_policy = retention_policy


class AzureStorageContainer(ProtectionContainer):  # pylint: disable=too-many-instance-attributes
    """Azure Storage Account workload-specific container.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar source_resource_id: Fully qualified ARM url.
    :vartype source_resource_id: str
    :ivar storage_account_version: Storage account version.
    :vartype storage_account_version: str
    :ivar resource_group: Resource group name of Recovery Services Vault.
    :vartype resource_group: str
    :ivar protected_item_count: Number of items backed up in this container.
    :vartype protected_item_count: int
    :ivar acquire_storage_account_lock: Whether storage account lock is to be acquired for this
     container or not. Known values are: "Acquire" and "NotAcquire".
    :vartype acquire_storage_account_lock: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AcquireStorageAccountLock
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "storage_account_version": {"key": "storageAccountVersion", "type": "str"},
        "resource_group": {"key": "resourceGroup", "type": "str"},
        "protected_item_count": {"key": "protectedItemCount", "type": "int"},
        "acquire_storage_account_lock": {"key": "acquireStorageAccountLock", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        storage_account_version: Optional[str] = None,
        resource_group: Optional[str] = None,
        protected_item_count: Optional[int] = None,
        acquire_storage_account_lock: Optional[Union[str, "_models.AcquireStorageAccountLock"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword source_resource_id: Fully qualified ARM url.
        :paramtype source_resource_id: str
        :keyword storage_account_version: Storage account version.
        :paramtype storage_account_version: str
        :keyword resource_group: Resource group name of Recovery Services Vault.
        :paramtype resource_group: str
        :keyword protected_item_count: Number of items backed up in this container.
        :paramtype protected_item_count: int
        :keyword acquire_storage_account_lock: Whether storage account lock is to be acquired for this
         container or not. Known values are: "Acquire" and "NotAcquire".
        :paramtype acquire_storage_account_lock: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AcquireStorageAccountLock
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            **kwargs
        )
        self.container_type: str = "StorageContainer"
        self.source_resource_id = source_resource_id
        self.storage_account_version = storage_account_version
        self.resource_group = resource_group
        self.protected_item_count = protected_item_count
        self.acquire_storage_account_lock = acquire_storage_account_lock


class AzureStorageErrorInfo(_serialization.Model):
    """Azure storage specific error information.

    :ivar error_code: Error code.
    :vartype error_code: int
    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations for above error code.
    :vartype recommendations: list[str]
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "int"},
        "error_string": {"key": "errorString", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[int] = None,
        error_string: Optional[str] = None,
        recommendations: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: Error code.
        :paramtype error_code: int
        :keyword error_string: Localized error string.
        :paramtype error_string: str
        :keyword recommendations: List of localized recommendations for above error code.
        :paramtype recommendations: list[str]
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_string = error_string
        self.recommendations = recommendations


class AzureStorageJob(Job):  # pylint: disable=too-many-instance-attributes
    """Azure storage specific job.

    All required parameters must be populated in order to send to Azure.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar duration: Time elapsed during the execution of this job.
    :vartype duration: ~datetime.timedelta
    :ivar actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
    :ivar error_details: Error details on execution of this job.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureStorageErrorInfo]
    :ivar storage_account_name: Specifies friendly name of the storage account.
    :vartype storage_account_name: str
    :ivar storage_account_version: Specifies whether the Storage account is a Classic or an Azure
     Resource Manager Storage account.
    :vartype storage_account_version: str
    :ivar extended_info: Additional information about the job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureStorageJobExtendedInfo
    :ivar is_user_triggered: Indicated that whether the job is adhoc(true) or scheduled(false).
    :vartype is_user_triggered: bool
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "error_details": {"key": "errorDetails", "type": "[AzureStorageErrorInfo]"},
        "storage_account_name": {"key": "storageAccountName", "type": "str"},
        "storage_account_version": {"key": "storageAccountVersion", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureStorageJobExtendedInfo"},
        "is_user_triggered": {"key": "isUserTriggered", "type": "bool"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        error_details: Optional[List["_models.AzureStorageErrorInfo"]] = None,
        storage_account_name: Optional[str] = None,
        storage_account_version: Optional[str] = None,
        extended_info: Optional["_models.AzureStorageJobExtendedInfo"] = None,
        is_user_triggered: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword duration: Time elapsed during the execution of this job.
        :paramtype duration: ~datetime.timedelta
        :keyword actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
        :keyword error_details: Error details on execution of this job.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureStorageErrorInfo]
        :keyword storage_account_name: Specifies friendly name of the storage account.
        :paramtype storage_account_name: str
        :keyword storage_account_version: Specifies whether the Storage account is a Classic or an
         Azure Resource Manager Storage account.
        :paramtype storage_account_version: str
        :keyword extended_info: Additional information about the job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureStorageJobExtendedInfo
        :keyword is_user_triggered: Indicated that whether the job is adhoc(true) or scheduled(false).
        :paramtype is_user_triggered: bool
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "AzureStorageJob"
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.storage_account_name = storage_account_name
        self.storage_account_version = storage_account_version
        self.extended_info = extended_info
        self.is_user_triggered = is_user_triggered


class AzureStorageJobExtendedInfo(_serialization.Model):
    """Azure Storage workload-specific additional information for job.

    :ivar tasks_list: List of tasks for this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureStorageJobTaskDetails]
    :ivar property_bag: Job properties.
    :vartype property_bag: dict[str, str]
    :ivar dynamic_error_message: Non localized error message on job execution.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[AzureStorageJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.AzureStorageJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks for this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureStorageJobTaskDetails]
        :keyword property_bag: Job properties.
        :paramtype property_bag: dict[str, str]
        :keyword dynamic_error_message: Non localized error message on job execution.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class AzureStorageJobTaskDetails(_serialization.Model):
    """Azure storage workload specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar status: The status.
    :vartype status: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, task_id: Optional[str] = None, status: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword status: The status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.status = status


class ProtectableContainer(_serialization.Model):
    """Protectable Container Class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureStorageProtectableContainer, AzureVMAppContainerProtectableContainer

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar protectable_container_type: Type of the container. The value of this property for


     #. Compute Azure VM is Microsoft.Compute/virtualMachines
     #. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines. Required. Known
     values are: "Invalid", "Unknown", "IaasVMContainer", "IaasVMServiceContainer", "DPMContainer",
     "AzureBackupServerContainer", "MABContainer", "Cluster", "AzureSqlContainer", "Windows",
     "VCenter", "VMAppContainer", "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype protectable_container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_id: Fabric Id of the container such as ARM Id.
    :vartype container_id: str
    """

    _validation = {
        "protectable_container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "protectable_container_type": {"key": "protectableContainerType", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_id": {"key": "containerId", "type": "str"},
    }

    _subtype_map = {
        "protectable_container_type": {
            "StorageContainer": "AzureStorageProtectableContainer",
            "VMAppContainer": "AzureVMAppContainerProtectableContainer",
        }
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        health_status: Optional[str] = None,
        container_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword container_id: Fabric Id of the container such as ARM Id.
        :paramtype container_id: str
        """
        super().__init__(**kwargs)
        self.friendly_name = friendly_name
        self.backup_management_type = backup_management_type
        self.protectable_container_type: Optional[str] = None
        self.health_status = health_status
        self.container_id = container_id


class AzureStorageProtectableContainer(ProtectableContainer):
    """Azure Storage-specific protectable containers.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar protectable_container_type: Type of the container. The value of this property for


     #. Compute Azure VM is Microsoft.Compute/virtualMachines
     #. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines. Required. Known
     values are: "Invalid", "Unknown", "IaasVMContainer", "IaasVMServiceContainer", "DPMContainer",
     "AzureBackupServerContainer", "MABContainer", "Cluster", "AzureSqlContainer", "Windows",
     "VCenter", "VMAppContainer", "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype protectable_container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_id: Fabric Id of the container such as ARM Id.
    :vartype container_id: str
    """

    _validation = {
        "protectable_container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "protectable_container_type": {"key": "protectableContainerType", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_id": {"key": "containerId", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        health_status: Optional[str] = None,
        container_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword container_id: Fabric Id of the container such as ARM Id.
        :paramtype container_id: str
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            health_status=health_status,
            container_id=container_id,
            **kwargs
        )
        self.protectable_container_type: str = "StorageContainer"


class AzureVMAppContainerProtectableContainer(ProtectableContainer):
    """Azure workload-specific container.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar protectable_container_type: Type of the container. The value of this property for


     #. Compute Azure VM is Microsoft.Compute/virtualMachines
     #. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines. Required. Known
     values are: "Invalid", "Unknown", "IaasVMContainer", "IaasVMServiceContainer", "DPMContainer",
     "AzureBackupServerContainer", "MABContainer", "Cluster", "AzureSqlContainer", "Windows",
     "VCenter", "VMAppContainer", "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype protectable_container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_id: Fabric Id of the container such as ARM Id.
    :vartype container_id: str
    """

    _validation = {
        "protectable_container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "protectable_container_type": {"key": "protectableContainerType", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_id": {"key": "containerId", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        health_status: Optional[str] = None,
        container_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword container_id: Fabric Id of the container such as ARM Id.
        :paramtype container_id: str
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            health_status=health_status,
            container_id=container_id,
            **kwargs
        )
        self.protectable_container_type: str = "VMAppContainer"


class AzureVMAppContainerProtectionContainer(AzureWorkloadContainer):  # pylint: disable=too-many-instance-attributes
    """Container for SQL workloads under Azure Virtual Machines.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar source_resource_id: ARM ID of the virtual machine represented by this Azure Workload
     Container.
    :vartype source_resource_id: str
    :ivar last_updated_time: Time stamp when this container was updated.
    :vartype last_updated_time: ~datetime.datetime
    :ivar extended_info: Additional details of a workload container.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadContainerExtendedInfo
    :ivar workload_type: Workload type for which registration was sent. Known values are:
     "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
     "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
     "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    :ivar operation_type: Re-Do Operation. Known values are: "Invalid", "Register", and
     "Reregister".
    :vartype operation_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationType
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "last_updated_time": {"key": "lastUpdatedTime", "type": "iso-8601"},
        "extended_info": {"key": "extendedInfo", "type": "AzureWorkloadContainerExtendedInfo"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "operation_type": {"key": "operationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        extended_info: Optional["_models.AzureWorkloadContainerExtendedInfo"] = None,
        workload_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        operation_type: Optional[Union[str, "_models.OperationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword source_resource_id: ARM ID of the virtual machine represented by this Azure Workload
         Container.
        :paramtype source_resource_id: str
        :keyword last_updated_time: Time stamp when this container was updated.
        :paramtype last_updated_time: ~datetime.datetime
        :keyword extended_info: Additional details of a workload container.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadContainerExtendedInfo
        :keyword workload_type: Workload type for which registration was sent. Known values are:
         "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
         "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
         "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        :keyword operation_type: Re-Do Operation. Known values are: "Invalid", "Register", and
         "Reregister".
        :paramtype operation_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationType
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            source_resource_id=source_resource_id,
            last_updated_time=last_updated_time,
            extended_info=extended_info,
            workload_type=workload_type,
            operation_type=operation_type,
            **kwargs
        )
        self.container_type: str = "VMAppContainer"


class AzureVMResourceFeatureSupportRequest(FeatureSupportRequest):
    """AzureResource(IaaS VM) Specific feature support request.

    All required parameters must be populated in order to send to Azure.

    :ivar feature_type: backup support feature type. Required.
    :vartype feature_type: str
    :ivar vm_size: Size of the resource: VM size(A/D series etc) in case of IaasVM.
    :vartype vm_size: str
    :ivar vm_sku: SKUs (Premium/Managed etc) in case of IaasVM.
    :vartype vm_sku: str
    """

    _validation = {
        "feature_type": {"required": True},
    }

    _attribute_map = {
        "feature_type": {"key": "featureType", "type": "str"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "vm_sku": {"key": "vmSku", "type": "str"},
    }

    def __init__(self, *, vm_size: Optional[str] = None, vm_sku: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword vm_size: Size of the resource: VM size(A/D series etc) in case of IaasVM.
        :paramtype vm_size: str
        :keyword vm_sku: SKUs (Premium/Managed etc) in case of IaasVM.
        :paramtype vm_sku: str
        """
        super().__init__(**kwargs)
        self.feature_type: str = "AzureVMResourceBackup"
        self.vm_size = vm_size
        self.vm_sku = vm_sku


class AzureVMResourceFeatureSupportResponse(_serialization.Model):
    """Response for feature support requests for Azure IaasVm.

    :ivar support_status: Support status of feature. Known values are: "Invalid", "Supported",
     "DefaultOFF", "DefaultON", and "NotSupported".
    :vartype support_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.SupportStatus
    """

    _attribute_map = {
        "support_status": {"key": "supportStatus", "type": "str"},
    }

    def __init__(self, *, support_status: Optional[Union[str, "_models.SupportStatus"]] = None, **kwargs: Any) -> None:
        """
        :keyword support_status: Support status of feature. Known values are: "Invalid", "Supported",
         "DefaultOFF", "DefaultON", and "NotSupported".
        :paramtype support_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.SupportStatus
        """
        super().__init__(**kwargs)
        self.support_status = support_status


class WorkloadItem(_serialization.Model):
    """Base class for backup item. Workload-specific backup items are derived from this class.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureVmWorkloadItem

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar workload_item_type: Type of the backup item. Required.
    :vartype workload_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    """

    _validation = {
        "workload_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
    }

    _subtype_map = {"workload_item_type": {"AzureVmWorkloadItem": "AzureVmWorkloadItem"}}

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type
        self.workload_item_type: Optional[str] = None
        self.friendly_name = friendly_name
        self.protection_state = protection_state


class AzureVmWorkloadItem(WorkloadItem):
    """Azure VM workload-specific workload item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureVmWorkloadSAPAseDatabaseWorkloadItem, AzureVmWorkloadSAPAseSystemWorkloadItem,
    AzureVmWorkloadSAPHanaDatabaseWorkloadItem, AzureVmWorkloadSAPHanaSystemWorkloadItem,
    AzureVmWorkloadSQLDatabaseWorkloadItem, AzureVmWorkloadSQLInstanceWorkloadItem

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar workload_item_type: Type of the backup item. Required.
    :vartype workload_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if workload item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
    :vartype sub_workload_item_count: int
    """

    _validation = {
        "workload_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "sub_workload_item_count": {"key": "subWorkloadItemCount", "type": "int"},
    }

    _subtype_map = {
        "workload_item_type": {
            "SAPAseDatabase": "AzureVmWorkloadSAPAseDatabaseWorkloadItem",
            "SAPAseSystem": "AzureVmWorkloadSAPAseSystemWorkloadItem",
            "SAPHanaDatabase": "AzureVmWorkloadSAPHanaDatabaseWorkloadItem",
            "SAPHanaSystem": "AzureVmWorkloadSAPHanaSystemWorkloadItem",
            "SQLDataBase": "AzureVmWorkloadSQLDatabaseWorkloadItem",
            "SQLInstance": "AzureVmWorkloadSQLInstanceWorkloadItem",
        }
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        sub_workload_item_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if workload item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
        :paramtype sub_workload_item_count: int
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            **kwargs
        )
        self.workload_item_type: str = "AzureVmWorkloadItem"
        self.parent_name = parent_name
        self.server_name = server_name
        self.is_auto_protectable = is_auto_protectable
        self.subinquireditemcount = subinquireditemcount
        self.sub_workload_item_count = sub_workload_item_count


class AzureVmWorkloadProtectableItem(WorkloadProtectableItem):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protectable item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureVmWorkloadSAPAseSystemProtectableItem, AzureVmWorkloadSAPHanaDBInstance,
    AzureVmWorkloadSAPHanaDatabaseProtectableItem, AzureVmWorkloadSAPHanaHSR,
    AzureVmWorkloadSAPHanaSystemProtectableItem,
    AzureVmWorkloadSQLAvailabilityGroupProtectableItem, AzureVmWorkloadSQLDatabaseProtectableItem,
    AzureVmWorkloadSQLInstanceProtectableItem

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar parent_unique_name: Parent Unique Name is added to provide the service formatted URI Name
     of the Parent
     Only Applicable for data bases where the parent would be either Instance or a SQL AG.
    :vartype parent_unique_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if protectable item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar is_auto_protected: Indicates if protectable item is auto-protected.
    :vartype is_auto_protected: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
    :vartype subprotectableitemcount: int
    :ivar prebackupvalidation: Pre-backup validation for protectable objects.
    :vartype prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_unique_name": {"key": "parentUniqueName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "is_auto_protected": {"key": "isAutoProtected", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "subprotectableitemcount": {"key": "subprotectableitemcount", "type": "int"},
        "prebackupvalidation": {"key": "prebackupvalidation", "type": "PreBackupValidation"},
    }

    _subtype_map = {
        "protectable_item_type": {
            "SAPAseSystem": "AzureVmWorkloadSAPAseSystemProtectableItem",
            "SAPHanaDBInstance": "AzureVmWorkloadSAPHanaDBInstance",
            "SAPHanaDatabase": "AzureVmWorkloadSAPHanaDatabaseProtectableItem",
            "SAPHanaHSR": "AzureVmWorkloadSAPHanaHSR",
            "SAPHanaSystem": "AzureVmWorkloadSAPHanaSystemProtectableItem",
            "SQLAvailabilityGroupContainer": "AzureVmWorkloadSQLAvailabilityGroupProtectableItem",
            "SQLDataBase": "AzureVmWorkloadSQLDatabaseProtectableItem",
            "SQLInstance": "AzureVmWorkloadSQLInstanceProtectableItem",
        }
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        parent_unique_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        is_auto_protected: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        subprotectableitemcount: Optional[int] = None,
        prebackupvalidation: Optional["_models.PreBackupValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword parent_unique_name: Parent Unique Name is added to provide the service formatted URI
         Name of the Parent
         Only Applicable for data bases where the parent would be either Instance or a SQL AG.
        :paramtype parent_unique_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if protectable item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword is_auto_protected: Indicates if protectable item is auto-protected.
        :paramtype is_auto_protected: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
        :paramtype subprotectableitemcount: int
        :keyword prebackupvalidation: Pre-backup validation for protectable objects.
        :paramtype prebackupvalidation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            **kwargs
        )
        self.protectable_item_type: str = "AzureVmWorkloadProtectableItem"
        self.parent_name = parent_name
        self.parent_unique_name = parent_unique_name
        self.server_name = server_name
        self.is_auto_protectable = is_auto_protectable
        self.is_auto_protected = is_auto_protected
        self.subinquireditemcount = subinquireditemcount
        self.subprotectableitemcount = subprotectableitemcount
        self.prebackupvalidation = prebackupvalidation


class AzureVmWorkloadProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protected item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureVmWorkloadSAPAseDatabaseProtectedItem, AzureVmWorkloadSAPHanaDBInstanceProtectedItem,
    AzureVmWorkloadSAPHanaDatabaseProtectedItem, AzureVmWorkloadSQLDatabaseProtectedItem

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the DB represented by this backup item.
    :vartype friendly_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar parent_name: Parent name of the DB such as Instance or Availability Group.
    :vartype parent_name: str
    :ivar parent_type: Parent type of protected item, example: for a DB, standalone server or
     distributed.
    :vartype parent_type: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
     Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
    :vartype last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar last_backup_error_detail: Error details in last backup.
    :vartype last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
    :ivar protected_item_data_source_id: Data ID of the protected item.
    :vartype protected_item_data_source_id: str
    :ivar protected_item_health_status: Health status of the backup item, evaluated based on last
     heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable", and
     "IRPending".
    :vartype protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "protection_status": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_type": {"key": "parentType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "last_backup_error_detail": {"key": "lastBackupErrorDetail", "type": "ErrorDetail"},
        "protected_item_data_source_id": {"key": "protectedItemDataSourceId", "type": "str"},
        "protected_item_health_status": {"key": "protectedItemHealthStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureVmWorkloadProtectedItemExtendedInfo"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
    }

    _subtype_map = {
        "protected_item_type": {
            "AzureVmWorkloadSAPAseDatabase": "AzureVmWorkloadSAPAseDatabaseProtectedItem",
            "AzureVmWorkloadSAPHanaDBInstance": "AzureVmWorkloadSAPHanaDBInstanceProtectedItem",
            "AzureVmWorkloadSAPHanaDatabase": "AzureVmWorkloadSAPHanaDatabaseProtectedItem",
            "AzureVmWorkloadSQLDatabase": "AzureVmWorkloadSQLDatabaseProtectedItem",
        }
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        server_name: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_type: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[Union[str, "_models.LastBackupStatus"]] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        last_backup_error_detail: Optional["_models.ErrorDetail"] = None,
        protected_item_data_source_id: Optional[str] = None,
        protected_item_health_status: Optional[Union[str, "_models.ProtectedItemHealthStatus"]] = None,
        extended_info: Optional["_models.AzureVmWorkloadProtectedItemExtendedInfo"] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword parent_name: Parent name of the DB such as Instance or Availability Group.
        :paramtype parent_name: str
        :keyword parent_type: Parent type of protected item, example: for a DB, standalone server or
         distributed.
        :paramtype parent_type: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
         Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
        :paramtype last_backup_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword last_backup_error_detail: Error details in last backup.
        :paramtype last_backup_error_detail:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
        :keyword protected_item_data_source_id: Data ID of the protected item.
        :paramtype protected_item_data_source_id: str
        :keyword protected_item_health_status: Health status of the backup item, evaluated based on
         last heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable",
         and "IRPending".
        :paramtype protected_item_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            **kwargs
        )
        self.protected_item_type: str = "AzureVmWorkloadProtectedItem"
        self.friendly_name = None
        self.server_name = server_name
        self.parent_name = parent_name
        self.parent_type = parent_type
        self.protection_status = None
        self.protection_state = protection_state
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.last_backup_error_detail = last_backup_error_detail
        self.protected_item_data_source_id = protected_item_data_source_id
        self.protected_item_health_status = protected_item_health_status
        self.extended_info = extended_info
        self.kpis_healths = kpis_healths


class AzureVmWorkloadProtectedItemExtendedInfo(_serialization.Model):
    """Additional information on Azure Workload for SQL specific backup item.

    :ivar oldest_recovery_point: The oldest backup copy available for this backup item across all
     tiers.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar oldest_recovery_point_in_vault: The oldest backup copy available for this backup item in
     vault tier.
    :vartype oldest_recovery_point_in_vault: ~datetime.datetime
    :ivar oldest_recovery_point_in_archive: The oldest backup copy available for this backup item
     in archive tier.
    :vartype oldest_recovery_point_in_archive: ~datetime.datetime
    :ivar newest_recovery_point_in_archive: The latest backup copy available for this backup item
     in archive tier.
    :vartype newest_recovery_point_in_archive: ~datetime.datetime
    :ivar recovery_point_count: Number of backup copies available for this backup item.
    :vartype recovery_point_count: int
    :ivar policy_state: Indicates consistency of policy object and policy applied to this backup
     item.
    :vartype policy_state: str
    :ivar recovery_model: Indicates consistency of policy object and policy applied to this backup
     item.
    :vartype recovery_model: str
    """

    _attribute_map = {
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "oldest_recovery_point_in_vault": {"key": "oldestRecoveryPointInVault", "type": "iso-8601"},
        "oldest_recovery_point_in_archive": {"key": "oldestRecoveryPointInArchive", "type": "iso-8601"},
        "newest_recovery_point_in_archive": {"key": "newestRecoveryPointInArchive", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "policy_state": {"key": "policyState", "type": "str"},
        "recovery_model": {"key": "recoveryModel", "type": "str"},
    }

    def __init__(
        self,
        *,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        oldest_recovery_point_in_vault: Optional[datetime.datetime] = None,
        oldest_recovery_point_in_archive: Optional[datetime.datetime] = None,
        newest_recovery_point_in_archive: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        policy_state: Optional[str] = None,
        recovery_model: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword oldest_recovery_point: The oldest backup copy available for this backup item across
         all tiers.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword oldest_recovery_point_in_vault: The oldest backup copy available for this backup item
         in vault tier.
        :paramtype oldest_recovery_point_in_vault: ~datetime.datetime
        :keyword oldest_recovery_point_in_archive: The oldest backup copy available for this backup
         item in archive tier.
        :paramtype oldest_recovery_point_in_archive: ~datetime.datetime
        :keyword newest_recovery_point_in_archive: The latest backup copy available for this backup
         item in archive tier.
        :paramtype newest_recovery_point_in_archive: ~datetime.datetime
        :keyword recovery_point_count: Number of backup copies available for this backup item.
        :paramtype recovery_point_count: int
        :keyword policy_state: Indicates consistency of policy object and policy applied to this backup
         item.
        :paramtype policy_state: str
        :keyword recovery_model: Indicates consistency of policy object and policy applied to this
         backup item.
        :paramtype recovery_model: str
        """
        super().__init__(**kwargs)
        self.oldest_recovery_point = oldest_recovery_point
        self.oldest_recovery_point_in_vault = oldest_recovery_point_in_vault
        self.oldest_recovery_point_in_archive = oldest_recovery_point_in_archive
        self.newest_recovery_point_in_archive = newest_recovery_point_in_archive
        self.recovery_point_count = recovery_point_count
        self.policy_state = policy_state
        self.recovery_model = recovery_model


class AzureVmWorkloadProtectionPolicy(ProtectionPolicy):
    """Azure VM (Mercury) workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_items_count: Number of items associated with this policy.
    :vartype protected_items_count: int
    :ivar backup_management_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype backup_management_type: str
    :ivar resource_guard_operation_requests: ResourceGuard Operation Requests.
    :vartype resource_guard_operation_requests: list[str]
    :ivar work_load_type: Type of workload for the backup management. Known values are: "Invalid",
     "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype work_load_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    :ivar settings: Common settings for the backup management.
    :vartype settings: ~azure.mgmt.recoveryservicesbackup.activestamp.models.Settings
    :ivar sub_protection_policy: List of sub-protection policies which includes schedule and
     retention.
    :vartype sub_protection_policy:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SubProtectionPolicy]
    :ivar make_policy_consistent: Fix the policy inconsistency.
    :vartype make_policy_consistent: bool
    """

    _validation = {
        "backup_management_type": {"required": True},
    }

    _attribute_map = {
        "protected_items_count": {"key": "protectedItemsCount", "type": "int"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "work_load_type": {"key": "workLoadType", "type": "str"},
        "settings": {"key": "settings", "type": "Settings"},
        "sub_protection_policy": {"key": "subProtectionPolicy", "type": "[SubProtectionPolicy]"},
        "make_policy_consistent": {"key": "makePolicyConsistent", "type": "bool"},
    }

    def __init__(
        self,
        *,
        protected_items_count: Optional[int] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        work_load_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        settings: Optional["_models.Settings"] = None,
        sub_protection_policy: Optional[List["_models.SubProtectionPolicy"]] = None,
        make_policy_consistent: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protected_items_count: Number of items associated with this policy.
        :paramtype protected_items_count: int
        :keyword resource_guard_operation_requests: ResourceGuard Operation Requests.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword work_load_type: Type of workload for the backup management. Known values are:
         "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
         "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
         "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype work_load_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        :keyword settings: Common settings for the backup management.
        :paramtype settings: ~azure.mgmt.recoveryservicesbackup.activestamp.models.Settings
        :keyword sub_protection_policy: List of sub-protection policies which includes schedule and
         retention.
        :paramtype sub_protection_policy:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SubProtectionPolicy]
        :keyword make_policy_consistent: Fix the policy inconsistency.
        :paramtype make_policy_consistent: bool
        """
        super().__init__(
            protected_items_count=protected_items_count,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.backup_management_type: str = "AzureWorkload"
        self.work_load_type = work_load_type
        self.settings = settings
        self.sub_protection_policy = sub_protection_policy
        self.make_policy_consistent = make_policy_consistent


class AzureVmWorkloadSAPAseDatabaseProtectedItem(
    AzureVmWorkloadProtectedItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protected item representing SAP ASE Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the DB represented by this backup item.
    :vartype friendly_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar parent_name: Parent name of the DB such as Instance or Availability Group.
    :vartype parent_name: str
    :ivar parent_type: Parent type of protected item, example: for a DB, standalone server or
     distributed.
    :vartype parent_type: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
     Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
    :vartype last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar last_backup_error_detail: Error details in last backup.
    :vartype last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
    :ivar protected_item_data_source_id: Data ID of the protected item.
    :vartype protected_item_data_source_id: str
    :ivar protected_item_health_status: Health status of the backup item, evaluated based on last
     heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable", and
     "IRPending".
    :vartype protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "protection_status": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_type": {"key": "parentType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "last_backup_error_detail": {"key": "lastBackupErrorDetail", "type": "ErrorDetail"},
        "protected_item_data_source_id": {"key": "protectedItemDataSourceId", "type": "str"},
        "protected_item_health_status": {"key": "protectedItemHealthStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureVmWorkloadProtectedItemExtendedInfo"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        server_name: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_type: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[Union[str, "_models.LastBackupStatus"]] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        last_backup_error_detail: Optional["_models.ErrorDetail"] = None,
        protected_item_data_source_id: Optional[str] = None,
        protected_item_health_status: Optional[Union[str, "_models.ProtectedItemHealthStatus"]] = None,
        extended_info: Optional["_models.AzureVmWorkloadProtectedItemExtendedInfo"] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword parent_name: Parent name of the DB such as Instance or Availability Group.
        :paramtype parent_name: str
        :keyword parent_type: Parent type of protected item, example: for a DB, standalone server or
         distributed.
        :paramtype parent_type: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
         Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
        :paramtype last_backup_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword last_backup_error_detail: Error details in last backup.
        :paramtype last_backup_error_detail:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
        :keyword protected_item_data_source_id: Data ID of the protected item.
        :paramtype protected_item_data_source_id: str
        :keyword protected_item_health_status: Health status of the backup item, evaluated based on
         last heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable",
         and "IRPending".
        :paramtype protected_item_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            server_name=server_name,
            parent_name=parent_name,
            parent_type=parent_type,
            protection_state=protection_state,
            last_backup_status=last_backup_status,
            last_backup_time=last_backup_time,
            last_backup_error_detail=last_backup_error_detail,
            protected_item_data_source_id=protected_item_data_source_id,
            protected_item_health_status=protected_item_health_status,
            extended_info=extended_info,
            kpis_healths=kpis_healths,
            **kwargs
        )
        self.protected_item_type: str = "AzureVmWorkloadSAPAseDatabase"


class AzureVmWorkloadSAPAseDatabaseWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP ASE Database.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar workload_item_type: Type of the backup item. Required.
    :vartype workload_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if workload item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
    :vartype sub_workload_item_count: int
    """

    _validation = {
        "workload_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "sub_workload_item_count": {"key": "subWorkloadItemCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        sub_workload_item_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if workload item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
        :paramtype sub_workload_item_count: int
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            subinquireditemcount=subinquireditemcount,
            sub_workload_item_count=sub_workload_item_count,
            **kwargs
        )
        self.workload_item_type: str = "SAPAseDatabase"


class AzureVmWorkloadSAPAseSystemProtectableItem(
    AzureVmWorkloadProtectableItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protectable item representing SAP ASE System.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar parent_unique_name: Parent Unique Name is added to provide the service formatted URI Name
     of the Parent
     Only Applicable for data bases where the parent would be either Instance or a SQL AG.
    :vartype parent_unique_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if protectable item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar is_auto_protected: Indicates if protectable item is auto-protected.
    :vartype is_auto_protected: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
    :vartype subprotectableitemcount: int
    :ivar prebackupvalidation: Pre-backup validation for protectable objects.
    :vartype prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_unique_name": {"key": "parentUniqueName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "is_auto_protected": {"key": "isAutoProtected", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "subprotectableitemcount": {"key": "subprotectableitemcount", "type": "int"},
        "prebackupvalidation": {"key": "prebackupvalidation", "type": "PreBackupValidation"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        parent_unique_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        is_auto_protected: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        subprotectableitemcount: Optional[int] = None,
        prebackupvalidation: Optional["_models.PreBackupValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword parent_unique_name: Parent Unique Name is added to provide the service formatted URI
         Name of the Parent
         Only Applicable for data bases where the parent would be either Instance or a SQL AG.
        :paramtype parent_unique_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if protectable item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword is_auto_protected: Indicates if protectable item is auto-protected.
        :paramtype is_auto_protected: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
        :paramtype subprotectableitemcount: int
        :keyword prebackupvalidation: Pre-backup validation for protectable objects.
        :paramtype prebackupvalidation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            parent_unique_name=parent_unique_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            is_auto_protected=is_auto_protected,
            subinquireditemcount=subinquireditemcount,
            subprotectableitemcount=subprotectableitemcount,
            prebackupvalidation=prebackupvalidation,
            **kwargs
        )
        self.protectable_item_type: str = "SAPAseSystem"


class AzureVmWorkloadSAPAseSystemWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP ASE System.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar workload_item_type: Type of the backup item. Required.
    :vartype workload_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if workload item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
    :vartype sub_workload_item_count: int
    """

    _validation = {
        "workload_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "sub_workload_item_count": {"key": "subWorkloadItemCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        sub_workload_item_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if workload item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
        :paramtype sub_workload_item_count: int
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            subinquireditemcount=subinquireditemcount,
            sub_workload_item_count=sub_workload_item_count,
            **kwargs
        )
        self.workload_item_type: str = "SAPAseSystem"


class AzureVmWorkloadSAPHanaDatabaseProtectableItem(
    AzureVmWorkloadProtectableItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protectable item representing SAP HANA Database.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar parent_unique_name: Parent Unique Name is added to provide the service formatted URI Name
     of the Parent
     Only Applicable for data bases where the parent would be either Instance or a SQL AG.
    :vartype parent_unique_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if protectable item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar is_auto_protected: Indicates if protectable item is auto-protected.
    :vartype is_auto_protected: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
    :vartype subprotectableitemcount: int
    :ivar prebackupvalidation: Pre-backup validation for protectable objects.
    :vartype prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_unique_name": {"key": "parentUniqueName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "is_auto_protected": {"key": "isAutoProtected", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "subprotectableitemcount": {"key": "subprotectableitemcount", "type": "int"},
        "prebackupvalidation": {"key": "prebackupvalidation", "type": "PreBackupValidation"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        parent_unique_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        is_auto_protected: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        subprotectableitemcount: Optional[int] = None,
        prebackupvalidation: Optional["_models.PreBackupValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword parent_unique_name: Parent Unique Name is added to provide the service formatted URI
         Name of the Parent
         Only Applicable for data bases where the parent would be either Instance or a SQL AG.
        :paramtype parent_unique_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if protectable item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword is_auto_protected: Indicates if protectable item is auto-protected.
        :paramtype is_auto_protected: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
        :paramtype subprotectableitemcount: int
        :keyword prebackupvalidation: Pre-backup validation for protectable objects.
        :paramtype prebackupvalidation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            parent_unique_name=parent_unique_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            is_auto_protected=is_auto_protected,
            subinquireditemcount=subinquireditemcount,
            subprotectableitemcount=subprotectableitemcount,
            prebackupvalidation=prebackupvalidation,
            **kwargs
        )
        self.protectable_item_type: str = "SAPHanaDatabase"


class AzureVmWorkloadSAPHanaDatabaseProtectedItem(
    AzureVmWorkloadProtectedItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protected item representing SAP HANA Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the DB represented by this backup item.
    :vartype friendly_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar parent_name: Parent name of the DB such as Instance or Availability Group.
    :vartype parent_name: str
    :ivar parent_type: Parent type of protected item, example: for a DB, standalone server or
     distributed.
    :vartype parent_type: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
     Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
    :vartype last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar last_backup_error_detail: Error details in last backup.
    :vartype last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
    :ivar protected_item_data_source_id: Data ID of the protected item.
    :vartype protected_item_data_source_id: str
    :ivar protected_item_health_status: Health status of the backup item, evaluated based on last
     heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable", and
     "IRPending".
    :vartype protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "protection_status": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_type": {"key": "parentType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "last_backup_error_detail": {"key": "lastBackupErrorDetail", "type": "ErrorDetail"},
        "protected_item_data_source_id": {"key": "protectedItemDataSourceId", "type": "str"},
        "protected_item_health_status": {"key": "protectedItemHealthStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureVmWorkloadProtectedItemExtendedInfo"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        server_name: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_type: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[Union[str, "_models.LastBackupStatus"]] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        last_backup_error_detail: Optional["_models.ErrorDetail"] = None,
        protected_item_data_source_id: Optional[str] = None,
        protected_item_health_status: Optional[Union[str, "_models.ProtectedItemHealthStatus"]] = None,
        extended_info: Optional["_models.AzureVmWorkloadProtectedItemExtendedInfo"] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword parent_name: Parent name of the DB such as Instance or Availability Group.
        :paramtype parent_name: str
        :keyword parent_type: Parent type of protected item, example: for a DB, standalone server or
         distributed.
        :paramtype parent_type: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
         Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
        :paramtype last_backup_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword last_backup_error_detail: Error details in last backup.
        :paramtype last_backup_error_detail:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
        :keyword protected_item_data_source_id: Data ID of the protected item.
        :paramtype protected_item_data_source_id: str
        :keyword protected_item_health_status: Health status of the backup item, evaluated based on
         last heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable",
         and "IRPending".
        :paramtype protected_item_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            server_name=server_name,
            parent_name=parent_name,
            parent_type=parent_type,
            protection_state=protection_state,
            last_backup_status=last_backup_status,
            last_backup_time=last_backup_time,
            last_backup_error_detail=last_backup_error_detail,
            protected_item_data_source_id=protected_item_data_source_id,
            protected_item_health_status=protected_item_health_status,
            extended_info=extended_info,
            kpis_healths=kpis_healths,
            **kwargs
        )
        self.protected_item_type: str = "AzureVmWorkloadSAPHanaDatabase"


class AzureVmWorkloadSAPHanaDatabaseWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP HANA Database.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar workload_item_type: Type of the backup item. Required.
    :vartype workload_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if workload item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
    :vartype sub_workload_item_count: int
    """

    _validation = {
        "workload_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "sub_workload_item_count": {"key": "subWorkloadItemCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        sub_workload_item_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if workload item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
        :paramtype sub_workload_item_count: int
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            subinquireditemcount=subinquireditemcount,
            sub_workload_item_count=sub_workload_item_count,
            **kwargs
        )
        self.workload_item_type: str = "SAPHanaDatabase"


class AzureVmWorkloadSAPHanaDBInstance(AzureVmWorkloadProtectableItem):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protectable item representing SAP HANA Dbinstance.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar parent_unique_name: Parent Unique Name is added to provide the service formatted URI Name
     of the Parent
     Only Applicable for data bases where the parent would be either Instance or a SQL AG.
    :vartype parent_unique_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if protectable item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar is_auto_protected: Indicates if protectable item is auto-protected.
    :vartype is_auto_protected: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
    :vartype subprotectableitemcount: int
    :ivar prebackupvalidation: Pre-backup validation for protectable objects.
    :vartype prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_unique_name": {"key": "parentUniqueName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "is_auto_protected": {"key": "isAutoProtected", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "subprotectableitemcount": {"key": "subprotectableitemcount", "type": "int"},
        "prebackupvalidation": {"key": "prebackupvalidation", "type": "PreBackupValidation"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        parent_unique_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        is_auto_protected: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        subprotectableitemcount: Optional[int] = None,
        prebackupvalidation: Optional["_models.PreBackupValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword parent_unique_name: Parent Unique Name is added to provide the service formatted URI
         Name of the Parent
         Only Applicable for data bases where the parent would be either Instance or a SQL AG.
        :paramtype parent_unique_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if protectable item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword is_auto_protected: Indicates if protectable item is auto-protected.
        :paramtype is_auto_protected: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
        :paramtype subprotectableitemcount: int
        :keyword prebackupvalidation: Pre-backup validation for protectable objects.
        :paramtype prebackupvalidation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            parent_unique_name=parent_unique_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            is_auto_protected=is_auto_protected,
            subinquireditemcount=subinquireditemcount,
            subprotectableitemcount=subprotectableitemcount,
            prebackupvalidation=prebackupvalidation,
            **kwargs
        )
        self.protectable_item_type: str = "SAPHanaDBInstance"


class AzureVmWorkloadSAPHanaDBInstanceProtectedItem(
    AzureVmWorkloadProtectedItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protected item representing SAP HANA DBInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the DB represented by this backup item.
    :vartype friendly_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar parent_name: Parent name of the DB such as Instance or Availability Group.
    :vartype parent_name: str
    :ivar parent_type: Parent type of protected item, example: for a DB, standalone server or
     distributed.
    :vartype parent_type: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
     Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
    :vartype last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar last_backup_error_detail: Error details in last backup.
    :vartype last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
    :ivar protected_item_data_source_id: Data ID of the protected item.
    :vartype protected_item_data_source_id: str
    :ivar protected_item_health_status: Health status of the backup item, evaluated based on last
     heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable", and
     "IRPending".
    :vartype protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "protection_status": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_type": {"key": "parentType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "last_backup_error_detail": {"key": "lastBackupErrorDetail", "type": "ErrorDetail"},
        "protected_item_data_source_id": {"key": "protectedItemDataSourceId", "type": "str"},
        "protected_item_health_status": {"key": "protectedItemHealthStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureVmWorkloadProtectedItemExtendedInfo"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        server_name: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_type: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[Union[str, "_models.LastBackupStatus"]] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        last_backup_error_detail: Optional["_models.ErrorDetail"] = None,
        protected_item_data_source_id: Optional[str] = None,
        protected_item_health_status: Optional[Union[str, "_models.ProtectedItemHealthStatus"]] = None,
        extended_info: Optional["_models.AzureVmWorkloadProtectedItemExtendedInfo"] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword parent_name: Parent name of the DB such as Instance or Availability Group.
        :paramtype parent_name: str
        :keyword parent_type: Parent type of protected item, example: for a DB, standalone server or
         distributed.
        :paramtype parent_type: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
         Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
        :paramtype last_backup_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword last_backup_error_detail: Error details in last backup.
        :paramtype last_backup_error_detail:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
        :keyword protected_item_data_source_id: Data ID of the protected item.
        :paramtype protected_item_data_source_id: str
        :keyword protected_item_health_status: Health status of the backup item, evaluated based on
         last heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable",
         and "IRPending".
        :paramtype protected_item_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            server_name=server_name,
            parent_name=parent_name,
            parent_type=parent_type,
            protection_state=protection_state,
            last_backup_status=last_backup_status,
            last_backup_time=last_backup_time,
            last_backup_error_detail=last_backup_error_detail,
            protected_item_data_source_id=protected_item_data_source_id,
            protected_item_health_status=protected_item_health_status,
            extended_info=extended_info,
            kpis_healths=kpis_healths,
            **kwargs
        )
        self.protected_item_type: str = "AzureVmWorkloadSAPHanaDBInstance"


class AzureVmWorkloadSAPHanaHSR(AzureVmWorkloadProtectableItem):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protectable item representing SAP HANA Dbinstance.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar parent_unique_name: Parent Unique Name is added to provide the service formatted URI Name
     of the Parent
     Only Applicable for data bases where the parent would be either Instance or a SQL AG.
    :vartype parent_unique_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if protectable item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar is_auto_protected: Indicates if protectable item is auto-protected.
    :vartype is_auto_protected: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
    :vartype subprotectableitemcount: int
    :ivar prebackupvalidation: Pre-backup validation for protectable objects.
    :vartype prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_unique_name": {"key": "parentUniqueName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "is_auto_protected": {"key": "isAutoProtected", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "subprotectableitemcount": {"key": "subprotectableitemcount", "type": "int"},
        "prebackupvalidation": {"key": "prebackupvalidation", "type": "PreBackupValidation"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        parent_unique_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        is_auto_protected: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        subprotectableitemcount: Optional[int] = None,
        prebackupvalidation: Optional["_models.PreBackupValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword parent_unique_name: Parent Unique Name is added to provide the service formatted URI
         Name of the Parent
         Only Applicable for data bases where the parent would be either Instance or a SQL AG.
        :paramtype parent_unique_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if protectable item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword is_auto_protected: Indicates if protectable item is auto-protected.
        :paramtype is_auto_protected: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
        :paramtype subprotectableitemcount: int
        :keyword prebackupvalidation: Pre-backup validation for protectable objects.
        :paramtype prebackupvalidation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            parent_unique_name=parent_unique_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            is_auto_protected=is_auto_protected,
            subinquireditemcount=subinquireditemcount,
            subprotectableitemcount=subprotectableitemcount,
            prebackupvalidation=prebackupvalidation,
            **kwargs
        )
        self.protectable_item_type: str = "SAPHanaHSR"


class AzureVmWorkloadSAPHanaSystemProtectableItem(
    AzureVmWorkloadProtectableItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protectable item representing SAP HANA System.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar parent_unique_name: Parent Unique Name is added to provide the service formatted URI Name
     of the Parent
     Only Applicable for data bases where the parent would be either Instance or a SQL AG.
    :vartype parent_unique_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if protectable item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar is_auto_protected: Indicates if protectable item is auto-protected.
    :vartype is_auto_protected: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
    :vartype subprotectableitemcount: int
    :ivar prebackupvalidation: Pre-backup validation for protectable objects.
    :vartype prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_unique_name": {"key": "parentUniqueName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "is_auto_protected": {"key": "isAutoProtected", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "subprotectableitemcount": {"key": "subprotectableitemcount", "type": "int"},
        "prebackupvalidation": {"key": "prebackupvalidation", "type": "PreBackupValidation"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        parent_unique_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        is_auto_protected: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        subprotectableitemcount: Optional[int] = None,
        prebackupvalidation: Optional["_models.PreBackupValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword parent_unique_name: Parent Unique Name is added to provide the service formatted URI
         Name of the Parent
         Only Applicable for data bases where the parent would be either Instance or a SQL AG.
        :paramtype parent_unique_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if protectable item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword is_auto_protected: Indicates if protectable item is auto-protected.
        :paramtype is_auto_protected: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
        :paramtype subprotectableitemcount: int
        :keyword prebackupvalidation: Pre-backup validation for protectable objects.
        :paramtype prebackupvalidation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            parent_unique_name=parent_unique_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            is_auto_protected=is_auto_protected,
            subinquireditemcount=subinquireditemcount,
            subprotectableitemcount=subprotectableitemcount,
            prebackupvalidation=prebackupvalidation,
            **kwargs
        )
        self.protectable_item_type: str = "SAPHanaSystem"


class AzureVmWorkloadSAPHanaSystemWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SAP HANA System.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar workload_item_type: Type of the backup item. Required.
    :vartype workload_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if workload item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
    :vartype sub_workload_item_count: int
    """

    _validation = {
        "workload_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "sub_workload_item_count": {"key": "subWorkloadItemCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        sub_workload_item_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if workload item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
        :paramtype sub_workload_item_count: int
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            subinquireditemcount=subinquireditemcount,
            sub_workload_item_count=sub_workload_item_count,
            **kwargs
        )
        self.workload_item_type: str = "SAPHanaSystem"


class AzureVmWorkloadSQLAvailabilityGroupProtectableItem(
    AzureVmWorkloadProtectableItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protectable item representing SQL Availability Group.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar parent_unique_name: Parent Unique Name is added to provide the service formatted URI Name
     of the Parent
     Only Applicable for data bases where the parent would be either Instance or a SQL AG.
    :vartype parent_unique_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if protectable item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar is_auto_protected: Indicates if protectable item is auto-protected.
    :vartype is_auto_protected: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
    :vartype subprotectableitemcount: int
    :ivar prebackupvalidation: Pre-backup validation for protectable objects.
    :vartype prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_unique_name": {"key": "parentUniqueName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "is_auto_protected": {"key": "isAutoProtected", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "subprotectableitemcount": {"key": "subprotectableitemcount", "type": "int"},
        "prebackupvalidation": {"key": "prebackupvalidation", "type": "PreBackupValidation"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        parent_unique_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        is_auto_protected: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        subprotectableitemcount: Optional[int] = None,
        prebackupvalidation: Optional["_models.PreBackupValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword parent_unique_name: Parent Unique Name is added to provide the service formatted URI
         Name of the Parent
         Only Applicable for data bases where the parent would be either Instance or a SQL AG.
        :paramtype parent_unique_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if protectable item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword is_auto_protected: Indicates if protectable item is auto-protected.
        :paramtype is_auto_protected: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
        :paramtype subprotectableitemcount: int
        :keyword prebackupvalidation: Pre-backup validation for protectable objects.
        :paramtype prebackupvalidation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            parent_unique_name=parent_unique_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            is_auto_protected=is_auto_protected,
            subinquireditemcount=subinquireditemcount,
            subprotectableitemcount=subprotectableitemcount,
            prebackupvalidation=prebackupvalidation,
            **kwargs
        )
        self.protectable_item_type: str = "SQLAvailabilityGroupContainer"


class AzureVmWorkloadSQLDatabaseProtectableItem(
    AzureVmWorkloadProtectableItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protectable item representing SQL Database.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar parent_unique_name: Parent Unique Name is added to provide the service formatted URI Name
     of the Parent
     Only Applicable for data bases where the parent would be either Instance or a SQL AG.
    :vartype parent_unique_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if protectable item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar is_auto_protected: Indicates if protectable item is auto-protected.
    :vartype is_auto_protected: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
    :vartype subprotectableitemcount: int
    :ivar prebackupvalidation: Pre-backup validation for protectable objects.
    :vartype prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_unique_name": {"key": "parentUniqueName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "is_auto_protected": {"key": "isAutoProtected", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "subprotectableitemcount": {"key": "subprotectableitemcount", "type": "int"},
        "prebackupvalidation": {"key": "prebackupvalidation", "type": "PreBackupValidation"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        parent_unique_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        is_auto_protected: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        subprotectableitemcount: Optional[int] = None,
        prebackupvalidation: Optional["_models.PreBackupValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword parent_unique_name: Parent Unique Name is added to provide the service formatted URI
         Name of the Parent
         Only Applicable for data bases where the parent would be either Instance or a SQL AG.
        :paramtype parent_unique_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if protectable item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword is_auto_protected: Indicates if protectable item is auto-protected.
        :paramtype is_auto_protected: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
        :paramtype subprotectableitemcount: int
        :keyword prebackupvalidation: Pre-backup validation for protectable objects.
        :paramtype prebackupvalidation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            parent_unique_name=parent_unique_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            is_auto_protected=is_auto_protected,
            subinquireditemcount=subinquireditemcount,
            subprotectableitemcount=subprotectableitemcount,
            prebackupvalidation=prebackupvalidation,
            **kwargs
        )
        self.protectable_item_type: str = "SQLDataBase"


class AzureVmWorkloadSQLDatabaseProtectedItem(
    AzureVmWorkloadProtectedItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protected item representing SQL Database.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the DB represented by this backup item.
    :vartype friendly_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar parent_name: Parent name of the DB such as Instance or Availability Group.
    :vartype parent_name: str
    :ivar parent_type: Parent type of protected item, example: for a DB, standalone server or
     distributed.
    :vartype parent_type: str
    :ivar protection_status: Backup status of this backup item.
    :vartype protection_status: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
     Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
    :vartype last_backup_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar last_backup_error_detail: Error details in last backup.
    :vartype last_backup_error_detail:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
    :ivar protected_item_data_source_id: Data ID of the protected item.
    :vartype protected_item_data_source_id: str
    :ivar protected_item_health_status: Health status of the backup item, evaluated based on last
     heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable", and
     "IRPending".
    :vartype protected_item_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
    :ivar extended_info: Additional information for this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
    :ivar kpis_healths: Health details of different KPIs.
    :vartype kpis_healths: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
        "friendly_name": {"readonly": True},
        "protection_status": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_type": {"key": "parentType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "last_backup_error_detail": {"key": "lastBackupErrorDetail", "type": "ErrorDetail"},
        "protected_item_data_source_id": {"key": "protectedItemDataSourceId", "type": "str"},
        "protected_item_health_status": {"key": "protectedItemHealthStatus", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "AzureVmWorkloadProtectedItemExtendedInfo"},
        "kpis_healths": {"key": "kpisHealths", "type": "{KPIResourceHealthDetails}"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        server_name: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_type: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        last_backup_status: Optional[Union[str, "_models.LastBackupStatus"]] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        last_backup_error_detail: Optional["_models.ErrorDetail"] = None,
        protected_item_data_source_id: Optional[str] = None,
        protected_item_health_status: Optional[Union[str, "_models.ProtectedItemHealthStatus"]] = None,
        extended_info: Optional["_models.AzureVmWorkloadProtectedItemExtendedInfo"] = None,
        kpis_healths: Optional[Dict[str, "_models.KPIResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword parent_name: Parent name of the DB such as Instance or Availability Group.
        :paramtype parent_name: str
        :keyword parent_type: Parent type of protected item, example: for a DB, standalone server or
         distributed.
        :paramtype parent_type: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword last_backup_status: Last backup operation status. Possible values: Healthy, Unhealthy.
         Known values are: "Invalid", "Healthy", "Unhealthy", and "IRPending".
        :paramtype last_backup_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastBackupStatus
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword last_backup_error_detail: Error details in last backup.
        :paramtype last_backup_error_detail:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
        :keyword protected_item_data_source_id: Data ID of the protected item.
        :paramtype protected_item_data_source_id: str
        :keyword protected_item_health_status: Health status of the backup item, evaluated based on
         last heartbeat received. Known values are: "Invalid", "Healthy", "Unhealthy", "NotReachable",
         and "IRPending".
        :paramtype protected_item_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemHealthStatus
        :keyword extended_info: Additional information for this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureVmWorkloadProtectedItemExtendedInfo
        :keyword kpis_healths: Health details of different KPIs.
        :paramtype kpis_healths: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KPIResourceHealthDetails]
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            server_name=server_name,
            parent_name=parent_name,
            parent_type=parent_type,
            protection_state=protection_state,
            last_backup_status=last_backup_status,
            last_backup_time=last_backup_time,
            last_backup_error_detail=last_backup_error_detail,
            protected_item_data_source_id=protected_item_data_source_id,
            protected_item_health_status=protected_item_health_status,
            extended_info=extended_info,
            kpis_healths=kpis_healths,
            **kwargs
        )
        self.protected_item_type: str = "AzureVmWorkloadSQLDatabase"


class AzureVmWorkloadSQLDatabaseWorkloadItem(AzureVmWorkloadItem):
    """Azure VM workload-specific workload item representing SQL Database.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar workload_item_type: Type of the backup item. Required.
    :vartype workload_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if workload item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
    :vartype sub_workload_item_count: int
    """

    _validation = {
        "workload_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "sub_workload_item_count": {"key": "subWorkloadItemCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        sub_workload_item_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if workload item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
        :paramtype sub_workload_item_count: int
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            subinquireditemcount=subinquireditemcount,
            sub_workload_item_count=sub_workload_item_count,
            **kwargs
        )
        self.workload_item_type: str = "SQLDataBase"


class AzureVmWorkloadSQLInstanceProtectableItem(
    AzureVmWorkloadProtectableItem
):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific protectable item representing SQL Instance.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar protectable_item_type: Type of the backup item. Required.
    :vartype protectable_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar parent_unique_name: Parent Unique Name is added to provide the service formatted URI Name
     of the Parent
     Only Applicable for data bases where the parent would be either Instance or a SQL AG.
    :vartype parent_unique_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if protectable item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar is_auto_protected: Indicates if protectable item is auto-protected.
    :vartype is_auto_protected: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
    :vartype subprotectableitemcount: int
    :ivar prebackupvalidation: Pre-backup validation for protectable objects.
    :vartype prebackupvalidation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
    """

    _validation = {
        "protectable_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protectable_item_type": {"key": "protectableItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "parent_unique_name": {"key": "parentUniqueName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "is_auto_protected": {"key": "isAutoProtected", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "subprotectableitemcount": {"key": "subprotectableitemcount", "type": "int"},
        "prebackupvalidation": {"key": "prebackupvalidation", "type": "PreBackupValidation"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        parent_unique_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        is_auto_protected: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        subprotectableitemcount: Optional[int] = None,
        prebackupvalidation: Optional["_models.PreBackupValidation"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword parent_unique_name: Parent Unique Name is added to provide the service formatted URI
         Name of the Parent
         Only Applicable for data bases where the parent would be either Instance or a SQL AG.
        :paramtype parent_unique_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if protectable item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword is_auto_protected: Indicates if protectable item is auto-protected.
        :paramtype is_auto_protected: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword subprotectableitemcount: For instance or AG, indicates number of DB's to be protected.
        :paramtype subprotectableitemcount: int
        :keyword prebackupvalidation: Pre-backup validation for protectable objects.
        :paramtype prebackupvalidation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PreBackupValidation
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            parent_unique_name=parent_unique_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            is_auto_protected=is_auto_protected,
            subinquireditemcount=subinquireditemcount,
            subprotectableitemcount=subprotectableitemcount,
            prebackupvalidation=prebackupvalidation,
            **kwargs
        )
        self.protectable_item_type: str = "SQLInstance"


class AzureVmWorkloadSQLInstanceWorkloadItem(AzureVmWorkloadItem):  # pylint: disable=too-many-instance-attributes
    """Azure VM workload-specific workload item representing SQL Instance.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Type of backup management to backup an item.
    :vartype backup_management_type: str
    :ivar workload_type: Type of workload for the backup management.
    :vartype workload_type: str
    :ivar workload_item_type: Type of the backup item. Required.
    :vartype workload_item_type: str
    :ivar friendly_name: Friendly name of the backup item.
    :vartype friendly_name: str
    :ivar protection_state: State of the back up item. Known values are: "Invalid", "NotProtected",
     "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar parent_name: Name for instance or AG.
    :vartype parent_name: str
    :ivar server_name: Host/Cluster Name for instance or AG.
    :vartype server_name: str
    :ivar is_auto_protectable: Indicates if workload item is auto-protectable.
    :vartype is_auto_protectable: bool
    :ivar subinquireditemcount: For instance or AG, indicates number of DB's present.
    :vartype subinquireditemcount: int
    :ivar sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
    :vartype sub_workload_item_count: int
    :ivar data_directory_paths: Data Directory Paths for default directories.
    :vartype data_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectory]
    """

    _validation = {
        "workload_item_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "is_auto_protectable": {"key": "isAutoProtectable", "type": "bool"},
        "subinquireditemcount": {"key": "subinquireditemcount", "type": "int"},
        "sub_workload_item_count": {"key": "subWorkloadItemCount", "type": "int"},
        "data_directory_paths": {"key": "dataDirectoryPaths", "type": "[SQLDataDirectory]"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        friendly_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        parent_name: Optional[str] = None,
        server_name: Optional[str] = None,
        is_auto_protectable: Optional[bool] = None,
        subinquireditemcount: Optional[int] = None,
        sub_workload_item_count: Optional[int] = None,
        data_directory_paths: Optional[List["_models.SQLDataDirectory"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management to backup an item.
        :paramtype backup_management_type: str
        :keyword workload_type: Type of workload for the backup management.
        :paramtype workload_type: str
        :keyword friendly_name: Friendly name of the backup item.
        :paramtype friendly_name: str
        :keyword protection_state: State of the back up item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword parent_name: Name for instance or AG.
        :paramtype parent_name: str
        :keyword server_name: Host/Cluster Name for instance or AG.
        :paramtype server_name: str
        :keyword is_auto_protectable: Indicates if workload item is auto-protectable.
        :paramtype is_auto_protectable: bool
        :keyword subinquireditemcount: For instance or AG, indicates number of DB's present.
        :paramtype subinquireditemcount: int
        :keyword sub_workload_item_count: For instance or AG, indicates number of DB's to be protected.
        :paramtype sub_workload_item_count: int
        :keyword data_directory_paths: Data Directory Paths for default directories.
        :paramtype data_directory_paths:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectory]
        """
        super().__init__(
            backup_management_type=backup_management_type,
            workload_type=workload_type,
            friendly_name=friendly_name,
            protection_state=protection_state,
            parent_name=parent_name,
            server_name=server_name,
            is_auto_protectable=is_auto_protectable,
            subinquireditemcount=subinquireditemcount,
            sub_workload_item_count=sub_workload_item_count,
            **kwargs
        )
        self.workload_item_type: str = "SQLInstance"
        self.data_directory_paths = data_directory_paths


class AzureWorkloadAutoProtectionIntent(AzureRecoveryServiceVaultProtectionIntent):
    """Azure Recovery Services Vault specific protection intent item.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSQLAutoProtectionIntent

    All required parameters must be populated in order to send to Azure.

    :ivar protection_intent_item_type: backup protectionIntent type. Required. Known values are:
     "Invalid", "AzureResourceItem", "RecoveryServiceVaultItem",
     "AzureWorkloadContainerAutoProtectionIntent", "AzureWorkloadAutoProtectionIntent", and
     "AzureWorkloadSQLAutoProtectionIntent".
    :vartype protection_intent_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntentItemType
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar item_id: ID of the item which is getting protected, In case of Azure Vm , it is
     ProtectedItemId.
    :vartype item_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    """

    _validation = {
        "protection_intent_item_type": {"required": True},
    }

    _attribute_map = {
        "protection_intent_item_type": {"key": "protectionIntentItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "item_id": {"key": "itemId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
    }

    _subtype_map = {
        "protection_intent_item_type": {"AzureWorkloadSQLAutoProtectionIntent": "AzureWorkloadSQLAutoProtectionIntent"}
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        source_resource_id: Optional[str] = None,
        item_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword item_id: ID of the item which is getting protected, In case of Azure Vm , it is
         ProtectedItemId.
        :paramtype item_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        """
        super().__init__(
            backup_management_type=backup_management_type,
            source_resource_id=source_resource_id,
            item_id=item_id,
            policy_id=policy_id,
            protection_state=protection_state,
            **kwargs
        )
        self.protection_intent_item_type: str = "AzureWorkloadAutoProtectionIntent"


class AzureWorkloadBackupRequest(BackupRequest):
    """AzureWorkload workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar backup_type: Type of backup, viz. Full, Differential, Log or CopyOnlyFull. Known values
     are: "Invalid", "Full", "Differential", "Log", "CopyOnlyFull", "Incremental", "SnapshotFull",
     and "SnapshotCopyOnlyFull".
    :vartype backup_type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupType
    :ivar enable_compression: Bool for Compression setting.
    :vartype enable_compression: bool
    :ivar recovery_point_expiry_time_in_utc: Backup copy will expire after the time specified
     (UTC).
    :vartype recovery_point_expiry_time_in_utc: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "backup_type": {"key": "backupType", "type": "str"},
        "enable_compression": {"key": "enableCompression", "type": "bool"},
        "recovery_point_expiry_time_in_utc": {"key": "recoveryPointExpiryTimeInUTC", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        backup_type: Optional[Union[str, "_models.BackupType"]] = None,
        enable_compression: Optional[bool] = None,
        recovery_point_expiry_time_in_utc: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_type: Type of backup, viz. Full, Differential, Log or CopyOnlyFull. Known
         values are: "Invalid", "Full", "Differential", "Log", "CopyOnlyFull", "Incremental",
         "SnapshotFull", and "SnapshotCopyOnlyFull".
        :paramtype backup_type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupType
        :keyword enable_compression: Bool for Compression setting.
        :paramtype enable_compression: bool
        :keyword recovery_point_expiry_time_in_utc: Backup copy will expire after the time specified
         (UTC).
        :paramtype recovery_point_expiry_time_in_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureWorkloadBackupRequest"
        self.backup_type = backup_type
        self.enable_compression = enable_compression
        self.recovery_point_expiry_time_in_utc = recovery_point_expiry_time_in_utc


class AzureWorkloadContainerAutoProtectionIntent(ProtectionIntent):
    """Azure workload specific protection intent item.

    All required parameters must be populated in order to send to Azure.

    :ivar protection_intent_item_type: backup protectionIntent type. Required. Known values are:
     "Invalid", "AzureResourceItem", "RecoveryServiceVaultItem",
     "AzureWorkloadContainerAutoProtectionIntent", "AzureWorkloadAutoProtectionIntent", and
     "AzureWorkloadSQLAutoProtectionIntent".
    :vartype protection_intent_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntentItemType
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar item_id: ID of the item which is getting protected, In case of Azure Vm , it is
     ProtectedItemId.
    :vartype item_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    """

    _validation = {
        "protection_intent_item_type": {"required": True},
    }

    _attribute_map = {
        "protection_intent_item_type": {"key": "protectionIntentItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "item_id": {"key": "itemId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        source_resource_id: Optional[str] = None,
        item_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword item_id: ID of the item which is getting protected, In case of Azure Vm , it is
         ProtectedItemId.
        :paramtype item_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        """
        super().__init__(
            backup_management_type=backup_management_type,
            source_resource_id=source_resource_id,
            item_id=item_id,
            policy_id=policy_id,
            protection_state=protection_state,
            **kwargs
        )
        self.protection_intent_item_type: str = "AzureWorkloadContainerAutoProtectionIntent"


class AzureWorkloadContainerExtendedInfo(_serialization.Model):
    """Extended information of the container.

    :ivar host_server_name: Host Os Name in case of Stand Alone and Cluster Name in case of
     distributed container.
    :vartype host_server_name: str
    :ivar inquiry_info: Inquiry Status for the container.
    :vartype inquiry_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.InquiryInfo
    :ivar nodes_list: List of the nodes in case of distributed container.
    :vartype nodes_list:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DistributedNodesInfo]
    """

    _attribute_map = {
        "host_server_name": {"key": "hostServerName", "type": "str"},
        "inquiry_info": {"key": "inquiryInfo", "type": "InquiryInfo"},
        "nodes_list": {"key": "nodesList", "type": "[DistributedNodesInfo]"},
    }

    def __init__(
        self,
        *,
        host_server_name: Optional[str] = None,
        inquiry_info: Optional["_models.InquiryInfo"] = None,
        nodes_list: Optional[List["_models.DistributedNodesInfo"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword host_server_name: Host Os Name in case of Stand Alone and Cluster Name in case of
         distributed container.
        :paramtype host_server_name: str
        :keyword inquiry_info: Inquiry Status for the container.
        :paramtype inquiry_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.InquiryInfo
        :keyword nodes_list: List of the nodes in case of distributed container.
        :paramtype nodes_list:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DistributedNodesInfo]
        """
        super().__init__(**kwargs)
        self.host_server_name = host_server_name
        self.inquiry_info = inquiry_info
        self.nodes_list = nodes_list


class AzureWorkloadErrorInfo(_serialization.Model):
    """Azure storage specific error information.

    :ivar error_code: Error code.
    :vartype error_code: int
    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar error_title: Title: Typically, the entity that the error pertains to.
    :vartype error_title: str
    :ivar recommendations: List of localized recommendations for above error code.
    :vartype recommendations: list[str]
    :ivar additional_details: Additional details for above error code.
    :vartype additional_details: str
    """

    _attribute_map = {
        "error_code": {"key": "errorCode", "type": "int"},
        "error_string": {"key": "errorString", "type": "str"},
        "error_title": {"key": "errorTitle", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
        "additional_details": {"key": "additionalDetails", "type": "str"},
    }

    def __init__(
        self,
        *,
        error_code: Optional[int] = None,
        error_string: Optional[str] = None,
        error_title: Optional[str] = None,
        recommendations: Optional[List[str]] = None,
        additional_details: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error_code: Error code.
        :paramtype error_code: int
        :keyword error_string: Localized error string.
        :paramtype error_string: str
        :keyword error_title: Title: Typically, the entity that the error pertains to.
        :paramtype error_title: str
        :keyword recommendations: List of localized recommendations for above error code.
        :paramtype recommendations: list[str]
        :keyword additional_details: Additional details for above error code.
        :paramtype additional_details: str
        """
        super().__init__(**kwargs)
        self.error_code = error_code
        self.error_string = error_string
        self.error_title = error_title
        self.recommendations = recommendations
        self.additional_details = additional_details


class AzureWorkloadJob(Job):  # pylint: disable=too-many-instance-attributes
    """Azure storage specific job.

    All required parameters must be populated in order to send to Azure.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar workload_type: Workload type of the job.
    :vartype workload_type: str
    :ivar duration: Time elapsed during the execution of this job.
    :vartype duration: ~datetime.timedelta
    :ivar actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
    :ivar error_details: Error details on execution of this job.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadErrorInfo]
    :ivar extended_info: Additional information about the job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadJobExtendedInfo
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "error_details": {"key": "errorDetails", "type": "[AzureWorkloadErrorInfo]"},
        "extended_info": {"key": "extendedInfo", "type": "AzureWorkloadJobExtendedInfo"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        workload_type: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        error_details: Optional[List["_models.AzureWorkloadErrorInfo"]] = None,
        extended_info: Optional["_models.AzureWorkloadJobExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword workload_type: Workload type of the job.
        :paramtype workload_type: str
        :keyword duration: Time elapsed during the execution of this job.
        :paramtype duration: ~datetime.timedelta
        :keyword actions_info: Gets or sets the state/actions applicable on this job like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
        :keyword error_details: Error details on execution of this job.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadErrorInfo]
        :keyword extended_info: Additional information about the job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadJobExtendedInfo
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "AzureWorkloadJob"
        self.workload_type = workload_type
        self.duration = duration
        self.actions_info = actions_info
        self.error_details = error_details
        self.extended_info = extended_info


class AzureWorkloadJobExtendedInfo(_serialization.Model):
    """Azure VM workload-specific additional information for job.

    :ivar tasks_list: List of tasks for this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadJobTaskDetails]
    :ivar property_bag: Job properties.
    :vartype property_bag: dict[str, str]
    :ivar dynamic_error_message: Non localized error message on job execution.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[AzureWorkloadJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.AzureWorkloadJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks for this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadJobTaskDetails]
        :keyword property_bag: Job properties.
        :paramtype property_bag: dict[str, str]
        :keyword dynamic_error_message: Non localized error message on job execution.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class AzureWorkloadJobTaskDetails(_serialization.Model):
    """Azure VM workload specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar status: The status.
    :vartype status: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, *, task_id: Optional[str] = None, status: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword status: The status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.status = status


class AzureWorkloadRecoveryPoint(RecoveryPoint):
    """Workload specific recovery point, specifically encapsulates full/diff recovery point.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadPointInTimeRecoveryPoint, AzureWorkloadSAPHanaRecoveryPoint,
    AzureWorkloadSQLRecoveryPoint

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar recovery_point_properties: Properties of Recovery Point.
    :vartype recovery_point_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformationV2]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "recovery_point_properties": {"key": "recoveryPointProperties", "type": "RecoveryPointProperties"},
    }

    _subtype_map = {
        "object_type": {
            "AzureWorkloadPointInTimeRecoveryPoint": "AzureWorkloadPointInTimeRecoveryPoint",
            "AzureWorkloadSAPHanaRecoveryPoint": "AzureWorkloadSAPHanaRecoveryPoint",
            "AzureWorkloadSQLRecoveryPoint": "AzureWorkloadSQLRecoveryPoint",
        }
    }

    def __init__(
        self,
        *,
        recovery_point_time_in_utc: Optional[datetime.datetime] = None,
        type: Optional[Union[str, "_models.RestorePointType"]] = None,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformationV2"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        recovery_point_properties: Optional["_models.RecoveryPointProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_time_in_utc: UTC time at which recovery point was created.
        :paramtype recovery_point_time_in_utc: ~datetime.datetime
        :keyword type: Type of restore point. Known values are: "Invalid", "Full", "Log",
         "Differential", "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
        :paramtype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword recovery_point_properties: Properties of Recovery Point.
        :paramtype recovery_point_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureWorkloadRecoveryPoint"
        self.recovery_point_time_in_utc = recovery_point_time_in_utc
        self.type = type
        self.recovery_point_tier_details = recovery_point_tier_details
        self.recovery_point_move_readiness_info = recovery_point_move_readiness_info
        self.recovery_point_properties = recovery_point_properties


class AzureWorkloadPointInTimeRecoveryPoint(AzureWorkloadRecoveryPoint):
    """Recovery point specific to PointInTime.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSAPHanaPointInTimeRecoveryPoint

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar recovery_point_properties: Properties of Recovery Point.
    :vartype recovery_point_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
    :ivar time_ranges: List of log ranges.
    :vartype time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.PointInTimeRange]
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformationV2]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "recovery_point_properties": {"key": "recoveryPointProperties", "type": "RecoveryPointProperties"},
        "time_ranges": {"key": "timeRanges", "type": "[PointInTimeRange]"},
    }

    _subtype_map = {
        "object_type": {"AzureWorkloadSAPHanaPointInTimeRecoveryPoint": "AzureWorkloadSAPHanaPointInTimeRecoveryPoint"}
    }

    def __init__(
        self,
        *,
        recovery_point_time_in_utc: Optional[datetime.datetime] = None,
        type: Optional[Union[str, "_models.RestorePointType"]] = None,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformationV2"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        recovery_point_properties: Optional["_models.RecoveryPointProperties"] = None,
        time_ranges: Optional[List["_models.PointInTimeRange"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_time_in_utc: UTC time at which recovery point was created.
        :paramtype recovery_point_time_in_utc: ~datetime.datetime
        :keyword type: Type of restore point. Known values are: "Invalid", "Full", "Log",
         "Differential", "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
        :paramtype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword recovery_point_properties: Properties of Recovery Point.
        :paramtype recovery_point_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
        :keyword time_ranges: List of log ranges.
        :paramtype time_ranges:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.PointInTimeRange]
        """
        super().__init__(
            recovery_point_time_in_utc=recovery_point_time_in_utc,
            type=type,
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            recovery_point_properties=recovery_point_properties,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadPointInTimeRecoveryPoint"
        self.time_ranges = time_ranges


class AzureWorkloadRestoreRequest(RestoreRequest):
    """AzureWorkload-specific restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadPointInTimeRestoreRequest, AzureWorkloadSAPHanaRestoreRequest,
    AzureWorkloadSQLRestoreRequest

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureWorkloadPointInTimeRestoreRequest": "AzureWorkloadPointInTimeRestoreRequest",
            "AzureWorkloadSAPHanaRestoreRequest": "AzureWorkloadSAPHanaRestoreRequest",
            "AzureWorkloadSQLRestoreRequest": "AzureWorkloadSQLRestoreRequest",
        }
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        """
        super().__init__(**kwargs)
        self.object_type: str = "AzureWorkloadRestoreRequest"
        self.recovery_type = recovery_type
        self.source_resource_id = source_resource_id
        self.property_bag = property_bag
        self.target_info = target_info
        self.recovery_mode = recovery_mode
        self.target_virtual_machine_id = target_virtual_machine_id


class AzureWorkloadPointInTimeRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log restore.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar point_in_time: PointInTime value.
    :vartype point_in_time: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "point_in_time": {"key": "pointInTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        point_in_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword point_in_time: PointInTime value.
        :paramtype point_in_time: ~datetime.datetime
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadPointInTimeRestoreRequest"
        self.point_in_time = point_in_time


class AzureWorkloadSAPHanaPointInTimeRecoveryPoint(AzureWorkloadPointInTimeRecoveryPoint):
    """Recovery point specific to PointInTime in SAPHana.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar recovery_point_properties: Properties of Recovery Point.
    :vartype recovery_point_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
    :ivar time_ranges: List of log ranges.
    :vartype time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.PointInTimeRange]
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformationV2]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "recovery_point_properties": {"key": "recoveryPointProperties", "type": "RecoveryPointProperties"},
        "time_ranges": {"key": "timeRanges", "type": "[PointInTimeRange]"},
    }

    def __init__(
        self,
        *,
        recovery_point_time_in_utc: Optional[datetime.datetime] = None,
        type: Optional[Union[str, "_models.RestorePointType"]] = None,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformationV2"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        recovery_point_properties: Optional["_models.RecoveryPointProperties"] = None,
        time_ranges: Optional[List["_models.PointInTimeRange"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_time_in_utc: UTC time at which recovery point was created.
        :paramtype recovery_point_time_in_utc: ~datetime.datetime
        :keyword type: Type of restore point. Known values are: "Invalid", "Full", "Log",
         "Differential", "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
        :paramtype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword recovery_point_properties: Properties of Recovery Point.
        :paramtype recovery_point_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
        :keyword time_ranges: List of log ranges.
        :paramtype time_ranges:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.PointInTimeRange]
        """
        super().__init__(
            recovery_point_time_in_utc=recovery_point_time_in_utc,
            type=type,
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            recovery_point_properties=recovery_point_properties,
            time_ranges=time_ranges,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaPointInTimeRecoveryPoint"


class AzureWorkloadSAPHanaRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SAP Hana-specific restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSAPHanaPointInTimeRestoreRequest, AzureWorkloadSAPHanaRestoreWithRehydrateRequest

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "AzureWorkloadSAPHanaPointInTimeRestoreRequest": "AzureWorkloadSAPHanaPointInTimeRestoreRequest",
            "AzureWorkloadSAPHanaRestoreWithRehydrateRequest": "AzureWorkloadSAPHanaRestoreWithRehydrateRequest",
        }
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaRestoreRequest"


class AzureWorkloadSAPHanaPointInTimeRestoreRequest(AzureWorkloadSAPHanaRestoreRequest):
    """AzureWorkload SAP Hana -specific restore. Specifically for PointInTime/Log restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar point_in_time: PointInTime value.
    :vartype point_in_time: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "point_in_time": {"key": "pointInTime", "type": "iso-8601"},
    }

    _subtype_map = {
        "object_type": {
            "AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest": "AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest"
        }
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        point_in_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword point_in_time: PointInTime value.
        :paramtype point_in_time: ~datetime.datetime
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaPointInTimeRestoreRequest"
        self.point_in_time = point_in_time


class AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest(AzureWorkloadSAPHanaPointInTimeRestoreRequest):
    """AzureWorkload SAP Hana-specific restore with integrated rehydration of recovery point.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar point_in_time: PointInTime value.
    :vartype point_in_time: ~datetime.datetime
    :ivar recovery_point_rehydration_info: RP Rehydration Info.
    :vartype recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "point_in_time": {"key": "pointInTime", "type": "iso-8601"},
        "recovery_point_rehydration_info": {
            "key": "recoveryPointRehydrationInfo",
            "type": "RecoveryPointRehydrationInfo",
        },
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        point_in_time: Optional[datetime.datetime] = None,
        recovery_point_rehydration_info: Optional["_models.RecoveryPointRehydrationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword point_in_time: PointInTime value.
        :paramtype point_in_time: ~datetime.datetime
        :keyword recovery_point_rehydration_info: RP Rehydration Info.
        :paramtype recovery_point_rehydration_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            point_in_time=point_in_time,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaPointInTimeRestoreWithRehydrateRequest"
        self.recovery_point_rehydration_info = recovery_point_rehydration_info


class AzureWorkloadSAPHanaRecoveryPoint(AzureWorkloadRecoveryPoint):
    """SAPHana specific recoverypoint, specifically encapsulates full/diff recoverypoints.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar recovery_point_properties: Properties of Recovery Point.
    :vartype recovery_point_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformationV2]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "recovery_point_properties": {"key": "recoveryPointProperties", "type": "RecoveryPointProperties"},
    }

    def __init__(
        self,
        *,
        recovery_point_time_in_utc: Optional[datetime.datetime] = None,
        type: Optional[Union[str, "_models.RestorePointType"]] = None,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformationV2"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        recovery_point_properties: Optional["_models.RecoveryPointProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_time_in_utc: UTC time at which recovery point was created.
        :paramtype recovery_point_time_in_utc: ~datetime.datetime
        :keyword type: Type of restore point. Known values are: "Invalid", "Full", "Log",
         "Differential", "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
        :paramtype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword recovery_point_properties: Properties of Recovery Point.
        :paramtype recovery_point_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
        """
        super().__init__(
            recovery_point_time_in_utc=recovery_point_time_in_utc,
            type=type,
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            recovery_point_properties=recovery_point_properties,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaRecoveryPoint"


class AzureWorkloadSAPHanaRestoreWithRehydrateRequest(AzureWorkloadSAPHanaRestoreRequest):
    """AzureWorkload SAP Hana-specific restore with integrated rehydration of recovery point.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar recovery_point_rehydration_info: RP Rehydration Info.
    :vartype recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "recovery_point_rehydration_info": {
            "key": "recoveryPointRehydrationInfo",
            "type": "RecoveryPointRehydrationInfo",
        },
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        recovery_point_rehydration_info: Optional["_models.RecoveryPointRehydrationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword recovery_point_rehydration_info: RP Rehydration Info.
        :paramtype recovery_point_rehydration_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSAPHanaRestoreWithRehydrateRequest"
        self.recovery_point_rehydration_info = recovery_point_rehydration_info


class AzureWorkloadSQLAutoProtectionIntent(AzureWorkloadAutoProtectionIntent):
    """Azure Workload SQL Auto Protection intent item.

    All required parameters must be populated in order to send to Azure.

    :ivar protection_intent_item_type: backup protectionIntent type. Required. Known values are:
     "Invalid", "AzureResourceItem", "RecoveryServiceVaultItem",
     "AzureWorkloadContainerAutoProtectionIntent", "AzureWorkloadAutoProtectionIntent", and
     "AzureWorkloadSQLAutoProtectionIntent".
    :vartype protection_intent_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntentItemType
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar item_id: ID of the item which is getting protected, In case of Azure Vm , it is
     ProtectedItemId.
    :vartype item_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar workload_item_type: Workload item type of the item for which intent is to be set. Known
     values are: "Invalid", "SQLInstance", "SQLDataBase", "SAPHanaSystem", "SAPHanaDatabase",
     "SAPAseSystem", "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadItemType
    """

    _validation = {
        "protection_intent_item_type": {"required": True},
    }

    _attribute_map = {
        "protection_intent_item_type": {"key": "protectionIntentItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "item_id": {"key": "itemId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        source_resource_id: Optional[str] = None,
        item_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        workload_item_type: Optional[Union[str, "_models.WorkloadItemType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Type of backup management for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword item_id: ID of the item which is getting protected, In case of Azure Vm , it is
         ProtectedItemId.
        :paramtype item_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword workload_item_type: Workload item type of the item for which intent is to be set.
         Known values are: "Invalid", "SQLInstance", "SQLDataBase", "SAPHanaSystem", "SAPHanaDatabase",
         "SAPAseSystem", "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype workload_item_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadItemType
        """
        super().__init__(
            backup_management_type=backup_management_type,
            source_resource_id=source_resource_id,
            item_id=item_id,
            policy_id=policy_id,
            protection_state=protection_state,
            **kwargs
        )
        self.protection_intent_item_type: str = "AzureWorkloadSQLAutoProtectionIntent"
        self.workload_item_type = workload_item_type


class AzureWorkloadSQLRecoveryPoint(AzureWorkloadRecoveryPoint):
    """SQL specific recoverypoint, specifically encapsulates full/diff recoverypoint along with
    extended info.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSQLPointInTimeRecoveryPoint

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar recovery_point_properties: Properties of Recovery Point.
    :vartype recovery_point_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
    :ivar extended_info: Extended Info that provides data directory details. Will be populated in
     two cases:
     When a specific recovery point is accessed using GetRecoveryPoint
     Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadSQLRecoveryPointExtendedInfo
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformationV2]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "recovery_point_properties": {"key": "recoveryPointProperties", "type": "RecoveryPointProperties"},
        "extended_info": {"key": "extendedInfo", "type": "AzureWorkloadSQLRecoveryPointExtendedInfo"},
    }

    _subtype_map = {
        "object_type": {"AzureWorkloadSQLPointInTimeRecoveryPoint": "AzureWorkloadSQLPointInTimeRecoveryPoint"}
    }

    def __init__(
        self,
        *,
        recovery_point_time_in_utc: Optional[datetime.datetime] = None,
        type: Optional[Union[str, "_models.RestorePointType"]] = None,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformationV2"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        recovery_point_properties: Optional["_models.RecoveryPointProperties"] = None,
        extended_info: Optional["_models.AzureWorkloadSQLRecoveryPointExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_time_in_utc: UTC time at which recovery point was created.
        :paramtype recovery_point_time_in_utc: ~datetime.datetime
        :keyword type: Type of restore point. Known values are: "Invalid", "Full", "Log",
         "Differential", "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
        :paramtype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword recovery_point_properties: Properties of Recovery Point.
        :paramtype recovery_point_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
        :keyword extended_info: Extended Info that provides data directory details. Will be populated
         in two cases:
         When a specific recovery point is accessed using GetRecoveryPoint
         Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadSQLRecoveryPointExtendedInfo
        """
        super().__init__(
            recovery_point_time_in_utc=recovery_point_time_in_utc,
            type=type,
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            recovery_point_properties=recovery_point_properties,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLRecoveryPoint"
        self.extended_info = extended_info


class AzureWorkloadSQLPointInTimeRecoveryPoint(AzureWorkloadSQLRecoveryPoint):
    """Recovery point specific to PointInTime.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_time_in_utc: UTC time at which recovery point was created.
    :vartype recovery_point_time_in_utc: ~datetime.datetime
    :ivar type: Type of restore point. Known values are: "Invalid", "Full", "Log", "Differential",
     "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar recovery_point_properties: Properties of Recovery Point.
    :vartype recovery_point_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
    :ivar extended_info: Extended Info that provides data directory details. Will be populated in
     two cases:
     When a specific recovery point is accessed using GetRecoveryPoint
     Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadSQLRecoveryPointExtendedInfo
    :ivar time_ranges: List of log ranges.
    :vartype time_ranges:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.PointInTimeRange]
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_time_in_utc": {"key": "recoveryPointTimeInUTC", "type": "iso-8601"},
        "type": {"key": "type", "type": "str"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformationV2]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "recovery_point_properties": {"key": "recoveryPointProperties", "type": "RecoveryPointProperties"},
        "extended_info": {"key": "extendedInfo", "type": "AzureWorkloadSQLRecoveryPointExtendedInfo"},
        "time_ranges": {"key": "timeRanges", "type": "[PointInTimeRange]"},
    }

    def __init__(
        self,
        *,
        recovery_point_time_in_utc: Optional[datetime.datetime] = None,
        type: Optional[Union[str, "_models.RestorePointType"]] = None,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformationV2"]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        recovery_point_properties: Optional["_models.RecoveryPointProperties"] = None,
        extended_info: Optional["_models.AzureWorkloadSQLRecoveryPointExtendedInfo"] = None,
        time_ranges: Optional[List["_models.PointInTimeRange"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_time_in_utc: UTC time at which recovery point was created.
        :paramtype recovery_point_time_in_utc: ~datetime.datetime
        :keyword type: Type of restore point. Known values are: "Invalid", "Full", "Log",
         "Differential", "Incremental", "SnapshotFull", and "SnapshotCopyOnlyFull".
        :paramtype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointType
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword recovery_point_properties: Properties of Recovery Point.
        :paramtype recovery_point_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
        :keyword extended_info: Extended Info that provides data directory details. Will be populated
         in two cases:
         When a specific recovery point is accessed using GetRecoveryPoint
         Or when ListRecoveryPoints is called for Log RP only with ExtendedInfo query filter.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.AzureWorkloadSQLRecoveryPointExtendedInfo
        :keyword time_ranges: List of log ranges.
        :paramtype time_ranges:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.PointInTimeRange]
        """
        super().__init__(
            recovery_point_time_in_utc=recovery_point_time_in_utc,
            type=type,
            recovery_point_tier_details=recovery_point_tier_details,
            recovery_point_move_readiness_info=recovery_point_move_readiness_info,
            recovery_point_properties=recovery_point_properties,
            extended_info=extended_info,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLPointInTimeRecoveryPoint"
        self.time_ranges = time_ranges


class AzureWorkloadSQLRestoreRequest(AzureWorkloadRestoreRequest):
    """AzureWorkload SQL -specific restore. Specifically for full/diff restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSQLPointInTimeRestoreRequest, AzureWorkloadSQLRestoreWithRehydrateRequest

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar should_use_alternate_target_location: Default option set to true. If this is set to
     false, alternate data directory must be provided.
    :vartype should_use_alternate_target_location: bool
    :ivar is_non_recoverable: SQL specific property where user can chose to set no-recovery when
     restore operation is tried.
    :vartype is_non_recoverable: bool
    :ivar alternate_directory_paths: Data directory details.
    :vartype alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryMapping]
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "should_use_alternate_target_location": {"key": "shouldUseAlternateTargetLocation", "type": "bool"},
        "is_non_recoverable": {"key": "isNonRecoverable", "type": "bool"},
        "alternate_directory_paths": {"key": "alternateDirectoryPaths", "type": "[SQLDataDirectoryMapping]"},
    }

    _subtype_map = {
        "object_type": {
            "AzureWorkloadSQLPointInTimeRestoreRequest": "AzureWorkloadSQLPointInTimeRestoreRequest",
            "AzureWorkloadSQLRestoreWithRehydrateRequest": "AzureWorkloadSQLRestoreWithRehydrateRequest",
        }
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        should_use_alternate_target_location: Optional[bool] = None,
        is_non_recoverable: Optional[bool] = None,
        alternate_directory_paths: Optional[List["_models.SQLDataDirectoryMapping"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword should_use_alternate_target_location: Default option set to true. If this is set to
         false, alternate data directory must be provided.
        :paramtype should_use_alternate_target_location: bool
        :keyword is_non_recoverable: SQL specific property where user can chose to set no-recovery when
         restore operation is tried.
        :paramtype is_non_recoverable: bool
        :keyword alternate_directory_paths: Data directory details.
        :paramtype alternate_directory_paths:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryMapping]
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLRestoreRequest"
        self.should_use_alternate_target_location = should_use_alternate_target_location
        self.is_non_recoverable = is_non_recoverable
        self.alternate_directory_paths = alternate_directory_paths


class AzureWorkloadSQLPointInTimeRestoreRequest(
    AzureWorkloadSQLRestoreRequest
):  # pylint: disable=too-many-instance-attributes
    """AzureWorkload SQL -specific restore. Specifically for PointInTime/Log restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar should_use_alternate_target_location: Default option set to true. If this is set to
     false, alternate data directory must be provided.
    :vartype should_use_alternate_target_location: bool
    :ivar is_non_recoverable: SQL specific property where user can chose to set no-recovery when
     restore operation is tried.
    :vartype is_non_recoverable: bool
    :ivar alternate_directory_paths: Data directory details.
    :vartype alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryMapping]
    :ivar point_in_time: PointInTime value.
    :vartype point_in_time: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "should_use_alternate_target_location": {"key": "shouldUseAlternateTargetLocation", "type": "bool"},
        "is_non_recoverable": {"key": "isNonRecoverable", "type": "bool"},
        "alternate_directory_paths": {"key": "alternateDirectoryPaths", "type": "[SQLDataDirectoryMapping]"},
        "point_in_time": {"key": "pointInTime", "type": "iso-8601"},
    }

    _subtype_map = {
        "object_type": {
            "AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest": "AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest"
        }
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        should_use_alternate_target_location: Optional[bool] = None,
        is_non_recoverable: Optional[bool] = None,
        alternate_directory_paths: Optional[List["_models.SQLDataDirectoryMapping"]] = None,
        point_in_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword should_use_alternate_target_location: Default option set to true. If this is set to
         false, alternate data directory must be provided.
        :paramtype should_use_alternate_target_location: bool
        :keyword is_non_recoverable: SQL specific property where user can chose to set no-recovery when
         restore operation is tried.
        :paramtype is_non_recoverable: bool
        :keyword alternate_directory_paths: Data directory details.
        :paramtype alternate_directory_paths:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryMapping]
        :keyword point_in_time: PointInTime value.
        :paramtype point_in_time: ~datetime.datetime
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            should_use_alternate_target_location=should_use_alternate_target_location,
            is_non_recoverable=is_non_recoverable,
            alternate_directory_paths=alternate_directory_paths,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLPointInTimeRestoreRequest"
        self.point_in_time = point_in_time


class AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest(
    AzureWorkloadSQLPointInTimeRestoreRequest
):  # pylint: disable=too-many-instance-attributes
    """AzureWorkload SQL-specific restore with integrated rehydration of recovery point.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar should_use_alternate_target_location: Default option set to true. If this is set to
     false, alternate data directory must be provided.
    :vartype should_use_alternate_target_location: bool
    :ivar is_non_recoverable: SQL specific property where user can chose to set no-recovery when
     restore operation is tried.
    :vartype is_non_recoverable: bool
    :ivar alternate_directory_paths: Data directory details.
    :vartype alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryMapping]
    :ivar point_in_time: PointInTime value.
    :vartype point_in_time: ~datetime.datetime
    :ivar recovery_point_rehydration_info: RP Rehydration Info.
    :vartype recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "should_use_alternate_target_location": {"key": "shouldUseAlternateTargetLocation", "type": "bool"},
        "is_non_recoverable": {"key": "isNonRecoverable", "type": "bool"},
        "alternate_directory_paths": {"key": "alternateDirectoryPaths", "type": "[SQLDataDirectoryMapping]"},
        "point_in_time": {"key": "pointInTime", "type": "iso-8601"},
        "recovery_point_rehydration_info": {
            "key": "recoveryPointRehydrationInfo",
            "type": "RecoveryPointRehydrationInfo",
        },
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        should_use_alternate_target_location: Optional[bool] = None,
        is_non_recoverable: Optional[bool] = None,
        alternate_directory_paths: Optional[List["_models.SQLDataDirectoryMapping"]] = None,
        point_in_time: Optional[datetime.datetime] = None,
        recovery_point_rehydration_info: Optional["_models.RecoveryPointRehydrationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword should_use_alternate_target_location: Default option set to true. If this is set to
         false, alternate data directory must be provided.
        :paramtype should_use_alternate_target_location: bool
        :keyword is_non_recoverable: SQL specific property where user can chose to set no-recovery when
         restore operation is tried.
        :paramtype is_non_recoverable: bool
        :keyword alternate_directory_paths: Data directory details.
        :paramtype alternate_directory_paths:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryMapping]
        :keyword point_in_time: PointInTime value.
        :paramtype point_in_time: ~datetime.datetime
        :keyword recovery_point_rehydration_info: RP Rehydration Info.
        :paramtype recovery_point_rehydration_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            should_use_alternate_target_location=should_use_alternate_target_location,
            is_non_recoverable=is_non_recoverable,
            alternate_directory_paths=alternate_directory_paths,
            point_in_time=point_in_time,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLPointInTimeRestoreWithRehydrateRequest"
        self.recovery_point_rehydration_info = recovery_point_rehydration_info


class AzureWorkloadSQLRecoveryPointExtendedInfo(_serialization.Model):
    """Extended info class details.

    :ivar data_directory_time_in_utc: UTC time at which data directory info was captured.
    :vartype data_directory_time_in_utc: ~datetime.datetime
    :ivar data_directory_paths: List of data directory paths during restore operation.
    :vartype data_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectory]
    """

    _attribute_map = {
        "data_directory_time_in_utc": {"key": "dataDirectoryTimeInUTC", "type": "iso-8601"},
        "data_directory_paths": {"key": "dataDirectoryPaths", "type": "[SQLDataDirectory]"},
    }

    def __init__(
        self,
        *,
        data_directory_time_in_utc: Optional[datetime.datetime] = None,
        data_directory_paths: Optional[List["_models.SQLDataDirectory"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_directory_time_in_utc: UTC time at which data directory info was captured.
        :paramtype data_directory_time_in_utc: ~datetime.datetime
        :keyword data_directory_paths: List of data directory paths during restore operation.
        :paramtype data_directory_paths:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectory]
        """
        super().__init__(**kwargs)
        self.data_directory_time_in_utc = data_directory_time_in_utc
        self.data_directory_paths = data_directory_paths


class AzureWorkloadSQLRestoreWithRehydrateRequest(
    AzureWorkloadSQLRestoreRequest
):  # pylint: disable=too-many-instance-attributes
    """AzureWorkload SQL-specific restore with integrated rehydration of recovery point.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM on which workload that was running
     is being recovered.
    :vartype source_resource_id: str
    :ivar property_bag: Workload specific property bag.
    :vartype property_bag: dict[str, str]
    :ivar target_info: Details of target database.
    :vartype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
    :ivar recovery_mode: Defines whether the current recovery mode is file restore or database
     restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
    :vartype recovery_mode: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
    :ivar target_virtual_machine_id: This is the complete ARM Id of the target VM
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar should_use_alternate_target_location: Default option set to true. If this is set to
     false, alternate data directory must be provided.
    :vartype should_use_alternate_target_location: bool
    :ivar is_non_recoverable: SQL specific property where user can chose to set no-recovery when
     restore operation is tried.
    :vartype is_non_recoverable: bool
    :ivar alternate_directory_paths: Data directory details.
    :vartype alternate_directory_paths:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryMapping]
    :ivar recovery_point_rehydration_info: RP Rehydration Info.
    :vartype recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "target_info": {"key": "targetInfo", "type": "TargetRestoreInfo"},
        "recovery_mode": {"key": "recoveryMode", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "should_use_alternate_target_location": {"key": "shouldUseAlternateTargetLocation", "type": "bool"},
        "is_non_recoverable": {"key": "isNonRecoverable", "type": "bool"},
        "alternate_directory_paths": {"key": "alternateDirectoryPaths", "type": "[SQLDataDirectoryMapping]"},
        "recovery_point_rehydration_info": {
            "key": "recoveryPointRehydrationInfo",
            "type": "RecoveryPointRehydrationInfo",
        },
    }

    def __init__(
        self,
        *,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        property_bag: Optional[Dict[str, str]] = None,
        target_info: Optional["_models.TargetRestoreInfo"] = None,
        recovery_mode: Optional[Union[str, "_models.RecoveryMode"]] = None,
        target_virtual_machine_id: Optional[str] = None,
        should_use_alternate_target_location: Optional[bool] = None,
        is_non_recoverable: Optional[bool] = None,
        alternate_directory_paths: Optional[List["_models.SQLDataDirectoryMapping"]] = None,
        recovery_point_rehydration_info: Optional["_models.RecoveryPointRehydrationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM on which workload that was
         running is being recovered.
        :paramtype source_resource_id: str
        :keyword property_bag: Workload specific property bag.
        :paramtype property_bag: dict[str, str]
        :keyword target_info: Details of target database.
        :paramtype target_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetRestoreInfo
        :keyword recovery_mode: Defines whether the current recovery mode is file restore or database
         restore. Known values are: "Invalid", "FileRecovery", and "WorkloadRecovery".
        :paramtype recovery_mode: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryMode
        :keyword target_virtual_machine_id: This is the complete ARM Id of the target VM
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword should_use_alternate_target_location: Default option set to true. If this is set to
         false, alternate data directory must be provided.
        :paramtype should_use_alternate_target_location: bool
        :keyword is_non_recoverable: SQL specific property where user can chose to set no-recovery when
         restore operation is tried.
        :paramtype is_non_recoverable: bool
        :keyword alternate_directory_paths: Data directory details.
        :paramtype alternate_directory_paths:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryMapping]
        :keyword recovery_point_rehydration_info: RP Rehydration Info.
        :paramtype recovery_point_rehydration_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
        """
        super().__init__(
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            property_bag=property_bag,
            target_info=target_info,
            recovery_mode=recovery_mode,
            target_virtual_machine_id=target_virtual_machine_id,
            should_use_alternate_target_location=should_use_alternate_target_location,
            is_non_recoverable=is_non_recoverable,
            alternate_directory_paths=alternate_directory_paths,
            **kwargs
        )
        self.object_type: str = "AzureWorkloadSQLRestoreWithRehydrateRequest"
        self.recovery_point_rehydration_info = recovery_point_rehydration_info


class Resource(_serialization.Model):
    """ARM Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.e_tag = e_tag


class BackupEngineBaseResource(Resource):
    """The base backup engine class. All workload specific backup engines derive from this class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: BackupEngineBaseResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineBase
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "BackupEngineBase"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.BackupEngineBase"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: BackupEngineBaseResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineBase
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ResourceList(_serialization.Model):
    """Base for all lists of resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.next_link = next_link


class BackupEngineBaseResourceList(ResourceList):
    """List of BackupEngineBase resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineBaseResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[BackupEngineBaseResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.BackupEngineBaseResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineBaseResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class BackupEngineExtendedInfo(_serialization.Model):
    """Additional information on backup engine.

    :ivar database_name: Database name of backup engine.
    :vartype database_name: str
    :ivar protected_items_count: Number of protected items in the backup engine.
    :vartype protected_items_count: int
    :ivar protected_servers_count: Number of protected servers in the backup engine.
    :vartype protected_servers_count: int
    :ivar disk_count: Number of disks in the backup engine.
    :vartype disk_count: int
    :ivar used_disk_space: Disk space used in the backup engine.
    :vartype used_disk_space: float
    :ivar available_disk_space: Disk space currently available in the backup engine.
    :vartype available_disk_space: float
    :ivar refreshed_at: Last refresh time in the backup engine.
    :vartype refreshed_at: ~datetime.datetime
    :ivar azure_protected_instances: Protected instances in the backup engine.
    :vartype azure_protected_instances: int
    """

    _attribute_map = {
        "database_name": {"key": "databaseName", "type": "str"},
        "protected_items_count": {"key": "protectedItemsCount", "type": "int"},
        "protected_servers_count": {"key": "protectedServersCount", "type": "int"},
        "disk_count": {"key": "diskCount", "type": "int"},
        "used_disk_space": {"key": "usedDiskSpace", "type": "float"},
        "available_disk_space": {"key": "availableDiskSpace", "type": "float"},
        "refreshed_at": {"key": "refreshedAt", "type": "iso-8601"},
        "azure_protected_instances": {"key": "azureProtectedInstances", "type": "int"},
    }

    def __init__(
        self,
        *,
        database_name: Optional[str] = None,
        protected_items_count: Optional[int] = None,
        protected_servers_count: Optional[int] = None,
        disk_count: Optional[int] = None,
        used_disk_space: Optional[float] = None,
        available_disk_space: Optional[float] = None,
        refreshed_at: Optional[datetime.datetime] = None,
        azure_protected_instances: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword database_name: Database name of backup engine.
        :paramtype database_name: str
        :keyword protected_items_count: Number of protected items in the backup engine.
        :paramtype protected_items_count: int
        :keyword protected_servers_count: Number of protected servers in the backup engine.
        :paramtype protected_servers_count: int
        :keyword disk_count: Number of disks in the backup engine.
        :paramtype disk_count: int
        :keyword used_disk_space: Disk space used in the backup engine.
        :paramtype used_disk_space: float
        :keyword available_disk_space: Disk space currently available in the backup engine.
        :paramtype available_disk_space: float
        :keyword refreshed_at: Last refresh time in the backup engine.
        :paramtype refreshed_at: ~datetime.datetime
        :keyword azure_protected_instances: Protected instances in the backup engine.
        :paramtype azure_protected_instances: int
        """
        super().__init__(**kwargs)
        self.database_name = database_name
        self.protected_items_count = protected_items_count
        self.protected_servers_count = protected_servers_count
        self.disk_count = disk_count
        self.used_disk_space = used_disk_space
        self.available_disk_space = available_disk_space
        self.refreshed_at = refreshed_at
        self.azure_protected_instances = azure_protected_instances


class BackupManagementUsage(_serialization.Model):
    """Backup management usages of a vault.

    :ivar unit: Unit of the usage. Known values are: "Count", "Bytes", "Seconds", "Percent",
     "CountPerSecond", and "BytesPerSecond".
    :vartype unit: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.UsagesUnit
    :ivar quota_period: Quota period of usage.
    :vartype quota_period: str
    :ivar next_reset_time: Next reset time of usage.
    :vartype next_reset_time: ~datetime.datetime
    :ivar current_value: Current value of usage.
    :vartype current_value: int
    :ivar limit: Limit of usage.
    :vartype limit: int
    :ivar name: Name of usage.
    :vartype name: ~azure.mgmt.recoveryservicesbackup.activestamp.models.NameInfo
    """

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "quota_period": {"key": "quotaPeriod", "type": "str"},
        "next_reset_time": {"key": "nextResetTime", "type": "iso-8601"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "NameInfo"},
    }

    def __init__(
        self,
        *,
        unit: Optional[Union[str, "_models.UsagesUnit"]] = None,
        quota_period: Optional[str] = None,
        next_reset_time: Optional[datetime.datetime] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["_models.NameInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unit: Unit of the usage. Known values are: "Count", "Bytes", "Seconds", "Percent",
         "CountPerSecond", and "BytesPerSecond".
        :paramtype unit: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.UsagesUnit
        :keyword quota_period: Quota period of usage.
        :paramtype quota_period: str
        :keyword next_reset_time: Next reset time of usage.
        :paramtype next_reset_time: ~datetime.datetime
        :keyword current_value: Current value of usage.
        :paramtype current_value: int
        :keyword limit: Limit of usage.
        :paramtype limit: int
        :keyword name: Name of usage.
        :paramtype name: ~azure.mgmt.recoveryservicesbackup.activestamp.models.NameInfo
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.quota_period = quota_period
        self.next_reset_time = next_reset_time
        self.current_value = current_value
        self.limit = limit
        self.name = name


class BackupManagementUsageList(_serialization.Model):
    """Backup management usage for vault.

    :ivar value: The list of backup management usages for the given vault.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementUsage]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BackupManagementUsage]"},
    }

    def __init__(self, *, value: Optional[List["_models.BackupManagementUsage"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of backup management usages for the given vault.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementUsage]
        """
        super().__init__(**kwargs)
        self.value = value


class BackupRequestResource(Resource):
    """Base class for backup request. Workload-specific backup requests are derived from this class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: BackupRequestResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupRequest
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "BackupRequest"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.BackupRequest"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: BackupRequestResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupRequest
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupResourceConfig(_serialization.Model):
    """The resource storage details.

    :ivar storage_model_type: Storage type. Known values are: "Invalid", "GeoRedundant",
     "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
    :vartype storage_model_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageType
    :ivar storage_type: Storage type. Known values are: "Invalid", "GeoRedundant",
     "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
    :vartype storage_type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageType
    :ivar storage_type_state: Locked or Unlocked. Once a machine is registered against a resource,
     the storageTypeState is always Locked. Known values are: "Invalid", "Locked", and "Unlocked".
    :vartype storage_type_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageTypeState
    :ivar cross_region_restore_flag: Opt in details of Cross Region Restore feature.
    :vartype cross_region_restore_flag: bool
    :ivar dedup_state: Vault Dedup state. Known values are: "Invalid", "Enabled", and "Disabled".
    :vartype dedup_state: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.DedupState
    :ivar xcool_state: Vault x-cool state. Known values are: "Invalid", "Enabled", and "Disabled".
    :vartype xcool_state: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.XcoolState
    """

    _attribute_map = {
        "storage_model_type": {"key": "storageModelType", "type": "str"},
        "storage_type": {"key": "storageType", "type": "str"},
        "storage_type_state": {"key": "storageTypeState", "type": "str"},
        "cross_region_restore_flag": {"key": "crossRegionRestoreFlag", "type": "bool"},
        "dedup_state": {"key": "dedupState", "type": "str"},
        "xcool_state": {"key": "xcoolState", "type": "str"},
    }

    def __init__(
        self,
        *,
        storage_model_type: Optional[Union[str, "_models.StorageType"]] = None,
        storage_type: Optional[Union[str, "_models.StorageType"]] = None,
        storage_type_state: Optional[Union[str, "_models.StorageTypeState"]] = None,
        cross_region_restore_flag: Optional[bool] = None,
        dedup_state: Optional[Union[str, "_models.DedupState"]] = None,
        xcool_state: Optional[Union[str, "_models.XcoolState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_model_type: Storage type. Known values are: "Invalid", "GeoRedundant",
         "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
        :paramtype storage_model_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageType
        :keyword storage_type: Storage type. Known values are: "Invalid", "GeoRedundant",
         "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
        :paramtype storage_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageType
        :keyword storage_type_state: Locked or Unlocked. Once a machine is registered against a
         resource, the storageTypeState is always Locked. Known values are: "Invalid", "Locked", and
         "Unlocked".
        :paramtype storage_type_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageTypeState
        :keyword cross_region_restore_flag: Opt in details of Cross Region Restore feature.
        :paramtype cross_region_restore_flag: bool
        :keyword dedup_state: Vault Dedup state. Known values are: "Invalid", "Enabled", and
         "Disabled".
        :paramtype dedup_state: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.DedupState
        :keyword xcool_state: Vault x-cool state. Known values are: "Invalid", "Enabled", and
         "Disabled".
        :paramtype xcool_state: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.XcoolState
        """
        super().__init__(**kwargs)
        self.storage_model_type = storage_model_type
        self.storage_type = storage_type
        self.storage_type_state = storage_type_state
        self.cross_region_restore_flag = cross_region_restore_flag
        self.dedup_state = dedup_state
        self.xcool_state = xcool_state


class BackupResourceConfigResource(Resource):
    """The resource storage details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: BackupResourceConfigResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupResourceConfig
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "BackupResourceConfig"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.BackupResourceConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: BackupResourceConfigResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupResourceConfig
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupResourceEncryptionConfig(_serialization.Model):
    """BackupResourceEncryptionConfig.

    :ivar encryption_at_rest_type: Encryption At Rest Type. Known values are: "Invalid",
     "MicrosoftManaged", and "CustomerManaged".
    :vartype encryption_at_rest_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.EncryptionAtRestType
    :ivar key_uri: Key Vault Key URI.
    :vartype key_uri: str
    :ivar subscription_id: Key Vault Subscription Id.
    :vartype subscription_id: str
    :ivar last_update_status: Known values are: "Invalid", "NotEnabled", "PartiallySucceeded",
     "PartiallyFailed", "Failed", "Succeeded", "Initialized", and "FirstInitialization".
    :vartype last_update_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastUpdateStatus
    :ivar infrastructure_encryption_state: Known values are: "Invalid", "Disabled", and "Enabled".
    :vartype infrastructure_encryption_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.InfrastructureEncryptionState
    """

    _attribute_map = {
        "encryption_at_rest_type": {"key": "encryptionAtRestType", "type": "str"},
        "key_uri": {"key": "keyUri", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "last_update_status": {"key": "lastUpdateStatus", "type": "str"},
        "infrastructure_encryption_state": {"key": "infrastructureEncryptionState", "type": "str"},
    }

    def __init__(
        self,
        *,
        encryption_at_rest_type: Optional[Union[str, "_models.EncryptionAtRestType"]] = None,
        key_uri: Optional[str] = None,
        subscription_id: Optional[str] = None,
        last_update_status: Optional[Union[str, "_models.LastUpdateStatus"]] = None,
        infrastructure_encryption_state: Optional[Union[str, "_models.InfrastructureEncryptionState"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encryption_at_rest_type: Encryption At Rest Type. Known values are: "Invalid",
         "MicrosoftManaged", and "CustomerManaged".
        :paramtype encryption_at_rest_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.EncryptionAtRestType
        :keyword key_uri: Key Vault Key URI.
        :paramtype key_uri: str
        :keyword subscription_id: Key Vault Subscription Id.
        :paramtype subscription_id: str
        :keyword last_update_status: Known values are: "Invalid", "NotEnabled", "PartiallySucceeded",
         "PartiallyFailed", "Failed", "Succeeded", "Initialized", and "FirstInitialization".
        :paramtype last_update_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastUpdateStatus
        :keyword infrastructure_encryption_state: Known values are: "Invalid", "Disabled", and
         "Enabled".
        :paramtype infrastructure_encryption_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.InfrastructureEncryptionState
        """
        super().__init__(**kwargs)
        self.encryption_at_rest_type = encryption_at_rest_type
        self.key_uri = key_uri
        self.subscription_id = subscription_id
        self.last_update_status = last_update_status
        self.infrastructure_encryption_state = infrastructure_encryption_state


class BackupResourceEncryptionConfigExtended(BackupResourceEncryptionConfig):
    """BackupResourceEncryptionConfigExtended.

    :ivar encryption_at_rest_type: Encryption At Rest Type. Known values are: "Invalid",
     "MicrosoftManaged", and "CustomerManaged".
    :vartype encryption_at_rest_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.EncryptionAtRestType
    :ivar key_uri: Key Vault Key URI.
    :vartype key_uri: str
    :ivar subscription_id: Key Vault Subscription Id.
    :vartype subscription_id: str
    :ivar last_update_status: Known values are: "Invalid", "NotEnabled", "PartiallySucceeded",
     "PartiallyFailed", "Failed", "Succeeded", "Initialized", and "FirstInitialization".
    :vartype last_update_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastUpdateStatus
    :ivar infrastructure_encryption_state: Known values are: "Invalid", "Disabled", and "Enabled".
    :vartype infrastructure_encryption_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.InfrastructureEncryptionState
    :ivar user_assigned_identity: User Assigned Identity Id.
    :vartype user_assigned_identity: str
    :ivar use_system_assigned_identity: bool to indicate whether to use system Assigned Identity or
     not.
    :vartype use_system_assigned_identity: bool
    """

    _attribute_map = {
        "encryption_at_rest_type": {"key": "encryptionAtRestType", "type": "str"},
        "key_uri": {"key": "keyUri", "type": "str"},
        "subscription_id": {"key": "subscriptionId", "type": "str"},
        "last_update_status": {"key": "lastUpdateStatus", "type": "str"},
        "infrastructure_encryption_state": {"key": "infrastructureEncryptionState", "type": "str"},
        "user_assigned_identity": {"key": "userAssignedIdentity", "type": "str"},
        "use_system_assigned_identity": {"key": "useSystemAssignedIdentity", "type": "bool"},
    }

    def __init__(
        self,
        *,
        encryption_at_rest_type: Optional[Union[str, "_models.EncryptionAtRestType"]] = None,
        key_uri: Optional[str] = None,
        subscription_id: Optional[str] = None,
        last_update_status: Optional[Union[str, "_models.LastUpdateStatus"]] = None,
        infrastructure_encryption_state: Optional[Union[str, "_models.InfrastructureEncryptionState"]] = None,
        user_assigned_identity: Optional[str] = None,
        use_system_assigned_identity: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encryption_at_rest_type: Encryption At Rest Type. Known values are: "Invalid",
         "MicrosoftManaged", and "CustomerManaged".
        :paramtype encryption_at_rest_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.EncryptionAtRestType
        :keyword key_uri: Key Vault Key URI.
        :paramtype key_uri: str
        :keyword subscription_id: Key Vault Subscription Id.
        :paramtype subscription_id: str
        :keyword last_update_status: Known values are: "Invalid", "NotEnabled", "PartiallySucceeded",
         "PartiallyFailed", "Failed", "Succeeded", "Initialized", and "FirstInitialization".
        :paramtype last_update_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.LastUpdateStatus
        :keyword infrastructure_encryption_state: Known values are: "Invalid", "Disabled", and
         "Enabled".
        :paramtype infrastructure_encryption_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.InfrastructureEncryptionState
        :keyword user_assigned_identity: User Assigned Identity Id.
        :paramtype user_assigned_identity: str
        :keyword use_system_assigned_identity: bool to indicate whether to use system Assigned Identity
         or not.
        :paramtype use_system_assigned_identity: bool
        """
        super().__init__(
            encryption_at_rest_type=encryption_at_rest_type,
            key_uri=key_uri,
            subscription_id=subscription_id,
            last_update_status=last_update_status,
            infrastructure_encryption_state=infrastructure_encryption_state,
            **kwargs
        )
        self.user_assigned_identity = user_assigned_identity
        self.use_system_assigned_identity = use_system_assigned_identity


class BackupResourceEncryptionConfigExtendedResource(Resource):
    """BackupResourceEncryptionConfigExtendedResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: BackupResourceEncryptionConfigExtendedResource properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupResourceEncryptionConfigExtended
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "BackupResourceEncryptionConfigExtended"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.BackupResourceEncryptionConfigExtended"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: BackupResourceEncryptionConfigExtendedResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupResourceEncryptionConfigExtended
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupResourceEncryptionConfigResource(Resource):
    """BackupResourceEncryptionConfigResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: BackupResourceEncryptionConfigResource properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupResourceEncryptionConfig
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "BackupResourceEncryptionConfig"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.BackupResourceEncryptionConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: BackupResourceEncryptionConfigResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupResourceEncryptionConfig
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupResourceVaultConfig(_serialization.Model):
    """Backup resource vault config details.

    :ivar storage_model_type: Storage type. Known values are: "Invalid", "GeoRedundant",
     "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
    :vartype storage_model_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageType
    :ivar storage_type: Storage type. Known values are: "Invalid", "GeoRedundant",
     "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
    :vartype storage_type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageType
    :ivar storage_type_state: Locked or Unlocked. Once a machine is registered against a resource,
     the storageTypeState is always Locked. Known values are: "Invalid", "Locked", and "Unlocked".
    :vartype storage_type_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageTypeState
    :ivar enhanced_security_state: Enabled or Disabled. Known values are: "Invalid", "Enabled", and
     "Disabled".
    :vartype enhanced_security_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.EnhancedSecurityState
    :ivar soft_delete_feature_state: Soft Delete feature state. Known values are: "Invalid",
     "Enabled", and "Disabled".
    :vartype soft_delete_feature_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.SoftDeleteFeatureState
    :ivar resource_guard_operation_requests: ResourceGuard Operation Requests.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_soft_delete_feature_state_editable: Is soft delete feature state editable.
    :vartype is_soft_delete_feature_state_editable: bool
    """

    _attribute_map = {
        "storage_model_type": {"key": "storageModelType", "type": "str"},
        "storage_type": {"key": "storageType", "type": "str"},
        "storage_type_state": {"key": "storageTypeState", "type": "str"},
        "enhanced_security_state": {"key": "enhancedSecurityState", "type": "str"},
        "soft_delete_feature_state": {"key": "softDeleteFeatureState", "type": "str"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_soft_delete_feature_state_editable": {"key": "isSoftDeleteFeatureStateEditable", "type": "bool"},
    }

    def __init__(
        self,
        *,
        storage_model_type: Optional[Union[str, "_models.StorageType"]] = None,
        storage_type: Optional[Union[str, "_models.StorageType"]] = None,
        storage_type_state: Optional[Union[str, "_models.StorageTypeState"]] = None,
        enhanced_security_state: Optional[Union[str, "_models.EnhancedSecurityState"]] = None,
        soft_delete_feature_state: Optional[Union[str, "_models.SoftDeleteFeatureState"]] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_soft_delete_feature_state_editable: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_model_type: Storage type. Known values are: "Invalid", "GeoRedundant",
         "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
        :paramtype storage_model_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageType
        :keyword storage_type: Storage type. Known values are: "Invalid", "GeoRedundant",
         "LocallyRedundant", "ZoneRedundant", and "ReadAccessGeoZoneRedundant".
        :paramtype storage_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageType
        :keyword storage_type_state: Locked or Unlocked. Once a machine is registered against a
         resource, the storageTypeState is always Locked. Known values are: "Invalid", "Locked", and
         "Unlocked".
        :paramtype storage_type_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.StorageTypeState
        :keyword enhanced_security_state: Enabled or Disabled. Known values are: "Invalid", "Enabled",
         and "Disabled".
        :paramtype enhanced_security_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.EnhancedSecurityState
        :keyword soft_delete_feature_state: Soft Delete feature state. Known values are: "Invalid",
         "Enabled", and "Disabled".
        :paramtype soft_delete_feature_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.SoftDeleteFeatureState
        :keyword resource_guard_operation_requests: ResourceGuard Operation Requests.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_soft_delete_feature_state_editable: Is soft delete feature state editable.
        :paramtype is_soft_delete_feature_state_editable: bool
        """
        super().__init__(**kwargs)
        self.storage_model_type = storage_model_type
        self.storage_type = storage_type
        self.storage_type_state = storage_type_state
        self.enhanced_security_state = enhanced_security_state
        self.soft_delete_feature_state = soft_delete_feature_state
        self.resource_guard_operation_requests = resource_guard_operation_requests
        self.is_soft_delete_feature_state_editable = is_soft_delete_feature_state_editable


class BackupResourceVaultConfigResource(Resource):
    """Backup resource vault config details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: BackupResourceVaultConfigResource properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupResourceVaultConfig
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "BackupResourceVaultConfig"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.BackupResourceVaultConfig"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: BackupResourceVaultConfigResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupResourceVaultConfig
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class BackupStatusRequest(_serialization.Model):
    """BackupStatus request.

    :ivar resource_type: Container Type - VM, SQLPaaS, DPM, AzureFileShare... Known values are:
     "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
     "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
     "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype resource_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar resource_id: Entire ARM resource id of the resource.
    :vartype resource_id: str
    :ivar po_logical_name: Protectable Item Logical Name.
    :vartype po_logical_name: str
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "po_logical_name": {"key": "poLogicalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        resource_id: Optional[str] = None,
        po_logical_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: Container Type - VM, SQLPaaS, DPM, AzureFileShare... Known values are:
         "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
         "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
         "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype resource_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
        :keyword resource_id: Entire ARM resource id of the resource.
        :paramtype resource_id: str
        :keyword po_logical_name: Protectable Item Logical Name.
        :paramtype po_logical_name: str
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.po_logical_name = po_logical_name


class BackupStatusResponse(_serialization.Model):
    """BackupStatus response.

    :ivar protection_status: Specifies whether the container is registered or not. Known values
     are: "Invalid", "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    :ivar vault_id: Specifies the arm resource id of the vault.
    :vartype vault_id: str
    :ivar fabric_name: Specifies the fabric name - Azure or AD. Known values are: "Invalid" and
     "Azure".
    :vartype fabric_name: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.FabricName
    :ivar container_name: Specifies the product specific container name. E.g.
     iaasvmcontainer;iaasvmcontainer;csname;vmname.
    :vartype container_name: str
    :ivar protected_item_name: Specifies the product specific ds name. E.g.
     vm;iaasvmcontainer;csname;vmname.
    :vartype protected_item_name: str
    :ivar error_code: ErrorCode in case of intent failed.
    :vartype error_code: str
    :ivar error_message: ErrorMessage in case of intent failed.
    :vartype error_message: str
    :ivar policy_name: Specifies the policy name which is used for protection.
    :vartype policy_name: str
    :ivar registration_status: Container registration status.
    :vartype registration_status: str
    """

    _attribute_map = {
        "protection_status": {"key": "protectionStatus", "type": "str"},
        "vault_id": {"key": "vaultId", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "protected_item_name": {"key": "protectedItemName", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        protection_status: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        vault_id: Optional[str] = None,
        fabric_name: Optional[Union[str, "_models.FabricName"]] = None,
        container_name: Optional[str] = None,
        protected_item_name: Optional[str] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        policy_name: Optional[str] = None,
        registration_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protection_status: Specifies whether the container is registered or not. Known values
         are: "Invalid", "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        :keyword vault_id: Specifies the arm resource id of the vault.
        :paramtype vault_id: str
        :keyword fabric_name: Specifies the fabric name - Azure or AD. Known values are: "Invalid" and
         "Azure".
        :paramtype fabric_name: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.FabricName
        :keyword container_name: Specifies the product specific container name. E.g.
         iaasvmcontainer;iaasvmcontainer;csname;vmname.
        :paramtype container_name: str
        :keyword protected_item_name: Specifies the product specific ds name. E.g.
         vm;iaasvmcontainer;csname;vmname.
        :paramtype protected_item_name: str
        :keyword error_code: ErrorCode in case of intent failed.
        :paramtype error_code: str
        :keyword error_message: ErrorMessage in case of intent failed.
        :paramtype error_message: str
        :keyword policy_name: Specifies the policy name which is used for protection.
        :paramtype policy_name: str
        :keyword registration_status: Container registration status.
        :paramtype registration_status: str
        """
        super().__init__(**kwargs)
        self.protection_status = protection_status
        self.vault_id = vault_id
        self.fabric_name = fabric_name
        self.container_name = container_name
        self.protected_item_name = protected_item_name
        self.error_code = error_code
        self.error_message = error_message
        self.policy_name = policy_name
        self.registration_status = registration_status


class BEKDetails(_serialization.Model):
    """BEK is bitlocker encryption key.

    :ivar secret_url: Secret is BEK.
    :vartype secret_url: str
    :ivar secret_vault_id: ID of the Key Vault where this Secret is stored.
    :vartype secret_vault_id: str
    :ivar secret_data: BEK data.
    :vartype secret_data: str
    """

    _attribute_map = {
        "secret_url": {"key": "secretUrl", "type": "str"},
        "secret_vault_id": {"key": "secretVaultId", "type": "str"},
        "secret_data": {"key": "secretData", "type": "str"},
    }

    def __init__(
        self,
        *,
        secret_url: Optional[str] = None,
        secret_vault_id: Optional[str] = None,
        secret_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword secret_url: Secret is BEK.
        :paramtype secret_url: str
        :keyword secret_vault_id: ID of the Key Vault where this Secret is stored.
        :paramtype secret_vault_id: str
        :keyword secret_data: BEK data.
        :paramtype secret_data: str
        """
        super().__init__(**kwargs)
        self.secret_url = secret_url
        self.secret_vault_id = secret_vault_id
        self.secret_data = secret_data


class BMSBackupEngineQueryObject(_serialization.Model):
    """Query parameters to fetch list of backup engines.

    :ivar expand: attribute to add extended info.
    :vartype expand: str
    """

    _attribute_map = {
        "expand": {"key": "expand", "type": "str"},
    }

    def __init__(self, *, expand: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword expand: attribute to add extended info.
        :paramtype expand: str
        """
        super().__init__(**kwargs)
        self.expand = expand


class BMSBackupEnginesQueryObject(_serialization.Model):
    """Query parameters to fetch list of backup engines.

    :ivar backup_management_type: Backup management type for the backup engine. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar friendly_name: Friendly name of the backup engine.
    :vartype friendly_name: str
    :ivar expand: Attribute to add extended info.
    :vartype expand: str
    """

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "expand": {"key": "expand", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        friendly_name: Optional[str] = None,
        expand: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Backup management type for the backup engine. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword friendly_name: Friendly name of the backup engine.
        :paramtype friendly_name: str
        :keyword expand: Attribute to add extended info.
        :paramtype expand: str
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.friendly_name = friendly_name
        self.expand = expand


class BMSBackupSummariesQueryObject(_serialization.Model):
    """Query parameters to fetch backup summaries.

    :ivar type: Backup management type for this container. Known values are: "Invalid",
     "BackupProtectedItemCountSummary", and "BackupProtectionContainerCountSummary".
    :vartype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.Type
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.Type"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: Backup management type for this container. Known values are: "Invalid",
         "BackupProtectedItemCountSummary", and "BackupProtectionContainerCountSummary".
        :paramtype type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.Type
        """
        super().__init__(**kwargs)
        self.type = type


class BMSContainerQueryObject(_serialization.Model):
    """The query filters that can be used with the list containers API.

    All required parameters must be populated in order to send to Azure.

    :ivar backup_management_type: Backup management type for this container. Required. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar container_type: Type of container for filter. Known values are: "Invalid", "Unknown",
     "IaasVMContainer", "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer",
     "MABContainer", "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer", and "HanaHSRContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ContainerType
    :ivar backup_engine_name: Backup engine name.
    :vartype backup_engine_name: str
    :ivar fabric_name: Fabric name for filter.
    :vartype fabric_name: str
    :ivar status: Status of registration of this container with the Recovery Services Vault.
    :vartype status: str
    :ivar friendly_name: Friendly name of this container.
    :vartype friendly_name: str
    """

    _validation = {
        "backup_management_type": {"required": True},
    }

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "backup_engine_name": {"key": "backupEngineName", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Union[str, "_models.BackupManagementType"],
        container_type: Optional[Union[str, "_models.ContainerType"]] = None,
        backup_engine_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        status: Optional[str] = None,
        friendly_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Backup management type for this container. Required. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword container_type: Type of container for filter. Known values are: "Invalid", "Unknown",
         "IaasVMContainer", "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer",
         "MABContainer", "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
         "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer", and "HanaHSRContainer".
        :paramtype container_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ContainerType
        :keyword backup_engine_name: Backup engine name.
        :paramtype backup_engine_name: str
        :keyword fabric_name: Fabric name for filter.
        :paramtype fabric_name: str
        :keyword status: Status of registration of this container with the Recovery Services Vault.
        :paramtype status: str
        :keyword friendly_name: Friendly name of this container.
        :paramtype friendly_name: str
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.container_type = container_type
        self.backup_engine_name = backup_engine_name
        self.fabric_name = fabric_name
        self.status = status
        self.friendly_name = friendly_name


class BMSContainersInquiryQueryObject(_serialization.Model):
    """The query filters that can be used with the inquire container API.

    :ivar backup_management_type: Backup management type for this container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Workload type for this container. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    """

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Backup management type for this container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword workload_type: Workload type for this container. Known values are: "Invalid", "VM",
         "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
         "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type


class BMSPOQueryObject(_serialization.Model):
    """Filters to list items that can be backed up.

    :ivar backup_management_type: Backup management type. Known values are: "Invalid",
     "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage", "AzureWorkload",
     and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Workload type. Known values are: "Invalid", "VM", "FileFolder",
     "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState", "Client",
     "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", "SAPAseDatabase", and
     "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    :ivar container_name: Full name of the container whose Protectable Objects should be returned.
    :vartype container_name: str
    :ivar status: Backup status query parameter.
    :vartype status: str
    :ivar friendly_name: Friendly name.
    :vartype friendly_name: str
    """

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        container_name: Optional[str] = None,
        status: Optional[str] = None,
        friendly_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Backup management type. Known values are: "Invalid",
         "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage", "AzureWorkload",
         and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword workload_type: Workload type. Known values are: "Invalid", "VM", "FileFolder",
         "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState", "Client",
         "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", "SAPAseDatabase", and
         "SAPHanaDBInstance".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        :keyword container_name: Full name of the container whose Protectable Objects should be
         returned.
        :paramtype container_name: str
        :keyword status: Backup status query parameter.
        :paramtype status: str
        :keyword friendly_name: Friendly name.
        :paramtype friendly_name: str
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_type = workload_type
        self.container_name = container_name
        self.status = status
        self.friendly_name = friendly_name


class BMSRefreshContainersQueryObject(_serialization.Model):
    """The query filters that can be used with the refresh container API.

    :ivar backup_management_type: Backup management type for this container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    """

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
    }

    def __init__(
        self, *, backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Backup management type for this container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type


class BMSRPQueryObject(_serialization.Model):
    """Filters to list backup copies.

    :ivar start_date: Backup copies created after this time.
    :vartype start_date: ~datetime.datetime
    :ivar end_date: Backup copies created before this time.
    :vartype end_date: ~datetime.datetime
    :ivar restore_point_query_type: RestorePoint type. Known values are: "Invalid", "Full", "Log",
     "Differential", "FullAndDifferential", "All", "Incremental", "SnapshotFull", and
     "SnapshotCopyOnlyFull".
    :vartype restore_point_query_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointQueryType
    :ivar extended_info: In Get Recovery Point, it tells whether extended information about
     recovery point is asked.
    :vartype extended_info: bool
    :ivar move_ready_rp_only: Whether the RP can be moved to another tier.
    :vartype move_ready_rp_only: bool
    :ivar include_soft_deleted_rp: Flag to indicate whether Soft Deleted RPs should be
     included/excluded from result.
    :vartype include_soft_deleted_rp: bool
    """

    _attribute_map = {
        "start_date": {"key": "startDate", "type": "iso-8601"},
        "end_date": {"key": "endDate", "type": "iso-8601"},
        "restore_point_query_type": {"key": "restorePointQueryType", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "bool"},
        "move_ready_rp_only": {"key": "moveReadyRPOnly", "type": "bool"},
        "include_soft_deleted_rp": {"key": "includeSoftDeletedRP", "type": "bool"},
    }

    def __init__(
        self,
        *,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        restore_point_query_type: Optional[Union[str, "_models.RestorePointQueryType"]] = None,
        extended_info: Optional[bool] = None,
        move_ready_rp_only: Optional[bool] = None,
        include_soft_deleted_rp: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_date: Backup copies created after this time.
        :paramtype start_date: ~datetime.datetime
        :keyword end_date: Backup copies created before this time.
        :paramtype end_date: ~datetime.datetime
        :keyword restore_point_query_type: RestorePoint type. Known values are: "Invalid", "Full",
         "Log", "Differential", "FullAndDifferential", "All", "Incremental", "SnapshotFull", and
         "SnapshotCopyOnlyFull".
        :paramtype restore_point_query_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestorePointQueryType
        :keyword extended_info: In Get Recovery Point, it tells whether extended information about
         recovery point is asked.
        :paramtype extended_info: bool
        :keyword move_ready_rp_only: Whether the RP can be moved to another tier.
        :paramtype move_ready_rp_only: bool
        :keyword include_soft_deleted_rp: Flag to indicate whether Soft Deleted RPs should be
         included/excluded from result.
        :paramtype include_soft_deleted_rp: bool
        """
        super().__init__(**kwargs)
        self.start_date = start_date
        self.end_date = end_date
        self.restore_point_query_type = restore_point_query_type
        self.extended_info = extended_info
        self.move_ready_rp_only = move_ready_rp_only
        self.include_soft_deleted_rp = include_soft_deleted_rp


class BMSWorkloadItemQueryObject(_serialization.Model):
    """Filters to list items that can be backed up.

    :ivar backup_management_type: Backup management type. Known values are: "Invalid",
     "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage", "AzureWorkload",
     and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_item_type: Workload Item type. Known values are: "Invalid", "SQLInstance",
     "SQLDataBase", "SAPHanaSystem", "SAPHanaDatabase", "SAPAseSystem", "SAPAseDatabase", and
     "SAPHanaDBInstance".
    :vartype workload_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadItemType
    :ivar workload_type: Workload type. Known values are: "Invalid", "VM", "FileFolder",
     "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState", "Client",
     "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", "SAPAseDatabase", and
     "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    :ivar protection_status: Backup status query parameter. Known values are: "Invalid",
     "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
    :vartype protection_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
    """

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_item_type": {"key": "workloadItemType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "protection_status": {"key": "protectionStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        workload_item_type: Optional[Union[str, "_models.WorkloadItemType"]] = None,
        workload_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        protection_status: Optional[Union[str, "_models.ProtectionStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Backup management type. Known values are: "Invalid",
         "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage", "AzureWorkload",
         and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword workload_item_type: Workload Item type. Known values are: "Invalid", "SQLInstance",
         "SQLDataBase", "SAPHanaSystem", "SAPHanaDatabase", "SAPAseSystem", "SAPAseDatabase", and
         "SAPHanaDBInstance".
        :paramtype workload_item_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadItemType
        :keyword workload_type: Workload type. Known values are: "Invalid", "VM", "FileFolder",
         "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState", "Client",
         "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase", "SAPAseDatabase", and
         "SAPHanaDBInstance".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        :keyword protection_status: Backup status query parameter. Known values are: "Invalid",
         "NotProtected", "Protecting", "Protected", and "ProtectionFailed".
        :paramtype protection_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionStatus
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.workload_item_type = workload_item_type
        self.workload_type = workload_type
        self.protection_status = protection_status


class ClientDiscoveryDisplay(_serialization.Model):
    """Localized display information of an operation.

    :ivar provider: Name of the provider for display purposes.
    :vartype provider: str
    :ivar resource: ResourceType for which this Operation can be performed.
    :vartype resource: str
    :ivar operation: Operations Name itself.
    :vartype operation: str
    :ivar description: Description of the operation having details of what operation is about.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Name of the provider for display purposes.
        :paramtype provider: str
        :keyword resource: ResourceType for which this Operation can be performed.
        :paramtype resource: str
        :keyword operation: Operations Name itself.
        :paramtype operation: str
        :keyword description: Description of the operation having details of what operation is about.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class ClientDiscoveryForLogSpecification(_serialization.Model):
    """Class to represent shoebox log specification in json client discovery.

    :ivar name: Name for shoebox log specification.
    :vartype name: str
    :ivar display_name: Localized display name.
    :vartype display_name: str
    :ivar blob_duration: blob duration of shoebox log specification.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name for shoebox log specification.
        :paramtype name: str
        :keyword display_name: Localized display name.
        :paramtype display_name: str
        :keyword blob_duration: blob duration of shoebox log specification.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ClientDiscoveryForProperties(_serialization.Model):
    """Class to represent shoebox properties in json client discovery.

    :ivar service_specification: Operation properties.
    :vartype service_specification:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryForServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ClientDiscoveryForServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ClientDiscoveryForServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: Operation properties.
        :paramtype service_specification:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryForServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class ClientDiscoveryForServiceSpecification(_serialization.Model):
    """Class to represent shoebox service specification in json client discovery.

    :ivar log_specifications: List of log specifications of this operation.
    :vartype log_specifications:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryForLogSpecification]
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[ClientDiscoveryForLogSpecification]"},
    }

    def __init__(
        self, *, log_specifications: Optional[List["_models.ClientDiscoveryForLogSpecification"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword log_specifications: List of log specifications of this operation.
        :paramtype log_specifications:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryForLogSpecification]
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications


class ClientDiscoveryResponse(_serialization.Model):
    """Operations List response which contains list of available APIs.

    :ivar value: List of available operations.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryValueForSingleApi]
    :ivar next_link: Link to the next chunk of Response.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ClientDiscoveryValueForSingleApi]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ClientDiscoveryValueForSingleApi"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of available operations.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryValueForSingleApi]
        :keyword next_link: Link to the next chunk of Response.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ClientDiscoveryValueForSingleApi(_serialization.Model):
    """Available operation details.

    :ivar name: Name of the Operation.
    :vartype name: str
    :ivar display: Contains the localized display information for this particular operation.
    :vartype display: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryDisplay
    :ivar origin: The intended executor of the operation;governs the display of the operation in
     the RBAC UX and the audit logs UX.
    :vartype origin: str
    :ivar properties: ShoeBox properties for the given operation.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryForProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "ClientDiscoveryDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "ClientDiscoveryForProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display: Optional["_models.ClientDiscoveryDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.ClientDiscoveryForProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the Operation.
        :paramtype name: str
        :keyword display: Contains the localized display information for this particular operation.
        :paramtype display:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryDisplay
        :keyword origin: The intended executor of the operation;governs the display of the operation in
         the RBAC UX and the audit logs UX.
        :paramtype origin: str
        :keyword properties: ShoeBox properties for the given operation.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientDiscoveryForProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.display = display
        self.origin = origin
        self.properties = properties


class ClientScriptForConnect(_serialization.Model):
    """Client script details for file / folder restore.

    :ivar script_content: File content of the client script for file / folder restore.
    :vartype script_content: str
    :ivar script_extension: File extension of the client script for file / folder restore - .ps1 ,
     .sh , etc.
    :vartype script_extension: str
    :ivar os_type: OS type - Windows, Linux etc. for which this file / folder restore client script
     works.
    :vartype os_type: str
    :ivar url: URL of Executable from where to source the content. If this is not null then
     ScriptContent should not be used.
    :vartype url: str
    :ivar script_name_suffix: Mandatory suffix that should be added to the name of script that is
     given for download to user.
     If its null or empty then , ignore it.
    :vartype script_name_suffix: str
    """

    _attribute_map = {
        "script_content": {"key": "scriptContent", "type": "str"},
        "script_extension": {"key": "scriptExtension", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "url": {"key": "url", "type": "str"},
        "script_name_suffix": {"key": "scriptNameSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        script_content: Optional[str] = None,
        script_extension: Optional[str] = None,
        os_type: Optional[str] = None,
        url: Optional[str] = None,
        script_name_suffix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword script_content: File content of the client script for file / folder restore.
        :paramtype script_content: str
        :keyword script_extension: File extension of the client script for file / folder restore - .ps1
         , .sh , etc.
        :paramtype script_extension: str
        :keyword os_type: OS type - Windows, Linux etc. for which this file / folder restore client
         script works.
        :paramtype os_type: str
        :keyword url: URL of Executable from where to source the content. If this is not null then
         ScriptContent should not be used.
        :paramtype url: str
        :keyword script_name_suffix: Mandatory suffix that should be added to the name of script that
         is given for download to user.
         If its null or empty then , ignore it.
        :paramtype script_name_suffix: str
        """
        super().__init__(**kwargs)
        self.script_content = script_content
        self.script_extension = script_extension
        self.os_type = os_type
        self.url = url
        self.script_name_suffix = script_name_suffix


class CloudErrorBody(_serialization.Model):
    """An error response from the Container Instance service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.recoveryservicesbackup.activestamp.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ContainerIdentityInfo(_serialization.Model):
    """Container identity information.

    :ivar unique_name: Unique name of the container.
    :vartype unique_name: str
    :ivar aad_tenant_id: Protection container identity - AAD Tenant.
    :vartype aad_tenant_id: str
    :ivar service_principal_client_id: Protection container identity - AAD Service Principal.
    :vartype service_principal_client_id: str
    :ivar audience: Protection container identity - Audience.
    :vartype audience: str
    """

    _attribute_map = {
        "unique_name": {"key": "uniqueName", "type": "str"},
        "aad_tenant_id": {"key": "aadTenantId", "type": "str"},
        "service_principal_client_id": {"key": "servicePrincipalClientId", "type": "str"},
        "audience": {"key": "audience", "type": "str"},
    }

    def __init__(
        self,
        *,
        unique_name: Optional[str] = None,
        aad_tenant_id: Optional[str] = None,
        service_principal_client_id: Optional[str] = None,
        audience: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword unique_name: Unique name of the container.
        :paramtype unique_name: str
        :keyword aad_tenant_id: Protection container identity - AAD Tenant.
        :paramtype aad_tenant_id: str
        :keyword service_principal_client_id: Protection container identity - AAD Service Principal.
        :paramtype service_principal_client_id: str
        :keyword audience: Protection container identity - Audience.
        :paramtype audience: str
        """
        super().__init__(**kwargs)
        self.unique_name = unique_name
        self.aad_tenant_id = aad_tenant_id
        self.service_principal_client_id = service_principal_client_id
        self.audience = audience


class DailyRetentionFormat(_serialization.Model):
    """Daily retention format.

    :ivar days_of_the_month: List of days of the month.
    :vartype days_of_the_month: list[~azure.mgmt.recoveryservicesbackup.activestamp.models.Day]
    """

    _attribute_map = {
        "days_of_the_month": {"key": "daysOfTheMonth", "type": "[Day]"},
    }

    def __init__(self, *, days_of_the_month: Optional[List["_models.Day"]] = None, **kwargs: Any) -> None:
        """
        :keyword days_of_the_month: List of days of the month.
        :paramtype days_of_the_month: list[~azure.mgmt.recoveryservicesbackup.activestamp.models.Day]
        """
        super().__init__(**kwargs)
        self.days_of_the_month = days_of_the_month


class DailyRetentionSchedule(_serialization.Model):
    """Daily retention schedule.

    :ivar retention_times: Retention times of retention policy.
    :vartype retention_times: list[~datetime.datetime]
    :ivar retention_duration: Retention duration of retention Policy.
    :vartype retention_duration:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionDuration
    """

    _attribute_map = {
        "retention_times": {"key": "retentionTimes", "type": "[iso-8601]"},
        "retention_duration": {"key": "retentionDuration", "type": "RetentionDuration"},
    }

    def __init__(
        self,
        *,
        retention_times: Optional[List[datetime.datetime]] = None,
        retention_duration: Optional["_models.RetentionDuration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword retention_times: Retention times of retention policy.
        :paramtype retention_times: list[~datetime.datetime]
        :keyword retention_duration: Retention duration of retention Policy.
        :paramtype retention_duration:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionDuration
        """
        super().__init__(**kwargs)
        self.retention_times = retention_times
        self.retention_duration = retention_duration


class DailySchedule(_serialization.Model):
    """DailySchedule.

    :ivar schedule_run_times: List of times of day this schedule has to be run.
    :vartype schedule_run_times: list[~datetime.datetime]
    """

    _attribute_map = {
        "schedule_run_times": {"key": "scheduleRunTimes", "type": "[iso-8601]"},
    }

    def __init__(self, *, schedule_run_times: Optional[List[datetime.datetime]] = None, **kwargs: Any) -> None:
        """
        :keyword schedule_run_times: List of times of day this schedule has to be run.
        :paramtype schedule_run_times: list[~datetime.datetime]
        """
        super().__init__(**kwargs)
        self.schedule_run_times = schedule_run_times


class Day(_serialization.Model):
    """Day of the week.

    :ivar date: Date of the month.
    :vartype date: int
    :ivar is_last: Whether Date is last date of month.
    :vartype is_last: bool
    """

    _attribute_map = {
        "date": {"key": "date", "type": "int"},
        "is_last": {"key": "isLast", "type": "bool"},
    }

    def __init__(self, *, date: Optional[int] = None, is_last: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword date: Date of the month.
        :paramtype date: int
        :keyword is_last: Whether Date is last date of month.
        :paramtype is_last: bool
        """
        super().__init__(**kwargs)
        self.date = date
        self.is_last = is_last


class DiskExclusionProperties(_serialization.Model):
    """DiskExclusionProperties.

    :ivar disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
    :vartype disk_lun_list: list[int]
    :ivar is_inclusion_list: Flag to indicate whether DiskLunList is to be included/ excluded from
     backup.
    :vartype is_inclusion_list: bool
    """

    _attribute_map = {
        "disk_lun_list": {"key": "diskLunList", "type": "[int]"},
        "is_inclusion_list": {"key": "isInclusionList", "type": "bool"},
    }

    def __init__(
        self, *, disk_lun_list: Optional[List[int]] = None, is_inclusion_list: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword disk_lun_list: List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
        :paramtype disk_lun_list: list[int]
        :keyword is_inclusion_list: Flag to indicate whether DiskLunList is to be included/ excluded
         from backup.
        :paramtype is_inclusion_list: bool
        """
        super().__init__(**kwargs)
        self.disk_lun_list = disk_lun_list
        self.is_inclusion_list = is_inclusion_list


class DiskInformation(_serialization.Model):
    """Disk information.

    :ivar lun:
    :vartype lun: int
    :ivar name:
    :vartype name: str
    """

    _attribute_map = {
        "lun": {"key": "lun", "type": "int"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, lun: Optional[int] = None, name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword lun:
        :paramtype lun: int
        :keyword name:
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.lun = lun
        self.name = name


class DistributedNodesInfo(_serialization.Model):
    """This is used to represent the various nodes of the distributed container.

    :ivar node_name: Name of the node under a distributed container.
    :vartype node_name: str
    :ivar status: Status of this Node.
     Failed | Succeeded.
    :vartype status: str
    :ivar error_detail: Error Details if the Status is non-success.
    :vartype error_detail: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
    """

    _attribute_map = {
        "node_name": {"key": "nodeName", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "error_detail": {"key": "errorDetail", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        node_name: Optional[str] = None,
        status: Optional[str] = None,
        error_detail: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword node_name: Name of the node under a distributed container.
        :paramtype node_name: str
        :keyword status: Status of this Node.
         Failed | Succeeded.
        :paramtype status: str
        :keyword error_detail: Error Details if the Status is non-success.
        :paramtype error_detail: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.node_name = node_name
        self.status = status
        self.error_detail = error_detail


class DpmBackupEngine(BackupEngineBase):  # pylint: disable=too-many-instance-attributes
    """Data Protection Manager (DPM) specific backup engine.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the backup engine.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the backup engine. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Registration status of the backup engine with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar backup_engine_state: Status of the backup engine with the Recovery Services Vault. =
     {Active/Deleting/DeleteFailed}.
    :vartype backup_engine_state: str
    :ivar health_status: Backup status of the backup engine.
    :vartype health_status: str
    :ivar backup_engine_type: Type of the backup engine. Required. Known values are: "Invalid",
     "DpmBackupEngine", and "AzureBackupServerEngine".
    :vartype backup_engine_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineType
    :ivar can_re_register: Flag indicating if the backup engine be registered, once already
     registered.
    :vartype can_re_register: bool
    :ivar backup_engine_id: ID of the backup engine.
    :vartype backup_engine_id: str
    :ivar dpm_version: Backup engine version.
    :vartype dpm_version: str
    :ivar azure_backup_agent_version: Backup agent version.
    :vartype azure_backup_agent_version: str
    :ivar is_azure_backup_agent_upgrade_available: To check if backup agent upgrade available.
    :vartype is_azure_backup_agent_upgrade_available: bool
    :ivar is_dpm_upgrade_available: To check if backup engine upgrade available.
    :vartype is_dpm_upgrade_available: bool
    :ivar extended_info: Extended info of the backupengine.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineExtendedInfo
    """

    _validation = {
        "backup_engine_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "backup_engine_state": {"key": "backupEngineState", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "backup_engine_type": {"key": "backupEngineType", "type": "str"},
        "can_re_register": {"key": "canReRegister", "type": "bool"},
        "backup_engine_id": {"key": "backupEngineId", "type": "str"},
        "dpm_version": {"key": "dpmVersion", "type": "str"},
        "azure_backup_agent_version": {"key": "azureBackupAgentVersion", "type": "str"},
        "is_azure_backup_agent_upgrade_available": {"key": "isAzureBackupAgentUpgradeAvailable", "type": "bool"},
        "is_dpm_upgrade_available": {"key": "isDpmUpgradeAvailable", "type": "bool"},
        "extended_info": {"key": "extendedInfo", "type": "BackupEngineExtendedInfo"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        backup_engine_state: Optional[str] = None,
        health_status: Optional[str] = None,
        can_re_register: Optional[bool] = None,
        backup_engine_id: Optional[str] = None,
        dpm_version: Optional[str] = None,
        azure_backup_agent_version: Optional[str] = None,
        is_azure_backup_agent_upgrade_available: Optional[bool] = None,
        is_dpm_upgrade_available: Optional[bool] = None,
        extended_info: Optional["_models.BackupEngineExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the backup engine.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the backup engine. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Registration status of the backup engine with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword backup_engine_state: Status of the backup engine with the Recovery Services Vault. =
         {Active/Deleting/DeleteFailed}.
        :paramtype backup_engine_state: str
        :keyword health_status: Backup status of the backup engine.
        :paramtype health_status: str
        :keyword can_re_register: Flag indicating if the backup engine be registered, once already
         registered.
        :paramtype can_re_register: bool
        :keyword backup_engine_id: ID of the backup engine.
        :paramtype backup_engine_id: str
        :keyword dpm_version: Backup engine version.
        :paramtype dpm_version: str
        :keyword azure_backup_agent_version: Backup agent version.
        :paramtype azure_backup_agent_version: str
        :keyword is_azure_backup_agent_upgrade_available: To check if backup agent upgrade available.
        :paramtype is_azure_backup_agent_upgrade_available: bool
        :keyword is_dpm_upgrade_available: To check if backup engine upgrade available.
        :paramtype is_dpm_upgrade_available: bool
        :keyword extended_info: Extended info of the backupengine.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupEngineExtendedInfo
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            backup_engine_state=backup_engine_state,
            health_status=health_status,
            can_re_register=can_re_register,
            backup_engine_id=backup_engine_id,
            dpm_version=dpm_version,
            azure_backup_agent_version=azure_backup_agent_version,
            is_azure_backup_agent_upgrade_available=is_azure_backup_agent_upgrade_available,
            is_dpm_upgrade_available=is_dpm_upgrade_available,
            extended_info=extended_info,
            **kwargs
        )
        self.backup_engine_type: str = "DpmBackupEngine"


class DPMContainerExtendedInfo(_serialization.Model):
    """Additional information of the DPMContainer.

    :ivar last_refreshed_at: Last refresh time of the DPMContainer.
    :vartype last_refreshed_at: ~datetime.datetime
    """

    _attribute_map = {
        "last_refreshed_at": {"key": "lastRefreshedAt", "type": "iso-8601"},
    }

    def __init__(self, *, last_refreshed_at: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword last_refreshed_at: Last refresh time of the DPMContainer.
        :paramtype last_refreshed_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.last_refreshed_at = last_refreshed_at


class DpmErrorInfo(_serialization.Model):
    """DPM workload-specific error information.

    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations for above error code.
    :vartype recommendations: list[str]
    """

    _attribute_map = {
        "error_string": {"key": "errorString", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(
        self, *, error_string: Optional[str] = None, recommendations: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword error_string: Localized error string.
        :paramtype error_string: str
        :keyword recommendations: List of localized recommendations for above error code.
        :paramtype recommendations: list[str]
        """
        super().__init__(**kwargs)
        self.error_string = error_string
        self.recommendations = recommendations


class DpmJob(Job):  # pylint: disable=too-many-instance-attributes
    """DPM workload-specific job object.

    All required parameters must be populated in order to send to Azure.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar duration: Time elapsed for job.
    :vartype duration: ~datetime.timedelta
    :ivar dpm_server_name: DPM server name managing the backup item or backup job.
    :vartype dpm_server_name: str
    :ivar container_name: Name of cluster/server protecting current backup item, if any.
    :vartype container_name: str
    :ivar container_type: Type of container.
    :vartype container_type: str
    :ivar workload_type: Type of backup item.
    :vartype workload_type: str
    :ivar actions_info: The state/actions applicable on this job like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
    :ivar error_details: The errors.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DpmErrorInfo]
    :ivar extended_info: Additional information for this job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DpmJobExtendedInfo
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "dpm_server_name": {"key": "dpmServerName", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "error_details": {"key": "errorDetails", "type": "[DpmErrorInfo]"},
        "extended_info": {"key": "extendedInfo", "type": "DpmJobExtendedInfo"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        dpm_server_name: Optional[str] = None,
        container_name: Optional[str] = None,
        container_type: Optional[str] = None,
        workload_type: Optional[str] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        error_details: Optional[List["_models.DpmErrorInfo"]] = None,
        extended_info: Optional["_models.DpmJobExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword duration: Time elapsed for job.
        :paramtype duration: ~datetime.timedelta
        :keyword dpm_server_name: DPM server name managing the backup item or backup job.
        :paramtype dpm_server_name: str
        :keyword container_name: Name of cluster/server protecting current backup item, if any.
        :paramtype container_name: str
        :keyword container_type: Type of container.
        :paramtype container_type: str
        :keyword workload_type: Type of backup item.
        :paramtype workload_type: str
        :keyword actions_info: The state/actions applicable on this job like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
        :keyword error_details: The errors.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DpmErrorInfo]
        :keyword extended_info: Additional information for this job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DpmJobExtendedInfo
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "DpmJob"
        self.duration = duration
        self.dpm_server_name = dpm_server_name
        self.container_name = container_name
        self.container_type = container_type
        self.workload_type = workload_type
        self.actions_info = actions_info
        self.error_details = error_details
        self.extended_info = extended_info


class DpmJobExtendedInfo(_serialization.Model):
    """Additional information on the DPM workload-specific job.

    :ivar tasks_list: List of tasks associated with this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DpmJobTaskDetails]
    :ivar property_bag: The job properties.
    :vartype property_bag: dict[str, str]
    :ivar dynamic_error_message: Non localized error message on job execution.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[DpmJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.DpmJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks associated with this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DpmJobTaskDetails]
        :keyword property_bag: The job properties.
        :paramtype property_bag: dict[str, str]
        :keyword dynamic_error_message: Non localized error message on job execution.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class DpmJobTaskDetails(_serialization.Model):
    """DPM workload-specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar duration: Time elapsed for task.
    :vartype duration: ~datetime.timedelta
    :ivar status: The status.
    :vartype status: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "duration": {"key": "duration", "type": "duration"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        task_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        duration: Optional[datetime.timedelta] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword duration: Time elapsed for task.
        :paramtype duration: ~datetime.timedelta
        :keyword status: The status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.status = status


class DPMProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Additional information on Backup engine specific backup item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the managed item.
    :vartype friendly_name: str
    :ivar backup_engine_name: Backup Management server protecting this backup item.
    :vartype backup_engine_name: str
    :ivar protection_state: Protection state of the backup engine. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemState
    :ivar extended_info: Extended info of the backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DPMProtectedItemExtendedInfo
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_engine_name": {"key": "backupEngineName", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "DPMProtectedItemExtendedInfo"},
    }

    def __init__(
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        friendly_name: Optional[str] = None,
        backup_engine_name: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectedItemState"]] = None,
        extended_info: Optional["_models.DPMProtectedItemExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword friendly_name: Friendly name of the managed item.
        :paramtype friendly_name: str
        :keyword backup_engine_name: Backup Management server protecting this backup item.
        :paramtype backup_engine_name: str
        :keyword protection_state: Protection state of the backup engine. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemState
        :keyword extended_info: Extended info of the backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DPMProtectedItemExtendedInfo
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            **kwargs
        )
        self.protected_item_type: str = "DPMProtectedItem"
        self.friendly_name = friendly_name
        self.backup_engine_name = backup_engine_name
        self.protection_state = protection_state
        self.extended_info = extended_info


class DPMProtectedItemExtendedInfo(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Additional information of DPM Protected item.

    :ivar protectable_object_load_path: Attribute to provide information on various DBs.
    :vartype protectable_object_load_path: dict[str, str]
    :ivar protected: To check if backup item is disk protected.
    :vartype protected: bool
    :ivar is_present_on_cloud: To check if backup item is cloud protected.
    :vartype is_present_on_cloud: bool
    :ivar last_backup_status: Last backup status information on backup item.
    :vartype last_backup_status: str
    :ivar last_refreshed_at: Last refresh time on backup item.
    :vartype last_refreshed_at: ~datetime.datetime
    :ivar oldest_recovery_point: Oldest cloud recovery point time.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: cloud recovery point count.
    :vartype recovery_point_count: int
    :ivar on_premise_oldest_recovery_point: Oldest disk recovery point time.
    :vartype on_premise_oldest_recovery_point: ~datetime.datetime
    :ivar on_premise_latest_recovery_point: latest disk recovery point time.
    :vartype on_premise_latest_recovery_point: ~datetime.datetime
    :ivar on_premise_recovery_point_count: disk recovery point count.
    :vartype on_premise_recovery_point_count: int
    :ivar is_collocated: To check if backup item is collocated.
    :vartype is_collocated: bool
    :ivar protection_group_name: Protection group name of the backup item.
    :vartype protection_group_name: str
    :ivar disk_storage_used_in_bytes: Used Disk storage in bytes.
    :vartype disk_storage_used_in_bytes: str
    :ivar total_disk_storage_size_in_bytes: total Disk storage in bytes.
    :vartype total_disk_storage_size_in_bytes: str
    """

    _attribute_map = {
        "protectable_object_load_path": {"key": "protectableObjectLoadPath", "type": "{str}"},
        "protected": {"key": "protected", "type": "bool"},
        "is_present_on_cloud": {"key": "isPresentOnCloud", "type": "bool"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_refreshed_at": {"key": "lastRefreshedAt", "type": "iso-8601"},
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
        "on_premise_oldest_recovery_point": {"key": "onPremiseOldestRecoveryPoint", "type": "iso-8601"},
        "on_premise_latest_recovery_point": {"key": "onPremiseLatestRecoveryPoint", "type": "iso-8601"},
        "on_premise_recovery_point_count": {"key": "onPremiseRecoveryPointCount", "type": "int"},
        "is_collocated": {"key": "isCollocated", "type": "bool"},
        "protection_group_name": {"key": "protectionGroupName", "type": "str"},
        "disk_storage_used_in_bytes": {"key": "diskStorageUsedInBytes", "type": "str"},
        "total_disk_storage_size_in_bytes": {"key": "totalDiskStorageSizeInBytes", "type": "str"},
    }

    def __init__(
        self,
        *,
        protectable_object_load_path: Optional[Dict[str, str]] = None,
        protected: Optional[bool] = None,
        is_present_on_cloud: Optional[bool] = None,
        last_backup_status: Optional[str] = None,
        last_refreshed_at: Optional[datetime.datetime] = None,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        on_premise_oldest_recovery_point: Optional[datetime.datetime] = None,
        on_premise_latest_recovery_point: Optional[datetime.datetime] = None,
        on_premise_recovery_point_count: Optional[int] = None,
        is_collocated: Optional[bool] = None,
        protection_group_name: Optional[str] = None,
        disk_storage_used_in_bytes: Optional[str] = None,
        total_disk_storage_size_in_bytes: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protectable_object_load_path: Attribute to provide information on various DBs.
        :paramtype protectable_object_load_path: dict[str, str]
        :keyword protected: To check if backup item is disk protected.
        :paramtype protected: bool
        :keyword is_present_on_cloud: To check if backup item is cloud protected.
        :paramtype is_present_on_cloud: bool
        :keyword last_backup_status: Last backup status information on backup item.
        :paramtype last_backup_status: str
        :keyword last_refreshed_at: Last refresh time on backup item.
        :paramtype last_refreshed_at: ~datetime.datetime
        :keyword oldest_recovery_point: Oldest cloud recovery point time.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: cloud recovery point count.
        :paramtype recovery_point_count: int
        :keyword on_premise_oldest_recovery_point: Oldest disk recovery point time.
        :paramtype on_premise_oldest_recovery_point: ~datetime.datetime
        :keyword on_premise_latest_recovery_point: latest disk recovery point time.
        :paramtype on_premise_latest_recovery_point: ~datetime.datetime
        :keyword on_premise_recovery_point_count: disk recovery point count.
        :paramtype on_premise_recovery_point_count: int
        :keyword is_collocated: To check if backup item is collocated.
        :paramtype is_collocated: bool
        :keyword protection_group_name: Protection group name of the backup item.
        :paramtype protection_group_name: str
        :keyword disk_storage_used_in_bytes: Used Disk storage in bytes.
        :paramtype disk_storage_used_in_bytes: str
        :keyword total_disk_storage_size_in_bytes: total Disk storage in bytes.
        :paramtype total_disk_storage_size_in_bytes: str
        """
        super().__init__(**kwargs)
        self.protectable_object_load_path = protectable_object_load_path
        self.protected = protected
        self.is_present_on_cloud = is_present_on_cloud
        self.last_backup_status = last_backup_status
        self.last_refreshed_at = last_refreshed_at
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count
        self.on_premise_oldest_recovery_point = on_premise_oldest_recovery_point
        self.on_premise_latest_recovery_point = on_premise_latest_recovery_point
        self.on_premise_recovery_point_count = on_premise_recovery_point_count
        self.is_collocated = is_collocated
        self.protection_group_name = protection_group_name
        self.disk_storage_used_in_bytes = disk_storage_used_in_bytes
        self.total_disk_storage_size_in_bytes = total_disk_storage_size_in_bytes


class EncryptionDetails(_serialization.Model):
    """Details needed if the VM was encrypted at the time of backup.

    :ivar encryption_enabled: Identifies whether this backup copy represents an encrypted VM at the
     time of backup.
    :vartype encryption_enabled: bool
    :ivar kek_url: Key Url.
    :vartype kek_url: str
    :ivar secret_key_url: Secret Url.
    :vartype secret_key_url: str
    :ivar kek_vault_id: ID of Key Vault where KEK is stored.
    :vartype kek_vault_id: str
    :ivar secret_key_vault_id: ID of Key Vault where Secret is stored.
    :vartype secret_key_vault_id: str
    """

    _attribute_map = {
        "encryption_enabled": {"key": "encryptionEnabled", "type": "bool"},
        "kek_url": {"key": "kekUrl", "type": "str"},
        "secret_key_url": {"key": "secretKeyUrl", "type": "str"},
        "kek_vault_id": {"key": "kekVaultId", "type": "str"},
        "secret_key_vault_id": {"key": "secretKeyVaultId", "type": "str"},
    }

    def __init__(
        self,
        *,
        encryption_enabled: Optional[bool] = None,
        kek_url: Optional[str] = None,
        secret_key_url: Optional[str] = None,
        kek_vault_id: Optional[str] = None,
        secret_key_vault_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword encryption_enabled: Identifies whether this backup copy represents an encrypted VM at
         the time of backup.
        :paramtype encryption_enabled: bool
        :keyword kek_url: Key Url.
        :paramtype kek_url: str
        :keyword secret_key_url: Secret Url.
        :paramtype secret_key_url: str
        :keyword kek_vault_id: ID of Key Vault where KEK is stored.
        :paramtype kek_vault_id: str
        :keyword secret_key_vault_id: ID of Key Vault where Secret is stored.
        :paramtype secret_key_vault_id: str
        """
        super().__init__(**kwargs)
        self.encryption_enabled = encryption_enabled
        self.kek_url = kek_url
        self.secret_key_url = secret_key_url
        self.kek_vault_id = kek_vault_id
        self.secret_key_vault_id = secret_key_vault_id


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """Error Detail class which encapsulates Code, Message and Recommendations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error Message related to the Code.
    :vartype message: str
    :ivar recommendations: List of recommendation strings.
    :vartype recommendations: list[str]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "recommendations": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.recommendations = None


class OperationResultInfoBase(_serialization.Model):
    """Base class for operation result info.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ExportJobsOperationResultInfo, OperationResultInfo

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "ExportJobsOperationResultInfo": "ExportJobsOperationResultInfo",
            "OperationResultInfo": "OperationResultInfo",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class ExportJobsOperationResultInfo(OperationResultInfoBase):
    """This class is used to send blob details after exporting jobs.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar blob_url: URL of the blob into which the serialized string of list of jobs is exported.
    :vartype blob_url: str
    :ivar blob_sas_key: SAS key to access the blob. It expires in 15 mins.
    :vartype blob_sas_key: str
    :ivar excel_file_blob_url: URL of the blob into which the ExcelFile is uploaded.
    :vartype excel_file_blob_url: str
    :ivar excel_file_blob_sas_key: SAS key to access the blob. It expires in 15 mins.
    :vartype excel_file_blob_sas_key: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "blob_url": {"key": "blobUrl", "type": "str"},
        "blob_sas_key": {"key": "blobSasKey", "type": "str"},
        "excel_file_blob_url": {"key": "excelFileBlobUrl", "type": "str"},
        "excel_file_blob_sas_key": {"key": "excelFileBlobSasKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        blob_url: Optional[str] = None,
        blob_sas_key: Optional[str] = None,
        excel_file_blob_url: Optional[str] = None,
        excel_file_blob_sas_key: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_url: URL of the blob into which the serialized string of list of jobs is
         exported.
        :paramtype blob_url: str
        :keyword blob_sas_key: SAS key to access the blob. It expires in 15 mins.
        :paramtype blob_sas_key: str
        :keyword excel_file_blob_url: URL of the blob into which the ExcelFile is uploaded.
        :paramtype excel_file_blob_url: str
        :keyword excel_file_blob_sas_key: SAS key to access the blob. It expires in 15 mins.
        :paramtype excel_file_blob_sas_key: str
        """
        super().__init__(**kwargs)
        self.object_type: str = "ExportJobsOperationResultInfo"
        self.blob_url = blob_url
        self.blob_sas_key = blob_sas_key
        self.excel_file_blob_url = excel_file_blob_url
        self.excel_file_blob_sas_key = excel_file_blob_sas_key


class ExtendedLocation(_serialization.Model):
    """The extended location of Recovery point where VM was present.

    :ivar name: Name of the extended location.
    :vartype name: str
    :ivar type: Type of the extended location. Possible values include: 'EdgeZone'.
    :vartype type: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Name of the extended location.
        :paramtype name: str
        :keyword type: Type of the extended location. Possible values include: 'EdgeZone'.
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class ExtendedProperties(_serialization.Model):
    """Extended Properties for Azure IaasVM Backup.

    :ivar disk_exclusion_properties: Extended Properties for Disk Exclusion.
    :vartype disk_exclusion_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DiskExclusionProperties
    :ivar linux_vm_application_name: Linux VM name.
    :vartype linux_vm_application_name: str
    """

    _attribute_map = {
        "disk_exclusion_properties": {"key": "diskExclusionProperties", "type": "DiskExclusionProperties"},
        "linux_vm_application_name": {"key": "linuxVmApplicationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        disk_exclusion_properties: Optional["_models.DiskExclusionProperties"] = None,
        linux_vm_application_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword disk_exclusion_properties: Extended Properties for Disk Exclusion.
        :paramtype disk_exclusion_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DiskExclusionProperties
        :keyword linux_vm_application_name: Linux VM name.
        :paramtype linux_vm_application_name: str
        """
        super().__init__(**kwargs)
        self.disk_exclusion_properties = disk_exclusion_properties
        self.linux_vm_application_name = linux_vm_application_name


class GenericContainer(ProtectionContainer):
    """Base class for generic container of backup items.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar fabric_name: Name of the container's fabric.
    :vartype fabric_name: str
    :ivar extended_information: Extended information (not returned in List container API calls).
    :vartype extended_information:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.GenericContainerExtendedInfo
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "extended_information": {"key": "extendedInformation", "type": "GenericContainerExtendedInfo"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        fabric_name: Optional[str] = None,
        extended_information: Optional["_models.GenericContainerExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword fabric_name: Name of the container's fabric.
        :paramtype fabric_name: str
        :keyword extended_information: Extended information (not returned in List container API calls).
        :paramtype extended_information:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.GenericContainerExtendedInfo
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            **kwargs
        )
        self.container_type: str = "GenericContainer"
        self.fabric_name = fabric_name
        self.extended_information = extended_information


class GenericContainerExtendedInfo(_serialization.Model):
    """Container extended information.

    :ivar raw_cert_data: Public key of container cert.
    :vartype raw_cert_data: str
    :ivar container_identity_info: Container identity information.
    :vartype container_identity_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ContainerIdentityInfo
    :ivar service_endpoints: Azure Backup Service Endpoints for the container.
    :vartype service_endpoints: dict[str, str]
    """

    _attribute_map = {
        "raw_cert_data": {"key": "rawCertData", "type": "str"},
        "container_identity_info": {"key": "containerIdentityInfo", "type": "ContainerIdentityInfo"},
        "service_endpoints": {"key": "serviceEndpoints", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        raw_cert_data: Optional[str] = None,
        container_identity_info: Optional["_models.ContainerIdentityInfo"] = None,
        service_endpoints: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword raw_cert_data: Public key of container cert.
        :paramtype raw_cert_data: str
        :keyword container_identity_info: Container identity information.
        :paramtype container_identity_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ContainerIdentityInfo
        :keyword service_endpoints: Azure Backup Service Endpoints for the container.
        :paramtype service_endpoints: dict[str, str]
        """
        super().__init__(**kwargs)
        self.raw_cert_data = raw_cert_data
        self.container_identity_info = container_identity_info
        self.service_endpoints = service_endpoints


class GenericProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """Base class for backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar policy_state: Indicates consistency of policy object and policy applied to this backup
     item.
    :vartype policy_state: str
    :ivar protection_state: Backup state of this backup item. Known values are: "Invalid",
     "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
     "BackupsSuspended".
    :vartype protection_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
    :ivar protected_item_id: Data Plane Service ID of the protected item.
    :vartype protected_item_id: int
    :ivar source_associations: Loosely coupled (type, value) associations (example - parent of a
     protected item).
    :vartype source_associations: dict[str, str]
    :ivar fabric_name: Name of this backup item's fabric.
    :vartype fabric_name: str
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "policy_state": {"key": "policyState", "type": "str"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "protected_item_id": {"key": "protectedItemId", "type": "int"},
        "source_associations": {"key": "sourceAssociations", "type": "{str}"},
        "fabric_name": {"key": "fabricName", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        friendly_name: Optional[str] = None,
        policy_state: Optional[str] = None,
        protection_state: Optional[Union[str, "_models.ProtectionState"]] = None,
        protected_item_id: Optional[int] = None,
        source_associations: Optional[Dict[str, str]] = None,
        fabric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword policy_state: Indicates consistency of policy object and policy applied to this backup
         item.
        :paramtype policy_state: str
        :keyword protection_state: Backup state of this backup item. Known values are: "Invalid",
         "IRPending", "Protected", "ProtectionError", "ProtectionStopped", "ProtectionPaused", and
         "BackupsSuspended".
        :paramtype protection_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionState
        :keyword protected_item_id: Data Plane Service ID of the protected item.
        :paramtype protected_item_id: int
        :keyword source_associations: Loosely coupled (type, value) associations (example - parent of a
         protected item).
        :paramtype source_associations: dict[str, str]
        :keyword fabric_name: Name of this backup item's fabric.
        :paramtype fabric_name: str
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            **kwargs
        )
        self.protected_item_type: str = "GenericProtectedItem"
        self.friendly_name = friendly_name
        self.policy_state = policy_state
        self.protection_state = protection_state
        self.protected_item_id = protected_item_id
        self.source_associations = source_associations
        self.fabric_name = fabric_name


class GenericProtectionPolicy(ProtectionPolicy):
    """Azure VM (Mercury) workload-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_items_count: Number of items associated with this policy.
    :vartype protected_items_count: int
    :ivar backup_management_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype backup_management_type: str
    :ivar resource_guard_operation_requests: ResourceGuard Operation Requests.
    :vartype resource_guard_operation_requests: list[str]
    :ivar sub_protection_policy: List of sub-protection policies which includes schedule and
     retention.
    :vartype sub_protection_policy:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SubProtectionPolicy]
    :ivar time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard
     Time".
    :vartype time_zone: str
    :ivar fabric_name: Name of this policy's fabric.
    :vartype fabric_name: str
    """

    _validation = {
        "backup_management_type": {"required": True},
    }

    _attribute_map = {
        "protected_items_count": {"key": "protectedItemsCount", "type": "int"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "sub_protection_policy": {"key": "subProtectionPolicy", "type": "[SubProtectionPolicy]"},
        "time_zone": {"key": "timeZone", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
    }

    def __init__(
        self,
        *,
        protected_items_count: Optional[int] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        sub_protection_policy: Optional[List["_models.SubProtectionPolicy"]] = None,
        time_zone: Optional[str] = None,
        fabric_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protected_items_count: Number of items associated with this policy.
        :paramtype protected_items_count: int
        :keyword resource_guard_operation_requests: ResourceGuard Operation Requests.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword sub_protection_policy: List of sub-protection policies which includes schedule and
         retention.
        :paramtype sub_protection_policy:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.SubProtectionPolicy]
        :keyword time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific
         Standard Time".
        :paramtype time_zone: str
        :keyword fabric_name: Name of this policy's fabric.
        :paramtype fabric_name: str
        """
        super().__init__(
            protected_items_count=protected_items_count,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.backup_management_type: str = "GenericProtectionPolicy"
        self.sub_protection_policy = sub_protection_policy
        self.time_zone = time_zone
        self.fabric_name = fabric_name


class GenericRecoveryPoint(RecoveryPoint):
    """Generic backup copy.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar friendly_name: Friendly name of the backup copy.
    :vartype friendly_name: str
    :ivar recovery_point_type: Type of the backup copy.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar recovery_point_additional_info: Additional information associated with this backup copy.
    :vartype recovery_point_additional_info: str
    :ivar recovery_point_properties: Properties of Recovery Point.
    :vartype recovery_point_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "recovery_point_additional_info": {"key": "recoveryPointAdditionalInfo", "type": "str"},
        "recovery_point_properties": {"key": "recoveryPointProperties", "type": "RecoveryPointProperties"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        recovery_point_type: Optional[str] = None,
        recovery_point_time: Optional[datetime.datetime] = None,
        recovery_point_additional_info: Optional[str] = None,
        recovery_point_properties: Optional["_models.RecoveryPointProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the backup copy.
        :paramtype friendly_name: str
        :keyword recovery_point_type: Type of the backup copy.
        :paramtype recovery_point_type: str
        :keyword recovery_point_time: Time at which this backup copy was created.
        :paramtype recovery_point_time: ~datetime.datetime
        :keyword recovery_point_additional_info: Additional information associated with this backup
         copy.
        :paramtype recovery_point_additional_info: str
        :keyword recovery_point_properties: Properties of Recovery Point.
        :paramtype recovery_point_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
        """
        super().__init__(**kwargs)
        self.object_type: str = "GenericRecoveryPoint"
        self.friendly_name = friendly_name
        self.recovery_point_type = recovery_point_type
        self.recovery_point_time = recovery_point_time
        self.recovery_point_additional_info = recovery_point_additional_info
        self.recovery_point_properties = recovery_point_properties


class GetProtectedItemQueryObject(_serialization.Model):
    """Filters to list backup items.

    :ivar expand: Specifies if the additional information should be provided for this item.
    :vartype expand: str
    """

    _attribute_map = {
        "expand": {"key": "expand", "type": "str"},
    }

    def __init__(self, *, expand: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword expand: Specifies if the additional information should be provided for this item.
        :paramtype expand: str
        """
        super().__init__(**kwargs)
        self.expand = expand


class HourlySchedule(_serialization.Model):
    """HourlySchedule.

    :ivar interval: Interval at which backup needs to be triggered. For hourly the value
      can be 4/6/8/12.
    :vartype interval: int
    :ivar schedule_window_start_time: To specify start time of the backup window.
    :vartype schedule_window_start_time: ~datetime.datetime
    :ivar schedule_window_duration: To specify duration of the backup window.
    :vartype schedule_window_duration: int
    """

    _attribute_map = {
        "interval": {"key": "interval", "type": "int"},
        "schedule_window_start_time": {"key": "scheduleWindowStartTime", "type": "iso-8601"},
        "schedule_window_duration": {"key": "scheduleWindowDuration", "type": "int"},
    }

    def __init__(
        self,
        *,
        interval: Optional[int] = None,
        schedule_window_start_time: Optional[datetime.datetime] = None,
        schedule_window_duration: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword interval: Interval at which backup needs to be triggered. For hourly the value
          can be 4/6/8/12.
        :paramtype interval: int
        :keyword schedule_window_start_time: To specify start time of the backup window.
        :paramtype schedule_window_start_time: ~datetime.datetime
        :keyword schedule_window_duration: To specify duration of the backup window.
        :paramtype schedule_window_duration: int
        """
        super().__init__(**kwargs)
        self.interval = interval
        self.schedule_window_start_time = schedule_window_start_time
        self.schedule_window_duration = schedule_window_duration


class IaasVMBackupRequest(BackupRequest):
    """IaaS VM workload-specific backup request.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_expiry_time_in_utc: Backup copy will expire after the time specified
     (UTC).
    :vartype recovery_point_expiry_time_in_utc: ~datetime.datetime
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_expiry_time_in_utc": {"key": "recoveryPointExpiryTimeInUTC", "type": "iso-8601"},
    }

    def __init__(self, *, recovery_point_expiry_time_in_utc: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword recovery_point_expiry_time_in_utc: Backup copy will expire after the time specified
         (UTC).
        :paramtype recovery_point_expiry_time_in_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.object_type: str = "IaasVMBackupRequest"
        self.recovery_point_expiry_time_in_utc = recovery_point_expiry_time_in_utc


class IaasVMILRRegistrationRequest(ILRRequest):
    """Restore files/folders from a backup copy of IaaS VM.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_id: ID of the IaaS VM backup copy from where the files/folders have to be
     restored.
    :vartype recovery_point_id: str
    :ivar virtual_machine_id: Fully qualified ARM ID of the virtual machine whose the files /
     folders have to be restored.
    :vartype virtual_machine_id: str
    :ivar initiator_name: iSCSI initiator name.
    :vartype initiator_name: str
    :ivar renew_existing_registration: Whether to renew existing registration with the iSCSI
     server.
    :vartype renew_existing_registration: bool
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "virtual_machine_id": {"key": "virtualMachineId", "type": "str"},
        "initiator_name": {"key": "initiatorName", "type": "str"},
        "renew_existing_registration": {"key": "renewExistingRegistration", "type": "bool"},
    }

    def __init__(
        self,
        *,
        recovery_point_id: Optional[str] = None,
        virtual_machine_id: Optional[str] = None,
        initiator_name: Optional[str] = None,
        renew_existing_registration: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_id: ID of the IaaS VM backup copy from where the files/folders have to
         be restored.
        :paramtype recovery_point_id: str
        :keyword virtual_machine_id: Fully qualified ARM ID of the virtual machine whose the files /
         folders have to be restored.
        :paramtype virtual_machine_id: str
        :keyword initiator_name: iSCSI initiator name.
        :paramtype initiator_name: str
        :keyword renew_existing_registration: Whether to renew existing registration with the iSCSI
         server.
        :paramtype renew_existing_registration: bool
        """
        super().__init__(**kwargs)
        self.object_type: str = "IaasVMILRRegistrationRequest"
        self.recovery_point_id = recovery_point_id
        self.virtual_machine_id = virtual_machine_id
        self.initiator_name = initiator_name
        self.renew_existing_registration = renew_existing_registration


class IaasVMRecoveryPoint(RecoveryPoint):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload specific backup copy.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_type: Type of the backup copy.
    :vartype recovery_point_type: str
    :ivar recovery_point_time: Time at which this backup copy was created.
    :vartype recovery_point_time: ~datetime.datetime
    :ivar recovery_point_additional_info: Additional information associated with this backup copy.
    :vartype recovery_point_additional_info: str
    :ivar source_vm_storage_type: Storage type of the VM whose backup copy is created.
    :vartype source_vm_storage_type: str
    :ivar is_source_vm_encrypted: Identifies whether the VM was encrypted when the backup copy is
     created.
    :vartype is_source_vm_encrypted: bool
    :ivar key_and_secret: Required details for recovering an encrypted VM. Applicable only when
     IsSourceVMEncrypted is true.
    :vartype key_and_secret:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.KeyAndSecretDetails
    :ivar is_instant_ilr_session_active: Is the session to recover items from this backup copy
     still active.
    :vartype is_instant_ilr_session_active: bool
    :ivar recovery_point_tier_details: Recovery point tier information.
    :vartype recovery_point_tier_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
    :ivar is_managed_virtual_machine: Whether VM is with Managed Disks.
    :vartype is_managed_virtual_machine: bool
    :ivar virtual_machine_size: Virtual Machine Size.
    :vartype virtual_machine_size: str
    :ivar original_storage_account_option: Original Storage Account Option.
    :vartype original_storage_account_option: bool
    :ivar os_type: OS type.
    :vartype os_type: str
    :ivar recovery_point_disk_configuration: Disk configuration.
    :vartype recovery_point_disk_configuration:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointDiskConfiguration
    :ivar zones: Identifies the zone of the VM at the time of backup. Applicable only for
     zone-pinned Vms.
    :vartype zones: list[str]
    :ivar recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
    :vartype recovery_point_move_readiness_info: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
    :ivar security_type: Security Type of the Disk.
    :vartype security_type: str
    :ivar recovery_point_properties: Properties of Recovery Point.
    :vartype recovery_point_properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
    :ivar is_private_access_enabled_on_any_disk: This flag denotes if any of the disks in the VM
     are using Private access network setting.
    :vartype is_private_access_enabled_on_any_disk: bool
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_type": {"key": "recoveryPointType", "type": "str"},
        "recovery_point_time": {"key": "recoveryPointTime", "type": "iso-8601"},
        "recovery_point_additional_info": {"key": "recoveryPointAdditionalInfo", "type": "str"},
        "source_vm_storage_type": {"key": "sourceVMStorageType", "type": "str"},
        "is_source_vm_encrypted": {"key": "isSourceVMEncrypted", "type": "bool"},
        "key_and_secret": {"key": "keyAndSecret", "type": "KeyAndSecretDetails"},
        "is_instant_ilr_session_active": {"key": "isInstantIlrSessionActive", "type": "bool"},
        "recovery_point_tier_details": {"key": "recoveryPointTierDetails", "type": "[RecoveryPointTierInformationV2]"},
        "is_managed_virtual_machine": {"key": "isManagedVirtualMachine", "type": "bool"},
        "virtual_machine_size": {"key": "virtualMachineSize", "type": "str"},
        "original_storage_account_option": {"key": "originalStorageAccountOption", "type": "bool"},
        "os_type": {"key": "osType", "type": "str"},
        "recovery_point_disk_configuration": {
            "key": "recoveryPointDiskConfiguration",
            "type": "RecoveryPointDiskConfiguration",
        },
        "zones": {"key": "zones", "type": "[str]"},
        "recovery_point_move_readiness_info": {
            "key": "recoveryPointMoveReadinessInfo",
            "type": "{RecoveryPointMoveReadinessInfo}",
        },
        "security_type": {"key": "securityType", "type": "str"},
        "recovery_point_properties": {"key": "recoveryPointProperties", "type": "RecoveryPointProperties"},
        "is_private_access_enabled_on_any_disk": {"key": "isPrivateAccessEnabledOnAnyDisk", "type": "bool"},
    }

    def __init__(
        self,
        *,
        recovery_point_type: Optional[str] = None,
        recovery_point_time: Optional[datetime.datetime] = None,
        recovery_point_additional_info: Optional[str] = None,
        source_vm_storage_type: Optional[str] = None,
        is_source_vm_encrypted: Optional[bool] = None,
        key_and_secret: Optional["_models.KeyAndSecretDetails"] = None,
        is_instant_ilr_session_active: Optional[bool] = None,
        recovery_point_tier_details: Optional[List["_models.RecoveryPointTierInformationV2"]] = None,
        is_managed_virtual_machine: Optional[bool] = None,
        virtual_machine_size: Optional[str] = None,
        original_storage_account_option: Optional[bool] = None,
        os_type: Optional[str] = None,
        recovery_point_disk_configuration: Optional["_models.RecoveryPointDiskConfiguration"] = None,
        zones: Optional[List[str]] = None,
        recovery_point_move_readiness_info: Optional[Dict[str, "_models.RecoveryPointMoveReadinessInfo"]] = None,
        security_type: Optional[str] = None,
        recovery_point_properties: Optional["_models.RecoveryPointProperties"] = None,
        is_private_access_enabled_on_any_disk: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_type: Type of the backup copy.
        :paramtype recovery_point_type: str
        :keyword recovery_point_time: Time at which this backup copy was created.
        :paramtype recovery_point_time: ~datetime.datetime
        :keyword recovery_point_additional_info: Additional information associated with this backup
         copy.
        :paramtype recovery_point_additional_info: str
        :keyword source_vm_storage_type: Storage type of the VM whose backup copy is created.
        :paramtype source_vm_storage_type: str
        :keyword is_source_vm_encrypted: Identifies whether the VM was encrypted when the backup copy
         is created.
        :paramtype is_source_vm_encrypted: bool
        :keyword key_and_secret: Required details for recovering an encrypted VM. Applicable only when
         IsSourceVMEncrypted is true.
        :paramtype key_and_secret:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.KeyAndSecretDetails
        :keyword is_instant_ilr_session_active: Is the session to recover items from this backup copy
         still active.
        :paramtype is_instant_ilr_session_active: bool
        :keyword recovery_point_tier_details: Recovery point tier information.
        :paramtype recovery_point_tier_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierInformationV2]
        :keyword is_managed_virtual_machine: Whether VM is with Managed Disks.
        :paramtype is_managed_virtual_machine: bool
        :keyword virtual_machine_size: Virtual Machine Size.
        :paramtype virtual_machine_size: str
        :keyword original_storage_account_option: Original Storage Account Option.
        :paramtype original_storage_account_option: bool
        :keyword os_type: OS type.
        :paramtype os_type: str
        :keyword recovery_point_disk_configuration: Disk configuration.
        :paramtype recovery_point_disk_configuration:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointDiskConfiguration
        :keyword zones: Identifies the zone of the VM at the time of backup. Applicable only for
         zone-pinned Vms.
        :paramtype zones: list[str]
        :keyword recovery_point_move_readiness_info: Eligibility of RP to be moved to another tier.
        :paramtype recovery_point_move_readiness_info: dict[str,
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointMoveReadinessInfo]
        :keyword security_type: Security Type of the Disk.
        :paramtype security_type: str
        :keyword recovery_point_properties: Properties of Recovery Point.
        :paramtype recovery_point_properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointProperties
        :keyword is_private_access_enabled_on_any_disk: This flag denotes if any of the disks in the VM
         are using Private access network setting.
        :paramtype is_private_access_enabled_on_any_disk: bool
        """
        super().__init__(**kwargs)
        self.object_type: str = "IaasVMRecoveryPoint"
        self.recovery_point_type = recovery_point_type
        self.recovery_point_time = recovery_point_time
        self.recovery_point_additional_info = recovery_point_additional_info
        self.source_vm_storage_type = source_vm_storage_type
        self.is_source_vm_encrypted = is_source_vm_encrypted
        self.key_and_secret = key_and_secret
        self.is_instant_ilr_session_active = is_instant_ilr_session_active
        self.recovery_point_tier_details = recovery_point_tier_details
        self.is_managed_virtual_machine = is_managed_virtual_machine
        self.virtual_machine_size = virtual_machine_size
        self.original_storage_account_option = original_storage_account_option
        self.os_type = os_type
        self.recovery_point_disk_configuration = recovery_point_disk_configuration
        self.zones = zones
        self.recovery_point_move_readiness_info = recovery_point_move_readiness_info
        self.security_type = security_type
        self.recovery_point_properties = recovery_point_properties
        self.is_private_access_enabled_on_any_disk = is_private_access_enabled_on_any_disk


class IaasVMRestoreRequest(RestoreRequest):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload-specific restore.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    IaasVMRestoreWithRehydrationRequest

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_id: ID of the backup copy to be recovered.
    :vartype recovery_point_id: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM which is being recovered.
    :vartype source_resource_id: str
    :ivar target_virtual_machine_id: This is the complete ARM Id of the VM that will be created.
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar target_resource_group_id: This is the ARM Id of the resource group that you want to
     create for this Virtual machine and other artifacts.
     For e.g. /subscriptions/{subId}/resourcegroups/{rg}.
    :vartype target_resource_group_id: str
    :ivar storage_account_id: Fully qualified ARM ID of the storage account to which the VM has to
     be restored.
    :vartype storage_account_id: str
    :ivar virtual_network_id: This is the virtual network Id of the vnet that will be attached to
     the virtual machine.
     User will be validated for join action permissions in the linked access.
    :vartype virtual_network_id: str
    :ivar subnet_id: Subnet ID, is the subnet ID associated with the to be restored VM. For Classic
     VMs it would be
     {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it would be ARM resource
     ID used to represent
     the subnet.
    :vartype subnet_id: str
    :ivar target_domain_name_id: Fully qualified ARM ID of the domain name to be associated to the
     VM being restored. This applies only to Classic
     Virtual Machines.
    :vartype target_domain_name_id: str
    :ivar region: Region in which the virtual machine is restored.
    :vartype region: str
    :ivar affinity_group: Affinity group associated to VM to be restored. Used only for Classic
     Compute Virtual Machines.
    :vartype affinity_group: str
    :ivar create_new_cloud_service: Should a new cloud service be created while restoring the VM.
     If this is false, VM will be restored to the same
     cloud service as it was at the time of backup.
    :vartype create_new_cloud_service: bool
    :ivar original_storage_account_option: Original Storage Account Option.
    :vartype original_storage_account_option: bool
    :ivar encryption_details: Details needed if the VM was encrypted at the time of backup.
    :vartype encryption_details:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.EncryptionDetails
    :ivar restore_disk_lun_list: List of Disk LUNs for partial restore.
    :vartype restore_disk_lun_list: list[int]
    :ivar restore_with_managed_disks: Flag to denote of an Unmanaged disk VM should be restored
     with Managed disks.
    :vartype restore_with_managed_disks: bool
    :ivar disk_encryption_set_id: DiskEncryptionSet's ID - needed if the VM needs to be encrypted
     at rest during restore with customer managed key.
    :vartype disk_encryption_set_id: str
    :ivar zones: Target zone where the VM and its disks should be restored.
    :vartype zones: list[str]
    :ivar identity_info: Managed Identity information required to access customer storage account.
    :vartype identity_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.IdentityInfo
    :ivar identity_based_restore_details: IaaS VM workload specific restore details for restores
     using managed identity.
    :vartype identity_based_restore_details:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.IdentityBasedRestoreDetails
    :ivar extended_location: Target extended location where the VM should be restored,
     should be null if restore is to be done in public cloud.
    :vartype extended_location:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedLocation
    :ivar secured_vm_details: Stores Secured VM Details.
    :vartype secured_vm_details:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.SecuredVMDetails
    :ivar target_disk_network_access_settings: Specifies target network access settings for disks
     of VM to be restored,.
    :vartype target_disk_network_access_settings:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetDiskNetworkAccessSettings
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "target_resource_group_id": {"key": "targetResourceGroupId", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "virtual_network_id": {"key": "virtualNetworkId", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "target_domain_name_id": {"key": "targetDomainNameId", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "affinity_group": {"key": "affinityGroup", "type": "str"},
        "create_new_cloud_service": {"key": "createNewCloudService", "type": "bool"},
        "original_storage_account_option": {"key": "originalStorageAccountOption", "type": "bool"},
        "encryption_details": {"key": "encryptionDetails", "type": "EncryptionDetails"},
        "restore_disk_lun_list": {"key": "restoreDiskLunList", "type": "[int]"},
        "restore_with_managed_disks": {"key": "restoreWithManagedDisks", "type": "bool"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "identity_info": {"key": "identityInfo", "type": "IdentityInfo"},
        "identity_based_restore_details": {"key": "identityBasedRestoreDetails", "type": "IdentityBasedRestoreDetails"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "secured_vm_details": {"key": "securedVMDetails", "type": "SecuredVMDetails"},
        "target_disk_network_access_settings": {
            "key": "targetDiskNetworkAccessSettings",
            "type": "TargetDiskNetworkAccessSettings",
        },
    }

    _subtype_map = {"object_type": {"IaasVMRestoreWithRehydrationRequest": "IaasVMRestoreWithRehydrationRequest"}}

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        recovery_point_id: Optional[str] = None,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        target_virtual_machine_id: Optional[str] = None,
        target_resource_group_id: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        virtual_network_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        target_domain_name_id: Optional[str] = None,
        region: Optional[str] = None,
        affinity_group: Optional[str] = None,
        create_new_cloud_service: Optional[bool] = None,
        original_storage_account_option: Optional[bool] = None,
        encryption_details: Optional["_models.EncryptionDetails"] = None,
        restore_disk_lun_list: Optional[List[int]] = None,
        restore_with_managed_disks: Optional[bool] = None,
        disk_encryption_set_id: Optional[str] = None,
        zones: Optional[List[str]] = None,
        identity_info: Optional["_models.IdentityInfo"] = None,
        identity_based_restore_details: Optional["_models.IdentityBasedRestoreDetails"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        secured_vm_details: Optional["_models.SecuredVMDetails"] = None,
        target_disk_network_access_settings: Optional["_models.TargetDiskNetworkAccessSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_id: ID of the backup copy to be recovered.
        :paramtype recovery_point_id: str
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM which is being recovered.
        :paramtype source_resource_id: str
        :keyword target_virtual_machine_id: This is the complete ARM Id of the VM that will be created.
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword target_resource_group_id: This is the ARM Id of the resource group that you want to
         create for this Virtual machine and other artifacts.
         For e.g. /subscriptions/{subId}/resourcegroups/{rg}.
        :paramtype target_resource_group_id: str
        :keyword storage_account_id: Fully qualified ARM ID of the storage account to which the VM has
         to be restored.
        :paramtype storage_account_id: str
        :keyword virtual_network_id: This is the virtual network Id of the vnet that will be attached
         to the virtual machine.
         User will be validated for join action permissions in the linked access.
        :paramtype virtual_network_id: str
        :keyword subnet_id: Subnet ID, is the subnet ID associated with the to be restored VM. For
         Classic VMs it would be
         {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it would be ARM resource
         ID used to represent
         the subnet.
        :paramtype subnet_id: str
        :keyword target_domain_name_id: Fully qualified ARM ID of the domain name to be associated to
         the VM being restored. This applies only to Classic
         Virtual Machines.
        :paramtype target_domain_name_id: str
        :keyword region: Region in which the virtual machine is restored.
        :paramtype region: str
        :keyword affinity_group: Affinity group associated to VM to be restored. Used only for Classic
         Compute Virtual Machines.
        :paramtype affinity_group: str
        :keyword create_new_cloud_service: Should a new cloud service be created while restoring the
         VM. If this is false, VM will be restored to the same
         cloud service as it was at the time of backup.
        :paramtype create_new_cloud_service: bool
        :keyword original_storage_account_option: Original Storage Account Option.
        :paramtype original_storage_account_option: bool
        :keyword encryption_details: Details needed if the VM was encrypted at the time of backup.
        :paramtype encryption_details:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.EncryptionDetails
        :keyword restore_disk_lun_list: List of Disk LUNs for partial restore.
        :paramtype restore_disk_lun_list: list[int]
        :keyword restore_with_managed_disks: Flag to denote of an Unmanaged disk VM should be restored
         with Managed disks.
        :paramtype restore_with_managed_disks: bool
        :keyword disk_encryption_set_id: DiskEncryptionSet's ID - needed if the VM needs to be
         encrypted at rest during restore with customer managed key.
        :paramtype disk_encryption_set_id: str
        :keyword zones: Target zone where the VM and its disks should be restored.
        :paramtype zones: list[str]
        :keyword identity_info: Managed Identity information required to access customer storage
         account.
        :paramtype identity_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.IdentityInfo
        :keyword identity_based_restore_details: IaaS VM workload specific restore details for restores
         using managed identity.
        :paramtype identity_based_restore_details:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.IdentityBasedRestoreDetails
        :keyword extended_location: Target extended location where the VM should be restored,
         should be null if restore is to be done in public cloud.
        :paramtype extended_location:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedLocation
        :keyword secured_vm_details: Stores Secured VM Details.
        :paramtype secured_vm_details:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.SecuredVMDetails
        :keyword target_disk_network_access_settings: Specifies target network access settings for
         disks of VM to be restored,.
        :paramtype target_disk_network_access_settings:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetDiskNetworkAccessSettings
        """
        super().__init__(**kwargs)
        self.object_type: str = "IaasVMRestoreRequest"
        self.recovery_point_id = recovery_point_id
        self.recovery_type = recovery_type
        self.source_resource_id = source_resource_id
        self.target_virtual_machine_id = target_virtual_machine_id
        self.target_resource_group_id = target_resource_group_id
        self.storage_account_id = storage_account_id
        self.virtual_network_id = virtual_network_id
        self.subnet_id = subnet_id
        self.target_domain_name_id = target_domain_name_id
        self.region = region
        self.affinity_group = affinity_group
        self.create_new_cloud_service = create_new_cloud_service
        self.original_storage_account_option = original_storage_account_option
        self.encryption_details = encryption_details
        self.restore_disk_lun_list = restore_disk_lun_list
        self.restore_with_managed_disks = restore_with_managed_disks
        self.disk_encryption_set_id = disk_encryption_set_id
        self.zones = zones
        self.identity_info = identity_info
        self.identity_based_restore_details = identity_based_restore_details
        self.extended_location = extended_location
        self.secured_vm_details = secured_vm_details
        self.target_disk_network_access_settings = target_disk_network_access_settings


class IaasVMRestoreWithRehydrationRequest(IaasVMRestoreRequest):  # pylint: disable=too-many-instance-attributes
    """IaaS VM workload-specific restore with integrated rehydration of recovery point.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_point_id: ID of the backup copy to be recovered.
    :vartype recovery_point_id: str
    :ivar recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
     "AlternateLocation", "RestoreDisks", and "Offline".
    :vartype recovery_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
    :ivar source_resource_id: Fully qualified ARM ID of the VM which is being recovered.
    :vartype source_resource_id: str
    :ivar target_virtual_machine_id: This is the complete ARM Id of the VM that will be created.
     For e.g.
     /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
    :vartype target_virtual_machine_id: str
    :ivar target_resource_group_id: This is the ARM Id of the resource group that you want to
     create for this Virtual machine and other artifacts.
     For e.g. /subscriptions/{subId}/resourcegroups/{rg}.
    :vartype target_resource_group_id: str
    :ivar storage_account_id: Fully qualified ARM ID of the storage account to which the VM has to
     be restored.
    :vartype storage_account_id: str
    :ivar virtual_network_id: This is the virtual network Id of the vnet that will be attached to
     the virtual machine.
     User will be validated for join action permissions in the linked access.
    :vartype virtual_network_id: str
    :ivar subnet_id: Subnet ID, is the subnet ID associated with the to be restored VM. For Classic
     VMs it would be
     {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it would be ARM resource
     ID used to represent
     the subnet.
    :vartype subnet_id: str
    :ivar target_domain_name_id: Fully qualified ARM ID of the domain name to be associated to the
     VM being restored. This applies only to Classic
     Virtual Machines.
    :vartype target_domain_name_id: str
    :ivar region: Region in which the virtual machine is restored.
    :vartype region: str
    :ivar affinity_group: Affinity group associated to VM to be restored. Used only for Classic
     Compute Virtual Machines.
    :vartype affinity_group: str
    :ivar create_new_cloud_service: Should a new cloud service be created while restoring the VM.
     If this is false, VM will be restored to the same
     cloud service as it was at the time of backup.
    :vartype create_new_cloud_service: bool
    :ivar original_storage_account_option: Original Storage Account Option.
    :vartype original_storage_account_option: bool
    :ivar encryption_details: Details needed if the VM was encrypted at the time of backup.
    :vartype encryption_details:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.EncryptionDetails
    :ivar restore_disk_lun_list: List of Disk LUNs for partial restore.
    :vartype restore_disk_lun_list: list[int]
    :ivar restore_with_managed_disks: Flag to denote of an Unmanaged disk VM should be restored
     with Managed disks.
    :vartype restore_with_managed_disks: bool
    :ivar disk_encryption_set_id: DiskEncryptionSet's ID - needed if the VM needs to be encrypted
     at rest during restore with customer managed key.
    :vartype disk_encryption_set_id: str
    :ivar zones: Target zone where the VM and its disks should be restored.
    :vartype zones: list[str]
    :ivar identity_info: Managed Identity information required to access customer storage account.
    :vartype identity_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.IdentityInfo
    :ivar identity_based_restore_details: IaaS VM workload specific restore details for restores
     using managed identity.
    :vartype identity_based_restore_details:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.IdentityBasedRestoreDetails
    :ivar extended_location: Target extended location where the VM should be restored,
     should be null if restore is to be done in public cloud.
    :vartype extended_location:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedLocation
    :ivar secured_vm_details: Stores Secured VM Details.
    :vartype secured_vm_details:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.SecuredVMDetails
    :ivar target_disk_network_access_settings: Specifies target network access settings for disks
     of VM to be restored,.
    :vartype target_disk_network_access_settings:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetDiskNetworkAccessSettings
    :ivar recovery_point_rehydration_info: RP Rehydration Info.
    :vartype recovery_point_rehydration_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_point_id": {"key": "recoveryPointId", "type": "str"},
        "recovery_type": {"key": "recoveryType", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "target_virtual_machine_id": {"key": "targetVirtualMachineId", "type": "str"},
        "target_resource_group_id": {"key": "targetResourceGroupId", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
        "virtual_network_id": {"key": "virtualNetworkId", "type": "str"},
        "subnet_id": {"key": "subnetId", "type": "str"},
        "target_domain_name_id": {"key": "targetDomainNameId", "type": "str"},
        "region": {"key": "region", "type": "str"},
        "affinity_group": {"key": "affinityGroup", "type": "str"},
        "create_new_cloud_service": {"key": "createNewCloudService", "type": "bool"},
        "original_storage_account_option": {"key": "originalStorageAccountOption", "type": "bool"},
        "encryption_details": {"key": "encryptionDetails", "type": "EncryptionDetails"},
        "restore_disk_lun_list": {"key": "restoreDiskLunList", "type": "[int]"},
        "restore_with_managed_disks": {"key": "restoreWithManagedDisks", "type": "bool"},
        "disk_encryption_set_id": {"key": "diskEncryptionSetId", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "identity_info": {"key": "identityInfo", "type": "IdentityInfo"},
        "identity_based_restore_details": {"key": "identityBasedRestoreDetails", "type": "IdentityBasedRestoreDetails"},
        "extended_location": {"key": "extendedLocation", "type": "ExtendedLocation"},
        "secured_vm_details": {"key": "securedVMDetails", "type": "SecuredVMDetails"},
        "target_disk_network_access_settings": {
            "key": "targetDiskNetworkAccessSettings",
            "type": "TargetDiskNetworkAccessSettings",
        },
        "recovery_point_rehydration_info": {
            "key": "recoveryPointRehydrationInfo",
            "type": "RecoveryPointRehydrationInfo",
        },
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        recovery_point_id: Optional[str] = None,
        recovery_type: Optional[Union[str, "_models.RecoveryType"]] = None,
        source_resource_id: Optional[str] = None,
        target_virtual_machine_id: Optional[str] = None,
        target_resource_group_id: Optional[str] = None,
        storage_account_id: Optional[str] = None,
        virtual_network_id: Optional[str] = None,
        subnet_id: Optional[str] = None,
        target_domain_name_id: Optional[str] = None,
        region: Optional[str] = None,
        affinity_group: Optional[str] = None,
        create_new_cloud_service: Optional[bool] = None,
        original_storage_account_option: Optional[bool] = None,
        encryption_details: Optional["_models.EncryptionDetails"] = None,
        restore_disk_lun_list: Optional[List[int]] = None,
        restore_with_managed_disks: Optional[bool] = None,
        disk_encryption_set_id: Optional[str] = None,
        zones: Optional[List[str]] = None,
        identity_info: Optional["_models.IdentityInfo"] = None,
        identity_based_restore_details: Optional["_models.IdentityBasedRestoreDetails"] = None,
        extended_location: Optional["_models.ExtendedLocation"] = None,
        secured_vm_details: Optional["_models.SecuredVMDetails"] = None,
        target_disk_network_access_settings: Optional["_models.TargetDiskNetworkAccessSettings"] = None,
        recovery_point_rehydration_info: Optional["_models.RecoveryPointRehydrationInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword recovery_point_id: ID of the backup copy to be recovered.
        :paramtype recovery_point_id: str
        :keyword recovery_type: Type of this recovery. Known values are: "Invalid", "OriginalLocation",
         "AlternateLocation", "RestoreDisks", and "Offline".
        :paramtype recovery_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryType
        :keyword source_resource_id: Fully qualified ARM ID of the VM which is being recovered.
        :paramtype source_resource_id: str
        :keyword target_virtual_machine_id: This is the complete ARM Id of the VM that will be created.
         For e.g.
         /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}.
        :paramtype target_virtual_machine_id: str
        :keyword target_resource_group_id: This is the ARM Id of the resource group that you want to
         create for this Virtual machine and other artifacts.
         For e.g. /subscriptions/{subId}/resourcegroups/{rg}.
        :paramtype target_resource_group_id: str
        :keyword storage_account_id: Fully qualified ARM ID of the storage account to which the VM has
         to be restored.
        :paramtype storage_account_id: str
        :keyword virtual_network_id: This is the virtual network Id of the vnet that will be attached
         to the virtual machine.
         User will be validated for join action permissions in the linked access.
        :paramtype virtual_network_id: str
        :keyword subnet_id: Subnet ID, is the subnet ID associated with the to be restored VM. For
         Classic VMs it would be
         {VnetID}/Subnet/{SubnetName} and, for the Azure Resource Manager VMs it would be ARM resource
         ID used to represent
         the subnet.
        :paramtype subnet_id: str
        :keyword target_domain_name_id: Fully qualified ARM ID of the domain name to be associated to
         the VM being restored. This applies only to Classic
         Virtual Machines.
        :paramtype target_domain_name_id: str
        :keyword region: Region in which the virtual machine is restored.
        :paramtype region: str
        :keyword affinity_group: Affinity group associated to VM to be restored. Used only for Classic
         Compute Virtual Machines.
        :paramtype affinity_group: str
        :keyword create_new_cloud_service: Should a new cloud service be created while restoring the
         VM. If this is false, VM will be restored to the same
         cloud service as it was at the time of backup.
        :paramtype create_new_cloud_service: bool
        :keyword original_storage_account_option: Original Storage Account Option.
        :paramtype original_storage_account_option: bool
        :keyword encryption_details: Details needed if the VM was encrypted at the time of backup.
        :paramtype encryption_details:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.EncryptionDetails
        :keyword restore_disk_lun_list: List of Disk LUNs for partial restore.
        :paramtype restore_disk_lun_list: list[int]
        :keyword restore_with_managed_disks: Flag to denote of an Unmanaged disk VM should be restored
         with Managed disks.
        :paramtype restore_with_managed_disks: bool
        :keyword disk_encryption_set_id: DiskEncryptionSet's ID - needed if the VM needs to be
         encrypted at rest during restore with customer managed key.
        :paramtype disk_encryption_set_id: str
        :keyword zones: Target zone where the VM and its disks should be restored.
        :paramtype zones: list[str]
        :keyword identity_info: Managed Identity information required to access customer storage
         account.
        :paramtype identity_info: ~azure.mgmt.recoveryservicesbackup.activestamp.models.IdentityInfo
        :keyword identity_based_restore_details: IaaS VM workload specific restore details for restores
         using managed identity.
        :paramtype identity_based_restore_details:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.IdentityBasedRestoreDetails
        :keyword extended_location: Target extended location where the VM should be restored,
         should be null if restore is to be done in public cloud.
        :paramtype extended_location:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ExtendedLocation
        :keyword secured_vm_details: Stores Secured VM Details.
        :paramtype secured_vm_details:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.SecuredVMDetails
        :keyword target_disk_network_access_settings: Specifies target network access settings for
         disks of VM to be restored,.
        :paramtype target_disk_network_access_settings:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.TargetDiskNetworkAccessSettings
        :keyword recovery_point_rehydration_info: RP Rehydration Info.
        :paramtype recovery_point_rehydration_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointRehydrationInfo
        """
        super().__init__(
            recovery_point_id=recovery_point_id,
            recovery_type=recovery_type,
            source_resource_id=source_resource_id,
            target_virtual_machine_id=target_virtual_machine_id,
            target_resource_group_id=target_resource_group_id,
            storage_account_id=storage_account_id,
            virtual_network_id=virtual_network_id,
            subnet_id=subnet_id,
            target_domain_name_id=target_domain_name_id,
            region=region,
            affinity_group=affinity_group,
            create_new_cloud_service=create_new_cloud_service,
            original_storage_account_option=original_storage_account_option,
            encryption_details=encryption_details,
            restore_disk_lun_list=restore_disk_lun_list,
            restore_with_managed_disks=restore_with_managed_disks,
            disk_encryption_set_id=disk_encryption_set_id,
            zones=zones,
            identity_info=identity_info,
            identity_based_restore_details=identity_based_restore_details,
            extended_location=extended_location,
            secured_vm_details=secured_vm_details,
            target_disk_network_access_settings=target_disk_network_access_settings,
            **kwargs
        )
        self.object_type: str = "IaasVMRestoreWithRehydrationRequest"
        self.recovery_point_rehydration_info = recovery_point_rehydration_info


class IdentityBasedRestoreDetails(_serialization.Model):
    """IaaS VM workload specific restore details for restores using managed identity.

    :ivar object_type: Gets the class type.
    :vartype object_type: str
    :ivar target_storage_account_id: Fully qualified ARM ID of the target storage account.
    :vartype target_storage_account_id: str
    """

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "target_storage_account_id": {"key": "targetStorageAccountId", "type": "str"},
    }

    def __init__(
        self, *, object_type: Optional[str] = None, target_storage_account_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword object_type: Gets the class type.
        :paramtype object_type: str
        :keyword target_storage_account_id: Fully qualified ARM ID of the target storage account.
        :paramtype target_storage_account_id: str
        """
        super().__init__(**kwargs)
        self.object_type = object_type
        self.target_storage_account_id = target_storage_account_id


class IdentityInfo(_serialization.Model):
    """Encapsulates Managed Identity related information.

    :ivar is_system_assigned_identity: To differentiate if the managed identity is system assigned
     or user assigned.
    :vartype is_system_assigned_identity: bool
    :ivar managed_identity_resource_id: Managed Identity Resource Id
     Optional: Might not be required in the case of system assigned managed identity.
    :vartype managed_identity_resource_id: str
    """

    _attribute_map = {
        "is_system_assigned_identity": {"key": "isSystemAssignedIdentity", "type": "bool"},
        "managed_identity_resource_id": {"key": "managedIdentityResourceId", "type": "str"},
    }

    def __init__(
        self,
        *,
        is_system_assigned_identity: Optional[bool] = None,
        managed_identity_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_system_assigned_identity: To differentiate if the managed identity is system
         assigned or user assigned.
        :paramtype is_system_assigned_identity: bool
        :keyword managed_identity_resource_id: Managed Identity Resource Id
         Optional: Might not be required in the case of system assigned managed identity.
        :paramtype managed_identity_resource_id: str
        """
        super().__init__(**kwargs)
        self.is_system_assigned_identity = is_system_assigned_identity
        self.managed_identity_resource_id = managed_identity_resource_id


class ILRRequestResource(Resource):
    """Parameters to Provision ILR API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: ILRRequestResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ILRRequest
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "ILRRequest"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.ILRRequest"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: ILRRequestResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ILRRequest
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class InquiryInfo(_serialization.Model):
    """Details about inquired protectable items under a given container.

    :ivar status: Inquiry Status for this container such as
     InProgress | Failed | Succeeded.
    :vartype status: str
    :ivar error_detail: Error Details if the Status is non-success.
    :vartype error_detail: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
    :ivar inquiry_details: Inquiry Details which will have workload specific details.
     For e.g. - For SQL and oracle this will contain different details.
    :vartype inquiry_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadInquiryDetails]
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error_detail": {"key": "errorDetail", "type": "ErrorDetail"},
        "inquiry_details": {"key": "inquiryDetails", "type": "[WorkloadInquiryDetails]"},
    }

    def __init__(
        self,
        *,
        status: Optional[str] = None,
        error_detail: Optional["_models.ErrorDetail"] = None,
        inquiry_details: Optional[List["_models.WorkloadInquiryDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Inquiry Status for this container such as
         InProgress | Failed | Succeeded.
        :paramtype status: str
        :keyword error_detail: Error Details if the Status is non-success.
        :paramtype error_detail: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
        :keyword inquiry_details: Inquiry Details which will have workload specific details.
         For e.g. - For SQL and oracle this will contain different details.
        :paramtype inquiry_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadInquiryDetails]
        """
        super().__init__(**kwargs)
        self.status = status
        self.error_detail = error_detail
        self.inquiry_details = inquiry_details


class InquiryValidation(_serialization.Model):
    """Validation for inquired protectable items under a given container.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Status for the Inquiry Validation.
    :vartype status: str
    :ivar error_detail: Error Detail in case the status is non-success.
    :vartype error_detail: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
    :ivar additional_detail: Error Additional Detail in case the status is non-success.
    :vartype additional_detail: str
    """

    _validation = {
        "additional_detail": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error_detail": {"key": "errorDetail", "type": "ErrorDetail"},
        "additional_detail": {"key": "additionalDetail", "type": "str"},
    }

    def __init__(
        self, *, status: Optional[str] = None, error_detail: Optional["_models.ErrorDetail"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword status: Status for the Inquiry Validation.
        :paramtype status: str
        :keyword error_detail: Error Detail in case the status is non-success.
        :paramtype error_detail: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.status = status
        self.error_detail = error_detail
        self.additional_detail = None


class InstantItemRecoveryTarget(_serialization.Model):
    """Target details for file / folder restore.

    :ivar client_scripts: List of client scripts.
    :vartype client_scripts:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientScriptForConnect]
    """

    _attribute_map = {
        "client_scripts": {"key": "clientScripts", "type": "[ClientScriptForConnect]"},
    }

    def __init__(
        self, *, client_scripts: Optional[List["_models.ClientScriptForConnect"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword client_scripts: List of client scripts.
        :paramtype client_scripts:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ClientScriptForConnect]
        """
        super().__init__(**kwargs)
        self.client_scripts = client_scripts


class InstantRPAdditionalDetails(_serialization.Model):
    """InstantRPAdditionalDetails.

    :ivar azure_backup_rg_name_prefix:
    :vartype azure_backup_rg_name_prefix: str
    :ivar azure_backup_rg_name_suffix:
    :vartype azure_backup_rg_name_suffix: str
    """

    _attribute_map = {
        "azure_backup_rg_name_prefix": {"key": "azureBackupRGNamePrefix", "type": "str"},
        "azure_backup_rg_name_suffix": {"key": "azureBackupRGNameSuffix", "type": "str"},
    }

    def __init__(
        self,
        *,
        azure_backup_rg_name_prefix: Optional[str] = None,
        azure_backup_rg_name_suffix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword azure_backup_rg_name_prefix:
        :paramtype azure_backup_rg_name_prefix: str
        :keyword azure_backup_rg_name_suffix:
        :paramtype azure_backup_rg_name_suffix: str
        """
        super().__init__(**kwargs)
        self.azure_backup_rg_name_prefix = azure_backup_rg_name_prefix
        self.azure_backup_rg_name_suffix = azure_backup_rg_name_suffix


class JobQueryObject(_serialization.Model):
    """Filters to list the jobs.

    :ivar status: Status of the job. Known values are: "Invalid", "InProgress", "Completed",
     "Failed", "CompletedWithWarnings", "Cancelled", and "Cancelling".
    :vartype status: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobStatus
    :ivar backup_management_type: Type of backup management for the job. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar operation: Type of operation. Known values are: "Invalid", "Register", "UnRegister",
     "ConfigureBackup", "Backup", "Restore", "DisableBackup", "DeleteBackupData",
     "CrossRegionRestore", "Undelete", and "UpdateCustomerManagedKey".
    :vartype operation: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobOperationType
    :ivar job_id: JobID represents the job uniquely.
    :vartype job_id: str
    :ivar start_time: Job has started at this time. Value is in UTC.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Job has ended at this time. Value is in UTC.
    :vartype end_time: ~datetime.datetime
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.JobStatus"]] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[Union[str, "_models.JobOperationType"]] = None,
        job_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the job. Known values are: "Invalid", "InProgress", "Completed",
         "Failed", "CompletedWithWarnings", "Cancelled", and "Cancelling".
        :paramtype status: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobStatus
        :keyword backup_management_type: Type of backup management for the job. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword operation: Type of operation. Known values are: "Invalid", "Register", "UnRegister",
         "ConfigureBackup", "Backup", "Restore", "DisableBackup", "DeleteBackupData",
         "CrossRegionRestore", "Undelete", and "UpdateCustomerManagedKey".
        :paramtype operation: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobOperationType
        :keyword job_id: JobID represents the job uniquely.
        :paramtype job_id: str
        :keyword start_time: Job has started at this time. Value is in UTC.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Job has ended at this time. Value is in UTC.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.status = status
        self.backup_management_type = backup_management_type
        self.operation = operation
        self.job_id = job_id
        self.start_time = start_time
        self.end_time = end_time


class JobResource(Resource):
    """Defines workload agnostic properties for a job.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: JobResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.Job
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "Job"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.Job"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: JobResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.Job
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class JobResourceList(ResourceList):
    """List of Job resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value: list[~azure.mgmt.recoveryservicesbackup.activestamp.models.JobResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[JobResource]"},
    }

    def __init__(
        self, *, next_link: Optional[str] = None, value: Optional[List["_models.JobResource"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value: list[~azure.mgmt.recoveryservicesbackup.activestamp.models.JobResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class KEKDetails(_serialization.Model):
    """KEK is encryption key for BEK.

    :ivar key_url: Key is KEK.
    :vartype key_url: str
    :ivar key_vault_id: Key Vault ID where this Key is stored.
    :vartype key_vault_id: str
    :ivar key_backup_data: KEK data.
    :vartype key_backup_data: str
    """

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
        "key_vault_id": {"key": "keyVaultId", "type": "str"},
        "key_backup_data": {"key": "keyBackupData", "type": "str"},
    }

    def __init__(
        self,
        *,
        key_url: Optional[str] = None,
        key_vault_id: Optional[str] = None,
        key_backup_data: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword key_url: Key is KEK.
        :paramtype key_url: str
        :keyword key_vault_id: Key Vault ID where this Key is stored.
        :paramtype key_vault_id: str
        :keyword key_backup_data: KEK data.
        :paramtype key_backup_data: str
        """
        super().__init__(**kwargs)
        self.key_url = key_url
        self.key_vault_id = key_vault_id
        self.key_backup_data = key_backup_data


class KeyAndSecretDetails(_serialization.Model):
    """BEK is bitlocker key.
    KEK is encryption key for BEK
    If the VM was encrypted then we will store following details :


    #. Secret(BEK) - Url + Backup Data + vaultId.
    #. Key(KEK) - Url + Backup Data + vaultId.
    #. EncryptionMechanism
       BEK and KEK can potentially have different vault ids.

    :ivar kek_details: KEK is encryption key for BEK.
    :vartype kek_details: ~azure.mgmt.recoveryservicesbackup.activestamp.models.KEKDetails
    :ivar bek_details: BEK is bitlocker encryption key.
    :vartype bek_details: ~azure.mgmt.recoveryservicesbackup.activestamp.models.BEKDetails
    :ivar encryption_mechanism: Encryption mechanism: None/ SinglePass/ DoublePass.
    :vartype encryption_mechanism: str
    """

    _attribute_map = {
        "kek_details": {"key": "kekDetails", "type": "KEKDetails"},
        "bek_details": {"key": "bekDetails", "type": "BEKDetails"},
        "encryption_mechanism": {"key": "encryptionMechanism", "type": "str"},
    }

    def __init__(
        self,
        *,
        kek_details: Optional["_models.KEKDetails"] = None,
        bek_details: Optional["_models.BEKDetails"] = None,
        encryption_mechanism: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kek_details: KEK is encryption key for BEK.
        :paramtype kek_details: ~azure.mgmt.recoveryservicesbackup.activestamp.models.KEKDetails
        :keyword bek_details: BEK is bitlocker encryption key.
        :paramtype bek_details: ~azure.mgmt.recoveryservicesbackup.activestamp.models.BEKDetails
        :keyword encryption_mechanism: Encryption mechanism: None/ SinglePass/ DoublePass.
        :paramtype encryption_mechanism: str
        """
        super().__init__(**kwargs)
        self.kek_details = kek_details
        self.bek_details = bek_details
        self.encryption_mechanism = encryption_mechanism


class KPIResourceHealthDetails(_serialization.Model):
    """KPI Resource Health Details.

    :ivar resource_health_status: Resource Health Status. Known values are: "Healthy",
     "TransientDegraded", "PersistentDegraded", "TransientUnhealthy", "PersistentUnhealthy", and
     "Invalid".
    :vartype resource_health_status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceHealthStatus
    :ivar resource_health_details: Resource Health Status.
    :vartype resource_health_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceHealthDetails]
    """

    _attribute_map = {
        "resource_health_status": {"key": "resourceHealthStatus", "type": "str"},
        "resource_health_details": {"key": "resourceHealthDetails", "type": "[ResourceHealthDetails]"},
    }

    def __init__(
        self,
        *,
        resource_health_status: Optional[Union[str, "_models.ResourceHealthStatus"]] = None,
        resource_health_details: Optional[List["_models.ResourceHealthDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_health_status: Resource Health Status. Known values are: "Healthy",
         "TransientDegraded", "PersistentDegraded", "TransientUnhealthy", "PersistentUnhealthy", and
         "Invalid".
        :paramtype resource_health_status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceHealthStatus
        :keyword resource_health_details: Resource Health Status.
        :paramtype resource_health_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceHealthDetails]
        """
        super().__init__(**kwargs)
        self.resource_health_status = resource_health_status
        self.resource_health_details = resource_health_details


class ListRecoveryPointsRecommendedForMoveRequest(_serialization.Model):
    """ListRecoveryPointsRecommendedForMoveRequest Request.

    :ivar object_type: Gets the class type.
    :vartype object_type: str
    :ivar excluded_rp_list: List of Recovery Points excluded from Move.
    :vartype excluded_rp_list: list[str]
    """

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "excluded_rp_list": {"key": "excludedRPList", "type": "[str]"},
    }

    def __init__(
        self, *, object_type: Optional[str] = None, excluded_rp_list: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword object_type: Gets the class type.
        :paramtype object_type: str
        :keyword excluded_rp_list: List of Recovery Points excluded from Move.
        :paramtype excluded_rp_list: list[str]
        """
        super().__init__(**kwargs)
        self.object_type = object_type
        self.excluded_rp_list = excluded_rp_list


class SchedulePolicy(_serialization.Model):
    """Base class for backup schedule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LogSchedulePolicy, LongTermSchedulePolicy, SimpleSchedulePolicy, SimpleSchedulePolicyV2

    All required parameters must be populated in order to send to Azure.

    :ivar schedule_policy_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype schedule_policy_type: str
    """

    _validation = {
        "schedule_policy_type": {"required": True},
    }

    _attribute_map = {
        "schedule_policy_type": {"key": "schedulePolicyType", "type": "str"},
    }

    _subtype_map = {
        "schedule_policy_type": {
            "LogSchedulePolicy": "LogSchedulePolicy",
            "LongTermSchedulePolicy": "LongTermSchedulePolicy",
            "SimpleSchedulePolicy": "SimpleSchedulePolicy",
            "SimpleSchedulePolicyV2": "SimpleSchedulePolicyV2",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.schedule_policy_type: Optional[str] = None


class LogSchedulePolicy(SchedulePolicy):
    """Log policy schedule.

    All required parameters must be populated in order to send to Azure.

    :ivar schedule_policy_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype schedule_policy_type: str
    :ivar schedule_frequency_in_mins: Frequency of the log schedule operation of this policy in
     minutes.
    :vartype schedule_frequency_in_mins: int
    """

    _validation = {
        "schedule_policy_type": {"required": True},
    }

    _attribute_map = {
        "schedule_policy_type": {"key": "schedulePolicyType", "type": "str"},
        "schedule_frequency_in_mins": {"key": "scheduleFrequencyInMins", "type": "int"},
    }

    def __init__(self, *, schedule_frequency_in_mins: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword schedule_frequency_in_mins: Frequency of the log schedule operation of this policy in
         minutes.
        :paramtype schedule_frequency_in_mins: int
        """
        super().__init__(**kwargs)
        self.schedule_policy_type: str = "LogSchedulePolicy"
        self.schedule_frequency_in_mins = schedule_frequency_in_mins


class RetentionPolicy(_serialization.Model):
    """Base class for retention policy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    LongTermRetentionPolicy, SimpleRetentionPolicy

    All required parameters must be populated in order to send to Azure.

    :ivar retention_policy_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype retention_policy_type: str
    """

    _validation = {
        "retention_policy_type": {"required": True},
    }

    _attribute_map = {
        "retention_policy_type": {"key": "retentionPolicyType", "type": "str"},
    }

    _subtype_map = {
        "retention_policy_type": {
            "LongTermRetentionPolicy": "LongTermRetentionPolicy",
            "SimpleRetentionPolicy": "SimpleRetentionPolicy",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.retention_policy_type: Optional[str] = None


class LongTermRetentionPolicy(RetentionPolicy):
    """Long term retention policy.

    All required parameters must be populated in order to send to Azure.

    :ivar retention_policy_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype retention_policy_type: str
    :ivar daily_schedule: Daily retention schedule of the protection policy.
    :vartype daily_schedule:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DailyRetentionSchedule
    :ivar weekly_schedule: Weekly retention schedule of the protection policy.
    :vartype weekly_schedule:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WeeklyRetentionSchedule
    :ivar monthly_schedule: Monthly retention schedule of the protection policy.
    :vartype monthly_schedule:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.MonthlyRetentionSchedule
    :ivar yearly_schedule: Yearly retention schedule of the protection policy.
    :vartype yearly_schedule:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.YearlyRetentionSchedule
    """

    _validation = {
        "retention_policy_type": {"required": True},
    }

    _attribute_map = {
        "retention_policy_type": {"key": "retentionPolicyType", "type": "str"},
        "daily_schedule": {"key": "dailySchedule", "type": "DailyRetentionSchedule"},
        "weekly_schedule": {"key": "weeklySchedule", "type": "WeeklyRetentionSchedule"},
        "monthly_schedule": {"key": "monthlySchedule", "type": "MonthlyRetentionSchedule"},
        "yearly_schedule": {"key": "yearlySchedule", "type": "YearlyRetentionSchedule"},
    }

    def __init__(
        self,
        *,
        daily_schedule: Optional["_models.DailyRetentionSchedule"] = None,
        weekly_schedule: Optional["_models.WeeklyRetentionSchedule"] = None,
        monthly_schedule: Optional["_models.MonthlyRetentionSchedule"] = None,
        yearly_schedule: Optional["_models.YearlyRetentionSchedule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword daily_schedule: Daily retention schedule of the protection policy.
        :paramtype daily_schedule:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DailyRetentionSchedule
        :keyword weekly_schedule: Weekly retention schedule of the protection policy.
        :paramtype weekly_schedule:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WeeklyRetentionSchedule
        :keyword monthly_schedule: Monthly retention schedule of the protection policy.
        :paramtype monthly_schedule:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.MonthlyRetentionSchedule
        :keyword yearly_schedule: Yearly retention schedule of the protection policy.
        :paramtype yearly_schedule:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.YearlyRetentionSchedule
        """
        super().__init__(**kwargs)
        self.retention_policy_type: str = "LongTermRetentionPolicy"
        self.daily_schedule = daily_schedule
        self.weekly_schedule = weekly_schedule
        self.monthly_schedule = monthly_schedule
        self.yearly_schedule = yearly_schedule


class LongTermSchedulePolicy(SchedulePolicy):
    """Long term policy schedule.

    All required parameters must be populated in order to send to Azure.

    :ivar schedule_policy_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype schedule_policy_type: str
    """

    _validation = {
        "schedule_policy_type": {"required": True},
    }

    _attribute_map = {
        "schedule_policy_type": {"key": "schedulePolicyType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.schedule_policy_type: str = "LongTermSchedulePolicy"


class MabContainer(ProtectionContainer):  # pylint: disable=too-many-instance-attributes
    """Container with items backed up using MAB backup engine.

    All required parameters must be populated in order to send to Azure.

    :ivar friendly_name: Friendly name of the container.
    :vartype friendly_name: str
    :ivar backup_management_type: Type of backup management for the container. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar registration_status: Status of registration of the container with the Recovery Services
     Vault.
    :vartype registration_status: str
    :ivar health_status: Status of health of the container.
    :vartype health_status: str
    :ivar container_type: Type of the container. The value of this property for: 1. Compute Azure
     VM is Microsoft.Compute/virtualMachines 2.
     Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like
     MAB, DPM etc) is
     Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer.
     6. Azure workload
     Backup is VMAppContainer. Required. Known values are: "Invalid", "Unknown", "IaasVMContainer",
     "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer", "MABContainer",
     "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", "GenericContainer",
     "Microsoft.ClassicCompute/virtualMachines", "Microsoft.Compute/virtualMachines", and
     "AzureWorkloadContainer".
    :vartype container_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerType
    :ivar protectable_object_type: Type of the protectable object associated with this container.
    :vartype protectable_object_type: str
    :ivar can_re_register: Can the container be registered one more time.
    :vartype can_re_register: bool
    :ivar container_id: ContainerID represents the container.
    :vartype container_id: int
    :ivar protected_item_count: Number of items backed up in this container.
    :vartype protected_item_count: int
    :ivar agent_version: Agent version of this container.
    :vartype agent_version: str
    :ivar extended_info: Additional information for this container.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.MabContainerExtendedInfo
    :ivar mab_container_health_details: Health details on this mab container.
    :vartype mab_container_health_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.MABContainerHealthDetails]
    :ivar container_health_state: Health state of mab container.
    :vartype container_health_state: str
    """

    _validation = {
        "container_type": {"required": True},
    }

    _attribute_map = {
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "registration_status": {"key": "registrationStatus", "type": "str"},
        "health_status": {"key": "healthStatus", "type": "str"},
        "container_type": {"key": "containerType", "type": "str"},
        "protectable_object_type": {"key": "protectableObjectType", "type": "str"},
        "can_re_register": {"key": "canReRegister", "type": "bool"},
        "container_id": {"key": "containerId", "type": "int"},
        "protected_item_count": {"key": "protectedItemCount", "type": "int"},
        "agent_version": {"key": "agentVersion", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "MabContainerExtendedInfo"},
        "mab_container_health_details": {"key": "mabContainerHealthDetails", "type": "[MABContainerHealthDetails]"},
        "container_health_state": {"key": "containerHealthState", "type": "str"},
    }

    def __init__(
        self,
        *,
        friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        registration_status: Optional[str] = None,
        health_status: Optional[str] = None,
        protectable_object_type: Optional[str] = None,
        can_re_register: Optional[bool] = None,
        container_id: Optional[int] = None,
        protected_item_count: Optional[int] = None,
        agent_version: Optional[str] = None,
        extended_info: Optional["_models.MabContainerExtendedInfo"] = None,
        mab_container_health_details: Optional[List["_models.MABContainerHealthDetails"]] = None,
        container_health_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword friendly_name: Friendly name of the container.
        :paramtype friendly_name: str
        :keyword backup_management_type: Type of backup management for the container. Known values are:
         "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword registration_status: Status of registration of the container with the Recovery
         Services Vault.
        :paramtype registration_status: str
        :keyword health_status: Status of health of the container.
        :paramtype health_status: str
        :keyword protectable_object_type: Type of the protectable object associated with this
         container.
        :paramtype protectable_object_type: str
        :keyword can_re_register: Can the container be registered one more time.
        :paramtype can_re_register: bool
        :keyword container_id: ContainerID represents the container.
        :paramtype container_id: int
        :keyword protected_item_count: Number of items backed up in this container.
        :paramtype protected_item_count: int
        :keyword agent_version: Agent version of this container.
        :paramtype agent_version: str
        :keyword extended_info: Additional information for this container.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.MabContainerExtendedInfo
        :keyword mab_container_health_details: Health details on this mab container.
        :paramtype mab_container_health_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.MABContainerHealthDetails]
        :keyword container_health_state: Health state of mab container.
        :paramtype container_health_state: str
        """
        super().__init__(
            friendly_name=friendly_name,
            backup_management_type=backup_management_type,
            registration_status=registration_status,
            health_status=health_status,
            protectable_object_type=protectable_object_type,
            **kwargs
        )
        self.container_type: str = "Windows"
        self.can_re_register = can_re_register
        self.container_id = container_id
        self.protected_item_count = protected_item_count
        self.agent_version = agent_version
        self.extended_info = extended_info
        self.mab_container_health_details = mab_container_health_details
        self.container_health_state = container_health_state


class MabContainerExtendedInfo(_serialization.Model):
    """Additional information of the container.

    :ivar last_refreshed_at: Time stamp when this container was refreshed.
    :vartype last_refreshed_at: ~datetime.datetime
    :ivar backup_item_type: Type of backup items associated with this container. Known values are:
     "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
     "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
     "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype backup_item_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupItemType
    :ivar backup_items: List of backup items associated with this container.
    :vartype backup_items: list[str]
    :ivar policy_name: Backup policy associated with this container.
    :vartype policy_name: str
    :ivar last_backup_status: Latest backup status of this container.
    :vartype last_backup_status: str
    """

    _attribute_map = {
        "last_refreshed_at": {"key": "lastRefreshedAt", "type": "iso-8601"},
        "backup_item_type": {"key": "backupItemType", "type": "str"},
        "backup_items": {"key": "backupItems", "type": "[str]"},
        "policy_name": {"key": "policyName", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        last_refreshed_at: Optional[datetime.datetime] = None,
        backup_item_type: Optional[Union[str, "_models.BackupItemType"]] = None,
        backup_items: Optional[List[str]] = None,
        policy_name: Optional[str] = None,
        last_backup_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_refreshed_at: Time stamp when this container was refreshed.
        :paramtype last_refreshed_at: ~datetime.datetime
        :keyword backup_item_type: Type of backup items associated with this container. Known values
         are: "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint",
         "VMwareVM", "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
         "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype backup_item_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupItemType
        :keyword backup_items: List of backup items associated with this container.
        :paramtype backup_items: list[str]
        :keyword policy_name: Backup policy associated with this container.
        :paramtype policy_name: str
        :keyword last_backup_status: Latest backup status of this container.
        :paramtype last_backup_status: str
        """
        super().__init__(**kwargs)
        self.last_refreshed_at = last_refreshed_at
        self.backup_item_type = backup_item_type
        self.backup_items = backup_items
        self.policy_name = policy_name
        self.last_backup_status = last_backup_status


class MABContainerHealthDetails(_serialization.Model):
    """MAB workload-specific Health Details.

    :ivar code: Health Code.
    :vartype code: int
    :ivar title: Health Title.
    :vartype title: str
    :ivar message: Health Message.
    :vartype message: str
    :ivar recommendations: Health Recommended Actions.
    :vartype recommendations: list[str]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "int"},
        "title": {"key": "title", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        code: Optional[int] = None,
        title: Optional[str] = None,
        message: Optional[str] = None,
        recommendations: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Health Code.
        :paramtype code: int
        :keyword title: Health Title.
        :paramtype title: str
        :keyword message: Health Message.
        :paramtype message: str
        :keyword recommendations: Health Recommended Actions.
        :paramtype recommendations: list[str]
        """
        super().__init__(**kwargs)
        self.code = code
        self.title = title
        self.message = message
        self.recommendations = recommendations


class MabErrorInfo(_serialization.Model):
    """MAB workload-specific error information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar error_string: Localized error string.
    :vartype error_string: str
    :ivar recommendations: List of localized recommendations.
    :vartype recommendations: list[str]
    """

    _validation = {
        "error_string": {"readonly": True},
        "recommendations": {"readonly": True},
    }

    _attribute_map = {
        "error_string": {"key": "errorString", "type": "str"},
        "recommendations": {"key": "recommendations", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.error_string = None
        self.recommendations = None


class MabFileFolderProtectedItem(ProtectedItem):  # pylint: disable=too-many-instance-attributes
    """MAB workload-specific backup item.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_item_type: backup item type. Required.
    :vartype protected_item_type: str
    :ivar backup_management_type: Type of backup management for the backed up item. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar workload_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar container_name: Unique name of container.
    :vartype container_name: str
    :ivar source_resource_id: ARM ID of the resource to be backed up.
    :vartype source_resource_id: str
    :ivar policy_id: ID of the backup policy with which this item is backed up.
    :vartype policy_id: str
    :ivar last_recovery_point: Timestamp when the last (latest) backup copy was created for this
     backup item.
    :vartype last_recovery_point: ~datetime.datetime
    :ivar backup_set_name: Name of the backup set the backup item belongs to.
    :vartype backup_set_name: str
    :ivar create_mode: Create mode to indicate recovery of existing soft deleted data source or
     creation of new data source. Known values are: "Invalid", "Default", and "Recover".
    :vartype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
    :ivar deferred_delete_time_in_utc: Time for deferred deletion in UTC.
    :vartype deferred_delete_time_in_utc: ~datetime.datetime
    :ivar is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
     deferred delete.
    :vartype is_scheduled_for_deferred_delete: bool
    :ivar deferred_delete_time_remaining: Time remaining before the DS marked for deferred delete
     is permanently deleted.
    :vartype deferred_delete_time_remaining: str
    :ivar is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS is
     to be purged soon.
    :vartype is_deferred_delete_schedule_upcoming: bool
    :ivar is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause state.
    :vartype is_rehydrate: bool
    :ivar resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check will
     be performed.
    :vartype resource_guard_operation_requests: list[str]
    :ivar is_archive_enabled: Flag to identify whether datasource is protected in archive.
    :vartype is_archive_enabled: bool
    :ivar policy_name: Name of the policy used for protection.
    :vartype policy_name: str
    :ivar soft_delete_retention_period: Soft delete retention period in days.
    :vartype soft_delete_retention_period: int
    :ivar friendly_name: Friendly name of this backup item.
    :vartype friendly_name: str
    :ivar computer_name: Name of the computer associated with this backup item.
    :vartype computer_name: str
    :ivar last_backup_status: Status of last backup operation.
    :vartype last_backup_status: str
    :ivar last_backup_time: Timestamp of the last backup operation on this backup item.
    :vartype last_backup_time: ~datetime.datetime
    :ivar protection_state: Protected, ProtectionStopped, IRPending or ProtectionError.
    :vartype protection_state: str
    :ivar deferred_delete_sync_time_in_utc: Sync time for deferred deletion in UTC.
    :vartype deferred_delete_sync_time_in_utc: int
    :ivar extended_info: Additional information with this backup item.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.MabFileFolderProtectedItemExtendedInfo
    """

    _validation = {
        "protected_item_type": {"required": True},
        "backup_management_type": {"readonly": True},
        "workload_type": {"readonly": True},
    }

    _attribute_map = {
        "protected_item_type": {"key": "protectedItemType", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "source_resource_id": {"key": "sourceResourceId", "type": "str"},
        "policy_id": {"key": "policyId", "type": "str"},
        "last_recovery_point": {"key": "lastRecoveryPoint", "type": "iso-8601"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
        "create_mode": {"key": "createMode", "type": "str"},
        "deferred_delete_time_in_utc": {"key": "deferredDeleteTimeInUTC", "type": "iso-8601"},
        "is_scheduled_for_deferred_delete": {"key": "isScheduledForDeferredDelete", "type": "bool"},
        "deferred_delete_time_remaining": {"key": "deferredDeleteTimeRemaining", "type": "str"},
        "is_deferred_delete_schedule_upcoming": {"key": "isDeferredDeleteScheduleUpcoming", "type": "bool"},
        "is_rehydrate": {"key": "isRehydrate", "type": "bool"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "is_archive_enabled": {"key": "isArchiveEnabled", "type": "bool"},
        "policy_name": {"key": "policyName", "type": "str"},
        "soft_delete_retention_period": {"key": "softDeleteRetentionPeriod", "type": "int"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "computer_name": {"key": "computerName", "type": "str"},
        "last_backup_status": {"key": "lastBackupStatus", "type": "str"},
        "last_backup_time": {"key": "lastBackupTime", "type": "iso-8601"},
        "protection_state": {"key": "protectionState", "type": "str"},
        "deferred_delete_sync_time_in_utc": {"key": "deferredDeleteSyncTimeInUTC", "type": "int"},
        "extended_info": {"key": "extendedInfo", "type": "MabFileFolderProtectedItemExtendedInfo"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        container_name: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        policy_id: Optional[str] = None,
        last_recovery_point: Optional[datetime.datetime] = None,
        backup_set_name: Optional[str] = None,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        deferred_delete_time_in_utc: Optional[datetime.datetime] = None,
        is_scheduled_for_deferred_delete: Optional[bool] = None,
        deferred_delete_time_remaining: Optional[str] = None,
        is_deferred_delete_schedule_upcoming: Optional[bool] = None,
        is_rehydrate: Optional[bool] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        is_archive_enabled: Optional[bool] = None,
        policy_name: Optional[str] = None,
        soft_delete_retention_period: Optional[int] = None,
        friendly_name: Optional[str] = None,
        computer_name: Optional[str] = None,
        last_backup_status: Optional[str] = None,
        last_backup_time: Optional[datetime.datetime] = None,
        protection_state: Optional[str] = None,
        deferred_delete_sync_time_in_utc: Optional[int] = None,
        extended_info: Optional["_models.MabFileFolderProtectedItemExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword container_name: Unique name of container.
        :paramtype container_name: str
        :keyword source_resource_id: ARM ID of the resource to be backed up.
        :paramtype source_resource_id: str
        :keyword policy_id: ID of the backup policy with which this item is backed up.
        :paramtype policy_id: str
        :keyword last_recovery_point: Timestamp when the last (latest) backup copy was created for this
         backup item.
        :paramtype last_recovery_point: ~datetime.datetime
        :keyword backup_set_name: Name of the backup set the backup item belongs to.
        :paramtype backup_set_name: str
        :keyword create_mode: Create mode to indicate recovery of existing soft deleted data source or
         creation of new data source. Known values are: "Invalid", "Default", and "Recover".
        :paramtype create_mode: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.CreateMode
        :keyword deferred_delete_time_in_utc: Time for deferred deletion in UTC.
        :paramtype deferred_delete_time_in_utc: ~datetime.datetime
        :keyword is_scheduled_for_deferred_delete: Flag to identify whether the DS is scheduled for
         deferred delete.
        :paramtype is_scheduled_for_deferred_delete: bool
        :keyword deferred_delete_time_remaining: Time remaining before the DS marked for deferred
         delete is permanently deleted.
        :paramtype deferred_delete_time_remaining: str
        :keyword is_deferred_delete_schedule_upcoming: Flag to identify whether the deferred deleted DS
         is to be purged soon.
        :paramtype is_deferred_delete_schedule_upcoming: bool
        :keyword is_rehydrate: Flag to identify that deferred deleted DS is to be moved into Pause
         state.
        :paramtype is_rehydrate: bool
        :keyword resource_guard_operation_requests: ResourceGuardOperationRequests on which LAC check
         will be performed.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword is_archive_enabled: Flag to identify whether datasource is protected in archive.
        :paramtype is_archive_enabled: bool
        :keyword policy_name: Name of the policy used for protection.
        :paramtype policy_name: str
        :keyword soft_delete_retention_period: Soft delete retention period in days.
        :paramtype soft_delete_retention_period: int
        :keyword friendly_name: Friendly name of this backup item.
        :paramtype friendly_name: str
        :keyword computer_name: Name of the computer associated with this backup item.
        :paramtype computer_name: str
        :keyword last_backup_status: Status of last backup operation.
        :paramtype last_backup_status: str
        :keyword last_backup_time: Timestamp of the last backup operation on this backup item.
        :paramtype last_backup_time: ~datetime.datetime
        :keyword protection_state: Protected, ProtectionStopped, IRPending or ProtectionError.
        :paramtype protection_state: str
        :keyword deferred_delete_sync_time_in_utc: Sync time for deferred deletion in UTC.
        :paramtype deferred_delete_sync_time_in_utc: int
        :keyword extended_info: Additional information with this backup item.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.MabFileFolderProtectedItemExtendedInfo
        """
        super().__init__(
            container_name=container_name,
            source_resource_id=source_resource_id,
            policy_id=policy_id,
            last_recovery_point=last_recovery_point,
            backup_set_name=backup_set_name,
            create_mode=create_mode,
            deferred_delete_time_in_utc=deferred_delete_time_in_utc,
            is_scheduled_for_deferred_delete=is_scheduled_for_deferred_delete,
            deferred_delete_time_remaining=deferred_delete_time_remaining,
            is_deferred_delete_schedule_upcoming=is_deferred_delete_schedule_upcoming,
            is_rehydrate=is_rehydrate,
            resource_guard_operation_requests=resource_guard_operation_requests,
            is_archive_enabled=is_archive_enabled,
            policy_name=policy_name,
            soft_delete_retention_period=soft_delete_retention_period,
            **kwargs
        )
        self.protected_item_type: str = "MabFileFolderProtectedItem"
        self.friendly_name = friendly_name
        self.computer_name = computer_name
        self.last_backup_status = last_backup_status
        self.last_backup_time = last_backup_time
        self.protection_state = protection_state
        self.deferred_delete_sync_time_in_utc = deferred_delete_sync_time_in_utc
        self.extended_info = extended_info


class MabFileFolderProtectedItemExtendedInfo(_serialization.Model):
    """Additional information on the backed up item.

    :ivar last_refreshed_at: Last time when the agent data synced to service.
    :vartype last_refreshed_at: ~datetime.datetime
    :ivar oldest_recovery_point: The oldest backup copy available.
    :vartype oldest_recovery_point: ~datetime.datetime
    :ivar recovery_point_count: Number of backup copies associated with the backup item.
    :vartype recovery_point_count: int
    """

    _attribute_map = {
        "last_refreshed_at": {"key": "lastRefreshedAt", "type": "iso-8601"},
        "oldest_recovery_point": {"key": "oldestRecoveryPoint", "type": "iso-8601"},
        "recovery_point_count": {"key": "recoveryPointCount", "type": "int"},
    }

    def __init__(
        self,
        *,
        last_refreshed_at: Optional[datetime.datetime] = None,
        oldest_recovery_point: Optional[datetime.datetime] = None,
        recovery_point_count: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword last_refreshed_at: Last time when the agent data synced to service.
        :paramtype last_refreshed_at: ~datetime.datetime
        :keyword oldest_recovery_point: The oldest backup copy available.
        :paramtype oldest_recovery_point: ~datetime.datetime
        :keyword recovery_point_count: Number of backup copies associated with the backup item.
        :paramtype recovery_point_count: int
        """
        super().__init__(**kwargs)
        self.last_refreshed_at = last_refreshed_at
        self.oldest_recovery_point = oldest_recovery_point
        self.recovery_point_count = recovery_point_count


class MabJob(Job):  # pylint: disable=too-many-instance-attributes
    """MAB workload-specific job.

    All required parameters must be populated in order to send to Azure.

    :ivar entity_friendly_name: Friendly name of the entity on which the current job is executing.
    :vartype entity_friendly_name: str
    :ivar backup_management_type: Backup management type to execute the current job. Known values
     are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar operation: The operation name.
    :vartype operation: str
    :ivar status: Job status.
    :vartype status: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar activity_id: ActivityId of job.
    :vartype activity_id: str
    :ivar job_type: This property will be used as the discriminator for deciding the specific types
     in the polymorphic chain of types. Required.
    :vartype job_type: str
    :ivar duration: Time taken by job to run.
    :vartype duration: ~datetime.timedelta
    :ivar actions_info: The state/actions applicable on jobs like cancel/retry.
    :vartype actions_info: list[str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
    :ivar mab_server_name: Name of server protecting the DS.
    :vartype mab_server_name: str
    :ivar mab_server_type: Server type of MAB container. Known values are: "Invalid", "Unknown",
     "IaasVMContainer", "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer",
     "MABContainer", "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
     "SQLAGWorkLoadContainer", "StorageContainer", and "GenericContainer".
    :vartype mab_server_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.MabServerType
    :ivar workload_type: Workload type of backup item. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    :ivar error_details: The errors.
    :vartype error_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.MabErrorInfo]
    :ivar extended_info: Additional information on the job.
    :vartype extended_info:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.MabJobExtendedInfo
    """

    _validation = {
        "job_type": {"required": True},
    }

    _attribute_map = {
        "entity_friendly_name": {"key": "entityFriendlyName", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "activity_id": {"key": "activityId", "type": "str"},
        "job_type": {"key": "jobType", "type": "str"},
        "duration": {"key": "duration", "type": "duration"},
        "actions_info": {"key": "actionsInfo", "type": "[str]"},
        "mab_server_name": {"key": "mabServerName", "type": "str"},
        "mab_server_type": {"key": "mabServerType", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
        "error_details": {"key": "errorDetails", "type": "[MabErrorInfo]"},
        "extended_info": {"key": "extendedInfo", "type": "MabJobExtendedInfo"},
    }

    def __init__(
        self,
        *,
        entity_friendly_name: Optional[str] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        operation: Optional[str] = None,
        status: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        activity_id: Optional[str] = None,
        duration: Optional[datetime.timedelta] = None,
        actions_info: Optional[List[Union[str, "_models.JobSupportedAction"]]] = None,
        mab_server_name: Optional[str] = None,
        mab_server_type: Optional[Union[str, "_models.MabServerType"]] = None,
        workload_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        error_details: Optional[List["_models.MabErrorInfo"]] = None,
        extended_info: Optional["_models.MabJobExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword entity_friendly_name: Friendly name of the entity on which the current job is
         executing.
        :paramtype entity_friendly_name: str
        :keyword backup_management_type: Backup management type to execute the current job. Known
         values are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql",
         "AzureStorage", "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword operation: The operation name.
        :paramtype operation: str
        :keyword status: Job status.
        :paramtype status: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword activity_id: ActivityId of job.
        :paramtype activity_id: str
        :keyword duration: Time taken by job to run.
        :paramtype duration: ~datetime.timedelta
        :keyword actions_info: The state/actions applicable on jobs like cancel/retry.
        :paramtype actions_info: list[str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.JobSupportedAction]
        :keyword mab_server_name: Name of server protecting the DS.
        :paramtype mab_server_name: str
        :keyword mab_server_type: Server type of MAB container. Known values are: "Invalid", "Unknown",
         "IaasVMContainer", "IaasVMServiceContainer", "DPMContainer", "AzureBackupServerContainer",
         "MABContainer", "Cluster", "AzureSqlContainer", "Windows", "VCenter", "VMAppContainer",
         "SQLAGWorkLoadContainer", "StorageContainer", and "GenericContainer".
        :paramtype mab_server_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.MabServerType
        :keyword workload_type: Workload type of backup item. Known values are: "Invalid", "VM",
         "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
         "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        :keyword error_details: The errors.
        :paramtype error_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.MabErrorInfo]
        :keyword extended_info: Additional information on the job.
        :paramtype extended_info:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.MabJobExtendedInfo
        """
        super().__init__(
            entity_friendly_name=entity_friendly_name,
            backup_management_type=backup_management_type,
            operation=operation,
            status=status,
            start_time=start_time,
            end_time=end_time,
            activity_id=activity_id,
            **kwargs
        )
        self.job_type: str = "MabJob"
        self.duration = duration
        self.actions_info = actions_info
        self.mab_server_name = mab_server_name
        self.mab_server_type = mab_server_type
        self.workload_type = workload_type
        self.error_details = error_details
        self.extended_info = extended_info


class MabJobExtendedInfo(_serialization.Model):
    """Additional information for the MAB workload-specific job.

    :ivar tasks_list: List of tasks for this job.
    :vartype tasks_list:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.MabJobTaskDetails]
    :ivar property_bag: The job properties.
    :vartype property_bag: dict[str, str]
    :ivar dynamic_error_message: Non localized error message specific to this job.
    :vartype dynamic_error_message: str
    """

    _attribute_map = {
        "tasks_list": {"key": "tasksList", "type": "[MabJobTaskDetails]"},
        "property_bag": {"key": "propertyBag", "type": "{str}"},
        "dynamic_error_message": {"key": "dynamicErrorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        tasks_list: Optional[List["_models.MabJobTaskDetails"]] = None,
        property_bag: Optional[Dict[str, str]] = None,
        dynamic_error_message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tasks_list: List of tasks for this job.
        :paramtype tasks_list:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.MabJobTaskDetails]
        :keyword property_bag: The job properties.
        :paramtype property_bag: dict[str, str]
        :keyword dynamic_error_message: Non localized error message specific to this job.
        :paramtype dynamic_error_message: str
        """
        super().__init__(**kwargs)
        self.tasks_list = tasks_list
        self.property_bag = property_bag
        self.dynamic_error_message = dynamic_error_message


class MabJobTaskDetails(_serialization.Model):
    """MAB workload-specific job task details.

    :ivar task_id: The task display name.
    :vartype task_id: str
    :ivar start_time: The start time.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time.
    :vartype end_time: ~datetime.datetime
    :ivar duration: Time elapsed for task.
    :vartype duration: ~datetime.timedelta
    :ivar status: The status.
    :vartype status: str
    """

    _attribute_map = {
        "task_id": {"key": "taskId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "duration": {"key": "duration", "type": "duration"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(
        self,
        *,
        task_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        duration: Optional[datetime.timedelta] = None,
        status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword task_id: The task display name.
        :paramtype task_id: str
        :keyword start_time: The start time.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time.
        :paramtype end_time: ~datetime.datetime
        :keyword duration: Time elapsed for task.
        :paramtype duration: ~datetime.timedelta
        :keyword status: The status.
        :paramtype status: str
        """
        super().__init__(**kwargs)
        self.task_id = task_id
        self.start_time = start_time
        self.end_time = end_time
        self.duration = duration
        self.status = status


class MabProtectionPolicy(ProtectionPolicy):
    """Mab container-specific backup policy.

    All required parameters must be populated in order to send to Azure.

    :ivar protected_items_count: Number of items associated with this policy.
    :vartype protected_items_count: int
    :ivar backup_management_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype backup_management_type: str
    :ivar resource_guard_operation_requests: ResourceGuard Operation Requests.
    :vartype resource_guard_operation_requests: list[str]
    :ivar schedule_policy: Backup schedule of backup policy.
    :vartype schedule_policy: ~azure.mgmt.recoveryservicesbackup.activestamp.models.SchedulePolicy
    :ivar retention_policy: Retention policy details.
    :vartype retention_policy:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionPolicy
    """

    _validation = {
        "backup_management_type": {"required": True},
    }

    _attribute_map = {
        "protected_items_count": {"key": "protectedItemsCount", "type": "int"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
        "schedule_policy": {"key": "schedulePolicy", "type": "SchedulePolicy"},
        "retention_policy": {"key": "retentionPolicy", "type": "RetentionPolicy"},
    }

    def __init__(
        self,
        *,
        protected_items_count: Optional[int] = None,
        resource_guard_operation_requests: Optional[List[str]] = None,
        schedule_policy: Optional["_models.SchedulePolicy"] = None,
        retention_policy: Optional["_models.RetentionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword protected_items_count: Number of items associated with this policy.
        :paramtype protected_items_count: int
        :keyword resource_guard_operation_requests: ResourceGuard Operation Requests.
        :paramtype resource_guard_operation_requests: list[str]
        :keyword schedule_policy: Backup schedule of backup policy.
        :paramtype schedule_policy:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.SchedulePolicy
        :keyword retention_policy: Retention policy details.
        :paramtype retention_policy:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionPolicy
        """
        super().__init__(
            protected_items_count=protected_items_count,
            resource_guard_operation_requests=resource_guard_operation_requests,
            **kwargs
        )
        self.backup_management_type: str = "MAB"
        self.schedule_policy = schedule_policy
        self.retention_policy = retention_policy


class MonthlyRetentionSchedule(_serialization.Model):
    """Monthly retention schedule.

    :ivar retention_schedule_format_type: Retention schedule format type for monthly retention
     policy. Known values are: "Invalid", "Daily", and "Weekly".
    :vartype retention_schedule_format_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionScheduleFormat
    :ivar retention_schedule_daily: Daily retention format for monthly retention policy.
    :vartype retention_schedule_daily:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DailyRetentionFormat
    :ivar retention_schedule_weekly: Weekly retention format for monthly retention policy.
    :vartype retention_schedule_weekly:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WeeklyRetentionFormat
    :ivar retention_times: Retention times of retention policy.
    :vartype retention_times: list[~datetime.datetime]
    :ivar retention_duration: Retention duration of retention Policy.
    :vartype retention_duration:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionDuration
    """

    _attribute_map = {
        "retention_schedule_format_type": {"key": "retentionScheduleFormatType", "type": "str"},
        "retention_schedule_daily": {"key": "retentionScheduleDaily", "type": "DailyRetentionFormat"},
        "retention_schedule_weekly": {"key": "retentionScheduleWeekly", "type": "WeeklyRetentionFormat"},
        "retention_times": {"key": "retentionTimes", "type": "[iso-8601]"},
        "retention_duration": {"key": "retentionDuration", "type": "RetentionDuration"},
    }

    def __init__(
        self,
        *,
        retention_schedule_format_type: Optional[Union[str, "_models.RetentionScheduleFormat"]] = None,
        retention_schedule_daily: Optional["_models.DailyRetentionFormat"] = None,
        retention_schedule_weekly: Optional["_models.WeeklyRetentionFormat"] = None,
        retention_times: Optional[List[datetime.datetime]] = None,
        retention_duration: Optional["_models.RetentionDuration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword retention_schedule_format_type: Retention schedule format type for monthly retention
         policy. Known values are: "Invalid", "Daily", and "Weekly".
        :paramtype retention_schedule_format_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionScheduleFormat
        :keyword retention_schedule_daily: Daily retention format for monthly retention policy.
        :paramtype retention_schedule_daily:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DailyRetentionFormat
        :keyword retention_schedule_weekly: Weekly retention format for monthly retention policy.
        :paramtype retention_schedule_weekly:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WeeklyRetentionFormat
        :keyword retention_times: Retention times of retention policy.
        :paramtype retention_times: list[~datetime.datetime]
        :keyword retention_duration: Retention duration of retention Policy.
        :paramtype retention_duration:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionDuration
        """
        super().__init__(**kwargs)
        self.retention_schedule_format_type = retention_schedule_format_type
        self.retention_schedule_daily = retention_schedule_daily
        self.retention_schedule_weekly = retention_schedule_weekly
        self.retention_times = retention_times
        self.retention_duration = retention_duration


class MoveRPAcrossTiersRequest(_serialization.Model):
    """MoveRPAcrossTiersRequest.

    :ivar object_type: Gets the class type.
    :vartype object_type: str
    :ivar source_tier_type: Source tier from where RP needs to be moved. Known values are:
     "Invalid", "InstantRP", "HardenedRP", and "ArchivedRP".
    :vartype source_tier_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierType
    :ivar target_tier_type: Target tier where RP needs to be moved. Known values are: "Invalid",
     "InstantRP", "HardenedRP", and "ArchivedRP".
    :vartype target_tier_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierType
    """

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "source_tier_type": {"key": "sourceTierType", "type": "str"},
        "target_tier_type": {"key": "targetTierType", "type": "str"},
    }

    def __init__(
        self,
        *,
        object_type: Optional[str] = None,
        source_tier_type: Optional[Union[str, "_models.RecoveryPointTierType"]] = None,
        target_tier_type: Optional[Union[str, "_models.RecoveryPointTierType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword object_type: Gets the class type.
        :paramtype object_type: str
        :keyword source_tier_type: Source tier from where RP needs to be moved. Known values are:
         "Invalid", "InstantRP", "HardenedRP", and "ArchivedRP".
        :paramtype source_tier_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierType
        :keyword target_tier_type: Target tier where RP needs to be moved. Known values are: "Invalid",
         "InstantRP", "HardenedRP", and "ArchivedRP".
        :paramtype target_tier_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierType
        """
        super().__init__(**kwargs)
        self.object_type = object_type
        self.source_tier_type = source_tier_type
        self.target_tier_type = target_tier_type


class NameInfo(_serialization.Model):
    """The name of usage.

    :ivar value: Value of usage.
    :vartype value: str
    :ivar localized_value: Localized value of usage.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: Value of usage.
        :paramtype value: str
        :keyword localized_value: Localized value of usage.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class NewErrorResponse(_serialization.Model):
    """The resource management error response.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.recoveryservicesbackup.activestamp.models.NewErrorResponseError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "NewErrorResponseError"},
    }

    def __init__(self, *, error: Optional["_models.NewErrorResponseError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.recoveryservicesbackup.activestamp.models.NewErrorResponseError
        """
        super().__init__(**kwargs)
        self.error = error


class NewErrorResponseError(_serialization.Model):
    """The error object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.recoveryservicesbackup.activestamp.models.NewErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[NewErrorResponse]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class OperationResultInfo(OperationResultInfoBase):
    """Operation result info.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar job_list: List of jobs created by this operation.
    :vartype job_list: list[str]
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "job_list": {"key": "jobList", "type": "[str]"},
    }

    def __init__(self, *, job_list: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword job_list: List of jobs created by this operation.
        :paramtype job_list: list[str]
        """
        super().__init__(**kwargs)
        self.object_type: str = "OperationResultInfo"
        self.job_list = job_list


class OperationWorkerResponse(_serialization.Model):
    """This is the base class for operation result responses.

    :ivar status_code: HTTP Status Code of the operation. Known values are: "Continue",
     "SwitchingProtocols", "OK", "Created", "Accepted", "NonAuthoritativeInformation", "NoContent",
     "ResetContent", "PartialContent", "MultipleChoices", "Ambiguous", "MovedPermanently", "Moved",
     "Found", "Redirect", "SeeOther", "RedirectMethod", "NotModified", "UseProxy", "Unused",
     "TemporaryRedirect", "RedirectKeepVerb", "BadRequest", "Unauthorized", "PaymentRequired",
     "Forbidden", "NotFound", "MethodNotAllowed", "NotAcceptable", "ProxyAuthenticationRequired",
     "RequestTimeout", "Conflict", "Gone", "LengthRequired", "PreconditionFailed",
     "RequestEntityTooLarge", "RequestUriTooLong", "UnsupportedMediaType",
     "RequestedRangeNotSatisfiable", "ExpectationFailed", "UpgradeRequired", "InternalServerError",
     "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout", and
     "HttpVersionNotSupported".
    :vartype status_code: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.HttpStatusCode
    :ivar headers: HTTP headers associated with this operation.
    :vartype headers: dict[str, list[str]]
    """

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "str"},
        "headers": {"key": "headers", "type": "{[str]}"},
    }

    def __init__(
        self,
        *,
        status_code: Optional[Union[str, "_models.HttpStatusCode"]] = None,
        headers: Optional[Dict[str, List[str]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status_code: HTTP Status Code of the operation. Known values are: "Continue",
         "SwitchingProtocols", "OK", "Created", "Accepted", "NonAuthoritativeInformation", "NoContent",
         "ResetContent", "PartialContent", "MultipleChoices", "Ambiguous", "MovedPermanently", "Moved",
         "Found", "Redirect", "SeeOther", "RedirectMethod", "NotModified", "UseProxy", "Unused",
         "TemporaryRedirect", "RedirectKeepVerb", "BadRequest", "Unauthorized", "PaymentRequired",
         "Forbidden", "NotFound", "MethodNotAllowed", "NotAcceptable", "ProxyAuthenticationRequired",
         "RequestTimeout", "Conflict", "Gone", "LengthRequired", "PreconditionFailed",
         "RequestEntityTooLarge", "RequestUriTooLong", "UnsupportedMediaType",
         "RequestedRangeNotSatisfiable", "ExpectationFailed", "UpgradeRequired", "InternalServerError",
         "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout", and
         "HttpVersionNotSupported".
        :paramtype status_code: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.HttpStatusCode
        :keyword headers: HTTP headers associated with this operation.
        :paramtype headers: dict[str, list[str]]
        """
        super().__init__(**kwargs)
        self.status_code = status_code
        self.headers = headers


class OperationResultInfoBaseResource(OperationWorkerResponse):
    """Base class for operation result info.

    :ivar status_code: HTTP Status Code of the operation. Known values are: "Continue",
     "SwitchingProtocols", "OK", "Created", "Accepted", "NonAuthoritativeInformation", "NoContent",
     "ResetContent", "PartialContent", "MultipleChoices", "Ambiguous", "MovedPermanently", "Moved",
     "Found", "Redirect", "SeeOther", "RedirectMethod", "NotModified", "UseProxy", "Unused",
     "TemporaryRedirect", "RedirectKeepVerb", "BadRequest", "Unauthorized", "PaymentRequired",
     "Forbidden", "NotFound", "MethodNotAllowed", "NotAcceptable", "ProxyAuthenticationRequired",
     "RequestTimeout", "Conflict", "Gone", "LengthRequired", "PreconditionFailed",
     "RequestEntityTooLarge", "RequestUriTooLong", "UnsupportedMediaType",
     "RequestedRangeNotSatisfiable", "ExpectationFailed", "UpgradeRequired", "InternalServerError",
     "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout", and
     "HttpVersionNotSupported".
    :vartype status_code: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.HttpStatusCode
    :ivar headers: HTTP headers associated with this operation.
    :vartype headers: dict[str, list[str]]
    :ivar operation: OperationResultInfoBaseResource operation.
    :vartype operation:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationResultInfoBase
    """

    _attribute_map = {
        "status_code": {"key": "statusCode", "type": "str"},
        "headers": {"key": "headers", "type": "{[str]}"},
        "operation": {"key": "operation", "type": "OperationResultInfoBase"},
    }

    def __init__(
        self,
        *,
        status_code: Optional[Union[str, "_models.HttpStatusCode"]] = None,
        headers: Optional[Dict[str, List[str]]] = None,
        operation: Optional["_models.OperationResultInfoBase"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status_code: HTTP Status Code of the operation. Known values are: "Continue",
         "SwitchingProtocols", "OK", "Created", "Accepted", "NonAuthoritativeInformation", "NoContent",
         "ResetContent", "PartialContent", "MultipleChoices", "Ambiguous", "MovedPermanently", "Moved",
         "Found", "Redirect", "SeeOther", "RedirectMethod", "NotModified", "UseProxy", "Unused",
         "TemporaryRedirect", "RedirectKeepVerb", "BadRequest", "Unauthorized", "PaymentRequired",
         "Forbidden", "NotFound", "MethodNotAllowed", "NotAcceptable", "ProxyAuthenticationRequired",
         "RequestTimeout", "Conflict", "Gone", "LengthRequired", "PreconditionFailed",
         "RequestEntityTooLarge", "RequestUriTooLong", "UnsupportedMediaType",
         "RequestedRangeNotSatisfiable", "ExpectationFailed", "UpgradeRequired", "InternalServerError",
         "NotImplemented", "BadGateway", "ServiceUnavailable", "GatewayTimeout", and
         "HttpVersionNotSupported".
        :paramtype status_code: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.HttpStatusCode
        :keyword headers: HTTP headers associated with this operation.
        :paramtype headers: dict[str, list[str]]
        :keyword operation: OperationResultInfoBaseResource operation.
        :paramtype operation:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationResultInfoBase
        """
        super().__init__(status_code=status_code, headers=headers, **kwargs)
        self.operation = operation


class OperationStatus(_serialization.Model):
    """Operation status.

    :ivar id: ID of the operation.
    :vartype id: str
    :ivar name: Name of the operation.
    :vartype name: str
    :ivar status: Operation status. Known values are: "Invalid", "InProgress", "Succeeded",
     "Failed", and "Canceled".
    :vartype status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationStatusValues
    :ivar start_time: Operation start time. Format: ISO-8601.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Operation end time. Format: ISO-8601.
    :vartype end_time: ~datetime.datetime
    :ivar error: Error information related to this operation.
    :vartype error: ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationStatusError
    :ivar properties: Additional information associated with this operation.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationStatusExtendedInfo
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "error": {"key": "error", "type": "OperationStatusError"},
        "properties": {"key": "properties", "type": "OperationStatusExtendedInfo"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        status: Optional[Union[str, "_models.OperationStatusValues"]] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        error: Optional["_models.OperationStatusError"] = None,
        properties: Optional["_models.OperationStatusExtendedInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: ID of the operation.
        :paramtype id: str
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword status: Operation status. Known values are: "Invalid", "InProgress", "Succeeded",
         "Failed", and "Canceled".
        :paramtype status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationStatusValues
        :keyword start_time: Operation start time. Format: ISO-8601.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Operation end time. Format: ISO-8601.
        :paramtype end_time: ~datetime.datetime
        :keyword error: Error information related to this operation.
        :paramtype error: ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationStatusError
        :keyword properties: Additional information associated with this operation.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.OperationStatusExtendedInfo
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.start_time = start_time
        self.end_time = end_time
        self.error = error
        self.properties = properties


class OperationStatusError(_serialization.Model):
    """Error information associated with operation status call.

    :ivar code: Error code of the operation failure.
    :vartype code: str
    :ivar message: Error message displayed if the operation failure.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: Error code of the operation failure.
        :paramtype code: str
        :keyword message: Error message displayed if the operation failure.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class OperationStatusExtendedInfo(_serialization.Model):
    """Base class for additional information of operation status.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    OperationStatusJobExtendedInfo, OperationStatusJobsExtendedInfo,
    OperationStatusProvisionILRExtendedInfo, OperationStatusValidateOperationExtendedInfo

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {
        "object_type": {
            "OperationStatusJobExtendedInfo": "OperationStatusJobExtendedInfo",
            "OperationStatusJobsExtendedInfo": "OperationStatusJobsExtendedInfo",
            "OperationStatusProvisionILRExtendedInfo": "OperationStatusProvisionILRExtendedInfo",
            "OperationStatusValidateOperationExtendedInfo": "OperationStatusValidateOperationExtendedInfo",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class OperationStatusJobExtendedInfo(OperationStatusExtendedInfo):
    """Operation status job extended info.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar job_id: ID of the job created for this protected item.
    :vartype job_id: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "job_id": {"key": "jobId", "type": "str"},
    }

    def __init__(self, *, job_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword job_id: ID of the job created for this protected item.
        :paramtype job_id: str
        """
        super().__init__(**kwargs)
        self.object_type: str = "OperationStatusJobExtendedInfo"
        self.job_id = job_id


class OperationStatusJobsExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for list of jobs.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar job_ids: IDs of the jobs created for the protected item.
    :vartype job_ids: list[str]
    :ivar failed_jobs_error: Stores all the failed jobs along with the corresponding error codes.
    :vartype failed_jobs_error: dict[str, str]
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "job_ids": {"key": "jobIds", "type": "[str]"},
        "failed_jobs_error": {"key": "failedJobsError", "type": "{str}"},
    }

    def __init__(
        self, *, job_ids: Optional[List[str]] = None, failed_jobs_error: Optional[Dict[str, str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword job_ids: IDs of the jobs created for the protected item.
        :paramtype job_ids: list[str]
        :keyword failed_jobs_error: Stores all the failed jobs along with the corresponding error
         codes.
        :paramtype failed_jobs_error: dict[str, str]
        """
        super().__init__(**kwargs)
        self.object_type: str = "OperationStatusJobsExtendedInfo"
        self.job_ids = job_ids
        self.failed_jobs_error = failed_jobs_error


class OperationStatusProvisionILRExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for ILR provision action.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar recovery_target: Target details for file / folder restore.
    :vartype recovery_target:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.InstantItemRecoveryTarget
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "recovery_target": {"key": "recoveryTarget", "type": "InstantItemRecoveryTarget"},
    }

    def __init__(self, *, recovery_target: Optional["_models.InstantItemRecoveryTarget"] = None, **kwargs: Any) -> None:
        """
        :keyword recovery_target: Target details for file / folder restore.
        :paramtype recovery_target:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.InstantItemRecoveryTarget
        """
        super().__init__(**kwargs)
        self.object_type: str = "OperationStatusProvisionILRExtendedInfo"
        self.recovery_target = recovery_target


class OperationStatusValidateOperationExtendedInfo(OperationStatusExtendedInfo):
    """Operation status extended info for ValidateOperation action.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar validate_operation_response: Gets the validation operation response.
    :vartype validate_operation_response:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ValidateOperationResponse
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "validate_operation_response": {"key": "validateOperationResponse", "type": "ValidateOperationResponse"},
    }

    def __init__(
        self, *, validate_operation_response: Optional["_models.ValidateOperationResponse"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword validate_operation_response: Gets the validation operation response.
        :paramtype validate_operation_response:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ValidateOperationResponse
        """
        super().__init__(**kwargs)
        self.object_type: str = "OperationStatusValidateOperationExtendedInfo"
        self.validate_operation_response = validate_operation_response


class PointInTimeRange(_serialization.Model):
    """Provides details for log ranges.

    :ivar start_time: Start time of the time range for log recovery.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the time range for log recovery.
    :vartype end_time: ~datetime.datetime
    """

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Start time of the time range for log recovery.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: End time of the time range for log recovery.
        :paramtype end_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time


class PreBackupValidation(_serialization.Model):
    """Pre-backup validation for Azure VM Workload provider.

    :ivar status: Status of protectable item, i.e. InProgress,Succeeded,Failed. Known values are:
     "Invalid", "Success", and "Failed".
    :vartype status: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.InquiryStatus
    :ivar code: Error code of protectable item.
    :vartype code: str
    :ivar message: Message corresponding to the error code for the protectable item.
    :vartype message: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.InquiryStatus"]] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of protectable item, i.e. InProgress,Succeeded,Failed. Known values
         are: "Invalid", "Success", and "Failed".
        :paramtype status: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.InquiryStatus
        :keyword code: Error code of protectable item.
        :paramtype code: str
        :keyword message: Message corresponding to the error code for the protectable item.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.code = code
        self.message = message


class PrepareDataMoveRequest(_serialization.Model):
    """Prepare DataMove Request.

    All required parameters must be populated in order to send to Azure.

    :ivar target_resource_id: ARM Id of target vault. Required.
    :vartype target_resource_id: str
    :ivar target_region: Target Region. Required.
    :vartype target_region: str
    :ivar data_move_level: DataMove Level. Required. Known values are: "Invalid", "Vault", and
     "Container".
    :vartype data_move_level: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataMoveLevel
    :ivar source_container_arm_ids: Source Container ArmIds
     This needs to be populated only if DataMoveLevel is set to container.
    :vartype source_container_arm_ids: list[str]
    :ivar ignore_moved: Ignore the artifacts which are already moved.
    :vartype ignore_moved: bool
    """

    _validation = {
        "target_resource_id": {"required": True},
        "target_region": {"required": True},
        "data_move_level": {"required": True},
    }

    _attribute_map = {
        "target_resource_id": {"key": "targetResourceId", "type": "str"},
        "target_region": {"key": "targetRegion", "type": "str"},
        "data_move_level": {"key": "dataMoveLevel", "type": "str"},
        "source_container_arm_ids": {"key": "sourceContainerArmIds", "type": "[str]"},
        "ignore_moved": {"key": "ignoreMoved", "type": "bool"},
    }

    def __init__(
        self,
        *,
        target_resource_id: str,
        target_region: str,
        data_move_level: Union[str, "_models.DataMoveLevel"],
        source_container_arm_ids: Optional[List[str]] = None,
        ignore_moved: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword target_resource_id: ARM Id of target vault. Required.
        :paramtype target_resource_id: str
        :keyword target_region: Target Region. Required.
        :paramtype target_region: str
        :keyword data_move_level: DataMove Level. Required. Known values are: "Invalid", "Vault", and
         "Container".
        :paramtype data_move_level: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataMoveLevel
        :keyword source_container_arm_ids: Source Container ArmIds
         This needs to be populated only if DataMoveLevel is set to container.
        :paramtype source_container_arm_ids: list[str]
        :keyword ignore_moved: Ignore the artifacts which are already moved.
        :paramtype ignore_moved: bool
        """
        super().__init__(**kwargs)
        self.target_resource_id = target_resource_id
        self.target_region = target_region
        self.data_move_level = data_move_level
        self.source_container_arm_ids = source_container_arm_ids
        self.ignore_moved = ignore_moved


class VaultStorageConfigOperationResultResponse(_serialization.Model):
    """Operation result response for Vault Storage Config.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    PrepareDataMoveResponse

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
    }

    _subtype_map = {"object_type": {"PrepareDataMoveResponse": "PrepareDataMoveResponse"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.object_type: Optional[str] = None


class PrepareDataMoveResponse(VaultStorageConfigOperationResultResponse):
    """Prepare DataMove Response.

    All required parameters must be populated in order to send to Azure.

    :ivar object_type: This property will be used as the discriminator for deciding the specific
     types in the polymorphic chain of types. Required.
    :vartype object_type: str
    :ivar correlation_id: Co-relationId for move operation.
    :vartype correlation_id: str
    :ivar source_vault_properties: Source Vault Properties.
    :vartype source_vault_properties: dict[str, str]
    """

    _validation = {
        "object_type": {"required": True},
    }

    _attribute_map = {
        "object_type": {"key": "objectType", "type": "str"},
        "correlation_id": {"key": "correlationId", "type": "str"},
        "source_vault_properties": {"key": "sourceVaultProperties", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        correlation_id: Optional[str] = None,
        source_vault_properties: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword correlation_id: Co-relationId for move operation.
        :paramtype correlation_id: str
        :keyword source_vault_properties: Source Vault Properties.
        :paramtype source_vault_properties: dict[str, str]
        """
        super().__init__(**kwargs)
        self.object_type: str = "PrepareDataMoveResponse"
        self.correlation_id = correlation_id
        self.source_vault_properties = source_vault_properties


class PreValidateEnableBackupRequest(_serialization.Model):
    """Contract to validate if backup can be enabled on the given resource in a given vault and given
    configuration.
    It will validate followings


    #. Vault capacity
    #. VM is already protected
    #. Any VM related configuration passed in properties.

    :ivar resource_type: ProtectedItem Type- VM, SqlDataBase, AzureFileShare etc. Known values are:
     "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM",
     "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
     "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype resource_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar resource_id: ARM Virtual Machine Id.
    :vartype resource_id: str
    :ivar vault_id: ARM id of the Recovery Services Vault.
    :vartype vault_id: str
    :ivar properties: Configuration of VM if any needs to be validated like OS type etc.
    :vartype properties: str
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "vault_id": {"key": "vaultId", "type": "str"},
        "properties": {"key": "properties", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        resource_id: Optional[str] = None,
        vault_id: Optional[str] = None,
        properties: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: ProtectedItem Type- VM, SqlDataBase, AzureFileShare etc. Known values
         are: "Invalid", "VM", "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint",
         "VMwareVM", "SystemState", "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare",
         "SAPHanaDatabase", "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype resource_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
        :keyword resource_id: ARM Virtual Machine Id.
        :paramtype resource_id: str
        :keyword vault_id: ARM id of the Recovery Services Vault.
        :paramtype vault_id: str
        :keyword properties: Configuration of VM if any needs to be validated like OS type etc.
        :paramtype properties: str
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.resource_id = resource_id
        self.vault_id = vault_id
        self.properties = properties


class PreValidateEnableBackupResponse(_serialization.Model):
    """Response contract for enable backup validation request.

    :ivar status: Validation Status. Known values are: "Invalid", "Succeeded", and "Failed".
    :vartype status: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.ValidationStatus
    :ivar error_code: Response error code.
    :vartype error_code: str
    :ivar error_message: Response error message.
    :vartype error_message: str
    :ivar recommendation: Recommended action for user.
    :vartype recommendation: str
    :ivar container_name: Specifies the product specific container name. E.g.
     iaasvmcontainer;iaasvmcontainer;rgname;vmname. This is required
     for portal.
    :vartype container_name: str
    :ivar protected_item_name: Specifies the product specific ds name. E.g.
     vm;iaasvmcontainer;rgname;vmname. This is required for portal.
    :vartype protected_item_name: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error_code": {"key": "errorCode", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
        "recommendation": {"key": "recommendation", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "protected_item_name": {"key": "protectedItemName", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ValidationStatus"]] = None,
        error_code: Optional[str] = None,
        error_message: Optional[str] = None,
        recommendation: Optional[str] = None,
        container_name: Optional[str] = None,
        protected_item_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Validation Status. Known values are: "Invalid", "Succeeded", and "Failed".
        :paramtype status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ValidationStatus
        :keyword error_code: Response error code.
        :paramtype error_code: str
        :keyword error_message: Response error message.
        :paramtype error_message: str
        :keyword recommendation: Recommended action for user.
        :paramtype recommendation: str
        :keyword container_name: Specifies the product specific container name. E.g.
         iaasvmcontainer;iaasvmcontainer;rgname;vmname. This is required
         for portal.
        :paramtype container_name: str
        :keyword protected_item_name: Specifies the product specific ds name. E.g.
         vm;iaasvmcontainer;rgname;vmname. This is required for portal.
        :paramtype protected_item_name: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.error_code = error_code
        self.error_message = error_message
        self.recommendation = recommendation
        self.container_name = container_name
        self.protected_item_name = protected_item_name


class PrivateEndpoint(_serialization.Model):
    """The Private Endpoint network resource that is linked to the Private Endpoint connection.

    :ivar id: Gets or sets id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Gets or sets id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(_serialization.Model):
    """Private Endpoint Connection Response Properties.

    :ivar provisioning_state: Gets or sets provisioning state of the private endpoint connection.
     Known values are: "Succeeded", "Deleting", "Failed", and "Pending".
    :vartype provisioning_state: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProvisioningState
    :ivar private_endpoint: Gets or sets private endpoint associated with the private endpoint
     connection.
    :vartype private_endpoint:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PrivateEndpoint
    :ivar private_link_service_connection_state: Gets or sets private link service connection
     state.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PrivateLinkServiceConnectionState
    """

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "private_endpoint": {"key": "privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provisioning_state: Gets or sets provisioning state of the private endpoint
         connection. Known values are: "Succeeded", "Deleting", "Failed", and "Pending".
        :paramtype provisioning_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProvisioningState
        :keyword private_endpoint: Gets or sets private endpoint associated with the private endpoint
         connection.
        :paramtype private_endpoint:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PrivateEndpoint
        :keyword private_link_service_connection_state: Gets or sets private link service connection
         state.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpointConnectionResource(Resource):
    """Private Endpoint Connection Response Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: PrivateEndpointConnectionResource properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PrivateEndpointConnection
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "PrivateEndpointConnection"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.PrivateEndpointConnection"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: PrivateEndpointConnectionResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PrivateEndpointConnection
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class PrivateLinkServiceConnectionState(_serialization.Model):
    """Private Link Service Connection State.

    :ivar status: Gets or sets the status. Known values are: "Pending", "Approved", "Rejected", and
     "Disconnected".
    :vartype status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.PrivateEndpointConnectionStatus
    :ivar description: Gets or sets description.
    :vartype description: str
    :ivar action_required: Gets or sets actions required.
    :vartype action_required: str
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "action_required": {"key": "actionRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.PrivateEndpointConnectionStatus"]] = None,
        description: Optional[str] = None,
        action_required: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Gets or sets the status. Known values are: "Pending", "Approved", "Rejected",
         and "Disconnected".
        :paramtype status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.PrivateEndpointConnectionStatus
        :keyword description: Gets or sets description.
        :paramtype description: str
        :keyword action_required: Gets or sets actions required.
        :paramtype action_required: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.action_required = action_required


class ProtectableContainerResource(Resource):
    """Protectable Container Class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: ProtectableContainerResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainer
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "ProtectableContainer"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.ProtectableContainer"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: ProtectableContainerResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainer
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectableContainerResourceList(ResourceList):
    """List of ProtectableContainer resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ProtectableContainerResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ProtectableContainerResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectableContainerResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class ProtectedItemQueryObject(_serialization.Model):
    """Filters to list backup items.

    :ivar health_state: Health State for the backed up item. Known values are: "Passed",
     "ActionRequired", "ActionSuggested", and "Invalid".
    :vartype health_state: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.HealthState
    :ivar backup_management_type: Backup management type for the backed up item. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar item_type: Type of workload this item represents. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype item_type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
    :ivar policy_name: Backup policy name associated with the backup item.
    :vartype policy_name: str
    :ivar container_name: Name of the container.
    :vartype container_name: str
    :ivar backup_engine_name: Backup Engine name.
    :vartype backup_engine_name: str
    :ivar friendly_name: Friendly name of protected item.
    :vartype friendly_name: str
    :ivar fabric_name: Name of the fabric.
    :vartype fabric_name: str
    :ivar backup_set_name: Name of the backup set.
    :vartype backup_set_name: str
    """

    _attribute_map = {
        "health_state": {"key": "healthState", "type": "str"},
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "item_type": {"key": "itemType", "type": "str"},
        "policy_name": {"key": "policyName", "type": "str"},
        "container_name": {"key": "containerName", "type": "str"},
        "backup_engine_name": {"key": "backupEngineName", "type": "str"},
        "friendly_name": {"key": "friendlyName", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "backup_set_name": {"key": "backupSetName", "type": "str"},
    }

    def __init__(
        self,
        *,
        health_state: Optional[Union[str, "_models.HealthState"]] = None,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        item_type: Optional[Union[str, "_models.DataSourceType"]] = None,
        policy_name: Optional[str] = None,
        container_name: Optional[str] = None,
        backup_engine_name: Optional[str] = None,
        friendly_name: Optional[str] = None,
        fabric_name: Optional[str] = None,
        backup_set_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword health_state: Health State for the backed up item. Known values are: "Passed",
         "ActionRequired", "ActionSuggested", and "Invalid".
        :paramtype health_state: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.HealthState
        :keyword backup_management_type: Backup management type for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword item_type: Type of workload this item represents. Known values are: "Invalid", "VM",
         "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
         "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype item_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DataSourceType
        :keyword policy_name: Backup policy name associated with the backup item.
        :paramtype policy_name: str
        :keyword container_name: Name of the container.
        :paramtype container_name: str
        :keyword backup_engine_name: Backup Engine name.
        :paramtype backup_engine_name: str
        :keyword friendly_name: Friendly name of protected item.
        :paramtype friendly_name: str
        :keyword fabric_name: Name of the fabric.
        :paramtype fabric_name: str
        :keyword backup_set_name: Name of the backup set.
        :paramtype backup_set_name: str
        """
        super().__init__(**kwargs)
        self.health_state = health_state
        self.backup_management_type = backup_management_type
        self.item_type = item_type
        self.policy_name = policy_name
        self.container_name = container_name
        self.backup_engine_name = backup_engine_name
        self.friendly_name = friendly_name
        self.fabric_name = fabric_name
        self.backup_set_name = backup_set_name


class ProtectedItemResource(Resource):
    """Base class for backup items.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: ProtectedItemResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItem
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "ProtectedItem"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.ProtectedItem"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: ProtectedItemResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItem
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectedItemResourceList(ResourceList):
    """List of ProtectedItem resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ProtectedItemResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ProtectedItemResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectedItemResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class ProtectionContainerResource(Resource):
    """Base class for container with backup items. Containers with specific workloads are derived from
    this class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: ProtectionContainerResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionContainer
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "ProtectionContainer"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.ProtectionContainer"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: ProtectionContainerResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionContainer
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectionContainerResourceList(ResourceList):
    """List of ProtectionContainer resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionContainerResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ProtectionContainerResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ProtectionContainerResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionContainerResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class ProtectionIntentQueryObject(_serialization.Model):
    """Filters to list protection intent.

    :ivar backup_management_type: Backup management type for the backed up item. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar item_type: Type of workload this item represents. Known values are: "Invalid",
     "SQLInstance", and "SQLAvailabilityGroupContainer".
    :vartype item_type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.IntentItemType
    :ivar parent_name: Parent name of the intent.
    :vartype parent_name: str
    :ivar item_name: Item name of the intent.
    :vartype item_name: str
    """

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "item_type": {"key": "itemType", "type": "str"},
        "parent_name": {"key": "parentName", "type": "str"},
        "item_name": {"key": "itemName", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        item_type: Optional[Union[str, "_models.IntentItemType"]] = None,
        parent_name: Optional[str] = None,
        item_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Backup management type for the backed up item. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword item_type: Type of workload this item represents. Known values are: "Invalid",
         "SQLInstance", and "SQLAvailabilityGroupContainer".
        :paramtype item_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.IntentItemType
        :keyword parent_name: Parent name of the intent.
        :paramtype parent_name: str
        :keyword item_name: Item name of the intent.
        :paramtype item_name: str
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.item_type = item_type
        self.parent_name = parent_name
        self.item_name = item_name


class ProtectionIntentResource(Resource):
    """Base class for backup ProtectionIntent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: ProtectionIntentResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntent
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "ProtectionIntent"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.ProtectionIntent"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: ProtectionIntentResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntent
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectionIntentResourceList(ResourceList):
    """List of ProtectionIntent resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntentResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ProtectionIntentResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ProtectionIntentResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionIntentResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class ProtectionPolicyQueryObject(_serialization.Model):
    """Filters the list backup policies API.

    :ivar backup_management_type: Backup management type for the backup policy. Known values are:
     "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
     "AzureWorkload", and "DefaultBackup".
    :vartype backup_management_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
    :ivar fabric_name: Fabric name for filter.
    :vartype fabric_name: str
    :ivar workload_type: Workload type for the backup policy. Known values are: "Invalid", "VM",
     "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
     "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
     "SAPAseDatabase", and "SAPHanaDBInstance".
    :vartype workload_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
    """

    _attribute_map = {
        "backup_management_type": {"key": "backupManagementType", "type": "str"},
        "fabric_name": {"key": "fabricName", "type": "str"},
        "workload_type": {"key": "workloadType", "type": "str"},
    }

    def __init__(
        self,
        *,
        backup_management_type: Optional[Union[str, "_models.BackupManagementType"]] = None,
        fabric_name: Optional[str] = None,
        workload_type: Optional[Union[str, "_models.WorkloadType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword backup_management_type: Backup management type for the backup policy. Known values
         are: "Invalid", "AzureIaasVM", "MAB", "DPM", "AzureBackupServer", "AzureSql", "AzureStorage",
         "AzureWorkload", and "DefaultBackup".
        :paramtype backup_management_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.BackupManagementType
        :keyword fabric_name: Fabric name for filter.
        :paramtype fabric_name: str
        :keyword workload_type: Workload type for the backup policy. Known values are: "Invalid", "VM",
         "FileFolder", "AzureSqlDb", "SQLDB", "Exchange", "Sharepoint", "VMwareVM", "SystemState",
         "Client", "GenericDataSource", "SQLDataBase", "AzureFileShare", "SAPHanaDatabase",
         "SAPAseDatabase", and "SAPHanaDBInstance".
        :paramtype workload_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WorkloadType
        """
        super().__init__(**kwargs)
        self.backup_management_type = backup_management_type
        self.fabric_name = fabric_name
        self.workload_type = workload_type


class ProtectionPolicyResource(Resource):
    """Base class for backup policy. Workload-specific backup policies are derived from this class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: ProtectionPolicyResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionPolicy
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "ProtectionPolicy"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.ProtectionPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: ProtectionPolicyResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionPolicy
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ProtectionPolicyResourceList(ResourceList):
    """List of ProtectionPolicy resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionPolicyResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ProtectionPolicyResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ProtectionPolicyResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ProtectionPolicyResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class RecoveryPointDiskConfiguration(_serialization.Model):
    """Disk configuration.

    :ivar number_of_disks_included_in_backup: Number of disks included in backup.
    :vartype number_of_disks_included_in_backup: int
    :ivar number_of_disks_attached_to_vm: Number of disks attached to the VM.
    :vartype number_of_disks_attached_to_vm: int
    :ivar included_disk_list: Information of disks included in backup.
    :vartype included_disk_list:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DiskInformation]
    :ivar excluded_disk_list: Information of disks excluded from backup.
    :vartype excluded_disk_list:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DiskInformation]
    """

    _attribute_map = {
        "number_of_disks_included_in_backup": {"key": "numberOfDisksIncludedInBackup", "type": "int"},
        "number_of_disks_attached_to_vm": {"key": "numberOfDisksAttachedToVm", "type": "int"},
        "included_disk_list": {"key": "includedDiskList", "type": "[DiskInformation]"},
        "excluded_disk_list": {"key": "excludedDiskList", "type": "[DiskInformation]"},
    }

    def __init__(
        self,
        *,
        number_of_disks_included_in_backup: Optional[int] = None,
        number_of_disks_attached_to_vm: Optional[int] = None,
        included_disk_list: Optional[List["_models.DiskInformation"]] = None,
        excluded_disk_list: Optional[List["_models.DiskInformation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number_of_disks_included_in_backup: Number of disks included in backup.
        :paramtype number_of_disks_included_in_backup: int
        :keyword number_of_disks_attached_to_vm: Number of disks attached to the VM.
        :paramtype number_of_disks_attached_to_vm: int
        :keyword included_disk_list: Information of disks included in backup.
        :paramtype included_disk_list:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DiskInformation]
        :keyword excluded_disk_list: Information of disks excluded from backup.
        :paramtype excluded_disk_list:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.DiskInformation]
        """
        super().__init__(**kwargs)
        self.number_of_disks_included_in_backup = number_of_disks_included_in_backup
        self.number_of_disks_attached_to_vm = number_of_disks_attached_to_vm
        self.included_disk_list = included_disk_list
        self.excluded_disk_list = excluded_disk_list


class RecoveryPointMoveReadinessInfo(_serialization.Model):
    """RecoveryPointMoveReadinessInfo.

    :ivar is_ready_for_move:
    :vartype is_ready_for_move: bool
    :ivar additional_info:
    :vartype additional_info: str
    """

    _attribute_map = {
        "is_ready_for_move": {"key": "isReadyForMove", "type": "bool"},
        "additional_info": {"key": "additionalInfo", "type": "str"},
    }

    def __init__(
        self, *, is_ready_for_move: Optional[bool] = None, additional_info: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword is_ready_for_move:
        :paramtype is_ready_for_move: bool
        :keyword additional_info:
        :paramtype additional_info: str
        """
        super().__init__(**kwargs)
        self.is_ready_for_move = is_ready_for_move
        self.additional_info = additional_info


class RecoveryPointProperties(_serialization.Model):
    """Properties of Recovery Point.

    :ivar expiry_time: Expiry time of Recovery Point in UTC.
    :vartype expiry_time: str
    :ivar rule_name: Rule name tagged on Recovery Point that governs life cycle.
    :vartype rule_name: str
    :ivar is_soft_deleted: Bool to indicate whether RP is in soft delete state or not.
    :vartype is_soft_deleted: bool
    """

    _attribute_map = {
        "expiry_time": {"key": "expiryTime", "type": "str"},
        "rule_name": {"key": "ruleName", "type": "str"},
        "is_soft_deleted": {"key": "isSoftDeleted", "type": "bool"},
    }

    def __init__(
        self,
        *,
        expiry_time: Optional[str] = None,
        rule_name: Optional[str] = None,
        is_soft_deleted: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword expiry_time: Expiry time of Recovery Point in UTC.
        :paramtype expiry_time: str
        :keyword rule_name: Rule name tagged on Recovery Point that governs life cycle.
        :paramtype rule_name: str
        :keyword is_soft_deleted: Bool to indicate whether RP is in soft delete state or not.
        :paramtype is_soft_deleted: bool
        """
        super().__init__(**kwargs)
        self.expiry_time = expiry_time
        self.rule_name = rule_name
        self.is_soft_deleted = is_soft_deleted


class RecoveryPointRehydrationInfo(_serialization.Model):
    """RP Rehydration Info.

    :ivar rehydration_retention_duration: How long the rehydrated RP should be kept
     Should be ISO8601 Duration format e.g. "P7D".
    :vartype rehydration_retention_duration: str
    :ivar rehydration_priority: Rehydration Priority. Known values are: "Standard" and "High".
    :vartype rehydration_priority: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RehydrationPriority
    """

    _attribute_map = {
        "rehydration_retention_duration": {"key": "rehydrationRetentionDuration", "type": "str"},
        "rehydration_priority": {"key": "rehydrationPriority", "type": "str"},
    }

    def __init__(
        self,
        *,
        rehydration_retention_duration: Optional[str] = None,
        rehydration_priority: Optional[Union[str, "_models.RehydrationPriority"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rehydration_retention_duration: How long the rehydrated RP should be kept
         Should be ISO8601 Duration format e.g. "P7D".
        :paramtype rehydration_retention_duration: str
        :keyword rehydration_priority: Rehydration Priority. Known values are: "Standard" and "High".
        :paramtype rehydration_priority: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RehydrationPriority
        """
        super().__init__(**kwargs)
        self.rehydration_retention_duration = rehydration_retention_duration
        self.rehydration_priority = rehydration_priority


class RecoveryPointResource(Resource):
    """Base class for backup copies. Workload-specific backup copies are derived from this class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: RecoveryPointResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPoint
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "RecoveryPoint"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.RecoveryPoint"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: RecoveryPointResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPoint
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class RecoveryPointResourceList(ResourceList):
    """List of RecoveryPoint resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[RecoveryPointResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.RecoveryPointResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class RecoveryPointTierInformation(_serialization.Model):
    """Recovery point tier information.

    :ivar type: Recovery point tier type. Known values are: "Invalid", "InstantRP", "HardenedRP",
     and "ArchivedRP".
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierType
    :ivar status: Recovery point tier status. Known values are: "Invalid", "Valid", "Disabled",
     "Deleted", and "Rehydrated".
    :vartype status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierStatus
    :ivar extended_info: Recovery point tier status.
    :vartype extended_info: dict[str, str]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RecoveryPointTierType"]] = None,
        status: Optional[Union[str, "_models.RecoveryPointTierStatus"]] = None,
        extended_info: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Recovery point tier type. Known values are: "Invalid", "InstantRP",
         "HardenedRP", and "ArchivedRP".
        :paramtype type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierType
        :keyword status: Recovery point tier status. Known values are: "Invalid", "Valid", "Disabled",
         "Deleted", and "Rehydrated".
        :paramtype status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierStatus
        :keyword extended_info: Recovery point tier status.
        :paramtype extended_info: dict[str, str]
        """
        super().__init__(**kwargs)
        self.type = type
        self.status = status
        self.extended_info = extended_info


class RecoveryPointTierInformationV2(RecoveryPointTierInformation):
    """RecoveryPoint Tier Information V2.

    :ivar type: Recovery point tier type. Known values are: "Invalid", "InstantRP", "HardenedRP",
     and "ArchivedRP".
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierType
    :ivar status: Recovery point tier status. Known values are: "Invalid", "Valid", "Disabled",
     "Deleted", and "Rehydrated".
    :vartype status: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierStatus
    :ivar extended_info: Recovery point tier status.
    :vartype extended_info: dict[str, str]
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "extended_info": {"key": "extendedInfo", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.RecoveryPointTierType"]] = None,
        status: Optional[Union[str, "_models.RecoveryPointTierStatus"]] = None,
        extended_info: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Recovery point tier type. Known values are: "Invalid", "InstantRP",
         "HardenedRP", and "ArchivedRP".
        :paramtype type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierType
        :keyword status: Recovery point tier status. Known values are: "Invalid", "Valid", "Disabled",
         "Deleted", and "Rehydrated".
        :paramtype status: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RecoveryPointTierStatus
        :keyword extended_info: Recovery point tier status.
        :paramtype extended_info: dict[str, str]
        """
        super().__init__(type=type, status=status, extended_info=extended_info, **kwargs)


class ResourceGuardOperationDetail(_serialization.Model):
    """ResourceGuardOperationDetail.

    :ivar vault_critical_operation:
    :vartype vault_critical_operation: str
    :ivar default_resource_request:
    :vartype default_resource_request: str
    """

    _attribute_map = {
        "vault_critical_operation": {"key": "vaultCriticalOperation", "type": "str"},
        "default_resource_request": {"key": "defaultResourceRequest", "type": "str"},
    }

    def __init__(
        self,
        *,
        vault_critical_operation: Optional[str] = None,
        default_resource_request: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vault_critical_operation:
        :paramtype vault_critical_operation: str
        :keyword default_resource_request:
        :paramtype default_resource_request: str
        """
        super().__init__(**kwargs)
        self.vault_critical_operation = vault_critical_operation
        self.default_resource_request = default_resource_request


class ResourceGuardProxyBase(_serialization.Model):
    """ResourceGuardProxyBase.

    :ivar resource_guard_resource_id:
    :vartype resource_guard_resource_id: str
    :ivar resource_guard_operation_details:
    :vartype resource_guard_operation_details:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceGuardOperationDetail]
    :ivar last_updated_time:
    :vartype last_updated_time: str
    :ivar description:
    :vartype description: str
    """

    _attribute_map = {
        "resource_guard_resource_id": {"key": "resourceGuardResourceId", "type": "str"},
        "resource_guard_operation_details": {
            "key": "resourceGuardOperationDetails",
            "type": "[ResourceGuardOperationDetail]",
        },
        "last_updated_time": {"key": "lastUpdatedTime", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_guard_resource_id: Optional[str] = None,
        resource_guard_operation_details: Optional[List["_models.ResourceGuardOperationDetail"]] = None,
        last_updated_time: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_guard_resource_id:
        :paramtype resource_guard_resource_id: str
        :keyword resource_guard_operation_details:
        :paramtype resource_guard_operation_details:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceGuardOperationDetail]
        :keyword last_updated_time:
        :paramtype last_updated_time: str
        :keyword description:
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.resource_guard_resource_id = resource_guard_resource_id
        self.resource_guard_operation_details = resource_guard_operation_details
        self.last_updated_time = last_updated_time
        self.description = description


class ResourceGuardProxyBaseResource(Resource):
    """ResourceGuardProxyBaseResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: ResourceGuardProxyBaseResource properties.
    :vartype properties:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceGuardProxyBase
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "ResourceGuardProxyBase"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.ResourceGuardProxyBase"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: ResourceGuardProxyBaseResource properties.
        :paramtype properties:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceGuardProxyBase
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class ResourceGuardProxyBaseResourceList(ResourceList):
    """List of ResourceGuardProxyBase resources.

    :ivar next_link: The uri to fetch the next page of resources. Call ListNext() fetches next page
     of resources.
    :vartype next_link: str
    :ivar value: List of resources.
    :vartype value:
     list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceGuardProxyBaseResource]
    """

    _attribute_map = {
        "next_link": {"key": "nextLink", "type": "str"},
        "value": {"key": "value", "type": "[ResourceGuardProxyBaseResource]"},
    }

    def __init__(
        self,
        *,
        next_link: Optional[str] = None,
        value: Optional[List["_models.ResourceGuardProxyBaseResource"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword next_link: The uri to fetch the next page of resources. Call ListNext() fetches next
         page of resources.
        :paramtype next_link: str
        :keyword value: List of resources.
        :paramtype value:
         list[~azure.mgmt.recoveryservicesbackup.activestamp.models.ResourceGuardProxyBaseResource]
        """
        super().__init__(next_link=next_link, **kwargs)
        self.value = value


class RestoreFileSpecs(_serialization.Model):
    """Restore file specs like file path, type and target folder path info.

    :ivar path: Source File/Folder path.
    :vartype path: str
    :ivar file_spec_type: Indicates what the Path variable stands for.
    :vartype file_spec_type: str
    :ivar target_folder_path: Destination folder path in target FileShare.
    :vartype target_folder_path: str
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "file_spec_type": {"key": "fileSpecType", "type": "str"},
        "target_folder_path": {"key": "targetFolderPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        file_spec_type: Optional[str] = None,
        target_folder_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: Source File/Folder path.
        :paramtype path: str
        :keyword file_spec_type: Indicates what the Path variable stands for.
        :paramtype file_spec_type: str
        :keyword target_folder_path: Destination folder path in target FileShare.
        :paramtype target_folder_path: str
        """
        super().__init__(**kwargs)
        self.path = path
        self.file_spec_type = file_spec_type
        self.target_folder_path = target_folder_path


class RestoreRequestResource(Resource):
    """Base class for restore request. Workload-specific restore requests are derived from this class.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id represents the complete path to the resource.
    :vartype id: str
    :ivar name: Resource name associated with the resource.
    :vartype name: str
    :ivar type: Resource type represents the complete path of the form
     Namespace/ResourceType/ResourceType/...
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar e_tag: Optional ETag.
    :vartype e_tag: str
    :ivar properties: RestoreRequestResource properties.
    :vartype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestoreRequest
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "e_tag": {"key": "eTag", "type": "str"},
        "properties": {"key": "properties", "type": "RestoreRequest"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        e_tag: Optional[str] = None,
        properties: Optional["_models.RestoreRequest"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword e_tag: Optional ETag.
        :paramtype e_tag: str
        :keyword properties: RestoreRequestResource properties.
        :paramtype properties: ~azure.mgmt.recoveryservicesbackup.activestamp.models.RestoreRequest
        """
        super().__init__(location=location, tags=tags, e_tag=e_tag, **kwargs)
        self.properties = properties


class RetentionDuration(_serialization.Model):
    """Retention duration.

    :ivar count: Count of duration types. Retention duration is obtained by the counting the
     duration type Count times.
     For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
    :vartype count: int
    :ivar duration_type: Retention duration type of retention policy. Known values are: "Invalid",
     "Days", "Weeks", "Months", and "Years".
    :vartype duration_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionDurationType
    """

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "duration_type": {"key": "durationType", "type": "str"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        duration_type: Optional[Union[str, "_models.RetentionDurationType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Count of duration types. Retention duration is obtained by the counting the
         duration type Count times.
         For example, when Count = 3 and DurationType = Weeks, retention duration will be three weeks.
        :paramtype count: int
        :keyword duration_type: Retention duration type of retention policy. Known values are:
         "Invalid", "Days", "Weeks", "Months", and "Years".
        :paramtype duration_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionDurationType
        """
        super().__init__(**kwargs)
        self.count = count
        self.duration_type = duration_type


class SecuredVMDetails(_serialization.Model):
    """Restore request parameters for Secured VMs.

    :ivar secured_vmos_disk_encryption_set_id: Gets or Sets Disk Encryption Set Id for Secured VM
     OS Disk.
    :vartype secured_vmos_disk_encryption_set_id: str
    """

    _attribute_map = {
        "secured_vmos_disk_encryption_set_id": {"key": "securedVMOsDiskEncryptionSetId", "type": "str"},
    }

    def __init__(self, *, secured_vmos_disk_encryption_set_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword secured_vmos_disk_encryption_set_id: Gets or Sets Disk Encryption Set Id for Secured
         VM OS Disk.
        :paramtype secured_vmos_disk_encryption_set_id: str
        """
        super().__init__(**kwargs)
        self.secured_vmos_disk_encryption_set_id = secured_vmos_disk_encryption_set_id


class SecurityPinBase(_serialization.Model):
    """Base class for get security pin request body.

    :ivar resource_guard_operation_requests: ResourceGuard Operation Requests.
    :vartype resource_guard_operation_requests: list[str]
    """

    _attribute_map = {
        "resource_guard_operation_requests": {"key": "resourceGuardOperationRequests", "type": "[str]"},
    }

    def __init__(self, *, resource_guard_operation_requests: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword resource_guard_operation_requests: ResourceGuard Operation Requests.
        :paramtype resource_guard_operation_requests: list[str]
        """
        super().__init__(**kwargs)
        self.resource_guard_operation_requests = resource_guard_operation_requests


class Settings(_serialization.Model):
    """Common settings field for backup management.

    :ivar time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific Standard
     Time".
    :vartype time_zone: str
    :ivar issqlcompression: SQL compression flag.
    :vartype issqlcompression: bool
    :ivar is_compression: Workload compression flag. This has been added so that 'isSqlCompression'
     will be deprecated once clients upgrade to consider this flag.
    :vartype is_compression: bool
    """

    _attribute_map = {
        "time_zone": {"key": "timeZone", "type": "str"},
        "issqlcompression": {"key": "issqlcompression", "type": "bool"},
        "is_compression": {"key": "isCompression", "type": "bool"},
    }

    def __init__(
        self,
        *,
        time_zone: Optional[str] = None,
        issqlcompression: Optional[bool] = None,
        is_compression: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword time_zone: TimeZone optional input as string. For example: TimeZone = "Pacific
         Standard Time".
        :paramtype time_zone: str
        :keyword issqlcompression: SQL compression flag.
        :paramtype issqlcompression: bool
        :keyword is_compression: Workload compression flag. This has been added so that
         'isSqlCompression'
         will be deprecated once clients upgrade to consider this flag.
        :paramtype is_compression: bool
        """
        super().__init__(**kwargs)
        self.time_zone = time_zone
        self.issqlcompression = issqlcompression
        self.is_compression = is_compression


class SimpleRetentionPolicy(RetentionPolicy):
    """Simple policy retention.

    All required parameters must be populated in order to send to Azure.

    :ivar retention_policy_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype retention_policy_type: str
    :ivar retention_duration: Retention duration of the protection policy.
    :vartype retention_duration:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionDuration
    """

    _validation = {
        "retention_policy_type": {"required": True},
    }

    _attribute_map = {
        "retention_policy_type": {"key": "retentionPolicyType", "type": "str"},
        "retention_duration": {"key": "retentionDuration", "type": "RetentionDuration"},
    }

    def __init__(self, *, retention_duration: Optional["_models.RetentionDuration"] = None, **kwargs: Any) -> None:
        """
        :keyword retention_duration: Retention duration of the protection policy.
        :paramtype retention_duration:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionDuration
        """
        super().__init__(**kwargs)
        self.retention_policy_type: str = "SimpleRetentionPolicy"
        self.retention_duration = retention_duration


class SimpleSchedulePolicy(SchedulePolicy):
    """Simple policy schedule.

    All required parameters must be populated in order to send to Azure.

    :ivar schedule_policy_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype schedule_policy_type: str
    :ivar schedule_run_frequency: Frequency of the schedule operation of this policy. Known values
     are: "Invalid", "Daily", "Weekly", and "Hourly".
    :vartype schedule_run_frequency: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ScheduleRunType
    :ivar schedule_run_days: List of days of week this schedule has to be run.
    :vartype schedule_run_days: list[str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.DayOfWeek]
    :ivar schedule_run_times: List of times of day this schedule has to be run.
    :vartype schedule_run_times: list[~datetime.datetime]
    :ivar hourly_schedule: Hourly Schedule of this Policy.
    :vartype hourly_schedule: ~azure.mgmt.recoveryservicesbackup.activestamp.models.HourlySchedule
    :ivar schedule_weekly_frequency: At every number weeks this schedule has to be run.
    :vartype schedule_weekly_frequency: int
    """

    _validation = {
        "schedule_policy_type": {"required": True},
    }

    _attribute_map = {
        "schedule_policy_type": {"key": "schedulePolicyType", "type": "str"},
        "schedule_run_frequency": {"key": "scheduleRunFrequency", "type": "str"},
        "schedule_run_days": {"key": "scheduleRunDays", "type": "[str]"},
        "schedule_run_times": {"key": "scheduleRunTimes", "type": "[iso-8601]"},
        "hourly_schedule": {"key": "hourlySchedule", "type": "HourlySchedule"},
        "schedule_weekly_frequency": {"key": "scheduleWeeklyFrequency", "type": "int"},
    }

    def __init__(
        self,
        *,
        schedule_run_frequency: Optional[Union[str, "_models.ScheduleRunType"]] = None,
        schedule_run_days: Optional[List[Union[str, "_models.DayOfWeek"]]] = None,
        schedule_run_times: Optional[List[datetime.datetime]] = None,
        hourly_schedule: Optional["_models.HourlySchedule"] = None,
        schedule_weekly_frequency: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schedule_run_frequency: Frequency of the schedule operation of this policy. Known
         values are: "Invalid", "Daily", "Weekly", and "Hourly".
        :paramtype schedule_run_frequency: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ScheduleRunType
        :keyword schedule_run_days: List of days of week this schedule has to be run.
        :paramtype schedule_run_days: list[str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.DayOfWeek]
        :keyword schedule_run_times: List of times of day this schedule has to be run.
        :paramtype schedule_run_times: list[~datetime.datetime]
        :keyword hourly_schedule: Hourly Schedule of this Policy.
        :paramtype hourly_schedule:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.HourlySchedule
        :keyword schedule_weekly_frequency: At every number weeks this schedule has to be run.
        :paramtype schedule_weekly_frequency: int
        """
        super().__init__(**kwargs)
        self.schedule_policy_type: str = "SimpleSchedulePolicy"
        self.schedule_run_frequency = schedule_run_frequency
        self.schedule_run_days = schedule_run_days
        self.schedule_run_times = schedule_run_times
        self.hourly_schedule = hourly_schedule
        self.schedule_weekly_frequency = schedule_weekly_frequency


class SimpleSchedulePolicyV2(SchedulePolicy):
    """The V2 policy schedule for IaaS that supports hourly backups.

    All required parameters must be populated in order to send to Azure.

    :ivar schedule_policy_type: This property will be used as the discriminator for deciding the
     specific types in the polymorphic chain of types. Required.
    :vartype schedule_policy_type: str
    :ivar schedule_run_frequency: Frequency of the schedule operation of this policy. Known values
     are: "Invalid", "Daily", "Weekly", and "Hourly".
    :vartype schedule_run_frequency: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.ScheduleRunType
    :ivar hourly_schedule: hourly schedule of this policy.
    :vartype hourly_schedule: ~azure.mgmt.recoveryservicesbackup.activestamp.models.HourlySchedule
    :ivar daily_schedule: Daily schedule of this policy.
    :vartype daily_schedule: ~azure.mgmt.recoveryservicesbackup.activestamp.models.DailySchedule
    :ivar weekly_schedule: Weekly schedule of this policy.
    :vartype weekly_schedule: ~azure.mgmt.recoveryservicesbackup.activestamp.models.WeeklySchedule
    """

    _validation = {
        "schedule_policy_type": {"required": True},
    }

    _attribute_map = {
        "schedule_policy_type": {"key": "schedulePolicyType", "type": "str"},
        "schedule_run_frequency": {"key": "scheduleRunFrequency", "type": "str"},
        "hourly_schedule": {"key": "hourlySchedule", "type": "HourlySchedule"},
        "daily_schedule": {"key": "dailySchedule", "type": "DailySchedule"},
        "weekly_schedule": {"key": "weeklySchedule", "type": "WeeklySchedule"},
    }

    def __init__(
        self,
        *,
        schedule_run_frequency: Optional[Union[str, "_models.ScheduleRunType"]] = None,
        hourly_schedule: Optional["_models.HourlySchedule"] = None,
        daily_schedule: Optional["_models.DailySchedule"] = None,
        weekly_schedule: Optional["_models.WeeklySchedule"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schedule_run_frequency: Frequency of the schedule operation of this policy. Known
         values are: "Invalid", "Daily", "Weekly", and "Hourly".
        :paramtype schedule_run_frequency: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.ScheduleRunType
        :keyword hourly_schedule: hourly schedule of this policy.
        :paramtype hourly_schedule:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.HourlySchedule
        :keyword daily_schedule: Daily schedule of this policy.
        :paramtype daily_schedule: ~azure.mgmt.recoveryservicesbackup.activestamp.models.DailySchedule
        :keyword weekly_schedule: Weekly schedule of this policy.
        :paramtype weekly_schedule:
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.WeeklySchedule
        """
        super().__init__(**kwargs)
        self.schedule_policy_type: str = "SimpleSchedulePolicyV2"
        self.schedule_run_frequency = schedule_run_frequency
        self.hourly_schedule = hourly_schedule
        self.daily_schedule = daily_schedule
        self.weekly_schedule = weekly_schedule


class SQLDataDirectory(_serialization.Model):
    """SQLDataDirectory info.

    :ivar type: Type of data directory mapping. Known values are: "Invalid", "Data", and "Log".
    :vartype type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryType
    :ivar path: File path.
    :vartype path: str
    :ivar logical_name: Logical name of the file.
    :vartype logical_name: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "path": {"key": "path", "type": "str"},
        "logical_name": {"key": "logicalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.SQLDataDirectoryType"]] = None,
        path: Optional[str] = None,
        logical_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of data directory mapping. Known values are: "Invalid", "Data", and "Log".
        :paramtype type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryType
        :keyword path: File path.
        :paramtype path: str
        :keyword logical_name: Logical name of the file.
        :paramtype logical_name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.path = path
        self.logical_name = logical_name


class SQLDataDirectoryMapping(_serialization.Model):
    """Encapsulates information regarding data directory.

    :ivar mapping_type: Type of data directory mapping. Known values are: "Invalid", "Data", and
     "Log".
    :vartype mapping_type: str or
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryType
    :ivar source_logical_name: Restore source logical name path.
    :vartype source_logical_name: str
    :ivar source_path: Restore source path.
    :vartype source_path: str
    :ivar target_path: Target path.
    :vartype target_path: str
    """

    _attribute_map = {
        "mapping_type": {"key": "mappingType", "type": "str"},
        "source_logical_name": {"key": "sourceLogicalName", "type": "str"},
        "source_path": {"key": "sourcePath", "type": "str"},
        "target_path": {"key": "targetPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        mapping_type: Optional[Union[str, "_models.SQLDataDirectoryType"]] = None,
        source_logical_name: Optional[str] = None,
        source_path: Optional[str] = None,
        target_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword mapping_type: Type of data directory mapping. Known values are: "Invalid", "Data", and
         "Log".
        :paramtype mapping_type: str or
         ~azure.mgmt.recoveryservicesbackup.activestamp.models.SQLDataDirectoryType
        :keyword source_logical_name: Restore source logical name path.
        :paramtype source_logical_name: str
        :keyword source_path: Restore source path.
        :paramtype source_path: str
        :keyword target_path: Target path.
        :paramtype target_path: str
        """
        super().__init__(**kwargs)
        self.mapping_type = mapping_type
        self.source_logical_name = source_logical_name
        self.source_path = source_path
        self.target_path = target_path


class SubProtectionPolicy(_serialization.Model):
    """Sub-protection policy which includes schedule and retention.

    :ivar policy_type: Type of backup policy type. Known values are: "Invalid", "Full",
     "Differential", "Log", "CopyOnlyFull", "Incremental", "SnapshotFull", and
     "SnapshotCopyOnlyFull".
    :vartype policy_type: str or ~azure.mgmt.recoveryservicesbackup.activestamp.models.PolicyType
    :ivar schedule_policy: Backup schedule specified as part of backup policy.
    :vartype schedule_policy: ~azure.mgmt.recoveryservicesbackup.activestamp.models.SchedulePolicy
    :ivar retention_policy: Retention policy with the details on backup copy retention ranges.
    :vartype retention_policy:
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.RetentionPolicy
    :ivar tiering_policy: Tiering policy to automatically move RPs to another tier.
     Key is Target Tier, defined in RecoveryPointTierType enum.
     Tiering policy specifies the criteria to move RP to the target tier.
    :vartype tiering_policy: dict[str,
     ~azure.mgmt.recoveryservicesbackup.activestamp.models.TieringPolicy]
    