/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.logging.Level;
import javax.sql.DataSource;
import oracle.jdbc.datasource.impl.OracleConnectionBuilderImpl;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.pool.OracleDataSource;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.jdbc.DataSourceConnectionFactoryAdapter;
import oracle.ucp.jdbc.JDBCConnectionPool;
import oracle.ucp.jdbc.JDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleJDBCConnectionRetrievalInfo;
import oracle.ucp.jdbc.oracle.OracleUniversalPooledConnection;
import oracle.ucp.util.UCPErrorHandler;
import oracle.ucp.util.Util;

public class OracleDataSourceConnectionFactoryAdapter
extends DataSourceConnectionFactoryAdapter {
    static final String CLASS_NAME = OracleDataSourceConnectionFactoryAdapter.class.getName();

    public OracleDataSourceConnectionFactoryAdapter(DataSource dataSource, Diagnosable diagnosticsCollector) throws UniversalConnectionPoolException {
        super(dataSource, diagnosticsCollector);
        this.initializeUrlFromConnectionFactory();
    }

    public OracleDataSourceConnectionFactoryAdapter(DataSource dataSource) throws UniversalConnectionPoolException {
        this(dataSource, DiagnosticsCollectorImpl.getCommon());
    }

    @Override
    public CompletionStage<Object> createConnectionAsync(ConnectionRetrievalInfo cri, Executor executor) {
        CompletableFuture cf;
        String instanceName;
        if (!(this.m_dataSource instanceof OracleDataSource)) {
            this.trace(Level.FINEST, CLASS_NAME, "createConnectionAsync", "about to create connection without specifying instance", null, null, new Object[0]);
            return super.createConnectionAsync(cri, executor);
        }
        OracleDataSource ods = (OracleDataSource)this.m_dataSource;
        OracleConnectionBuilderImpl builder = ods.createConnectionBuilder();
        JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)cri;
        if (cri instanceof OracleJDBCConnectionRetrievalInfo) {
            instanceName = ((OracleJDBCConnectionRetrievalInfo)cri).getInstanceName();
            this.trace(Level.FINEST, CLASS_NAME, "createConnectionAsync", "about to create connection to the instance {0}", null, null, instanceName);
        } else {
            instanceName = null;
        }
        try {
            cf = ((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)builder.user(jdbcCri.getUser())).password(jdbcCri.getPassword().toJDBCOpaqueString())).instanceName(instanceName)).serviceName(jdbcCri.getUserRequestedServiceName())).shardingKey(jdbcCri.getShardingKey())).superShardingKey(jdbcCri.getSuperShardingKey())).sslContext(jdbcCri.getSSLContext())).hostnameResolver(jdbcCri.getHostnameResolver() == null ? null : host -> jdbcCri.getHostnameResolver().getAllByName(host))).readOnlyInstanceAllowed(jdbcCri.isReadOnlyInstanceAllowed())).executorOracle(executor)).buildAsyncOracle().toCompletableFuture();
        }
        catch (SQLException e) {
            this.onFailedConnectionCreation(e);
            CompletableFuture<Object> cfe = new CompletableFuture<Object>();
            cfe.completeExceptionally(e);
            return cfe;
        }
        return cf.thenComposeAsync(conn -> {
            CompletableFuture<oracle.jdbc.OracleConnection> cf2 = new CompletableFuture<oracle.jdbc.OracleConnection>();
            if (null == conn) {
                cf2.complete(null);
                return cf2;
            }
            if (null != conn) {
                this.onSuccessfulConnectionCreation(conn);
            }
            try {
                OracleDataSourceConnectionFactoryAdapter.postProcessConnection(jdbcCri, instanceName, conn);
                cf2.complete((oracle.jdbc.OracleConnection)conn);
            }
            catch (SQLException e) {
                this.onFailedConnectionCreation(e);
                cf2.completeExceptionally(e);
            }
            return cf2;
        });
    }

    @Override
    public CompletionStage<Void> closeConnectionAsync(Object connection, Executor executor) {
        if (!(connection instanceof Connection)) {
            this.trace(Level.SEVERE, CLASS_NAME, "createConnectionAsync", "not an Oracle connection", null, null, new Object[0]);
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<Void> cf = new CompletableFuture<Void>();
        try {
            Connection conn = (Connection)connection;
            oracle.jdbc.OracleConnection oconn = conn.unwrap(oracle.jdbc.OracleConnection.class);
            CompletionStageUtil.subscribeForSingleItem((Flow.Publisher)oconn.closeAsyncOracle()).whenCompleteAsync((nil, error) -> {
                if (Objects.nonNull(error)) {
                    this.trace(Level.WARNING, CLASS_NAME, "createConnectionAsync", "failed to close connection", null, error, new Object[0]);
                    cf.completeExceptionally((Throwable)error);
                } else {
                    cf.complete(null);
                }
            }, executor);
        }
        catch (SQLException e) {
            cf.completeExceptionally(e);
        }
        return cf;
    }

    @Override
    public Object createConnection(ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        Connection connection = null;
        try {
            if (!(this.m_dataSource instanceof OracleDataSource)) {
                this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection without specifying instance", null, null, new Object[0]);
                connection = (Connection)super.createConnection(connectionRequestInfo);
            } else {
                OracleDataSource ods = (OracleDataSource)this.m_dataSource;
                JDBCConnectionRetrievalInfo jdbcCri = (JDBCConnectionRetrievalInfo)connectionRequestInfo;
                String instanceName = connectionRequestInfo instanceof OracleJDBCConnectionRetrievalInfo ? ((OracleJDBCConnectionRetrievalInfo)connectionRequestInfo).getInstanceName() : null;
                this.trace(Level.FINEST, CLASS_NAME, "createConnection", "about to create connection to the instance: {0}", null, null, instanceName);
                OracleConnectionBuilderImpl builder = ods.createConnectionBuilder();
                connection = ((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)((OracleConnectionBuilderImpl)builder.user(jdbcCri.getUser())).password(jdbcCri.getPassword().toJDBCOpaqueString())).instanceName(instanceName)).serviceName(jdbcCri.getUserRequestedServiceName())).shardingKey(jdbcCri.getShardingKey())).superShardingKey(jdbcCri.getSuperShardingKey())).sslContext(jdbcCri.getSSLContext())).hostnameResolver(jdbcCri.getHostnameResolver() == null ? null : host -> jdbcCri.getHostnameResolver().getAllByName(host))).readOnlyInstanceAllowed(jdbcCri.isReadOnlyInstanceAllowed())).build();
                OracleDataSourceConnectionFactoryAdapter.postProcessConnection(jdbcCri, instanceName, connection);
            }
            if (null != connection) {
                this.onSuccessfulConnectionCreation(connection);
            }
        }
        catch (Throwable e) {
            this.onFailedConnectionCreation(e);
            this.trace(Level.WARNING, CLASS_NAME, "createConnection", "", null, e, new Object[0]);
            if (null != connection) {
                this.closeConnection(connection);
            }
            UCPErrorHandler.throwUniversalConnectionPoolException(257, e);
        }
        return connection;
    }

    private static void postProcessConnection(JDBCConnectionRetrievalInfo jdbcCri, String instanceName, Object connection) throws SQLException {
        if (connection instanceof OracleConnection) {
            Properties proxyProps;
            String in = ((OracleConnection)connection).getServerSessionInfo().getProperty("INSTANCE_NAME");
            assert (null != in);
            assert (instanceName == null || Util.equalsNormalized(in, instanceName)) : "internal error: got connection from the wrong instance";
            if (instanceName != null && !"".equals(instanceName) && !Util.equalsNormalized(in, instanceName)) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "postProcessConnection", "wrong conn opened, desired: {0}, actual: {1}", null, null, instanceName, in);
            }
            if ((proxyProps = jdbcCri.getProxyProperties()) != null) {
                int proxyType = jdbcCri.getProxyType();
                DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "postProcessConnection", "Opening proxy session with Properties={0}", null, null, proxyProps);
                ((OracleConnection)connection).openProxySession(proxyType, proxyProps);
            }
        } else {
            DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "postProcessConnection", "not an oracle connection", null, null, new Object[0]);
        }
    }

    @Override
    public UniversalPooledConnection createPooledConnection(Object connection, ConnectionRetrievalInfo connectionRequestInfo) throws UniversalConnectionPoolException {
        JDBCConnectionPool jdbccp = (JDBCConnectionPool)this.getUniversalConnectionPool();
        OracleUniversalPooledConnection pooledConnection = new OracleUniversalPooledConnection(jdbccp, connection, connectionRequestInfo, jdbccp.isFailoverEnabled());
        return pooledConnection;
    }

    @Override
    public void initializeUrlFromConnectionFactory() {
        Class<?> dsClass = this.m_dataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
            Method m = cls.getMethod("getURL", new Class[0]);
            this.m_url = (String)m.invoke((Object)this.m_dataSource, new Object[0]);
            this.trace(Level.FINEST, CLASS_NAME, "initializeUrlFromConnectionFactory", "initializeUrlFromConnectionFactory() succeeded", null, null, new Object[0]);
        }
        catch (Exception exc) {
            this.trace(Level.WARNING, CLASS_NAME, "initializeUrlFromConnectionFactory", "", null, exc, new Object[0]);
        }
    }

    @Override
    public void setUrl(String url) {
        Class<?> dsClass = this.m_dataSource.getClass();
        Class<?> cls = null;
        try {
            cls = Class.forName("oracle.jdbc.pool.OracleDataSource", true, dsClass.getClassLoader());
            Method m = cls.getMethod("setURL", String.class);
            m.invoke((Object)this.m_dataSource, url);
        }
        catch (Exception exc) {
            this.trace(Level.WARNING, CLASS_NAME, "setUrl", "", null, exc, new Object[0]);
        }
    }
}

