/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.common;

import java.util.Comparator;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import oracle.jdbc.clio.annotations.Debug;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.ucp.ConnectionFactoryAdapter;
import oracle.ucp.ConnectionRetrievalInfo;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.UniversalPooledConnection;
import oracle.ucp.common.ConnectionSource;
import oracle.ucp.common.CoreConnection;
import oracle.ucp.diagnostics.Diagnosable;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.UCPErrorHandler;

abstract class Database
implements ConnectionSource {
    static final String CLASS_NAME = Database.class.getName();
    private volatile Diagnosable diagnosticsCollector = DiagnosticsCollectorImpl.getCommon();

    Database(Diagnosable diagnosticsCollector) {
        this.diagnosticsCollector = Objects.requireNonNull(diagnosticsCollector);
    }

    protected abstract ConnectionFactoryAdapter getConnectionFactoryAdapter();

    protected abstract AtomicInteger connectionsCreated();

    protected abstract AtomicInteger connectionsClosed();

    @Override
    public Comparator<CoreConnection> costComparator(final Properties labels) {
        return new Comparator<CoreConnection>(){

            @Override
            public int compare(CoreConnection conn1, CoreConnection conn2) {
                if (null == conn1) {
                    throw new IllegalArgumentException("conn1 is null");
                }
                if (null == conn2) {
                    throw new IllegalArgumentException("conn2 is null");
                }
                UniversalPooledConnection upc1 = (UniversalPooledConnection)conn1.getDelegate();
                UniversalPooledConnection upc2 = (UniversalPooledConnection)conn2.getDelegate();
                return upc1.labelingCost(labels) - upc2.labelingCost(labels);
            }

            @Override
            public boolean equals(Object that) {
                if (!(that instanceof Comparator)) {
                    return false;
                }
                return this == that;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    protected UniversalPooledConnection createPooledConnection(ConnectionRetrievalInfo connectionRetrievalInfo) throws UniversalConnectionPoolException {
        try {
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Database", "createPooledConnection", "entering args ({0})", null, null, connectionRetrievalInfo);
            if (cri == null) {
                this.trace(Level.WARNING, CLASS_NAME, "createPooledConnection", "CRI is not defined", null, null, new Object[0]);
                UniversalPooledConnection universalPooledConnection = null;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Database", "createPooledConnection", "returning {0}", null, null, universalPooledConnection);
                return universalPooledConnection;
            }
            Object connection = null;
            UniversalPooledConnection upc = null;
            try {
                connection = this.getConnectionFactoryAdapter().createConnection((ConnectionRetrievalInfo)cri);
                if (null == connection) {
                    UCPErrorHandler.throwUniversalConnectionPoolException(100);
                }
                upc = this.getConnectionFactoryAdapter().createPooledConnection(connection, cri.getCopyWithNoLabels());
                this.connectionsCreated().incrementAndGet();
            }
            finally {
                if (null != connection && null == upc) {
                    try {
                        this.getConnectionFactoryAdapter().closeConnection(connection);
                        this.connectionsClosed().incrementAndGet();
                    }
                    catch (UniversalConnectionPoolException e) {
                        this.trace(Level.WARNING, CLASS_NAME, "createPooledConnection", "", null, e, new Object[0]);
                    }
                }
            }
            UniversalPooledConnection universalPooledConnection = upc;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Database", "createPooledConnection", "returning {0}", null, null, universalPooledConnection);
            return universalPooledConnection;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Database", "createPooledConnection", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Debug(level=Debug.Level.FINEST)
    protected CompletionStage<UniversalPooledConnection> createPooledConnectionAsync(ConnectionRetrievalInfo connectionRetrievalInfo, Executor executor) {
        try {
            void executor2;
            void cri;
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Database", "createPooledConnectionAsync", "entering args ({0}, {1})", null, null, connectionRetrievalInfo, executor);
            CompletableFuture<UniversalPooledConnection> cf = new CompletableFuture<UniversalPooledConnection>();
            if (Objects.isNull(cri)) {
                this.trace(Level.WARNING, CLASS_NAME, "createPooledConnectionAsync", "CRI is null", null, null, new Object[0]);
                cf.completeExceptionally(new IllegalArgumentException("CRI is null"));
                CompletableFuture<UniversalPooledConnection> completableFuture = cf;
                this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Database", "createPooledConnectionAsync", "returning {0}", null, null, completableFuture);
                return completableFuture;
            }
            CompletionStage<UniversalPooledConnection> completionStage = this.getConnectionFactoryAdapter().createConnectionAsync((ConnectionRetrievalInfo)cri, (Executor)executor2).thenComposeAsync(arg_0 -> this.lambda$createPooledConnectionAsync$1(cf, (ConnectionRetrievalInfo)cri, (Executor)executor2, arg_0));
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Database", "createPooledConnectionAsync", "returning {0}", null, null, completionStage);
            return completionStage;
        }
        catch (Throwable throwable) {
            this.debug(Level.FINEST, SecurityLabel.INTERNAL, "oracle.ucp.common.Database", "createPooledConnectionAsync", "throwing", null, throwable, new Object[0]);
            throw throwable;
        }
    }

    @Override
    public Diagnosable getDiagnosable() {
        return this.diagnosticsCollector;
    }

    private /* synthetic */ CompletionStage lambda$createPooledConnectionAsync$1(CompletableFuture cf, ConnectionRetrievalInfo cri, Executor executor, Object conn) {
        UniversalPooledConnection upc;
        if (Objects.isNull(conn)) {
            cf.completeExceptionally(UCPErrorHandler.newUniversalConnectionPoolException(100));
            return cf;
        }
        try {
            upc = this.getConnectionFactoryAdapter().createPooledConnection(conn, cri.getCopyWithNoLabels());
        }
        catch (UniversalConnectionPoolException e) {
            cf.completeExceptionally(e);
            return cf;
        }
        if (Objects.isNull(upc)) {
            return this.getConnectionFactoryAdapter().closeConnectionAsync(conn, executor).thenComposeAsync(p -> {
                this.connectionsClosed().incrementAndGet();
                return null;
            }, executor);
        }
        this.connectionsCreated().incrementAndGet();
        cf.complete(upc);
        return cf;
    }
}

