/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.pojo;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.mutations.EdgeStrategy;
import oracle.pgx.common.mutations.LabelMergingFunction;
import oracle.pgx.common.mutations.MergingFunction;
import oracle.pgx.common.mutations.MergingStrategy;
import oracle.pgx.common.mutations.PickByEdgeId;
import oracle.pgx.common.mutations.PickByProperty;
import oracle.pgx.common.mutations.PickingStrategy;
import oracle.pgx.common.mutations.PickingStrategyFunction;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.JsonUtil;

public class EdgeStrategyDeserializer
extends JsonDeserializer<EdgeStrategy> {
    private static JsonNode getNode(JsonNode jsonNode, String valueName) {
        JsonNode resultNode = jsonNode.get(valueName);
        if (resultNode == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"MISSING_JSON_FIELD_MUTATION_STRATEGY", (Object[])new Object[]{valueName}));
        }
        return resultNode;
    }

    private static EdgeStrategy getEdgeStrategy(JsonNode mEdgeStrategy, boolean noSelfEdges) throws IOException {
        switch ((EdgeStrategy.StrategyType)JsonUtil.fromJsonNode((JsonNode)EdgeStrategyDeserializer.getNode(mEdgeStrategy, "strategyType"), EdgeStrategy.StrategyType.class)) {
            case KEEP_ALL: {
                return new EdgeStrategy.KeepMultiEdgesStrategy(noSelfEdges);
            }
            case PICK_ANY: {
                return new PickingStrategy.PickAnyStrategy(noSelfEdges);
            }
            case PICK_BY_EDGE_ID: {
                return new PickByEdgeId((PickingStrategyFunction)JsonUtil.fromJsonNode((JsonNode)EdgeStrategyDeserializer.getNode(mEdgeStrategy, "pickingStrategyFunction"), PickingStrategyFunction.class), noSelfEdges);
            }
            case PICK_BY_PROPERTY: {
                if (mEdgeStrategy.hasNonNull("edgePropertyId")) {
                    return new PickByProperty((PgxId)JsonUtil.fromJsonNode((JsonNode)mEdgeStrategy.get("edgePropertyId"), PgxId.class), (PickingStrategyFunction)JsonUtil.fromJsonNode((JsonNode)EdgeStrategyDeserializer.getNode(mEdgeStrategy, "pickingStrategyFunction"), PickingStrategyFunction.class), noSelfEdges);
                }
                return new PickByProperty(EdgeStrategyDeserializer.getNode(mEdgeStrategy, "edgePropertyIndex").asInt(), (PickingStrategyFunction)JsonUtil.fromJsonNode((JsonNode)EdgeStrategyDeserializer.getNode(mEdgeStrategy, "pickingStrategyFunction"), PickingStrategyFunction.class), noSelfEdges);
            }
            case MERGE: {
                return EdgeStrategyDeserializer.getMergeStrategy(mEdgeStrategy, noSelfEdges);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNKNOWN_EDGE_STRATEGY", (Object[])new Object[]{EdgeStrategyDeserializer.getNode(mEdgeStrategy, "strategyType").asText()}));
    }

    private static EdgeStrategy getMergeStrategy(JsonNode mEdgeStrategy, boolean noSelfEdges) {
        JsonNode mStrategies = EdgeStrategyDeserializer.getNode(mEdgeStrategy, "mergingStrategies");
        MergingFunction[] mergingFunctions = new MergingFunction[mStrategies.size()];
        int i = 0;
        for (JsonNode mStrategy : mStrategies) {
            mergingFunctions[i++] = MergingFunction.valueOf((String)mStrategy.asText());
        }
        LabelMergingFunction labelMergingFunction = LabelMergingFunction.valueOf((String)EdgeStrategyDeserializer.getNode(mEdgeStrategy, "labelMergingStrategy").asText());
        boolean keepUserDefinedEdgeKeys = EdgeStrategyDeserializer.getNode(mEdgeStrategy, "keepUserDefinedEdgeKeys").asBoolean();
        return new MergingStrategy(mergingFunctions, labelMergingFunction, keepUserDefinedEdgeKeys, noSelfEdges);
    }

    public EdgeStrategy deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode jsonNode = (JsonNode)jp.getCodec().readTree(jp);
        boolean noSelfEdges = EdgeStrategyDeserializer.getNode(jsonNode, "noSelfEdges").asBoolean();
        return EdgeStrategyDeserializer.getEdgeStrategy(jsonNode, noSelfEdges);
    }
}

