/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.subgraph.internal;

import java.util.ArrayList;
import java.util.Objects;
import oracle.pgx.api.subgraph.PreparedPgqlQueryBuilder;
import oracle.pgx.common.types.QueryArgumentType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.PreparedQueryArgumentConfig;
import oracle.pgx.config.PreparedQueryArgumentConfigBuilder;
import oracle.pgx.config.PreparedQueryConfig;
import oracle.pgx.config.PreparedQueryConfigBuilder;

public class PreparedPgqlQueryBuilderImpl
implements PreparedPgqlQueryBuilder<PreparedPgqlQueryBuilderImpl> {
    private final ArrayList<PreparedQueryArgumentConfig> arguments = new ArrayList();
    private final String query;

    public PreparedPgqlQueryBuilderImpl(String query) {
        this.query = Objects.requireNonNull(query);
    }

    @Override
    public PreparedPgqlQueryBuilderImpl withArg(int position, QueryArgumentType type, Object value) {
        if (position < 1) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_ARGUMENT_POSITION", (Object[])new Object[]{position}));
        }
        ErrorMessages.requireNonNull((Object)type, (String)"type");
        ErrorMessages.requireNonNull((Object)value, (String)"value");
        if (!type.getTypeClass().isInstance(value)) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNEXPECTED_VALUE_TYPE", (Object[])new Object[]{type.toKey(), value, value.getClass().getName()}));
        }
        PreparedQueryArgumentConfig preparedQueryArgumentConfig = PreparedQueryArgumentConfigBuilder.buildPreparedQueryArgumentConfig(builder -> builder.setType(type).setValue(value));
        this.ensureArgumentCapacity(position - 1);
        this.arguments.set(position - 1, preparedQueryArgumentConfig);
        return this;
    }

    public PreparedQueryConfig buildQueryWithArguments() {
        for (int i = 0; i < this.arguments.size(); ++i) {
            ErrorMessages.requireNonNull((Object)this.arguments.get(i), (String)("argument " + (i + 1)));
        }
        return PreparedQueryConfigBuilder.buildPreparedQueryConfig(builder -> builder.setQuery(this.query).setArguments(this.arguments));
    }

    private void ensureArgumentCapacity(int index) {
        if (this.arguments.size() < index + 1) {
            this.arguments.ensureCapacity(index + 1);
            int fillersToAdd = 1 + index - this.arguments.size();
            for (int i = 0; i < fillersToAdd; ++i) {
                this.arguments.add(null);
            }
        }
    }
}

