/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.mllib;

import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.mllib.Pg2vecModelMetadata;
import oracle.pgx.api.mllib.Pg2vecModel;
import oracle.pgx.config.mllib.Pg2vecModelConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pg2vecModelBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(Pg2vecModelBuilder.class);
    private final PgxSession session;
    private final Core core;
    private final Supplier<String> keystorePathSupplier;
    private final Supplier<char[]> keystorePasswordSupplier;
    private final Pg2vecModelConfig pg2vecModelConfig;

    public Pg2vecModelBuilder(PgxSession session, Core core, Supplier<String> keystorePathSupplier, Supplier<char[]> keystorePasswordSupplier) {
        this.session = session;
        this.core = core;
        this.keystorePathSupplier = keystorePathSupplier;
        this.keystorePasswordSupplier = keystorePasswordSupplier;
        this.pg2vecModelConfig = new Pg2vecModelConfig();
    }

    public Pg2vecModelBuilder setUseGraphletSize(boolean useGraphletSize) {
        this.pg2vecModelConfig.setUseGraphletSize(Boolean.valueOf(useGraphletSize));
        return this;
    }

    public Boolean getUseGraphletSize() {
        return this.pg2vecModelConfig.getUseGraphletSize();
    }

    public Pg2vecModelBuilder setGraphLetIdPropertyName(String graphLetIdName) {
        this.pg2vecModelConfig.setGraphLetIdPropertyName(graphLetIdName);
        return this;
    }

    public String getGraphLetIdPropertyName() {
        return this.pg2vecModelConfig.getGraphLetIdPropertyName();
    }

    public Pg2vecModelBuilder setVertexPropertyNames(Collection<String> vertexPropertyNames) {
        this.pg2vecModelConfig.setVertexPropertyNames(vertexPropertyNames);
        return this;
    }

    public Collection<String> getVertexPropertyNames() {
        return this.pg2vecModelConfig.getVertexPropertyNames();
    }

    public Pg2vecModelBuilder setMinWordFrequency(int minWordFrequency) {
        this.pg2vecModelConfig.setMinWordFrequency(minWordFrequency);
        return this;
    }

    public int getMinWordFrequency() {
        return this.pg2vecModelConfig.getMinWordFrequency();
    }

    public Pg2vecModelBuilder setBatchSize(int batchSize) {
        this.pg2vecModelConfig.setBatchSize(batchSize);
        return this;
    }

    public int getBatchSize() {
        return this.pg2vecModelConfig.getBatchSize();
    }

    public Pg2vecModelBuilder setNumEpochs(int numEpochs) {
        this.pg2vecModelConfig.setNumEpochs(numEpochs);
        return this;
    }

    public int getNumEpochs() {
        return this.pg2vecModelConfig.getNumEpochs();
    }

    public Pg2vecModelBuilder setLayerSize(int layerSize) {
        this.pg2vecModelConfig.setLayerSize(layerSize);
        return this;
    }

    public int getLayerSize() {
        return this.pg2vecModelConfig.getLayerSize();
    }

    public Pg2vecModelBuilder setLearningRate(double lr) {
        this.pg2vecModelConfig.setLearningRate(lr);
        return this;
    }

    public double getLearningRate() {
        return this.pg2vecModelConfig.getLearningRate();
    }

    public Pg2vecModelBuilder setMinLearningRate(double minLr) {
        this.pg2vecModelConfig.setMinLearningRate(minLr);
        return this;
    }

    public double getMinLearningRate() {
        return this.pg2vecModelConfig.getMinLearningRate();
    }

    public Pg2vecModelBuilder setWindowSize(int windowSize) {
        this.pg2vecModelConfig.setWindowSize(windowSize);
        return this;
    }

    public int getWindowSize() {
        return this.pg2vecModelConfig.getWindowSize();
    }

    public Pg2vecModelBuilder setWalkLength(int walkLength) {
        this.pg2vecModelConfig.setWalkLength(walkLength);
        return this;
    }

    public int getWalkLength() {
        return this.pg2vecModelConfig.getWalkLength();
    }

    public Pg2vecModelBuilder setWalksPerVertex(int walksPerVertex) {
        this.pg2vecModelConfig.setWalksPerVertex(walksPerVertex);
        return this;
    }

    public int getWalksPerVertex() {
        return this.pg2vecModelConfig.getWalksPerVertex();
    }

    public Pg2vecModelBuilder setGraphletSizePropertyName(String graphletSizePropertyName) {
        this.pg2vecModelConfig.setGraphletSizePropertyName(graphletSizePropertyName);
        return this;
    }

    public String getGraphletSizePropertyName() {
        return this.pg2vecModelConfig.getGraphletSizePropertyName();
    }

    public Pg2vecModelBuilder setSeed(Long seed) {
        this.pg2vecModelConfig.setSeed(seed);
        return this;
    }

    public Long getSeed() {
        return this.pg2vecModelConfig.getSeed();
    }

    public Pg2vecModelBuilder setShuffle(boolean shuffle) {
        this.pg2vecModelConfig.setShuffle(shuffle);
        return this;
    }

    public boolean isShuffle() {
        return this.pg2vecModelConfig.isShuffle();
    }

    public Pg2vecModelBuilder setEnableAccelerator(boolean enableAccelerator) {
        this.pg2vecModelConfig.setEnableAccelerator(enableAccelerator);
        return this;
    }

    public Pg2vecModel build() throws InterruptedException, ExecutionException {
        LOG.debug("Building Model...");
        return (Pg2vecModel)((PgxFuture)this.core.createPg2vecModel(this.session.getSessionContext(), new Pg2vecModelMetadata(null, this.pg2vecModelConfig)).thenApply(metaData -> new Pg2vecModel(this.session, this.core, this.keystorePathSupplier, this.keystorePasswordSupplier, (Pg2vecModelMetadata)((Object)metaData)))).get();
    }
}

