/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal.characteristic;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.regex.Pattern;
import oracle.pgx.api.internal.characteristic.WorkloadCharacteristicCategory;

public interface WorkloadCharacteristic {
    public WorkloadCharacteristicCategory getCategory();

    public String name();

    @JsonValue
    default public String toFullyQualifiedString() {
        return this.getCategory().name() + "." + this.name();
    }

    @JsonCreator
    public static WorkloadCharacteristic fromFullyQualifiedString(String fullyQualified) {
        String[] names = fullyQualified.split(Pattern.quote("."), 2);
        WorkloadCharacteristicCategory category = WorkloadCharacteristicCategory.valueOf(names[0]);
        return category.parseCharacteristic(names[1]);
    }
}

