/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.internal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import oracle.pgx.api.Namespace;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.Self;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.PrettyPrint;
import oracle.pgx.config.LinkTemplate;

public class Property
extends Self {
    private int dimension;
    private PgxId propertyId;
    private String name;
    @JsonIgnore
    private PgxId graphId;
    private EntityType entityType;
    private PropertyType type;
    private Namespace namespace;
    @JsonProperty(value="transient")
    private boolean transientFlag;

    public Property() {
    }

    public Property(Property property) {
        super((Object)property.getId());
        this.namespace = property.namespace;
        this.name = property.name;
        this.entityType = property.entityType;
        this.type = property.type;
        this.dimension = property.dimension;
        this.transientFlag = property.transientFlag;
        this.setId(property.getId());
    }

    public Property(PgxId propertyId, Namespace namespace, String name, EntityType entityType, PropertyType type, int dimension, boolean transientFlag, PgxId graphId) {
        super((Object)propertyId);
        this.propertyId = propertyId;
        this.namespace = namespace;
        this.name = name;
        this.entityType = entityType;
        this.type = type;
        this.dimension = dimension;
        this.transientFlag = transientFlag;
        this.graphId = graphId;
        this.injectLinks();
    }

    public Property(PgxId propertyId, String name, EntityType entityType, PropertyType type, boolean transientFlag) {
        super((Object)propertyId);
        this.propertyId = propertyId;
        this.name = name;
        this.entityType = entityType;
        this.type = type;
        this.dimension = 0;
        this.transientFlag = transientFlag;
    }

    public PgxId getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(PgxId propertyId) {
        this.propertyId = propertyId;
    }

    public String getName() {
        return this.name;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public PropertyType getType() {
        return this.type;
    }

    public int getDimension() {
        return this.dimension;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setType(PropertyType type) {
        this.type = type;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }

    public PgxId getGraphId() {
        return this.graphId;
    }

    public void setGraphId(PgxId graphId) {
        this.graphId = graphId;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void injectLinks() {
        Link selfLink = new Link(LinkRel.SELF, LinkTemplate.PROPERTY_SELF.generateLink(new Object[0]));
        this.addLinks(new Link[]{selfLink});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)((Object)o);
        return this.dimension == property.dimension && this.transientFlag == property.transientFlag && Objects.equals(this.propertyId, property.propertyId) && Objects.equals(this.name, property.name) && Objects.equals(this.graphId, property.graphId) && this.entityType == property.entityType && this.type == property.type;
    }

    public int hashCode() {
        return Objects.hash(this.dimension, this.propertyId, this.name, this.graphId, this.entityType, this.type, this.transientFlag);
    }

    public String toString() {
        return PrettyPrint.prettify((Object)this);
    }
}

