/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.schema;

import java.util.Objects;
import oracle.pgx.api.frames.schema.datatypes.DataType;

public final class ColumnDescriptor {
    private final String columnName;
    private final DataType columnType;

    public static ColumnDescriptor columnDescriptor(String columnName, DataType columnType) {
        return new ColumnDescriptor(columnName, columnType);
    }

    private ColumnDescriptor(String columnName, DataType columnType) {
        this.columnName = columnName;
        this.columnType = columnType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DataType getColumnType() {
        return this.columnType;
    }

    public String toString() {
        return "ColumnDescriptor[" + this.columnName + ", " + this.columnType.simpleString() + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ColumnDescriptor)) {
            return false;
        }
        ColumnDescriptor otherColDesc = (ColumnDescriptor)obj;
        return Objects.equals(otherColDesc.columnName, this.columnName) && Objects.equals(otherColDesc.columnType, this.columnType);
    }

    public int hashCode() {
        return 42;
    }
}

