/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Iterator;
import java.util.Map;
import oracle.pgx.api.MapIterable;
import oracle.pgx.api.PgxEdge;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxManagedObject;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.internal.Core;
import oracle.pgx.api.internal.Edge;
import oracle.pgx.api.internal.Entity;
import oracle.pgx.api.internal.MapProxy;
import oracle.pgx.api.internal.Vertex;
import oracle.pgx.common.Entry;
import oracle.pgx.common.types.PropertyType;

public class PgxMap<K, V>
extends PgxManagedObject {
    private final Core core;
    private final SessionContext sessionContext;
    private final PgxGraph graph;
    private final PropertyType keyType;
    private final PropertyType valType;
    private final String mapName;

    private Object unwrapKey(K key) {
        return PgxMap.unwrap(key);
    }

    private Object unwrapValue(V value) {
        return PgxMap.unwrap(value);
    }

    private K wrapKey(Object key) {
        if (key instanceof Entity) {
            return this.wrapKey((Entity)key);
        }
        switch (this.getKeyType()) {
            case VERTEX: {
                return (K)new PgxVertex<Object>(this.graph, key);
            }
            case EDGE: {
                return (K)new PgxEdge(this.graph, (Long)key);
            }
        }
        return (K)key;
    }

    private K wrapKey(Entity entity) {
        switch (this.getKeyType()) {
            case VERTEX: {
                return (K)new PgxVertex<Vertex>(this.graph, (Vertex)entity);
            }
            case EDGE: {
                return (K)new PgxEdge(this.graph, (Edge)entity);
            }
        }
        return (K)entity;
    }

    private V wrapValue(Object value) {
        if (value instanceof Entity) {
            return this.wrapValue((Entity)value);
        }
        switch (this.getValueType()) {
            case VERTEX: {
                return (V)new PgxVertex<Object>(this.graph, value);
            }
            case EDGE: {
                return (V)new PgxEdge(this.graph, (Long)value);
            }
        }
        return (V)value;
    }

    private V wrapValue(Entity entity) {
        switch (this.getValueType()) {
            case VERTEX: {
                return (V)new PgxVertex<Vertex>(this.graph, (Vertex)entity);
            }
            case EDGE: {
                return (V)new PgxEdge(this.graph, (Edge)entity);
            }
        }
        return (V)entity;
    }

    PgxMap(PgxGraph graph, PropertyType keyType, PropertyType valType, String mapName) {
        this.graph = graph;
        this.sessionContext = this.graph.getSession().getSessionContext();
        this.core = this.graph.getSession().getCore();
        this.keyType = keyType;
        this.valType = valType;
        this.mapName = mapName;
    }

    PgxMap(PgxSession session, PropertyType keyType, PropertyType valType, String mapName) {
        this.graph = null;
        this.sessionContext = session.getSessionContext();
        this.core = session.getCore();
        this.keyType = keyType;
        this.valType = valType;
        this.mapName = mapName;
    }

    public PgxGraph getGraph() {
        return this.graph;
    }

    public String getSessionId() {
        return this.sessionContext.getSessionId();
    }

    @Override
    public String getName() {
        return this.mapName;
    }

    public PropertyType getKeyType() {
        return this.keyType;
    }

    public PropertyType getValueType() {
        return this.valType;
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        return this.core.destroyMap(this.sessionContext, this.mapName);
    }

    public PgxFuture<Void> putAsync(K key, V value) {
        return this.core.setMapEntry(this.sessionContext, this.mapName, this.unwrapKey(key), this.unwrapValue(value)).thenAccept(ignore -> {});
    }

    public PgxFuture<Boolean> removeAsync(K key) {
        return this.core.removeMapEntry(this.sessionContext, this.mapName, this.unwrapKey(key));
    }

    public PgxFuture<Integer> sizeAsync() {
        return this.getProxy().thenApply(MapProxy::size);
    }

    public PgxFuture<V> getAsync(K key) {
        return this.getProxy().thenApply(proxy -> this.wrapValue(proxy.get(this.unwrapKey(key))));
    }

    public PgxFuture<Boolean> containsKeyAsync(K key) {
        return this.getProxy().thenApply(proxy -> proxy.containsKey(this.unwrapKey(key)));
    }

    public PgxFuture<MapIterable<K, V>> entriesAsync() {
        return this.getProxy().thenApply(proxy -> new Entries(proxy.entries().iterator()));
    }

    public PgxFuture<Iterable<K>> keysAsync() {
        return this.getProxy().thenApply(proxy -> new Keys(proxy.keys().iterator()));
    }

    public String toString() {
        Map.Entry<String, Object> entry = this.graph == null ? PgxMap.entry("session", this.sessionContext) : PgxMap.entry("graph", this.graph.getName());
        return this.toString(PgxMap.entry("name", this.getName()), entry, PgxMap.entry("keyType", this.getKeyType().toKey()), PgxMap.entry("valueType", this.getValueType().toKey()));
    }

    private PgxFuture<MapProxy<Object, Object>> getProxy() {
        return this.core.getMapProxy(this.sessionContext, this.mapName);
    }

    public void put(K key, V value) {
        this.putAsync(key, value).join();
    }

    public boolean remove(K key) {
        return this.removeAsync(key).join();
    }

    public int size() {
        return this.sizeAsync().join();
    }

    public V get(K key) {
        return this.getAsync(key).join();
    }

    public boolean containsKey(K key) {
        return this.containsKeyAsync(key).join();
    }

    public MapIterable<K, V> entries() {
        return this.entriesAsync().join();
    }

    public Iterable<K> keys() {
        return this.keysAsync().join();
    }

    private final class Keys
    implements Iterable<K> {
        private final Iterator<Object> keyIterator;

        public Keys(Iterator<Object> wrappedIterator) {
            this.keyIterator = wrappedIterator;
        }

        @Override
        public Iterator<K> iterator() {
            return new KeysIterator(this.keyIterator);
        }
    }

    private final class KeysIterator
    implements Iterator<K> {
        private final Iterator<Object> wrappedIterator;

        KeysIterator(Iterator<Object> wrappedIterator) {
            this.wrappedIterator = wrappedIterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public K next() {
            Object key = this.wrappedIterator.next();
            return PgxMap.this.wrapKey(key);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class Entries
    implements MapIterable<K, V> {
        private final Iterator<Map.Entry<Object, Object>> entryIterator;

        public Entries(Iterator<Map.Entry<Object, Object>> wrappedIterator) {
            this.entryIterator = wrappedIterator;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntriesIterator(this.entryIterator);
        }
    }

    private final class EntriesIterator
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<Object, Object>> wrappedIterator;

        EntriesIterator(Iterator<Map.Entry<Object, Object>> wrappedIterator) {
            this.wrappedIterator = wrappedIterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry<Object, Object> entry = this.wrappedIterator.next();
            return new Entry<Object, Object>(PgxMap.this.wrapKey(entry.getKey()), PgxMap.this.wrapValue(entry.getValue()));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

