/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Iterator;
import oracle.pgx.api.ComponentCollection;
import oracle.pgx.api.Destroyable;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxVertex;
import oracle.pgx.api.VertexCollection;
import oracle.pgx.api.VertexProperty;
import oracle.pgx.api.internal.ComponentsProxy;
import oracle.pgx.common.NotFoundException;
import oracle.pgx.common.PgxId;

public class Partition<ID>
extends Destroyable
implements Iterable<VertexCollection<ID>> {
    private final PgxGraph graph;
    private final VertexProperty<ID, Long> componentsProperty;
    private final ComponentsProxy proxy;

    Partition(PgxGraph graph, VertexProperty<ID, Long> componentsProperty, ComponentsProxy proxy) {
        this.graph = graph;
        this.componentsProperty = componentsProperty;
        this.proxy = proxy;
    }

    PgxId getPropertyId() {
        return this.proxy.getPropertyId();
    }

    public PgxGraph getGraph() {
        return this.graph;
    }

    public VertexProperty<ID, Long> getComponentsProperty() {
        return this.componentsProperty;
    }

    public long size() {
        return this.proxy.size();
    }

    @Override
    public Iterator<VertexCollection<ID>> iterator() {
        return this.proxy.getVertexCollectionIterator(this.graph, null);
    }

    public VertexCollection<ID> getPartitionByVertex(PgxVertex<ID> vertex) {
        long compId = this.getPartitionIndexOfVertex(vertex);
        return this.getPartitionByIndex(compId);
    }

    public long getPartitionIndexOfVertex(PgxVertex<ID> vertex) {
        return this.proxy.getComponentIdForNode(vertex.serialize());
    }

    public VertexCollection<ID> getPartitionByIndex(long index) {
        return Partition.getPartition(this.graph, this.proxy.getComponentNamespace(), index);
    }

    @Override
    public PgxFuture<Void> destroyAsync() {
        if (this.size() > 0L) {
            return this.iterator().next().destroyAsync();
        }
        return PgxFuture.completedFuture(null);
    }

    @Deprecated
    public PgxFuture<Void> destroyAsync(boolean ignoreNotFound) {
        if (this.size() > 0L) {
            PgxFuture<Void> result = this.iterator().next().destroyAsync();
            if (ignoreNotFound) {
                PgxFuture newResult = new PgxFuture();
                result.exceptionally(t -> {
                    if (t instanceof NotFoundException) {
                        newResult.complete(null);
                    } else {
                        newResult.completeExceptionally((Throwable)t);
                    }
                    return null;
                });
                result = newResult;
            }
            return result;
        }
        return PgxFuture.completedFuture(null);
    }

    public String toString() {
        return this.toString(Partition.entry("graph", this.graph.getName()));
    }

    private static <ID> VertexCollection<ID> getPartition(PgxGraph graph, PgxId collectionName, long id) {
        ComponentCollection comp = new ComponentCollection(graph, collectionName, id);
        return comp;
    }
}

