/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import oracle.pgx.api.EdgeBuilder;
import oracle.pgx.api.GraphBuilder;
import oracle.pgx.api.GraphChangeSet;
import oracle.pgx.api.GraphMetaData;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.PgxSession;
import oracle.pgx.api.SessionContext;
import oracle.pgx.api.VertexBuilder;
import oracle.pgx.api.frames.PgxFrame;
import oracle.pgx.api.frames.PgxGraphFromFramesCreator;
import oracle.pgx.api.graphbuilder.EdgeBuilderImpl;
import oracle.pgx.api.graphbuilder.VertexBuilderImpl;
import oracle.pgx.api.internal.ApiObject;
import oracle.pgx.api.internal.Changes;
import oracle.pgx.api.internal.EdgeChanges;
import oracle.pgx.api.internal.Graph;
import oracle.pgx.api.internal.VertexChanges;
import oracle.pgx.api.internal.partitionedgraphbuilder.FrameFromGraphBuilderEntityCreator;
import oracle.pgx.api.internal.partitionedgraphbuilder.PartitionedGraphBuilderEntity;
import oracle.pgx.api.internal.partitionedgraphbuilder.PartitionedGraphEdgeBuilderEntity;
import oracle.pgx.common.Pair;
import oracle.pgx.common.PgxId;
import oracle.pgx.common.types.ChangeType;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.IdStrategy;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ChangeTrackingMap;
import oracle.pgx.common.util.EntityIdConversionHelper;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.InvalidChangeHandler;
import oracle.pgx.config.GraphBuilderConfig;
import oracle.pgx.config.IdGenerationStrategy;
import oracle.pgx.config.OnAddExistingElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphBuilderImpl<VID>
extends ApiObject
implements GraphBuilder<VID> {
    private static final Logger LOG = LoggerFactory.getLogger(GraphBuilderImpl.class);
    protected final PgxSession session;
    protected final Changes<VID> changes;
    protected final String graphBuilderName;
    protected String dataSourceVersion;
    protected final IdType idType;
    private final Map<GraphBuilderConfig.Field, Object> configValues;
    private final boolean partitioned;
    private boolean partitionedVerticesIds;
    private boolean partitionedEdgesIds;
    protected boolean isConfigLocked;

    private static String createRandomGraphBuilderName() {
        return UUID.randomUUID().toString();
    }

    protected GraphBuilderImpl(PgxSession session, IdType idType, Changes.ChangesIntent intent) {
        this.session = session;
        this.changes = new Changes(idType, intent);
        this.graphBuilderName = GraphBuilderImpl.createRandomGraphBuilderName();
        this.idType = idType;
        this.configValues = new EnumMap<GraphBuilderConfig.Field, Object>(GraphBuilderConfig.Field.class);
        this.partitioned = this.getSession().getServerInstance().isCreatePartitionedGraphsWithGraphBuilder();
    }

    GraphBuilderImpl(PgxSession session, IdType idType) {
        this(session, idType, Changes.ChangesIntent.CREATE);
    }

    protected GraphBuilderImpl(GraphBuilderImpl<VID> base) {
        this.session = base.session;
        this.changes = base.changes;
        this.graphBuilderName = base.graphBuilderName;
        this.idType = base.idType;
        this.configValues = base.configValues;
        this.isConfigLocked = true;
        this.partitioned = base.partitioned;
    }

    protected void expectedIdGenerationStrategy(GraphBuilderConfig.Field configField, IdGenerationStrategy validIdGenerationStrategy, EntityType entityType) {
        IdGenerationStrategy currentMode = (IdGenerationStrategy)this.getConfigParameter(configField);
        if (!currentMode.equals((Object)validIdGenerationStrategy)) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"INVALID_ID_GENERATION_STRATEGY", (Object[])new Object[]{entityType, currentMode, validIdGenerationStrategy}));
        }
    }

    protected VertexBuilder<VID> getVertexBuilder(VID vertexId, boolean isIgnored) {
        VertexBuilderImpl<VID> vertexBuilder = new VertexBuilderImpl<VID>(this, vertexId, isIgnored);
        this.isConfigLocked = true;
        return vertexBuilder;
    }

    protected EdgeBuilder<VID> getEdgeBuilder(Object edgeId, boolean isIgnored) {
        EdgeBuilderImpl edgeBuilder = new EdgeBuilderImpl(this, edgeId, isIgnored);
        this.isConfigLocked = true;
        return edgeBuilder;
    }

    @Override
    public void setDataSourceVersion(String version) {
        this.dataSourceVersion = version;
    }

    @Override
    public VertexBuilder<VID> addVertex(VID vertexId) {
        InvalidChangeHandler invalidChangeHandler = this.changes.getInvalidChangeHandler();
        if (!EntityIdConversionHelper.canConvertVertexId((IdType)this.idType, vertexId)) {
            invalidChangeHandler.handleVertexIdMismatch(this.idType, vertexId, ChangeType.ADD, InvalidChangeHandler.VertexLocation.STANDALONE);
            return this.getVertexBuilder(vertexId, true);
        }
        vertexId = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, vertexId, (InvalidChangeHandler)invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.STANDALONE);
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, IdGenerationStrategy.USER_IDS, EntityType.VERTEX);
        boolean success = this.changes.addVertex(vertexId);
        return this.getVertexBuilder(vertexId, false);
    }

    @Override
    public VertexBuilder<VID> addVertex() {
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, IdGenerationStrategy.AUTO_GENERATED, EntityType.VERTEX);
        VID currentImplicitId = this.changes.getImplicitVertexId();
        boolean success = this.changes.addVertex(currentImplicitId);
        return this.getVertexBuilder(currentImplicitId, !success);
    }

    @Override
    public GraphBuilder<VID> resetVertex(VID vertexId) {
        InvalidChangeHandler invalidChangeHandler = this.changes.getInvalidChangeHandler();
        if (!EntityIdConversionHelper.canConvertVertexId((IdType)this.idType, vertexId)) {
            invalidChangeHandler.handleVertexIdMismatch(this.idType, vertexId, null, InvalidChangeHandler.VertexLocation.STANDALONE);
            return this;
        }
        vertexId = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, vertexId, (InvalidChangeHandler)invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.STANDALONE);
        this.changes.resetVertex(vertexId);
        return this;
    }

    @Override
    public GraphBuilder<VID> resetVertex(VertexBuilder<VID> vertex) {
        this.assertSameGraphBuilder(this, vertex);
        return this.resetVertex(vertex.getId());
    }

    @Override
    public GraphBuilder<VID> resetEdge(long edgeId) {
        this.changes.resetEdge(edgeId);
        return this;
    }

    @Override
    public GraphBuilder<VID> resetEdge(String edgeId) {
        this.changes.resetEdge(edgeId);
        return this;
    }

    @Override
    public EdgeBuilder<VID> addEdge(long edgeId, VID srcVertex, VID dstVertex) {
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, IdGenerationStrategy.USER_IDS, EntityType.VERTEX);
        return this.addEdgeWithoutVertexIdGenerationStrategyCheck(edgeId, srcVertex, dstVertex, true);
    }

    @Override
    public EdgeBuilder<VID> addEdge(String edgeId, VID srcVertex, VID dstVertex) {
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, IdGenerationStrategy.USER_IDS, EntityType.VERTEX);
        return this.addEdgeWithoutVertexIdGenerationStrategyCheck(edgeId, srcVertex, dstVertex, true);
    }

    protected EdgeBuilder<VID> addEdgeWithoutVertexIdGenerationStrategyCheck(Object edgeId, VID srcVertex, VID dstVertex, boolean withLazyVertices) {
        InvalidChangeHandler invalidChangeHandler = this.changes.getInvalidChangeHandler();
        if (!this.changes.canConvertSrcAndDstVertexIdTypeAndLogIfNecessary(srcVertex, dstVertex, this.idType)) {
            return this.getEdgeBuilder(edgeId, true);
        }
        srcVertex = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, srcVertex, (InvalidChangeHandler)invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.EDGE_SOURCE);
        dstVertex = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, dstVertex, (InvalidChangeHandler)invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.EDGE_DESTINATION);
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.EDGE_ID_GENERATION_STRATEGY, IdGenerationStrategy.USER_IDS, EntityType.EDGE);
        boolean success = this.changes.addEdge(edgeId, srcVertex, dstVertex, withLazyVertices);
        return this.getEdgeBuilder(edgeId, false);
    }

    @Override
    public EdgeBuilder<VID> addEdge(VID srcVertex, VID dstVertex) {
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, IdGenerationStrategy.USER_IDS, EntityType.VERTEX);
        return this.addEdgeWithoutVertexIdGenerationStrategyCheck(srcVertex, dstVertex, true);
    }

    protected EdgeBuilder<VID> addEdgeWithoutVertexIdGenerationStrategyCheck(VID srcVertex, VID dstVertex, boolean withLazyVertices) {
        InvalidChangeHandler invalidChangeHandler = this.changes.getInvalidChangeHandler();
        if (!this.changes.canConvertSrcAndDstVertexIdTypeAndLogIfNecessary(srcVertex, dstVertex, this.idType)) {
            return this.getEdgeBuilder(-1L, true);
        }
        srcVertex = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, srcVertex, (InvalidChangeHandler)invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.EDGE_SOURCE);
        dstVertex = EntityIdConversionHelper.toVertexIdAndLogIfNecessary((IdType)this.idType, dstVertex, (InvalidChangeHandler)invalidChangeHandler, (InvalidChangeHandler.VertexLocation)InvalidChangeHandler.VertexLocation.EDGE_DESTINATION);
        this.expectedIdGenerationStrategy(GraphBuilderConfig.Field.EDGE_ID_GENERATION_STRATEGY, IdGenerationStrategy.AUTO_GENERATED, EntityType.EDGE);
        long currentImplicitId = this.changes.getImplicitEdgeId();
        boolean success = this.changes.addEdge(currentImplicitId, srcVertex, dstVertex, withLazyVertices);
        return this.getEdgeBuilder(currentImplicitId, !success);
    }

    protected final void assertSameGraphBuilder(GraphBuilder<VID> builder1, GraphBuilder<VID> builder2) {
        if (builder1 instanceof GraphBuilderImpl && builder2 instanceof GraphBuilderImpl) {
            GraphBuilderImpl graphBuilder1 = (GraphBuilderImpl)builder1;
            GraphBuilderImpl graphBuilder2 = (GraphBuilderImpl)builder2;
            if (graphBuilder1.session != graphBuilder2.session || graphBuilder1.changes != graphBuilder2.changes || !Objects.equals(graphBuilder1.graphBuilderName, graphBuilder2.graphBuilderName) || !Objects.equals(graphBuilder1.getOldGraphId(), graphBuilder2.getOldGraphId())) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CHANGES_COME_FROM_TWO_DIFFERENT_GRAPH_BUILDERS", (Object[])new Object[0]));
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"CHANGES_COME_FROM_TWO_DIFFERENT_GRAPH_BUILDERS", (Object[])new Object[0]));
        }
    }

    private void assertSameGraphBuilder(GraphBuilder originBuilder, VertexBuilder<VID> srcVertex, VertexBuilder<VID> dstVertex) {
        this.assertSameGraphBuilder(originBuilder, srcVertex);
        this.assertSameGraphBuilder(originBuilder, dstVertex);
    }

    @Override
    public EdgeBuilder<VID> addEdge(long edgeId, VertexBuilder<VID> srcVertex, VertexBuilder<VID> dstVertex) {
        this.assertSameGraphBuilder(this, srcVertex, dstVertex);
        VID srcVertexId = srcVertex.getId();
        VID dstVertexId = dstVertex.getId();
        return this.addEdgeWithoutVertexIdGenerationStrategyCheck(edgeId, srcVertexId, dstVertexId, false);
    }

    @Override
    public EdgeBuilder<VID> addEdge(String edgeId, VertexBuilder<VID> srcVertex, VertexBuilder<VID> dstVertex) {
        this.assertSameGraphBuilder(this, srcVertex, dstVertex);
        VID srcVertexId = srcVertex.getId();
        VID dstVertexId = dstVertex.getId();
        return this.addEdgeWithoutVertexIdGenerationStrategyCheck(edgeId, srcVertexId, dstVertexId, false);
    }

    @Override
    public EdgeBuilder<VID> addEdge(VertexBuilder<VID> srcVertex, VertexBuilder<VID> dstVertex) {
        this.assertSameGraphBuilder(this, srcVertex, dstVertex);
        VID srcVertexId = srcVertex.getId();
        VID dstVertexId = dstVertex.getId();
        return this.addEdgeWithoutVertexIdGenerationStrategyCheck(srcVertexId, dstVertexId, false);
    }

    protected GraphBuilderConfig createGraphBuilderConfig() {
        HashMap rawMap = new HashMap();
        this.configValues.forEach((field, o) -> rawMap.put(field.toKey(), o));
        return GraphBuilderConfig.parse(rawMap, (boolean)true, null);
    }

    @Override
    public final PgxFuture<PgxGraph> buildAsync(String newGraphName) {
        boolean isGraphChangeSet = this instanceof GraphChangeSet;
        if (!isGraphChangeSet && this.partitioned) {
            return this.buildPartitionedGraphAsync(newGraphName);
        }
        return this.buildGraphAsync(newGraphName);
    }

    private PgxFuture<PgxGraph> buildPartitionedGraphAsync(String newGraphName) {
        this.getValidatedVertexIdStrategy();
        this.getValidatedEdgeIdStrategy();
        List vertexChanges = this.changes.getVertexChanges();
        List edgeChanges = this.changes.getEdgeChanges();
        IdType vertexIdType = Changes.extractVertexIdType(vertexChanges, edgeChanges);
        IdType edgeIdType = Changes.extractEdgeIdType(edgeChanges);
        PartitionedGraphBuilderEntity partitionedGraphBuilderEntity = new PartitionedGraphBuilderEntity();
        partitionedGraphBuilderEntity.initializeVertexIdToEntityMap(vertexChanges);
        Map vertexEntities = partitionedGraphBuilderEntity.initializeAndFillEntitiesData(vertexChanges);
        Map edgeEntities = partitionedGraphBuilderEntity.initializeAndFillEntitiesData(edgeChanges);
        HashMap<String, Pair> edgeEntityToSrcAndDstEntitiesMapping = new HashMap<String, Pair>();
        HashMap<PartitionedGraphBuilderEntity, CompletableFuture> vertexEntityToFrameMapping = new HashMap<PartitionedGraphBuilderEntity, CompletableFuture>();
        HashMap<PartitionedGraphEdgeBuilderEntity, CompletableFuture> edgeEntityToFrameMapping = new HashMap<PartitionedGraphEdgeBuilderEntity, CompletableFuture>();
        ArrayList frameFutureList = new ArrayList();
        try {
            CompletableFuture framePgxFuture;
            FrameFromGraphBuilderEntityCreator creator;
            for (String key : vertexEntities.keySet()) {
                PartitionedGraphBuilderEntity vertexEntity = (PartitionedGraphBuilderEntity)vertexEntities.get(key);
                creator = new FrameFromGraphBuilderEntityCreator(this.session, vertexEntity, vertexIdType, edgeIdType);
                framePgxFuture = creator.createFrameAsync().exceptionally(throwable -> {
                    this.deleteAllCreatedFrames(frameFutureList);
                    throw new RuntimeException((Throwable)throwable);
                });
                vertexEntityToFrameMapping.put(vertexEntity, framePgxFuture);
                frameFutureList.add(framePgxFuture);
            }
            for (String key : edgeEntities.keySet()) {
                PartitionedGraphEdgeBuilderEntity edgeEntity = (PartitionedGraphEdgeBuilderEntity)edgeEntities.get(key);
                String sourceEntity = edgeEntity.getSourceEntityName();
                String destinationEntity = edgeEntity.getDestinationEntityName();
                edgeEntityToSrcAndDstEntitiesMapping.put(edgeEntity.getEntityName(), Pair.of((Object)sourceEntity, (Object)destinationEntity));
                creator = new FrameFromGraphBuilderEntityCreator(this.session, edgeEntity, vertexIdType, edgeIdType);
                framePgxFuture = creator.createFrameAsync().exceptionally(throwable -> {
                    this.deleteAllCreatedFrames(frameFutureList).join();
                    throw new RuntimeException((Throwable)throwable);
                });
                edgeEntityToFrameMapping.put(edgeEntity, framePgxFuture);
                frameFutureList.add(framePgxFuture);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            this.deleteAllCreatedFrames(frameFutureList).join();
            throw new RuntimeException(e);
        }
        PgxFuture<Void> allOfFutures = PgxFuture.allOf(frameFutureList);
        return allOfFutures.thenCompose(ignore -> {
            try {
                return this.buildGraphFromFrames(newGraphName, vertexEntityToFrameMapping, edgeEntityToFrameMapping, edgeEntityToSrcAndDstEntitiesMapping, frameFutureList);
            }
            catch (InterruptedException | ExecutionException e) {
                this.deleteAllCreatedFrames(frameFutureList).join();
                throw new RuntimeException(e);
            }
        });
    }

    private PgxFuture<PgxGraph> buildGraphAsync(String newGraphName) {
        if (this.partitionedVerticesIds || this.partitionedEdgesIds) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"PARTITIONED_IDS_NOT_SUPPORTED_FOR_NON_PARTITIONED_GRAPHS", (Object[])new Object[0]));
        }
        SessionContext sessionContext = this.session.getSessionContext();
        PgxId oldGraphId = this.getOldGraphId().orElse(null);
        IdType idType = this.changes.getIdType();
        Map<String, PropertyType> vertexPropTypes = this.changes.getVertexPropTypes();
        Map<String, PropertyType> edgePropTypes = this.changes.getEdgePropTypes();
        OnAddExistingElement addExistingVertexPolicy = this.changes.getAddExistingVertexPolicy();
        OnAddExistingElement addExistingEdgePolicy = this.changes.getAddExistingEdgePolicy();
        List<ChangeTrackingMap.ChangeSetEntry<VID, VertexChanges>> vertexChanges = this.changes.getVertexChanges();
        List<ChangeTrackingMap.ChangeSetEntry<Object, EdgeChanges>> edgeChanges = this.changes.getEdgeChanges();
        GraphBuilderConfig config = this.createGraphBuilderConfig();
        IdGenerationStrategy vertexIdGenerationStrategy = config.getVertexIdGenerationStrategy();
        IdGenerationStrategy edgeIdGenerationStrategy = config.getEdgeIdGenerationStrategy();
        LOG.debug("Parsed Graph Builder Config: {}", (Object)config);
        InvalidChangeHandler invalidChangeHandler = this.changes.getInvalidChangeHandler();
        return ((PgxFuture)this.session.getCore().addChanges(sessionContext, this.graphBuilderName, vertexChanges, edgeChanges, oldGraphId, addExistingVertexPolicy, addExistingEdgePolicy, invalidChangeHandler.getInvalidChangePolicy(), invalidChangeHandler.getRquiredConversionPolicy(), vertexIdGenerationStrategy, edgeIdGenerationStrategy).thenCompose(aVoid -> this.session.getCore().buildGraph(sessionContext, oldGraphId, this.graphBuilderName, idType, vertexPropTypes, edgePropTypes, newGraphName, config, this.dataSourceVersion))).thenApply(graph -> {
            GraphMetaData metaData = graph.getMetaData();
            LOG.info("Created a graph with {} vertices and {} edges. Vertex properties: {}. Edge properties: {}.", new Object[]{metaData.getNumVertices(), metaData.getNumEdges(), graph.getVertexPropertyNames(), graph.getEdgePropertyNames()});
            return new PgxGraph(this.session, (Graph)((Object)graph));
        });
    }

    private PgxFuture<PgxGraph> buildGraphFromFrames(String graphName, Map<PartitionedGraphBuilderEntity, PgxFuture<PgxFrame>> vertexEntitiesFrames, Map<PartitionedGraphEdgeBuilderEntity, PgxFuture<PgxFrame>> edgeEntitiesFrames, Map<String, Pair<String, String>> edgeEntityToSrcAndDstEntities, List<PgxFuture<PgxFrame>> frameFutureList) throws ExecutionException, InterruptedException {
        String idPropertyName;
        String entityName;
        if (graphName == null) {
            graphName = "";
        }
        PgxGraphFromFramesCreator creator = this.session.createGraphFromFrames(graphName);
        for (Map.Entry<PartitionedGraphBuilderEntity, PgxFuture<PgxFrame>> s : vertexEntitiesFrames.entrySet()) {
            PgxFrame vertexFrame = s.getValue().get();
            entityName = s.getKey().getEntityName();
            idPropertyName = s.getKey().getIdPropertyName();
            creator.vertexProvider(entityName, vertexFrame).vertexKeyColumn(idPropertyName);
        }
        for (PartitionedGraphEdgeBuilderEntity key : edgeEntitiesFrames.keySet()) {
            entityName = key.getEntityName();
            String srcVertexEntityName = (String)edgeEntityToSrcAndDstEntities.get(entityName).getFirst();
            String dstVertexEntityName = (String)edgeEntityToSrcAndDstEntities.get(entityName).getSecond();
            PgxFrame edgeFrame = edgeEntitiesFrames.get(key).get();
            idPropertyName = key.getIdPropertyName();
            String srcIdPropertyName = key.getSrcIdPropertyName();
            String dstIdPropertyName = key.getDstIdPropertyName();
            creator.edgeProvider(entityName, srcVertexEntityName, dstVertexEntityName, edgeFrame).sourceVertexKeyColumn(srcIdPropertyName).destinationVertexKeyColumn(dstIdPropertyName).edgeKeyColumn(idPropertyName);
        }
        creator.partitioned(true);
        creator.vertexIdStrategy(this.getValidatedVertexIdStrategy());
        creator.edgeIdStrategy(this.getValidatedEdgeIdStrategy());
        return ((PgxFuture)creator.createAsync().exceptionally(throwable -> {
            this.deleteAllCreatedFrames(frameFutureList).join();
            throw new RuntimeException((Throwable)throwable);
        })).thenCompose(graph -> this.deleteAllCreatedFrames(frameFutureList).thenReturn(graph));
    }

    private PgxFuture<Void> deleteAllCreatedFrames(List<PgxFuture<PgxFrame>> futures) {
        ArrayList destroyFrameFutures = new ArrayList();
        for (PgxFuture<PgxFrame> framePgxFuture : futures) {
            destroyFrameFutures.add(framePgxFuture.thenCompose(PgxFrame::destroyAsync));
        }
        futures.clear();
        return PgxFuture.allOf(destroyFrameFutures);
    }

    private IdStrategy getValidatedVertexIdStrategy() {
        boolean isRetainVertexIds = (Boolean)this.getConfigParameter(GraphBuilderConfig.Field.RETAIN_VERTEX_ID);
        return this.getValidatedIdStrategy(isRetainVertexIds, this.partitionedVerticesIds);
    }

    private IdStrategy getValidatedEdgeIdStrategy() {
        boolean isRetainVertexIds = (Boolean)this.getConfigParameter(GraphBuilderConfig.Field.RETAIN_EDGE_ID);
        return this.getValidatedIdStrategy(isRetainVertexIds, this.partitionedEdgesIds);
    }

    private IdStrategy getValidatedIdStrategy(boolean isRetainIds, boolean partitionedIds) {
        if (!isRetainIds) {
            if (partitionedIds) {
                throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"PARTITIONED_GRAPH_BUILDER_PARTITIONED_IDS_NOT_ALLOWED", (Object[])new Object[0]));
            }
            return IdStrategy.UNSTABLE_GENERATED_IDS;
        }
        if (partitionedIds) {
            return IdStrategy.PARTITIONED_IDS;
        }
        return IdStrategy.KEYS_AS_IDS;
    }

    protected Optional<PgxId> getOldGraphId() {
        return Optional.empty();
    }

    @Override
    public final PgxFuture<PgxGraph> buildAsync() {
        return this.buildAsync(null);
    }

    @Override
    public void setConfigParameter(GraphBuilderConfig.Field parameter, Object value) {
        if (this.isConfigLocked) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"GRAPH_BUILDER_FINALIZED_CONFIG_UNSUPPORTED_CHANGE", (Object[])new Object[0]));
        }
        if (value != null) {
            Class expectedClass;
            Class<?> valueClass = value.getClass();
            if (!valueClass.isAssignableFrom(expectedClass = parameter.getType())) {
                throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNEXPECTED_FIELD_TYPE", (Object[])new Object[]{expectedClass, parameter.toKey(), valueClass}));
            }
        } else {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"GRAPH_BUILDER_CONFIG_NULL_VALUE", (Object[])new Object[]{parameter}));
        }
        this.configValues.put(parameter, value);
    }

    @Override
    public Object getConfigParameter(GraphBuilderConfig.Field parameter) {
        return this.configValues.getOrDefault(parameter, parameter.getDefaultVal());
    }

    @Override
    public GraphBuilder<VID> setRetainEdgeIds(boolean retainEdgeIds) {
        this.checkIfConfigFinalizedAndThrowIfNecessary();
        this.setConfigParameter(GraphBuilderConfig.Field.RETAIN_EDGE_ID, retainEdgeIds);
        return this;
    }

    @Override
    public GraphBuilder<VID> setRetainVertexIds(boolean retainVertexIds) {
        this.checkIfConfigFinalizedAndThrowIfNecessary();
        this.setConfigParameter(GraphBuilderConfig.Field.RETAIN_VERTEX_ID, retainVertexIds);
        return this;
    }

    @Override
    public GraphBuilder<VID> setVertexIdGenerationStrategy(IdGenerationStrategy vertexIdGenerationStrategy) {
        this.checkIfConfigFinalizedAndThrowIfNecessary();
        this.setConfigParameter(GraphBuilderConfig.Field.VERTEX_ID_GENERATION_STRATEGY, vertexIdGenerationStrategy);
        return this;
    }

    @Override
    public GraphBuilder<VID> setEdgeIdGenerationStrategy(IdGenerationStrategy edgeIdGenerationStrategy) {
        this.checkIfConfigFinalizedAndThrowIfNecessary();
        this.setConfigParameter(GraphBuilderConfig.Field.EDGE_ID_GENERATION_STRATEGY, edgeIdGenerationStrategy);
        return this;
    }

    @Override
    public final PgxGraph build(String newGraphName) throws ExecutionException, InterruptedException {
        return this.buildAsync(newGraphName).get();
    }

    @Override
    public final PgxGraph build() throws ExecutionException, InterruptedException {
        return this.buildAsync().get();
    }

    @Override
    public GraphBuilder<VID> partitionedVertexIds(boolean partitionedIds) {
        if (this.isConfigLocked) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"GRAPH_BUILDER_FINALIZED_CONFIG_UNSUPPORTED_CHANGE", (Object[])new Object[0]));
        }
        this.partitionedVerticesIds = partitionedIds;
        return this;
    }

    @Override
    public GraphBuilder<VID> partitionedEdgeIds(boolean partitionedIds) {
        if (this.isConfigLocked) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"GRAPH_BUILDER_FINALIZED_CONFIG_UNSUPPORTED_CHANGE", (Object[])new Object[0]));
        }
        this.partitionedEdgesIds = partitionedIds;
        return this;
    }

    public boolean isGraphBuilderConfigFinalized() {
        return this.isConfigLocked;
    }

    public final PgxSession getSession() {
        return this.session;
    }

    final Changes<VID> getChanges() {
        return this.changes;
    }

    private void checkIfConfigFinalizedAndThrowIfNecessary() {
        if (this.isGraphBuilderConfigFinalized()) {
            throw new UnsupportedOperationException(ErrorMessages.getMessage((String)"GRAPH_BUILDER_FINALIZED_CONFIG_UNSUPPORTED_CHANGE", (Object[])new Object[0]));
        }
    }

    public String toString() {
        return this.toString(GraphBuilderImpl.entry("session", this.getSession().getId()), GraphBuilderImpl.entry("vertexChanges", this.changes.getNumVertexChanges()), GraphBuilderImpl.entry("edgeChanges", this.changes.getNumEdgeChanges()));
    }
}

