/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.vfs;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.vfs.AbstractUriVirtualFile;
import oracle.pgx.vfs.CommonsVfsVirtualFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathVirtualFile
extends AbstractUriVirtualFile {
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathVirtualFile.class);

    ClasspathVirtualFile(String path) throws IOException {
        super(path);
        this.ensureAbsolutePath();
    }

    ClasspathVirtualFile(String parent, String relative) throws IOException {
        super(parent, relative);
        this.ensureAbsolutePath();
    }

    private void ensureAbsolutePath() {
        if (this.uri.getPath() == null) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("EXPECTED_ABSOLUTE_PATH", this.uri.toString()));
        }
    }

    @Override
    public boolean exists() throws IOException {
        InputStream is = this.getResourceAsStream();
        if (is != null) {
            is.close();
            return true;
        }
        return false;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream is = this.getResourceAsStream();
        if (is == null) {
            throw new FileNotFoundException(this.uri.getSchemeSpecificPart());
        }
        return is;
    }

    private InputStream getResourceAsStream() {
        ClassLoader cl;
        String path = this.uri.getPath();
        LOG.trace("try to load {} from classpath", (Object)path);
        InputStream is = ClasspathVirtualFile.class.getResourceAsStream(path);
        if (is == null && (cl = Thread.currentThread().getContextClassLoader()) != null) {
            is = cl.getResourceAsStream(path);
        }
        return is;
    }

    private URL getResource() {
        String path = this.uri.getPath();
        LOG.trace("try to load {} from classpath", (Object)path);
        return this.getClass().getResource(path);
    }

    @Override
    protected RuntimeException readOnlyException() {
        return new UnsupportedOperationException(ErrorMessages.getMessage("CLASSPATH_IS_READ_ONLY", this.uri.toString()));
    }

    @Override
    public long getLastModifiedTimestamp() throws IOException {
        URL url = this.getResource();
        if (url == null) {
            return 0L;
        }
        return new File(url.getPath()).lastModified();
    }

    @Override
    public long getSizeInBytes() throws IOException {
        URL url = this.getResource();
        if (url == null) {
            return 0L;
        }
        return new File(url.getPath()).length();
    }

    @Override
    public boolean isFile() {
        URL url = this.getResource();
        return new File(url.getPath()).isFile();
    }

    public Stream<ClasspathVirtualFile> listFiles() throws IOException {
        if (this.isFile()) {
            return this.tryListFilesInJar();
        }
        URL url = this.getClass().getResource(this.uri.getPath());
        String path = url.getPath();
        File[] children = new File(path).listFiles();
        if (children == null) {
            return Stream.empty();
        }
        Stream[] streams = new Stream[children.length];
        for (int i = 0; i < children.length; ++i) {
            Path childPath = Paths.get(this.uri.toString(), children[i].getName());
            streams[i] = new ClasspathVirtualFile(childPath.toString()).listFiles();
        }
        return Arrays.stream(streams).flatMap(Function.identity());
    }

    public Stream<ClasspathVirtualFile> listJsonFiles() throws IOException {
        List files;
        if (this.isFile()) {
            files = this.tryListFilesInJar().collect(Collectors.toList());
            if (files.size() == 1 && files.get(0) == this) {
                return Stream.of(this);
            }
        } else {
            files = this.listFiles().collect(Collectors.toList());
        }
        ArrayList<ClasspathVirtualFile> streams = new ArrayList<ClasspathVirtualFile>();
        for (ClasspathVirtualFile vf : files) {
            File f = new File(this.getClass().getResource(vf.uri.getPath()).getPath());
            if (f.isHidden() || !CommonsVfsVirtualFile.isJsonFile(f.getName())) continue;
            streams.add(vf);
        }
        return streams.stream();
    }

    private Stream<ClasspathVirtualFile> tryListFilesInJar() throws IOException {
        ZipInputStream stream = new ZipInputStream(this.getInputStream());
        ZipEntry entry = stream.getNextEntry();
        if (entry == null) {
            return Stream.of(this);
        }
        ArrayList<ClasspathVirtualFile> files = new ArrayList<ClasspathVirtualFile>();
        while (entry != null) {
            if (!entry.isDirectory()) {
                Path childPath = Paths.get(this.uri.toString(), entry.getName());
                files.add(new ClasspathVirtualFile(childPath.toString()));
            }
            entry = stream.getNextEntry();
        }
        return files.stream();
    }
}

