/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.utils;

import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.util.ErrorMessages;

public class OracleAndPgxPropertyTypeUtils {
    public static final int UNDEFINED_PRECISION = 0;
    public static final int UNDEFINED_SCALE = -127;
    private static final int MAX_NUM_DIGITS_INTEGER = 9;
    private static final int MAX_NUM_DIGITS_LONG = 18;
    private static final int FLOAT_MAX_PRECISION = 23;
    private static final String BINARY_FLOAT = "BINARY_FLOAT";
    private static final String BINARY_DOUBLE = "BINARY_DOUBLE";
    private static final String CHAR = "CHAR";
    private static final String CLOB = "CLOB";
    private static final String NCHAR = "NCHAR";
    private static final String VARCHAR = "VARCHAR";
    private static final String VARCHAR2 = "VARCHAR2";
    private static final String NVARCHAR2 = "NVARCHAR2";
    public static final String NUMBER = "NUMBER";
    private static final String DATE = "DATE";
    public static final String TIMESTAMP = "TIMESTAMP";
    private static final String TIMESTAMP_WITH_TIMEZONE = "TIMESTAMP WITH TIME ZONE";
    public static final String TIMESTAMP_WITH_LOCAL_TIME_ZONE = "TIMESTAMP WITH LOCAL TIME ZONE";

    public static PropertyType getPgxPropertyType(String columnName, String typeName, int precision, int scale, boolean isKeyColumn, boolean isEdgeKeyColumn) {
        switch (typeName) {
            case "BINARY_FLOAT": {
                return PropertyType.FLOAT;
            }
            case "BINARY_DOUBLE": {
                return PropertyType.DOUBLE;
            }
            case "VARCHAR": 
            case "VARCHAR2": 
            case "NVARCHAR2": 
            case "CHAR": 
            case "NCHAR": 
            case "CLOB": {
                return PropertyType.STRING;
            }
            case "FLOAT": {
                if (0 < precision && precision <= 23) {
                    return PropertyType.FLOAT;
                }
                return PropertyType.DOUBLE;
            }
            case "NUMBER": {
                if (isKeyColumn) {
                    if (scale == -127 || precision == 0) {
                        return PropertyType.LONG;
                    }
                    if (OracleAndPgxPropertyTypeUtils.fitsInJavaInteger(precision, scale) && !isEdgeKeyColumn) {
                        return PropertyType.INTEGER;
                    }
                    return PropertyType.LONG;
                }
                if (scale == -127 || precision == 0) {
                    return PropertyType.DOUBLE;
                }
                if (!OracleAndPgxPropertyTypeUtils.isDecimal(scale) && OracleAndPgxPropertyTypeUtils.fitsInJavaInteger(precision, scale)) {
                    return PropertyType.INTEGER;
                }
                if (!OracleAndPgxPropertyTypeUtils.isDecimal(scale) && OracleAndPgxPropertyTypeUtils.fitsInJavaLong(precision, scale)) {
                    return PropertyType.LONG;
                }
                return PropertyType.DOUBLE;
            }
            case "DATE": 
            case "TIMESTAMP": 
            case "TIMESTAMP WITH LOCAL TIME ZONE": {
                return PropertyType.TIMESTAMP;
            }
            case "TIMESTAMP WITH TIME ZONE": {
                return PropertyType.TIMESTAMP_WITH_TIMEZONE;
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage("UNSUPPORTED_DATABASE_DATATYPE", columnName, typeName));
    }

    private static boolean isDecimal(int scale) {
        return scale > 0;
    }

    private static boolean fitsInJavaInteger(int precision, int scale) {
        return precision - scale <= 9;
    }

    private static boolean fitsInJavaLong(int precision, int scale) {
        return precision - scale <= 18;
    }
}

