/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.ChronoField;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.TemporalTypeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Java8TemporalModule
extends SimpleModule {
    private static final Logger LOG = LoggerFactory.getLogger(LocalDateDeserializer.class);

    public Java8TemporalModule() {
        super("Java8TemporalModule", Version.unknownVersion());
        this.addSerializer(LocalDate.class, new LocalDateSerializer());
        this.addSerializer(LocalTime.class, new LocalTimeSerializer());
        this.addSerializer(LocalDateTime.class, new LocalDateTimeSerializer());
        this.addSerializer(OffsetTime.class, new OffsetTimeSerializer());
        this.addSerializer(OffsetDateTime.class, new OffsetDateTimeSerializer());
        this.addDeserializer(LocalDate.class, new LocalDateDeserializer());
        this.addDeserializer(LocalTime.class, new LocalTimeDeserializer());
        this.addDeserializer(LocalDateTime.class, new LocalDateTimeDeserializer());
        this.addDeserializer(OffsetTime.class, new OffsetTimeDeserializer());
        this.addDeserializer(OffsetDateTime.class, new OffsetDateTimeDeserializer());
    }

    private class OffsetDateTimeDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        private OffsetDateTimeDeserializer() {
        }

        public OffsetDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode jsonTree = (JsonNode)jp.readValueAsTree();
            long timestampPart = jsonTree.get("TIMESTAMP_PART_OF_TS_WITH_TZ").asLong();
            int offsetPart = jsonTree.get("TZ_PART_OF_TS_WITH_TZ").asInt();
            return TemporalTypeUtils.parseTimestampWithTimezone(timestampPart, offsetPart);
        }
    }

    public class OffsetDateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        public static final String TIMESTAMP_PART = "TIMESTAMP_PART_OF_TS_WITH_TZ";
        public static final String OFFSET_PART = "TZ_PART_OF_TS_WITH_TZ";

        public void serialize(OffsetDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            jgen.writeFieldName(TIMESTAMP_PART);
            jgen.writeNumber(TemporalTypeUtils.getMillisFromTimestamp(value.toLocalDateTime()));
            jgen.writeFieldName(OFFSET_PART);
            long offsetPartInSec = value.getOffset().getTotalSeconds();
            jgen.writeNumber(offsetPartInSec);
            jgen.writeEndObject();
        }
    }

    private class OffsetTimeDeserializer
    extends JsonDeserializer<OffsetTime> {
        private OffsetTimeDeserializer() {
        }

        public OffsetTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode jsonTree = (JsonNode)jp.readValueAsTree();
            JsonNode timeNode = jsonTree.get("TIME_PART_OF_TIME_WITH_TZ");
            if (timeNode == null) {
                throw new JsonParseException(jp, ErrorMessages.getMessage("MISSING_JSON_FIELD", "TIME_PART_OF_TIME_WITH_TZ"));
            }
            JsonNode offsetNode = jsonTree.get("TZ_PART_OF_TIME_WITH_TZ");
            if (offsetNode == null) {
                throw new JsonParseException(jp, ErrorMessages.getMessage("MISSING_JSON_FIELD", "TZ_PART_OF_TIME_WITH_TZ"));
            }
            int timePart = timeNode.asInt();
            int offsetPart = offsetNode.asInt();
            return TemporalTypeUtils.parseTimeWithTimezone(timePart, offsetPart);
        }
    }

    public class OffsetTimeSerializer
    extends JsonSerializer<OffsetTime> {
        public static final String TIME_PART = "TIME_PART_OF_TIME_WITH_TZ";
        public static final String OFFSET_PART = "TZ_PART_OF_TIME_WITH_TZ";

        public void serialize(OffsetTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            jgen.writeFieldName(TIME_PART);
            long timePartInMs = value.toLocalTime().get(ChronoField.MILLI_OF_DAY);
            jgen.writeNumber(timePartInMs);
            jgen.writeFieldName(OFFSET_PART);
            long offsetPartInSec = value.getOffset().getTotalSeconds();
            jgen.writeNumber(offsetPartInSec);
            jgen.writeEndObject();
        }
    }

    private class LocalDateTimeDeserializer
    extends JsonDeserializer<LocalDateTime> {
        private LocalDateTimeDeserializer() {
        }

        public LocalDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode jsonTimestamp = (JsonNode)jp.readValueAsTree().get("TIMESTAMP");
            return TemporalTypeUtils.parseTimestamp(jsonTimestamp.asLong());
        }
    }

    private class LocalDateTimeSerializer
    extends JsonSerializer<LocalDateTime> {
        private LocalDateTimeSerializer() {
        }

        public void serialize(LocalDateTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            jgen.writeFieldName("TIMESTAMP");
            long msFromEpoch = TemporalTypeUtils.getMillisFromTimestamp(value);
            jgen.writeNumber(msFromEpoch);
            jgen.writeEndObject();
        }
    }

    private class LocalTimeDeserializer
    extends JsonDeserializer<LocalTime> {
        private LocalTimeDeserializer() {
        }

        public LocalTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode jsonTime = (JsonNode)jp.readValueAsTree().get("TIME");
            return TemporalTypeUtils.parseTimeFromMillis(jsonTime.asInt());
        }
    }

    private class LocalTimeSerializer
    extends JsonSerializer<LocalTime> {
        private LocalTimeSerializer() {
        }

        public void serialize(LocalTime value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            jgen.writeFieldName("TIME");
            int milliSeconds = value.get(ChronoField.MILLI_OF_DAY);
            jgen.writeNumber(milliSeconds);
            jgen.writeEndObject();
        }
    }

    private class LocalDateDeserializer
    extends JsonDeserializer<LocalDate> {
        private LocalDateDeserializer() {
        }

        public LocalDate deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode jsonDateLong = (JsonNode)jp.readValueAsTree().get("LOCAL_DATE");
            return LocalDate.ofEpochDay(jsonDateLong.asLong());
        }
    }

    private class LocalDateSerializer
    extends JsonSerializer<LocalDate> {
        private LocalDateSerializer() {
        }

        public void serialize(LocalDate value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
            jgen.writeStartObject();
            jgen.writeFieldName("LOCAL_DATE");
            long day = value.getLong(ChronoField.EPOCH_DAY);
            jgen.writeNumber(day);
            jgen.writeEndObject();
        }
    }
}

