/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import oracle.pgql.lang.spatial.Point2D;
import oracle.pgx.common.GmParseException;
import oracle.pgx.common.types.Edge;
import oracle.pgx.common.types.EntityType;
import oracle.pgx.common.types.Node;
import oracle.pgx.common.types.Type;
import oracle.pgx.common.types.Types;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.common.util.TemporalTypeUtils;

public enum PropertyType implements Type
{
    INTEGER(Integer.class, 0),
    LONG(Long.class, 0L),
    FLOAT(Float.class, Float.valueOf(0.0f)),
    DOUBLE(Double.class, 0.0),
    BOOLEAN(Boolean.class, false),
    VERTEX(Node.class, -1),
    EDGE(Edge.class, -1L),
    STRING(String.class, ""),
    LOCAL_DATE(LocalDate.class, LocalDate.ofEpochDay(0L)),
    TIME(LocalTime.class, LocalTime.ofNanoOfDay(0L)),
    TIMESTAMP(LocalDateTime.class, TemporalTypeUtils.parseTimestamp(0L)),
    TIME_WITH_TIMEZONE(OffsetTime.class, TemporalTypeUtils.parseTimeWithTimezone(0, 0)),
    TIMESTAMP_WITH_TIMEZONE(OffsetDateTime.class, TemporalTypeUtils.parseTimestampWithTimezone(0L, 0)),
    RO_STRING_SET(Set.class, Collections.emptySet()),
    POINT2D(Point2D.class, new Point2D(0.0, 0.0));

    public static final String DEFAULT_LABEL = "";
    private static final Map<String, PropertyType> ALIASES;
    private final Class<?> typeClass;
    private final Object defaultValue;

    public static PropertyType getTypeFor(Class<?> typeClass) {
        return (PropertyType)Types.getByTypeClass((Type[])PropertyType.values(), typeClass);
    }

    @JsonCreator
    public static PropertyType parsePropertyType(String input) {
        if ("DATE".equals(input = input.toUpperCase().trim())) {
            throw new IllegalArgumentException(ErrorMessages.getMessage("DATE_PROPERTY_TYPE_WAS_REMOVED", new Object[0]));
        }
        return Types.parse(PropertyType.class, input, ALIASES);
    }

    public static Temporal parseTemporal(String input, PropertyType type) throws GmParseException {
        if (input == null) {
            return null;
        }
        switch (type) {
            case LOCAL_DATE: {
                return TemporalTypeUtils.parseLocalDate(input);
            }
            case TIME: {
                return TemporalTypeUtils.parseTime(input);
            }
            case TIMESTAMP: {
                return TemporalTypeUtils.parseTimestamp(input);
            }
            case TIME_WITH_TIMEZONE: {
                return TemporalTypeUtils.parseTimeWithTimezone(input);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return TemporalTypeUtils.parseTimestampWithTimezone(input);
            }
        }
        throw new GmParseException("cannot parse " + input + " to type " + type.toString());
    }

    public static boolean parseBoolean(String input) {
        if (input == null) {
            return false;
        }
        String lcInput = input.toLowerCase();
        if (lcInput.equals("true")) {
            return true;
        }
        if (lcInput.equals("false")) {
            return false;
        }
        int intVal = Integer.parseInt(lcInput);
        return intVal == 1;
    }

    private PropertyType(Class<?> typeClass, Object defaultValue) {
        this.typeClass = typeClass;
        this.defaultValue = defaultValue;
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @JsonValue
    public String toKey() {
        return this.name().toLowerCase();
    }

    public String toString() {
        return this.toKey();
    }

    public boolean isNumericType() {
        switch (this) {
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return true;
            }
        }
        return false;
    }

    public boolean isTemporalType() {
        switch (this) {
            case LOCAL_DATE: 
            case TIME: 
            case TIMESTAMP: 
            case TIME_WITH_TIMEZONE: 
            case TIMESTAMP_WITH_TIMEZONE: {
                return true;
            }
        }
        return false;
    }

    public boolean isNodeOrEdge() {
        return this == VERTEX || this == EDGE;
    }

    public Object parse(String input) throws GmParseException {
        if (input == null) {
            return null;
        }
        switch (this) {
            case INTEGER: {
                return Integer.valueOf(input);
            }
            case LONG: {
                return Long.decode(input);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(input));
            }
            case DOUBLE: {
                return Double.parseDouble(input);
            }
            case BOOLEAN: {
                return PropertyType.parseBoolean(input);
            }
            case STRING: {
                return input;
            }
            case LOCAL_DATE: {
                return TemporalTypeUtils.parseLocalDate(input);
            }
            case TIME: {
                return TemporalTypeUtils.parseTime(input);
            }
            case TIMESTAMP: {
                return TemporalTypeUtils.parseTimestamp(input);
            }
            case TIME_WITH_TIMEZONE: {
                return TemporalTypeUtils.parseTimeWithTimezone(input);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return TemporalTypeUtils.parseTimestampWithTimezone(input);
            }
        }
        throw new GmParseException("cannot parse " + input + " to type " + this.name());
    }

    public Optional<EntityType> toEntityType() {
        switch (this) {
            case VERTEX: {
                return Optional.of(EntityType.VERTEX);
            }
            case EDGE: {
                return Optional.of(EntityType.EDGE);
            }
        }
        return Optional.empty();
    }

    static {
        ALIASES = new HashMap<String, PropertyType>();
        ALIASES.put("INT", INTEGER);
        ALIASES.put("NODE", VERTEX);
        ALIASES.put("TIME WITH TIMEZONE", TIME_WITH_TIMEZONE);
        ALIASES.put("TIME WITH TIME ZONE", TIME_WITH_TIMEZONE);
        ALIASES.put("TIMESTAMP WITH TIMEZONE", TIMESTAMP_WITH_TIMEZONE);
        ALIASES.put("TIMESTAMP WITH TIME ZONE", TIMESTAMP_WITH_TIMEZONE);
    }
}

