/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import oracle.pgx.common.types.PropertyType;
import oracle.pgx.common.types.Type;
import oracle.pgx.common.types.Types;
import oracle.pgx.common.util.ErrorMessages;

public enum IdType implements Type
{
    INTEGER(Integer.class),
    LONG(Long.class),
    STRING(String.class);

    private static final Map<String, IdType> ALIASES;
    private final Class<?> typeClass;

    public static IdType getTypeFor(Class<?> typeClass) {
        return (IdType)Types.getByTypeClass((Type[])IdType.values(), typeClass);
    }

    @JsonCreator
    public static IdType parseIdType(String input) {
        return Types.parse(IdType.class, input, ALIASES);
    }

    private IdType(Class<?> typeClass) {
        this.typeClass = typeClass;
    }

    public static PropertyType toPropertyType(IdType idType) {
        switch (idType) {
            case INTEGER: {
                return PropertyType.INTEGER;
            }
            case LONG: {
                return PropertyType.LONG;
            }
            case STRING: {
                return PropertyType.STRING;
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage("UNSUPPORTED_KEY_TYPE", idType));
    }

    @Override
    public Class<?> getTypeClass() {
        return this.typeClass;
    }

    public Object parse(String input) {
        if (input == null) {
            return null;
        }
        switch (this) {
            case INTEGER: {
                return Integer.valueOf(input);
            }
            case LONG: {
                return Long.decode(input);
            }
            case STRING: {
                return input;
            }
        }
        throw new UnsupportedOperationException("can't parse " + this);
    }

    @Override
    @JsonValue
    public String toKey() {
        return this.name().toLowerCase();
    }

    public static IdType fromPropertyType(PropertyType propertyType) {
        if (propertyType == null) {
            return null;
        }
        switch (propertyType) {
            case INTEGER: {
                return INTEGER;
            }
            case LONG: {
                return LONG;
            }
            case STRING: {
                return STRING;
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage("INVALID_TYPE", propertyType));
    }

    public String toString() {
        return this.toKey();
    }

    static {
        ALIASES = new HashMap<String, IdType>();
        ALIASES.put("INT", INTEGER);
    }
}

