/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import oracle.pgx.common.PgxCharset;

public class LoggingOutputStream
extends OutputStream {
    private final Consumer<String> logger;
    private final BooleanSupplier isEnabled;
    private final byte[] lineSeparator;
    private byte[] buffer;
    private int count;

    public LoggingOutputStream(Consumer<String> logger, BooleanSupplier isEnabled) {
        this.logger = logger;
        this.isEnabled = isEnabled;
        this.lineSeparator = LoggingOutputStream.calculateLineSeparator();
        this.buffer = new byte[32];
        this.count = 0;
    }

    private static byte[] calculateLineSeparator() {
        ByteBuffer lineSeparatorBuffer = PgxCharset.getCharset().encode(System.lineSeparator());
        byte[] separator = new byte[lineSeparatorBuffer.remaining()];
        lineSeparatorBuffer.get(separator);
        return separator;
    }

    private void ensureCapacity(int minLength) {
        if (this.buffer.length >= minLength) {
            return;
        }
        int newLength = Math.max(minLength, this.buffer.length * 2);
        byte[] newArray = new byte[newLength];
        System.arraycopy(this.buffer, 0, newArray, 0, this.count);
        this.buffer = newArray;
    }

    private void writeLine(int offset, int length) {
        assert (offset < this.count);
        assert (length >= 0);
        if (length == 0) {
            return;
        }
        String line = new String(this.buffer, offset, length, PgxCharset.getCharset());
        this.logger.accept(line);
    }

    private void writeLog() {
        int searchLength;
        int index;
        int processedBytes = 0;
        int searchOffset = 0;
        while (searchOffset < this.count && (index = LoggingOutputStream.indexOf(this.buffer, this.lineSeparator, searchOffset, searchLength = this.count - searchOffset)) != -1) {
            this.writeLine(searchOffset, index - searchOffset);
            processedBytes += index - searchOffset + this.lineSeparator.length;
            searchOffset = index + this.lineSeparator.length;
        }
        System.arraycopy(this.buffer, processedBytes, this.buffer, 0, this.count - processedBytes);
        this.count -= processedBytes;
        assert (this.count >= 0);
    }

    @Override
    public void write(int b) {
        if (!this.isEnabled.getAsBoolean()) {
            return;
        }
        this.ensureCapacity(this.count + 1);
        this.buffer[this.count] = (byte)b;
        ++this.count;
        this.writeLog();
    }

    @Override
    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (!this.isEnabled.getAsBoolean()) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.count + len);
        System.arraycopy(b, off, this.buffer, this.count, len);
        this.count += len;
        this.writeLog();
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    private static int indexOf(byte[] haystack, byte[] needle, int haystackOffset, int haystackLength) {
        assert (haystack != null);
        assert (needle != null && needle.length > 0);
        assert (haystackOffset >= 0 && haystackOffset <= haystack.length);
        assert (haystackLength >= 0 && haystackOffset + haystackLength <= haystack.length);
        block0: for (int i = haystackOffset; i < haystackOffset + haystackLength - needle.length + 1; ++i) {
            for (int j = 0; j < needle.length; ++j) {
                if (haystack[i + j] != needle[j]) continue block0;
            }
            return i;
        }
        return -1;
    }
}

