/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.filter;

import java.util.Objects;
import oracle.pgx.api.filter.EdgeFilter;
import oracle.pgx.api.filter.FilterType;
import oracle.pgx.api.filter.GraphFilter;
import oracle.pgx.api.filter.VertexFilter;
import oracle.pgx.common.util.ErrorMessages;

public abstract class GraphFilterWithExpression
extends GraphFilter {
    private final String filterExpression;

    protected GraphFilterWithExpression(FilterType type, String filterExpression) {
        super(type);
        this.filterExpression = filterExpression;
    }

    public final String getFilterExpression() {
        return this.filterExpression;
    }

    @Override
    public final GraphFilterWithExpression asGraphFilterWithExpression() {
        return this;
    }

    @Override
    public boolean hasExpression() {
        return true;
    }

    public static GraphFilterWithExpression fromTypeAndExpression(FilterType type, String filterExpression) {
        switch (type) {
            case EDGE: {
                return new EdgeFilter(filterExpression);
            }
            case VERTEX: {
                return new VertexFilter(filterExpression);
            }
        }
        throw new IllegalArgumentException(ErrorMessages.getMessage("NO_EXPRESSION_FILTER", type.toString().toLowerCase()));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GraphFilterWithExpression that = (GraphFilterWithExpression)o;
        return Objects.equals(this.filterExpression, that.filterExpression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.filterExpression);
    }
}

