/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import oracle.ons.ConfigurationException;
import oracle.ons.DefaultSocketManager;
import oracle.ons.Node;
import oracle.ons.NodeAddress;
import oracle.ons.NotificationNetwork;
import oracle.ons.ONS;
import oracle.ons.ONSConfiguration;
import oracle.ons.ONSException;
import oracle.ons.ThreadPoolWorkloadManager;
import oracle.ons.spi.SocketManager;
import oracle.ons.spi.WorkloadManager;

public class NotificationManager {
    private WorkloadManager wm;
    private SocketManager sm;
    private int activeNetworks = 0;
    Logger logger = Logger.getLogger(ONS.class.getCanonicalName());
    private final ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> networks = new ConcurrentHashMap();
    private final ConcurrentHashMap<NodeAddress, Node> nodes = new ConcurrentHashMap();
    private final ConcurrentHashMap<NodeAddress, Long> nodeHistory = new ConcurrentHashMap();
    private static volatile NotificationManager instance = null;
    private volatile MaintenanceTask maintenanceTask = null;

    private NotificationManager(WorkloadManager workloadManager, SocketManager socketManager) {
        String string = System.getProperty("oracle.ons.debug", "none");
        this.logger.setUseParentHandlers(false);
        if (string.equalsIgnoreCase("true")) {
            this.logger.setLevel(Level.ALL);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(Level.ALL);
            consoleHandler.setFormatter(new SimpleFormatter());
            this.logger.addHandler(consoleHandler);
        }
        this.wm = workloadManager;
        this.sm = socketManager;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(WorkloadManager workloadManager, SocketManager socketManager) throws ONSException {
        Class<NotificationManager> clazz = NotificationManager.class;
        synchronized (NotificationManager.class) {
            if (instance != null) {
                throw new ConfigurationException("Only one implicit ONS Manager is allowed per JVM");
            }
            instance = new NotificationManager(workloadManager != null ? workloadManager : new ThreadPoolWorkloadManager(), socketManager != null ? socketManager : new DefaultSocketManager());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void initialize() throws ONSException {
        NotificationManager.initialize(null, null);
    }

    public static NotificationManager getNotificationManager() {
        if (instance == null) {
            try {
                NotificationManager.initialize();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
        }
        return instance;
    }

    protected WorkloadManager getWorkloadManager() {
        return this.wm;
    }

    protected SocketManager getSocketManager() {
        return this.sm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NotificationNetwork getNetwork(ONSConfiguration oNSConfiguration) throws ONSException {
        ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> concurrentHashMap = this.networks;
        synchronized (concurrentHashMap) {
            this.logger.log(Level.FINE, "ONS getNetwork(" + oNSConfiguration + "): " + oNSConfiguration.getFingerprint());
            WeakReference<NotificationNetwork> weakReference = this.networks.get(oNSConfiguration.getFingerprint());
            NotificationNetwork notificationNetwork = null;
            if (weakReference != null) {
                notificationNetwork = (NotificationNetwork)weakReference.get();
            }
            if (notificationNetwork == null) {
                if (weakReference != null) {
                    this.logger.log(Level.FINEST, "ONS getNetwork: networks hash found but no network: " + weakReference);
                }
                this.logger.log(Level.FINE, "ONS getNetwork: creating notification network");
                notificationNetwork = new NotificationNetwork(oNSConfiguration);
                this.networks.put(oNSConfiguration.getFingerprint(), new WeakReference<NotificationNetwork>(notificationNetwork));
                this.logger.log(Level.FINE, "ONS getNetwork: network: " + notificationNetwork);
            } else {
                this.logger.log(Level.FINE, "ONS getNetwork: network from networks hash (" + weakReference + "): " + notificationNetwork);
            }
            return notificationNetwork;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNodeUp(Node node) {
        ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> concurrentHashMap = this.networks;
        synchronized (concurrentHashMap) {
            this.logger.fine("ONS node up: " + node.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNodeDown(Node node) {
        ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> concurrentHashMap = this.networks;
        synchronized (concurrentHashMap) {
            this.logger.fine("ONS node down: " + node.toString());
            this.nodes.remove(node.getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connect(ONSConfiguration.NodeList nodeList, Set<NodeAddress> set, int n, NotificationNetwork notificationNetwork) {
        int n2 = 0;
        if (n == 0) {
            this.logger.fine("ONS nodelist " + nodeList + " network: " + notificationNetwork + " maxConnections = 0");
            return;
        }
        if (nodeList.failedTo != null) {
            n = 1;
        }
        ArrayList<NodeAddress> arrayList = new ArrayList<NodeAddress>();
        arrayList.addAll(set);
        ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> concurrentHashMap = this.networks;
        synchronized (concurrentHashMap) {
            this.logger.fine("ONS nodelist " + nodeList + " network: " + notificationNetwork + " begin connect");
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Node object = this.nodes.get(iterator.next());
                if (object == null) continue;
                boolean node = false;
                this.logger.finest("ONS nodelist " + nodeList + " node found: " + object + " (" + object.getAddress().toString() + ")");
                if (!nodeList.pending.contains(object) && !nodeList.connected.contains(object)) {
                    this.logger.finest("ONS nodelist " + nodeList + " node to pending: " + object);
                    nodeList.pending.add(object);
                    node = true;
                }
                if (!object.isConnected()) continue;
                this.logger.finest("ONS nodelist " + nodeList + " node is connected: " + object);
                iterator.remove();
                ++n2;
                if (!node) continue;
                notificationNetwork.onNodeUp(object);
            }
            if (n2 >= n) {
                this.logger.finest("ONS nodelist " + nodeList + " at max connections: " + n2 + "/" + n);
                return;
            }
            Collections.sort(arrayList, new Comparator<NodeAddress>(){

                @Override
                public int compare(NodeAddress nodeAddress, NodeAddress nodeAddress2) {
                    Long l = (Long)NotificationManager.this.nodeHistory.get(nodeAddress);
                    Long l2 = (Long)NotificationManager.this.nodeHistory.get(nodeAddress2);
                    if (l != null && l2 != null) {
                        return l.compareTo(l2);
                    }
                    if (l != null) {
                        return 1;
                    }
                    if (l2 != null) {
                        return -1;
                    }
                    return 0;
                }
            });
            this.logger.finest("ONS scanning nodes for network " + notificationNetwork);
            for (NodeAddress nodeAddress : arrayList) {
                Node node;
                Node node2 = this.nodes.putIfAbsent(nodeAddress, node = new Node(this, nodeAddress, notificationNetwork.config));
                if (node2 == null) {
                    node2 = node;
                    this.logger.finest("ONS new node: " + node2 + "(" + node2.getAddress().toString() + ")");
                } else {
                    this.logger.finest("ONS existing node: " + node2 + "(" + node2.getAddress().toString() + ")");
                }
                if (!node2.register(notificationNetwork)) continue;
                this.nodeHistory.put(nodeAddress, System.currentTimeMillis());
                this.logger.finest("ONS nodelist " + nodeList + " registered node to pending: " + node2);
                nodeList.pending.add(node2);
                if (node2.isConnected()) {
                    this.logger.finest("ONS nodelist " + nodeList + " registered node connected: " + node2);
                    notificationNetwork.onNodeUp(node2);
                }
                if (++n2 < n) continue;
                break;
            }
            this.logger.fine("ONS nodelist " + nodeList + " network: " + notificationNetwork + " end connect");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNetworkUp(NotificationNetwork notificationNetwork) {
        ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> concurrentHashMap = this.networks;
        synchronized (concurrentHashMap) {
            if (this.maintenanceTask == null) {
                this.logger.fine("ONS onNetworkUp network: " + notificationNetwork + " sched maint");
                this.maintenanceTask = new MaintenanceTask();
                this.wm.scheduleDelayed(this.maintenanceTask, Node.PING_TIMEOUT / 2L);
            }
            ++this.activeNetworks;
            this.logger.fine("ONS onNetworkUp network: " + notificationNetwork + " activeNetworks: " + this.activeNetworks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onNetworkDown(NotificationNetwork notificationNetwork) {
        ConcurrentHashMap<Object, WeakReference<NotificationNetwork>> concurrentHashMap = this.networks;
        synchronized (concurrentHashMap) {
            this.logger.fine("ONS onNetworkDown network: " + notificationNetwork + " remove from networks hash");
            this.networks.remove(notificationNetwork.config.getFingerprint());
            --this.activeNetworks;
            this.logger.fine("ONS onNetworkDown network: " + notificationNetwork + " activeNetworks: " + this.activeNetworks);
        }
    }

    private class MaintenanceTask
    implements Runnable {
        private MaintenanceTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList arrayList = new ArrayList();
            ArrayList<NotificationNetwork> arrayList2 = new ArrayList<NotificationNetwork>();
            long l = System.currentTimeMillis();
            int n = 0;
            NotificationManager.this.logger.fine("ONS MaintenanceTask begin");
            Object object = NotificationManager.this.networks;
            synchronized (object) {
                for (Object object2 : NotificationManager.this.networks.values()) {
                    NotificationNetwork notificationNetwork = (NotificationNetwork)((Reference)object2).get();
                    if (notificationNetwork == null) continue;
                    NotificationManager.this.logger.fine("ONS MaintenanceTask adding network: " + notificationNetwork);
                    arrayList2.add(notificationNetwork);
                }
            }
            NotificationManager.this.logger.fine("ONS MaintenanceTask network release phase");
            for (NotificationNetwork notificationNetwork : arrayList2) {
                notificationNetwork.releaseIfUnused();
            }
            object = NotificationManager.this.networks;
            synchronized (object) {
                NotificationManager.this.logger.fine("ONS MaintenanceTask node scan phase");
                arrayList.addAll(NotificationManager.this.nodes.values());
                for (Object object2 : arrayList) {
                    if (((Node)object2).isConnected()) {
                        ((Node)object2).checkConnection(l);
                    }
                    if (((Node)object2).isGarbage()) continue;
                    NotificationManager.this.logger.fine("ONS MaintenanceTask node connected: " + object2);
                    ++n;
                }
                if (n == 0) {
                    NotificationManager.this.logger.fine("ONS MaintenanceTask no connected nodes");
                    NotificationManager.this.maintenanceTask = null;
                } else {
                    NotificationManager.this.logger.fine("ONS MaintenanceTask connected nodes " + n + " resched");
                    NotificationManager.this.wm.scheduleDelayed(NotificationManager.this.maintenanceTask, Node.PING_TIMEOUT / 2L);
                }
                NotificationManager.this.logger.fine("ONS MaintenanceTask end");
            }
        }
    }
}

