/*
 * Decompiled with CFR 0.152.
 */
package oracle.graphviz.pgql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import oracle.graphviz.pgql.exception.GraphVisualizationExecutionException;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ResultSet;
import oracle.pgx.graphviz.driver.Driver;
import oracle.pgx.graphviz.formatter.EnhancedResultSet;
import oracle.pgx.graphviz.formatter.Result;
import oracle.pgx.graphviz.library.QueryEnhancer;
import oracle.pgx.graphviz.library.TableOnlyResultSet;
import oracle.pgx.graphviz.library.VisualResultSet;
import oracle.pgx.graphviz.library.enhancer.Enhancement;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPgqlDriver
implements Driver {
    protected static final Logger LOG = LoggerFactory.getLogger(AbstractPgqlDriver.class);
    private static final String THREAD_NAMING_PATTERN = "graphviz-execution-%d";
    private static final int DEFAULT_NUMBER_OF_THREADS = 64;
    private final ExecutorService executorService;

    public AbstractPgqlDriver(Map<String, Object> properties) {
        BasicThreadFactory threadFactory = new BasicThreadFactory.Builder().namingPattern(THREAD_NAMING_PATTERN).daemon(true).build();
        int threadPoolSize = 64;
        String threadPoolSizeString = (String)properties.get("graphviz.driver.thread_pool_size");
        if (!StringUtils.isEmpty((CharSequence)threadPoolSizeString)) {
            threadPoolSize = Integer.valueOf(threadPoolSizeString);
        }
        this.executorService = Executors.newFixedThreadPool(threadPoolSize, (ThreadFactory)threadFactory);
    }

    public AbstractPgqlDriver(Map<String, Object> properties, ExecutorService executorService) {
        this.executorService = executorService;
    }

    private QueryEnhancer<Result> getEnhancerFromProperties(Map<String, Object> props) {
        return (QueryEnhancer)props.get("query_enhancer");
    }

    @Nonnull
    public EnhancedResultSet getEnhancedResultSet(ResultSet rs, @Nullable String schema, String graphName, boolean canViz, boolean isDirectedSupported, boolean supportsMultipleIterations, Map<String, Object> properties) throws PgqlException {
        List header = (List)properties.get("original_header");
        if (canViz) {
            Enhancement enhancement = (Enhancement)properties.get("enhancement");
            return new VisualResultSet(rs, enhancement, schema, header, isDirectedSupported, supportsMultipleIterations);
        }
        return new TableOnlyResultSet(rs, graphName, schema, header, supportsMultipleIterations);
    }

    public Optional<Result> execute(String query, @Nullable String schema, String graphName, Map<String, Object> props) throws PgqlException, SQLException, IOException {
        QueryEnhancer<Result> enhancer = this.getEnhancerFromProperties(props);
        return enhancer.execute(query, schema, graphName, props);
    }

    public Future<Optional<Result>> executeAsync(String query, @Nullable String schema, String graphName, Map<String, Object> props) throws PgqlException, SQLException, IOException {
        CompletableFuture<Optional<Result>> queryExecution = CompletableFuture.supplyAsync(() -> {
            try {
                return this.execute(query, schema, graphName, props);
            }
            catch (IOException | SQLException | PgqlException ex) {
                throw new GraphVisualizationExecutionException(ex);
            }
        }, this.executorService);
        return queryExecution;
    }
}

