/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang.gradual;

import io.usethesource.capsule.BinaryRelation;
import io.usethesource.capsule.Set;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.strategoxt.lang.gradual.AllOf;
import org.strategoxt.lang.gradual.BlobT;
import org.strategoxt.lang.gradual.BottomT;
import org.strategoxt.lang.gradual.ConstructorArity;
import org.strategoxt.lang.gradual.DynT;
import org.strategoxt.lang.gradual.IllFormedTermT;
import org.strategoxt.lang.gradual.IntT;
import org.strategoxt.lang.gradual.OneOf;
import org.strategoxt.lang.gradual.RealT;
import org.strategoxt.lang.gradual.Sort;
import org.strategoxt.lang.gradual.SortVar;
import org.strategoxt.lang.gradual.StringT;
import org.strategoxt.lang.gradual.Type;
import org.strategoxt.lang.gradual.TypedConstructor;

public class TypeInfo {
    private BinaryRelation.Transient<Type, Type> injections = BinaryRelation.Transient.of();
    private BinaryRelation.Transient<ConstructorArity, TypedConstructor> consSorts = BinaryRelation.Transient.of();

    public void internalCopyFrom(TypeInfo toCopy) {
        for (Map.Entry e : toCopy.injections.entrySet()) {
            this.injections.__insert((Object)((Type)e.getKey()), (Object)((Type)e.getValue()));
        }
        for (Map.Entry e : toCopy.consSorts.entrySet()) {
            this.consSorts.__insert((Object)((ConstructorArity)e.getKey()), (Object)((TypedConstructor)e.getValue()));
        }
    }

    public boolean typeIsA(Type currentType, Type type, Map<SortVar, Type> env) {
        if (currentType == type || currentType.equals(type)) {
            return true;
        }
        if (currentType == BottomT.INSTANCE) {
            return true;
        }
        if (type instanceof SortVar) {
            SortVar sortvar = (SortVar)type;
            Type typeOfVar = env.get(sortvar);
            if (typeOfVar != null) {
                Type lub = this.leastUpperBound(Arrays.asList(currentType, typeOfVar), env);
                env.put(sortvar, lub);
            } else {
                env.put(sortvar, currentType);
            }
            return true;
        }
        if (type == DynT.INSTANCE) {
            return true;
        }
        if (this.injections.containsEntry((Object)currentType, (Object)type)) {
            return true;
        }
        if (currentType instanceof OneOf) {
            boolean result = false;
            for (Type ct : ((OneOf)currentType).types) {
                HashMap<SortVar, Type> speculativeEnv;
                if (this.typeIsA(ct, type, speculativeEnv = new HashMap<SortVar, Type>(env))) {
                    env.putAll(speculativeEnv);
                    result = true;
                    continue;
                }
                return false;
            }
            return result;
        }
        if (type instanceof OneOf) {
            for (Type t2 : ((OneOf)type).types) {
                HashMap<SortVar, Type> speculativeEnv;
                if (!this.typeIsA(currentType, t2, speculativeEnv = new HashMap<SortVar, Type>(env))) continue;
                env.putAll(speculativeEnv);
                return true;
            }
            return false;
        }
        if (currentType instanceof AllOf) {
            for (Type ct : ((AllOf)currentType).types) {
                HashMap<SortVar, Type> speculativeEnv;
                if (!this.typeIsA(ct, type, speculativeEnv = new HashMap<SortVar, Type>(env))) continue;
                env.putAll(speculativeEnv);
                return true;
            }
            return false;
        }
        if (type instanceof AllOf) {
            boolean result = false;
            for (Type t3 : ((AllOf)type).types) {
                HashMap<SortVar, Type> speculativeEnv;
                if (this.typeIsA(currentType, t3, speculativeEnv = new HashMap<SortVar, Type>(env))) {
                    env.putAll(speculativeEnv);
                    result = true;
                    continue;
                }
                return false;
            }
            return result;
        }
        if (currentType instanceof Sort && type instanceof Sort) {
            Sort currentSort = (Sort)currentType;
            Sort sort = (Sort)type;
            if (currentSort.sort.equals(sort.sort)) {
                return this.typeIsA(currentSort.types, sort.types, env);
            }
            HashSet<Type> injectIntoType = new HashSet<Type>((Collection<Type>)this.injections.inverse().get((Object)type));
            injectIntoType.removeIf(t -> this.injections.containsEntry((Object)type, t));
            switch (injectIntoType.size()) {
                case 0: {
                    return false;
                }
                case 1: {
                    return this.typeIsA(currentType, (Type)injectIntoType.iterator().next(), env);
                }
            }
            return this.typeIsA(currentType, new OneOf(injectIntoType), env);
        }
        return (currentType instanceof IntT || currentType instanceof RealT || currentType instanceof StringT || currentType instanceof BlobT) && currentType.equals(type);
    }

    public boolean typeIsA(Collection<Type> currentTypes, Collection<Type> types, Map<SortVar, Type> env) {
        if (currentTypes.size() == types.size()) {
            Iterator<Type> ctIter = currentTypes.iterator();
            Iterator<Type> tIter = types.iterator();
            while (ctIter.hasNext()) {
                if (this.typeIsA(ctIter.next(), tIter.next(), env)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Type leastUpperBound(List<Type> subTermTypes, Map<SortVar, Type> env) {
        if (subTermTypes.isEmpty()) {
            throw new IllegalArgumentException("least upper bound of empty list is undefined");
        }
        Iterator<Type> it = subTermTypes.iterator();
        Type lub = it.next();
        while (it.hasNext()) {
            Type next = it.next();
            if (this.typeIsA(lub, next, new HashMap<SortVar, Type>(env))) {
                lub = next;
                continue;
            }
            if (this.typeIsA(next, lub, new HashMap<SortVar, Type>(env))) continue;
            if (this.sharedPrefix(next, lub)) {
                Sort nextSort = (Sort)next;
                Sort lubSort = (Sort)lub;
                ArrayList<Type> argumentTypes = new ArrayList<Type>(nextSort.types.size());
                Iterator<Type> nextIter = nextSort.types.iterator();
                Iterator<Type> lubIter = lubSort.types.iterator();
                while (nextIter.hasNext()) {
                    Type nextArgType = nextIter.next();
                    Type lubArgType = lubIter.next();
                    argumentTypes.add(this.leastUpperBound(Arrays.asList(nextArgType, lubArgType), env));
                }
                lub = new Sort(((Sort)next).sort, argumentTypes);
                continue;
            }
            HashSet<Type> upperBounds = new HashSet<Type>();
            upperBounds.addAll((Collection<Type>)this.injections.get((Object)lub));
            upperBounds.retainAll((Collection<?>)this.injections.get((Object)next));
            if (upperBounds.isEmpty()) {
                return new OneOf(new HashSet<Type>(subTermTypes));
            }
            lub = this.lowestType(upperBounds, env);
        }
        return lub;
    }

    private boolean sharedPrefix(Type next, Type lub) {
        if (next instanceof Sort && lub instanceof Sort) {
            Sort nextSort = (Sort)next;
            Sort lubSort = (Sort)lub;
            return nextSort.sort.equals(lubSort.sort) && nextSort.types.size() == lubSort.types.size();
        }
        return false;
    }

    private Type lowestType(Collection<Type> relatedTypes, Map<SortVar, Type> env) {
        assert (relatedTypes.size() > 1);
        HashSet<Type> types = new HashSet<Type>();
        block0: for (Type candidateLowestType : relatedTypes) {
            for (Type testType : relatedTypes) {
                if (candidateLowestType != testType && this.typeIsA(testType, candidateLowestType, new HashMap<SortVar, Type>(env))) continue block0;
            }
            types.add(candidateLowestType);
        }
        if (types.size() == 1) {
            return (Type)types.iterator().next();
        }
        return new AllOf(types);
    }

    public Type typeOf(String constructorName, List<Type> subTermTypes) {
        HashSet<Type> types = new HashSet<Type>();
        Set.Immutable typedConstructors = this.consSorts.get((Object)new ConstructorArity(constructorName, subTermTypes.size()));
        for (TypedConstructor tc : typedConstructors) {
            HashMap<SortVar, Type> env = new HashMap<SortVar, Type>();
            if (tc.type instanceof Sort) {
                for (Type ta : ((Sort)tc.type).types) {
                    if (!(ta instanceof SortVar)) continue;
                    env.put((SortVar)ta, null);
                }
            }
            if (!this.typeIsA(subTermTypes, tc.subTermTypes, env)) continue;
            if (tc.type instanceof Sort) {
                Sort sort = (Sort)tc.type;
                ArrayList<Type> typeArgs = new ArrayList<Type>(sort.types.size());
                for (Type ta : sort.types) {
                    if (ta instanceof SortVar) {
                        Type lookupResult = (Type)env.get((SortVar)ta);
                        if (lookupResult != null) {
                            typeArgs.add(lookupResult);
                            continue;
                        }
                        typeArgs.add(BottomT.INSTANCE);
                        continue;
                    }
                    typeArgs.add(ta);
                }
                types.add(new Sort(sort.sort, typeArgs));
                continue;
            }
            types.add(tc.type);
        }
        switch (types.size()) {
            case 0: {
                return new IllFormedTermT(constructorName, subTermTypes);
            }
            case 1: {
                return (Type)types.iterator().next();
            }
        }
        return new AllOf(types);
    }

    public void registerConstructor(Type sort, String name, List<Type> subTermTypes) {
        this.consSorts.__insert((Object)new ConstructorArity(name, subTermTypes.size()), (Object)new TypedConstructor(name, subTermTypes, sort));
    }

    public void registerInjection(Type from, Type to) {
        this.injections.__insert((Object)from, (Object)to);
    }

    public void finishRegistration() {
        this.injections = TypeInfo.reflexiveTransitiveClosure((BinaryRelation.Immutable<Type, Type>)this.injections.freeze());
    }

    private static BinaryRelation.Transient<Type, Type> reflexiveTransitiveClosure(BinaryRelation.Immutable<Type, Type> rel) {
        LinkedList<AbstractMap.SimpleImmutableEntry<Type, Type>> worklist = new LinkedList<AbstractMap.SimpleImmutableEntry<Type, Type>>(rel.entrySet());
        BinaryRelation.Transient result = rel.asTransient();
        while (!worklist.isEmpty()) {
            Map.Entry e = (Map.Entry)worklist.pop();
            for (Type post : rel.get(e.getValue())) {
                if (result.containsEntry(e.getKey(), (Object)post)) continue;
                result.__insert((Object)((Type)e.getKey()), (Object)post);
                worklist.add(new AbstractMap.SimpleImmutableEntry<Type, Type>((Type)e.getKey(), post));
            }
        }
        for (Map.Entry e : rel.entrySet()) {
            Type key = (Type)e.getKey();
            Type value = (Type)e.getValue();
            result.__insert((Object)key, (Object)key);
            result.__insert((Object)value, (Object)value);
        }
        return result;
    }

    public void clear() {
        this.injections = BinaryRelation.Transient.of();
        this.consSorts = BinaryRelation.Transient.of();
    }
}

