/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms.util;

import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoPlaceholder;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.IStrategoTuple;
import org.spoofax.interpreter.terms.TermType;

public final class TermUtils {
    private TermUtils() {
    }

    public static boolean isString(IStrategoTerm term) {
        boolean isString;
        boolean bl = isString = term != null && term.getType() == TermType.STRING;
        assert (!isString || term instanceof IStrategoString) : TermUtils.getTypeMismatchAssertionMessage(IStrategoString.class, TermType.STRING, term);
        return isString;
    }

    public static boolean isString(IStrategoTerm term, String value) {
        return TermUtils.isString(term) && ((IStrategoString)term).stringValue().equals(value);
    }

    public static boolean isInt(IStrategoTerm term) {
        boolean isInt;
        boolean bl = isInt = term != null && term.getType() == TermType.INT;
        assert (!isInt || term instanceof IStrategoInt) : TermUtils.getTypeMismatchAssertionMessage(IStrategoInt.class, TermType.INT, term);
        return isInt;
    }

    public static boolean isInt(IStrategoTerm term, int value) {
        return TermUtils.isInt(term) && ((IStrategoInt)term).intValue() == value;
    }

    public static boolean isReal(IStrategoTerm term) {
        boolean isReal;
        boolean bl = isReal = term != null && term.getType() == TermType.REAL;
        assert (!isReal || term instanceof IStrategoReal) : TermUtils.getTypeMismatchAssertionMessage(IStrategoReal.class, TermType.REAL, term);
        return isReal;
    }

    public static boolean isReal(IStrategoTerm term, double value) {
        return TermUtils.isReal(term) && TermUtils.fuzzyEquals(((IStrategoReal)term).realValue(), value);
    }

    public static boolean isAppl(IStrategoTerm term) {
        boolean isAppl;
        boolean bl = isAppl = term != null && term.getType() == TermType.APPL;
        assert (!isAppl || term instanceof IStrategoAppl) : TermUtils.getTypeMismatchAssertionMessage(IStrategoAppl.class, TermType.APPL, term);
        return isAppl;
    }

    public static boolean isAppl(IStrategoTerm term, IStrategoConstructor constructor) {
        return TermUtils.isAppl(term) && ((IStrategoAppl)term).getConstructor().equals(constructor);
    }

    public static boolean isAppl(IStrategoTerm term, @Nullable String constructorName) {
        return TermUtils.isAppl(term, constructorName, -1);
    }

    public static boolean isAppl(IStrategoTerm term, @Nullable String constructorName, int arity) {
        if (!TermUtils.isAppl(term)) {
            return false;
        }
        IStrategoConstructor constructor = ((IStrategoAppl)term).getConstructor();
        return !(constructorName != null && !constructor.getName().equals(constructorName) || arity >= 0 && constructor.getArity() != arity);
    }

    public static boolean isList(IStrategoTerm term) {
        boolean isList;
        boolean bl = isList = term != null && term.getType() == TermType.LIST;
        assert (!isList || term instanceof IStrategoList) : TermUtils.getTypeMismatchAssertionMessage(IStrategoList.class, TermType.LIST, term);
        return isList;
    }

    public static boolean isList(IStrategoTerm term, int size) {
        return TermUtils.isList(term) && ((IStrategoList)term).size() == size;
    }

    public static boolean isTuple(IStrategoTerm term) {
        boolean isTuple;
        boolean bl = isTuple = term != null && term.getType() == TermType.TUPLE;
        assert (!isTuple || term instanceof IStrategoTuple) : TermUtils.getTypeMismatchAssertionMessage(IStrategoTuple.class, TermType.TUPLE, term);
        return isTuple;
    }

    public static boolean isTuple(IStrategoTerm term, int size) {
        return TermUtils.isTuple(term) && ((IStrategoTuple)term).size() == size;
    }

    public static boolean isPlaceholder(IStrategoTerm term) {
        boolean isTuple;
        boolean bl = isTuple = term != null && term.getType() == TermType.PLACEHOLDER;
        assert (!isTuple || term instanceof IStrategoPlaceholder) : TermUtils.getTypeMismatchAssertionMessage(IStrategoTuple.class, TermType.PLACEHOLDER, term);
        return isTuple;
    }

    public static Optional<IStrategoString> asString(IStrategoTerm term) {
        return TermUtils.isString(term) ? Optional.of((IStrategoString)term) : Optional.empty();
    }

    public static Optional<IStrategoInt> asInt(IStrategoTerm term) {
        return TermUtils.isInt(term) ? Optional.of((IStrategoInt)term) : Optional.empty();
    }

    public static Optional<IStrategoReal> asReal(IStrategoTerm term) {
        return TermUtils.isReal(term) ? Optional.of((IStrategoReal)term) : Optional.empty();
    }

    public static Optional<IStrategoAppl> asAppl(IStrategoTerm term) {
        return TermUtils.isAppl(term) ? Optional.of((IStrategoAppl)term) : Optional.empty();
    }

    public static Optional<IStrategoList> asList(IStrategoTerm term) {
        return TermUtils.isList(term) ? Optional.of((IStrategoList)term) : Optional.empty();
    }

    public static Optional<IStrategoTuple> asTuple(IStrategoTerm term) {
        return TermUtils.isTuple(term) ? Optional.of((IStrategoTuple)term) : Optional.empty();
    }

    public static Optional<IStrategoPlaceholder> asPlaceholder(IStrategoTerm term) {
        return TermUtils.isPlaceholder(term) ? Optional.of((IStrategoPlaceholder)term) : Optional.empty();
    }

    public static Optional<String> asJavaString(IStrategoTerm term) {
        return TermUtils.asString(term).map(IStrategoString::stringValue);
    }

    public static Optional<Integer> asJavaInt(IStrategoTerm term) {
        return TermUtils.asInt(term).map(IStrategoInt::intValue);
    }

    public static Optional<Double> asJavaReal(IStrategoTerm term) {
        return TermUtils.asReal(term).map(IStrategoReal::realValue);
    }

    public static Optional<List<IStrategoTerm>> asJavaList(IStrategoTerm term) {
        return TermUtils.asList(term).map(t -> Collections.unmodifiableList(Arrays.asList(t.getAllSubterms())));
    }

    public static IStrategoString toString(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.STRING);
        }
        return TermUtils.asString(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.STRING, term.getType()));
    }

    public static IStrategoInt toInt(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.INT);
        }
        return TermUtils.asInt(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.INT, term.getType()));
    }

    public static IStrategoReal toReal(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.REAL);
        }
        return TermUtils.asReal(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.REAL, term.getType()));
    }

    public static IStrategoAppl toAppl(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.APPL);
        }
        return TermUtils.asAppl(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.APPL, term.getType()));
    }

    public static IStrategoList toList(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.LIST);
        }
        return TermUtils.asList(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.LIST, term.getType()));
    }

    public static IStrategoTuple toTuple(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.TUPLE);
        }
        return TermUtils.asTuple(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.TUPLE, term.getType()));
    }

    public static IStrategoPlaceholder toPlaceholder(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.PLACEHOLDER);
        }
        return TermUtils.asPlaceholder(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.PLACEHOLDER, term.getType()));
    }

    public static String toJavaString(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.STRING);
        }
        return TermUtils.asJavaString(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.STRING, term.getType()));
    }

    public static int toJavaInt(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.INT);
        }
        return TermUtils.asJavaInt(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.INT, term.getType()));
    }

    public static double toJavaReal(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.REAL);
        }
        return TermUtils.asJavaReal(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.REAL, term.getType()));
    }

    public static List<IStrategoTerm> toJavaList(IStrategoTerm term) {
        if (term == null) {
            throw TermUtils.newTermNullException(TermType.LIST);
        }
        return TermUtils.asJavaList(term).orElseThrow(() -> TermUtils.newTermCastException(TermType.LIST, term.getType()));
    }

    private static Optional<IStrategoTerm> tryGetTermAt(IStrategoTerm term, int index) {
        try {
            if (index >= 0 && index < term.getSubtermCount()) {
                return Optional.ofNullable(term.getSubterm(index));
            }
            return Optional.empty();
        }
        catch (IndexOutOfBoundsException e) {
            return Optional.empty();
        }
    }

    public static boolean isStringAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).map(TermUtils::isString).orElse(false);
    }

    public static boolean isStringAt(IStrategoTerm term, int index, String value) {
        return TermUtils.tryGetTermAt(term, index).map(t -> TermUtils.isString(t, value)).orElse(false);
    }

    public static boolean isIntAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).map(TermUtils::isInt).orElse(false);
    }

    public static boolean isIntAt(IStrategoTerm term, int index, int value) {
        return TermUtils.tryGetTermAt(term, index).map(t -> TermUtils.isInt(t, value)).orElse(false);
    }

    public static boolean isRealAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).map(TermUtils::isReal).orElse(false);
    }

    public static boolean isRealAt(IStrategoTerm term, int index, double value) {
        return TermUtils.tryGetTermAt(term, index).map(t -> TermUtils.isReal(t, value)).orElse(false);
    }

    public static boolean isApplAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).map(TermUtils::isAppl).orElse(false);
    }

    public static boolean isApplAt(IStrategoTerm term, int index, IStrategoConstructor constructor) {
        return TermUtils.tryGetTermAt(term, index).map(t -> TermUtils.isAppl(t, constructor)).orElse(false);
    }

    public static boolean isApplAt(IStrategoTerm term, int index, @Nullable String constructorName) {
        return TermUtils.isApplAt(term, index, constructorName, -1);
    }

    public static boolean isApplAt(IStrategoTerm term, int index, @Nullable String constructorName, int arity) {
        return TermUtils.tryGetTermAt(term, index).map(t -> TermUtils.isAppl(t, constructorName, arity)).orElse(false);
    }

    public static boolean isListAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).map(TermUtils::isList).orElse(false);
    }

    public static boolean isListAt(IStrategoTerm term, int index, int size) {
        return TermUtils.tryGetTermAt(term, index).map(t -> TermUtils.isList(t, size)).orElse(false);
    }

    public static boolean isTupleAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).map(TermUtils::isTuple).orElse(false);
    }

    public static boolean isTupleAt(IStrategoTerm term, int index, int size) {
        return TermUtils.tryGetTermAt(term, index).map(t -> TermUtils.isTuple(t, size)).orElse(false);
    }

    public static boolean isPlaceholderAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).map(TermUtils::isPlaceholder).orElse(false);
    }

    public static Optional<IStrategoString> asStringAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asString);
    }

    public static Optional<IStrategoInt> asIntAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asInt);
    }

    public static Optional<IStrategoReal> asRealAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asReal);
    }

    public static Optional<IStrategoAppl> asApplAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asAppl);
    }

    public static Optional<IStrategoList> asListAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asList);
    }

    public static Optional<IStrategoTuple> asTupleAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asTuple);
    }

    public static Optional<IStrategoPlaceholder> asPlaceholderAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asPlaceholder);
    }

    public static Optional<String> asJavaStringAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asJavaString);
    }

    public static Optional<Integer> asJavaIntAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asJavaInt);
    }

    public static Optional<Double> asJavaRealAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asJavaReal);
    }

    public static Optional<List<IStrategoTerm>> asJavaListAt(IStrategoTerm term, int index) {
        return TermUtils.tryGetTermAt(term, index).flatMap(TermUtils::asJavaList);
    }

    public static IStrategoString toStringAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.STRING, index);
        }
        return TermUtils.asString(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.STRING, term.getType(), index));
    }

    public static IStrategoInt toIntAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.INT, index);
        }
        return TermUtils.asInt(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.INT, term.getType(), index));
    }

    public static IStrategoReal toRealAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.REAL, index);
        }
        return TermUtils.asReal(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.REAL, term.getType(), index));
    }

    public static IStrategoAppl toApplAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.APPL, index);
        }
        return TermUtils.asAppl(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.APPL, term.getType(), index));
    }

    public static IStrategoList toListAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.LIST, index);
        }
        return TermUtils.asList(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.LIST, term.getType(), index));
    }

    public static IStrategoTuple toTupleAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.TUPLE, index);
        }
        return TermUtils.asTuple(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.TUPLE, term.getType(), index));
    }

    public static IStrategoPlaceholder toPlaceholderAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.PLACEHOLDER, index);
        }
        return TermUtils.asPlaceholder(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.PLACEHOLDER, term.getType(), index));
    }

    public static String toJavaStringAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.STRING, index);
        }
        return TermUtils.asJavaString(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.STRING, term.getType(), index));
    }

    public static int toJavaIntAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.INT, index);
        }
        return TermUtils.asJavaInt(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.INT, term.getType(), index));
    }

    public static double toJavaRealAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.REAL, index);
        }
        return TermUtils.asJavaReal(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.REAL, term.getType(), index));
    }

    public static List<IStrategoTerm> toJavaListAt(IStrategoTerm term, int index) {
        if (term == null) {
            throw TermUtils.newTermNullException();
        }
        IStrategoTerm subterm = term.getSubterm(index);
        if (subterm == null) {
            throw TermUtils.newTermNullException(TermType.LIST, index);
        }
        return TermUtils.asJavaList(subterm).orElseThrow(() -> TermUtils.newTermCastException(TermType.LIST, term.getType(), index));
    }

    public static Optional<String> tryGetName(IStrategoTerm term) {
        return TermUtils.asAppl(term).map(t -> t.getConstructor().getName());
    }

    private static boolean fuzzyEquals(double a, double b) {
        double EPSILON = 1.0E-30;
        return Math.copySign(a - b, 1.0) <= EPSILON || a == b || Double.isNaN(a) && Double.isNaN(b);
    }

    private static ClassCastException newTermCastException(TermType expectedType, TermType actualType) {
        return TermUtils.newTermCastException(expectedType, actualType, -1);
    }

    private static ClassCastException newTermCastException(TermType expectedType, TermType actualType, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append("Expected ");
        sb.append(TermUtils.termTypeToString(expectedType));
        if (index >= 0) {
            sb.append(" subterm at index ").append(index);
        } else {
            sb.append(" term");
        }
        sb.append(", but got ");
        sb.append(TermUtils.termTypeToString(actualType));
        if (index >= 0) {
            sb.append(" subterm.");
        } else {
            sb.append(" term.");
        }
        return new ClassCastException(sb.toString());
    }

    private static NullPointerException newTermNullException() {
        return new NullPointerException("Expected a term; got null.");
    }

    private static NullPointerException newTermNullException(TermType expectedType) {
        return TermUtils.newTermNullException(expectedType, -1);
    }

    private static NullPointerException newTermNullException(TermType expectedType, int index) {
        StringBuilder sb = new StringBuilder();
        sb.append("Expected ");
        sb.append(TermUtils.termTypeToString(expectedType));
        if (index >= 0) {
            sb.append(" subterm at index ").append(index);
        } else {
            sb.append(" term");
        }
        sb.append(", but got null.");
        return new NullPointerException(sb.toString());
    }

    private static String getTypeMismatchAssertionMessage(Class<?> expectedClass, TermType expectedType, IStrategoTerm term) {
        return "Expected " + TermUtils.termTypeToString(expectedType) + " term to implement interface " + expectedClass.getSimpleName() + ": " + term.getClass().getSimpleName();
    }

    public static String termTypeToString(TermType type) {
        switch (type) {
            case APPL: {
                return "a Constructor Application";
            }
            case LIST: {
                return "a List";
            }
            case INT: {
                return "an Int";
            }
            case REAL: {
                return "a Real";
            }
            case STRING: {
                return "a String";
            }
            case CTOR: {
                return "a Constructor";
            }
            case TUPLE: {
                return "a Tuple";
            }
            case REF: {
                return "a Ref";
            }
            case BLOB: {
                return "a Blob";
            }
            case PLACEHOLDER: {
                return "a Placeholder";
            }
        }
        return "an unrecognized";
    }
}

