/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.terms;

import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.AbstractStrategoList;
import org.spoofax.terms.AbstractTermFactory;
import org.spoofax.terms.StrategoArrayListBuilder;
import org.spoofax.terms.StrategoArrayListIterator;
import org.spoofax.terms.StrategoList;
import org.spoofax.terms.attachments.ITermAttachment;
import org.spoofax.terms.attachments.TermAttachmentType;

public class StrategoArrayList
extends AbstractStrategoList
implements RandomAccess {
    private static final long serialVersionUID = -1746012089187246512L;
    final IStrategoTerm[] terms;
    private final int offset;
    final int endOffset;
    final ITermAttachment[] tailAttachments;

    public StrategoArrayList(IStrategoTerm ... terms) {
        this(terms, null);
    }

    public StrategoArrayList(IStrategoTerm[] terms, @Nullable IStrategoList annotations) {
        this(terms, annotations, 0, terms.length, new ITermAttachment[terms.length]);
    }

    protected StrategoArrayList(IStrategoTerm[] terms, @Nullable IStrategoList annotations, int offset, int endOffset) {
        this(terms, annotations, offset, endOffset, new ITermAttachment[terms.length]);
    }

    protected StrategoArrayList(IStrategoTerm[] terms, @Nullable IStrategoList annotations, int offset, int endOffset, ITermAttachment[] tailAttachments) {
        super(annotations);
        ITermAttachment attachment;
        if (offset > terms.length) {
            throw new IllegalArgumentException("Offset (" + offset + ") is larger than backing array (" + terms.length + ")");
        }
        if (endOffset > terms.length) {
            throw new IllegalArgumentException("Length (" + endOffset + ") is larger than backing array (" + terms.length + ")");
        }
        this.terms = terms;
        this.offset = offset;
        this.endOffset = endOffset;
        this.tailAttachments = tailAttachments;
        if (offset > 0 && (attachment = tailAttachments[offset - 1]) != null) {
            super.putAttachment(attachment);
        }
    }

    public static StrategoArrayList fromCollection(Collection<? extends IStrategoTerm> terms) {
        return new StrategoArrayList(terms.toArray(AbstractTermFactory.EMPTY_TERM_ARRAY));
    }

    public static StrategoArrayListBuilder arrayListBuilder() {
        return new StrategoArrayListBuilder(16);
    }

    public static StrategoArrayListBuilder arrayListBuilder(int size) {
        return new StrategoArrayListBuilder(size);
    }

    @Override
    public int getSubtermCount() {
        return this.endOffset - this.offset;
    }

    @Override
    public IStrategoTerm getSubterm(int index) {
        if (index < this.getSubtermCount()) {
            return this.terms[this.offset + index];
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public IStrategoTerm[] getAllSubterms() {
        return Arrays.copyOfRange(this.terms, this.offset, this.endOffset);
    }

    @Override
    @Deprecated
    public IStrategoTerm get(int index) {
        return this.getSubterm(index);
    }

    @Override
    @Deprecated
    public IStrategoList prepend(IStrategoTerm prefix) {
        return new StrategoList(prefix, this, null);
    }

    @Override
    public IStrategoTerm head() {
        try {
            return this.getSubterm(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    @Override
    public IStrategoList tail() {
        if (this.isEmpty()) {
            throw new IllegalStateException();
        }
        return new StrategoArrayList(this.terms, null, this.offset + 1, this.endOffset, this.tailAttachments);
    }

    @Override
    public boolean isEmpty() {
        return this.getSubtermCount() == 0;
    }

    @Override
    protected boolean doSlowMatch(IStrategoTerm second) {
        IStrategoList secondAnnotations;
        if (!(second instanceof StrategoArrayList)) {
            return super.doSlowMatch(second);
        }
        if (this == second) {
            return true;
        }
        if (this.getSubtermCount() != second.getSubtermCount()) {
            return false;
        }
        StrategoArrayList other = (StrategoArrayList)second;
        if (!this.getAnnotations().match(other.getAnnotations())) {
            return false;
        }
        if (this.terms == other.terms) {
            return this.offset == other.offset && this.endOffset == other.endOffset;
        }
        Iterator<IStrategoTerm> termsThis = this.iterator();
        Iterator<IStrategoTerm> termsOther = other.iterator();
        while (termsThis.hasNext()) {
            IStrategoTerm otherNext;
            IStrategoTerm thisNext = termsThis.next();
            if (thisNext == (otherNext = termsOther.next()) || thisNext.match(otherNext)) continue;
            return false;
        }
        IStrategoList annotations = this.getAnnotations();
        if (annotations == (secondAnnotations = second.getAnnotations())) {
            return true;
        }
        return annotations.match(secondAnnotations);
    }

    @Override
    public Iterator<IStrategoTerm> iterator() {
        return new StrategoArrayListIterator(this);
    }

    @Override
    public void putAttachment(ITermAttachment attachment) {
        this.setTailAttachment(attachment);
        super.putAttachment(attachment);
    }

    @Override
    @Nullable
    public ITermAttachment removeAttachment(TermAttachmentType<?> type) {
        ITermAttachment attachment = super.removeAttachment(type);
        this.setTailAttachment(this.attachment());
        return attachment;
    }

    @Override
    protected void clearAttachments() {
        this.setTailAttachment(null);
        super.clearAttachments();
    }

    private void setTailAttachment(ITermAttachment attachment) {
        if (this.offset > 0) {
            this.tailAttachments[this.offset - 1] = attachment;
        }
    }
}

