/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.recovery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import mb.jsglr.shared.IToken;
import mb.jsglr.shared.ITokens;
import org.metaborg.parsetable.characterclasses.CharacterClassFactory;
import org.metaborg.parsetable.query.ParsingMode;
import org.spoofax.jsglr2.JSGLR2Request;
import org.spoofax.jsglr2.inputstack.IInputStack;
import org.spoofax.jsglr2.messages.Category;
import org.spoofax.jsglr2.messages.Message;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.ParseException;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.parser.observing.ParserObserving;
import org.spoofax.jsglr2.parser.result.ParseFailureCause;
import org.spoofax.jsglr2.recovery.IBacktrackChoicePoint;
import org.spoofax.jsglr2.recovery.IRecoveryParseState;
import org.spoofax.jsglr2.recovery.RecoveryJob;
import org.spoofax.jsglr2.recovery.RecoveryMessage;
import org.spoofax.jsglr2.recovery.RecoveryType;
import org.spoofax.jsglr2.stack.IStackNode;
import org.spoofax.jsglr2.stack.collections.IActiveStacks;
import org.spoofax.jsglr2.stack.collections.IForActorStacks;

public abstract class AbstractRecoveryParseState<InputStack extends IInputStack, StackNode extends IStackNode, BacktrackChoicePoint extends IBacktrackChoicePoint<InputStack, StackNode>>
extends AbstractParseState<InputStack, StackNode>
implements IRecoveryParseState<InputStack, StackNode, BacktrackChoicePoint> {
    Stack<BacktrackChoicePoint> backtrackChoicePoints = new Stack();
    private RecoveryJob<StackNode> recoveryJob = null;
    private boolean appliedRecovery = false;

    public AbstractRecoveryParseState(JSGLR2Request request, InputStack inputStack, IActiveStacks<StackNode> activeStacks, IForActorStacks<StackNode> forActorStacks) {
        super(request, inputStack, activeStacks, forActorStacks);
    }

    @Override
    public void nextParseRound(ParserObserving observing) throws ParseException {
        super.nextParseRound(observing);
        if (this.isRecovering() && this.recoveryJob.timeout()) {
            throw new ParseException(new ParseFailureCause(ParseFailureCause.Type.RecoveryTimeout, this.inputStack.safePosition()), this.inputStack.safeCharacter());
        }
        int currentOffset = this.inputStack.offset();
        if (!(currentOffset != 0 && !CharacterClassFactory.isNewLine(this.inputStack.getChar(currentOffset - 1)) || this.isRecovering() && this.lastBacktrackChoicePoint().offset() >= currentOffset)) {
            Object choicePoint = this.saveBacktrackChoicePoint();
            observing.notify(observer -> observer.recoveryBacktrackChoicePoint(this.backtrackChoicePoints().size() - 1, choicePoint));
        }
        if (this.successfulRecovery(this.request, currentOffset)) {
            this.endRecovery();
            observing.notify(observer -> observer.endRecovery(this));
        }
    }

    @Override
    public Stack<BacktrackChoicePoint> backtrackChoicePoints() {
        return this.backtrackChoicePoints;
    }

    @Override
    public void startRecovery(JSGLR2Request request, int offset) {
        this.recoveryJob = new RecoveryJob(offset, request.recoveryIterationsQuota, request.recoveryTimeout);
        this.mode = ParsingMode.Recovery;
    }

    @Override
    public void endRecovery() {
        this.recoveryJob = null;
        this.mode = ParsingMode.Standard;
    }

    @Override
    public RecoveryJob<StackNode> recoveryJob() {
        return this.recoveryJob;
    }

    @Override
    public boolean nextRecoveryIteration() {
        if (this.recoveryJob().hasNextIteration()) {
            int iteration;
            int i = iteration = this.recoveryJob().nextIteration();
            while (i > 0 && this.backtrackChoicePoints.size() > 1) {
                this.backtrackChoicePoints.pop();
                --i;
            }
            this.resetToBacktrackChoicePoint((IBacktrackChoicePoint)this.backtrackChoicePoints.peek());
            this.recoveryJob.initQuota(this.activeStacks);
            return true;
        }
        return false;
    }

    protected void resetToBacktrackChoicePoint(BacktrackChoicePoint backtrackChoicePoint) {
        this.inputStack = backtrackChoicePoint.inputStack().clone();
        this.activeStacks.clear();
        for (IStackNode activeStack : backtrackChoicePoint.activeStacks()) {
            this.activeStacks.add(activeStack);
        }
    }

    @Override
    public boolean appliedRecovery() {
        return this.appliedRecovery;
    }

    @Override
    public void setAppliedRecovery() {
        this.appliedRecovery = true;
    }

    public List<Message> postProcessMessages(Collection<Message> originalMessages, ITokens tokens) {
        ArrayList<Message> messages = new ArrayList<Message>();
        Iterator<Message> iterator = originalMessages.iterator();
        while (iterator.hasNext()) {
            Message originalMessage;
            Message message = originalMessage = iterator.next();
            if (originalMessage.category == Category.RECOVERY && ((RecoveryMessage)message).recoveryType == RecoveryType.INSERTION && originalMessage.region != null) {
                IToken precedingToken;
                IToken token = tokens.getTokenAtOffset(originalMessage.region.startOffset);
                IToken iToken = precedingToken = token != null ? token.getTokenBefore() : null;
                if (precedingToken != null && precedingToken.getKind() == IToken.Kind.TK_LAYOUT) {
                    Position position = Position.atStartOfToken(precedingToken);
                    boolean positionAtNewLine = CharacterClassFactory.isNewLine(this.inputStack.inputString().codePointAt(position.offset));
                    if (positionAtNewLine && position.offset > 0) {
                        Position previousPosition = position.previous(this.inputStack.inputString());
                        boolean previousPositionAtNewLine = CharacterClassFactory.isNewLine(this.inputStack.inputString().codePointAt(previousPosition.offset));
                        if (!previousPositionAtNewLine) {
                            position = previousPosition;
                        }
                    }
                    message = message.atPosition(position);
                }
            }
            messages.add(message);
        }
        return messages;
    }
}

