/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.parser;

import mb.jsglr.shared.IToken;
import org.metaborg.parsetable.characterclasses.CharacterClassFactory;

public class Position {
    public final int offset;
    public final int line;
    public final int column;
    public static final Position START_POSITION = new Position(0, 1, 1);

    public Position(int offset, int line, int column) {
        this.offset = offset;
        this.line = line;
        this.column = column;
    }

    public Position(Position p) {
        this.offset = p.offset;
        this.line = p.line;
        this.column = p.column;
    }

    public static Position atEnd(String string) {
        return Position.atOffset(string, string.length());
    }

    public static Position atOffset(String string, int offset) {
        if (offset == 0) {
            return START_POSITION;
        }
        int lines = 1;
        int i = 0;
        while (i < offset) {
            if (string.charAt(i) == '\n') {
                ++lines;
            }
            ++i;
        }
        int column = string.codePointBefore(offset) == 10 ? 1 : 1 + string.codePointCount(string.lastIndexOf(10, offset - 1) + 1, offset);
        return new Position(offset, lines, column);
    }

    public Position next(int character) {
        return CharacterClassFactory.isNewLine(character) ? this.nextLine() : new Position(this.offset + Character.charCount(character), this.line, this.column + 1);
    }

    public Position previous(String inputString) {
        int previousChar = inputString.codePointBefore(this.offset);
        int previousCharWidth = Character.charCount(previousChar);
        return CharacterClassFactory.isNewLine(previousChar) ? Position.atOffset(inputString, this.offset - previousCharWidth) : new Position(this.offset - previousCharWidth, this.line, this.column - 1);
    }

    public Position nextLine() {
        return new Position(this.offset + 1, this.line + 1, 1);
    }

    public Position step(String inputString, int width) {
        int offset = this.offset;
        int line = this.line;
        int column = this.column;
        int end = Integer.min(inputString.length(), offset + width);
        while (offset < end) {
            char c = inputString.charAt(offset);
            if (CharacterClassFactory.isNewLine(c)) {
                ++line;
                column = 1;
            } else if (!Character.isLowSurrogate(c)) {
                ++column;
            }
            ++offset;
        }
        return new Position(offset, line, column);
    }

    public String coordinatesToString() {
        return String.valueOf(this.line) + ":" + this.column;
    }

    public String toString() {
        return "offset: " + this.offset + " l: " + this.line + " c: " + this.column;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.column;
        result = 31 * result + this.line;
        result = 31 * result + this.offset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        return this.column == other.column && this.line == other.line && this.offset == other.offset;
    }

    public static Position atStartOfToken(IToken token) {
        return new Position(token.getStartOffset(), token.getLine(), token.getColumn());
    }
}

