/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.incremental;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mb.jsglr.shared.IToken;
import mb.jsglr.shared.ImploderAttachment;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.jsglr.client.imploder.Tokenizer;
import org.spoofax.jsglr.client.incremental.DamageRegionAnalyzer;
import org.spoofax.jsglr.client.incremental.IncrementalSGLR;
import org.spoofax.jsglr.client.incremental.IncrementalSortSet;
import org.spoofax.terms.SimpleTermVisitor;
import org.spoofax.terms.attachments.ParentAttachment;

public class NeighborDamageExpander {
    private final IncrementalSortSet incrementalSorts;
    private final int oldDamageStart;
    private final int oldDamageEnd;
    private final List<ISimpleTerm> damageNodes;
    private ISimpleTerm leftNeighbor;
    private ISimpleTerm rightNeighbor;

    public NeighborDamageExpander(DamageRegionAnalyzer damageAnalyzer, List<ISimpleTerm> damageNodes, ISimpleTerm oldTree) {
        this.incrementalSorts = damageAnalyzer.incrementalSorts;
        this.oldDamageStart = damageAnalyzer.damageStart;
        this.oldDamageEnd = damageAnalyzer.damageEnd;
        this.damageNodes = this.initExpandedDamageNodes(damageNodes, oldTree);
    }

    public int getExpandedDamageStart() {
        if (this.leftNeighbor == null) {
            return this.oldDamageStart;
        }
        return Math.min(this.oldDamageStart, ImploderAttachment.getLeftToken(this.leftNeighbor).getStartOffset());
    }

    public int getExpandedDamageEnd() {
        if (this.rightNeighbor == null) {
            return this.oldDamageEnd;
        }
        return Math.max(this.oldDamageEnd, ImploderAttachment.getRightToken(this.rightNeighbor).getEndOffset());
    }

    public List<ISimpleTerm> getExpandedDamageNodes() {
        return this.damageNodes;
    }

    private List<ISimpleTerm> initExpandedDamageNodes(List<ISimpleTerm> damageNodes, ISimpleTerm tree) {
        if (damageNodes.size() == 0) {
            return Collections.unmodifiableList(damageNodes);
        }
        ISimpleTerm first = damageNodes.get(0);
        ISimpleTerm last = damageNodes.get(damageNodes.size() - 1);
        Object SEEN_LAST = null;
        ISimpleTerm parent = ParentAttachment.tryTraverseGetParent(first, tree);
        ArrayList<ISimpleTerm> results = new ArrayList<ISimpleTerm>(damageNodes.size() + 2);
        ISimpleTerm previous = null;
        Iterator<ISimpleTerm> iterator = SimpleTermVisitor.tryGetListIterator(parent);
        int i = 0;
        int max2 = parent.getSubtermCount();
        while (i < max2) {
            ISimpleTerm child;
            ISimpleTerm iSimpleTerm = child = iterator == null ? parent.getSubterm(i) : iterator.next();
            if (child == first) {
                if (previous != null && this.incrementalSorts.isIncrementalNode(previous) && !this.isLeftCollateralDamage(first)) {
                    this.leftNeighbor = previous;
                    results.add(this.leftNeighbor);
                } else {
                    this.leftNeighbor = first;
                }
                results.addAll(damageNodes);
            } else if (child == last) {
                if (this.isRightCollateralDamage(last)) {
                    this.rightNeighbor = last;
                } else {
                    last = SEEN_LAST;
                }
            } else if (last == SEEN_LAST) {
                if (!this.incrementalSorts.isIncrementalNode(child)) break;
                this.rightNeighbor = child;
                results.add(this.rightNeighbor);
                break;
            }
            previous = child;
            ++i;
        }
        assert (results.size() >= damageNodes.size());
        return results;
    }

    boolean isDamagedNode(ISimpleTerm node, boolean considerLeftLayout, boolean considerRightLayout) {
        IToken left = ImploderAttachment.getLeftToken(node);
        IToken right = ImploderAttachment.getRightToken(node);
        if (left == null || right == null) {
            return false;
        }
        if (considerLeftLayout) {
            left = Tokenizer.findLeftMostLayoutToken(left);
        }
        if (considerRightLayout) {
            right = Tokenizer.findRightMostLayoutToken(right);
        }
        int startOffset = left.getStartOffset();
        int endOffset = right.getEndOffset();
        return IncrementalSGLR.isRangeOverlap(this.oldDamageStart, this.oldDamageEnd, startOffset, endOffset);
    }

    private boolean isLeftCollateralDamage(ISimpleTerm child) {
        assert (this.isDamagedNode(child, true, true));
        return !this.isDamagedNode(child, true, false);
    }

    private boolean isRightCollateralDamage(ISimpleTerm child) {
        assert (this.isDamagedNode(child, true, true));
        return !this.isDamagedNode(child, false, true);
    }
}

