/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.metaborg.util.stream.Utils;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.library.AbstractPrimitive;
import org.spoofax.interpreter.library.IOAgent;
import org.spoofax.interpreter.library.ssl.SSLLibrary;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.terms.util.TermUtils;

public class SSL_copy
extends AbstractPrimitive {
    SSL_copy() {
        super("SSL_copy", 0, 2);
    }

    @Override
    public boolean call(IContext env, Strategy[] svars, IStrategoTerm[] tvars) throws InterpreterException {
        boolean closeOut;
        OutputStream out;
        boolean closeIn;
        InputStream in;
        block18: {
            IOAgent agent;
            block17: {
                SSLLibrary op = (SSLLibrary)env.getOperatorRegistry("SSL");
                agent = op.getIOAgent();
                if (this.isSameFile(tvars, agent)) {
                    return true;
                }
                try {
                    if (TermUtils.isString(tvars[0])) {
                        in = agent.openInputStream(TermUtils.toJavaString(tvars[0]));
                        closeIn = true;
                        break block17;
                    }
                    if (TermUtils.isAppl(tvars[0], "stdin")) {
                        in = agent.internalGetInputStream(0);
                        closeIn = false;
                        break block17;
                    }
                    return false;
                }
                catch (IOException e) {
                    agent.printError("SSL_copy: Could not copy file (" + e.getMessage() + "-" + "attempted to copy to " + tvars[1]);
                    return false;
                }
            }
            if (TermUtils.isString(tvars[1])) {
                out = agent.openFileOutputStream(TermUtils.toJavaString(tvars[1]));
                closeOut = true;
                break block18;
            }
            if (TermUtils.isAppl(tvars[1], "stdout")) {
                out = agent.internalGetOutputStream(1);
                closeOut = false;
                break block18;
            }
            if (TermUtils.isAppl(tvars[1], "stderr")) {
                out = agent.internalGetOutputStream(2);
                closeOut = false;
                break block18;
            }
            return false;
        }
        try {
            if (in instanceof FileInputStream && out instanceof FileOutputStream) {
                FileChannel inChannel = ((FileInputStream)in).getChannel();
                FileChannel outChannel = ((FileOutputStream)out).getChannel();
                inChannel.transferTo(0L, inChannel.size(), outChannel);
            } else {
                Utils.copy(in, out);
            }
        }
        finally {
            if (closeOut) {
                out.close();
            }
            if (closeIn) {
                in.close();
            }
        }
        return true;
    }

    private boolean isSameFile(IStrategoTerm[] tvars, IOAgent agent) {
        if (TermUtils.isString(tvars[0]) && TermUtils.isString(tvars[1])) {
            File file1 = agent.openFile(TermUtils.toJavaString(tvars[0]));
            File file2 = agent.openFile(TermUtils.toJavaString(tvars[1]));
            try {
                if (file1.exists() && file1.getCanonicalPath().equals(file2.getCanonicalPath())) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

