/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;

public class UniqueQueue<T>
implements Queue<T>,
Set<T> {
    private final Queue<T> queue;
    private final Set<T> set;

    public UniqueQueue() {
        this.queue = new LinkedList<T>();
        this.set = new HashSet<T>();
    }

    public UniqueQueue(Queue<T> queue, Set<T> set) {
        this.queue = queue;
        this.set = set;
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <TA> TA[] toArray(TA[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        this.set.remove(o);
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean added = false;
        for (T e : c) {
            if (!this.set.add(e)) continue;
            added = true;
            this.queue.add(e);
        }
        return added;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.set.removeAll(c);
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.set.retainAll(c);
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
        this.set.clear();
    }

    @Override
    public boolean add(T e) {
        if (this.set.add(e)) {
            return this.queue.add(e);
        }
        return false;
    }

    @Override
    public boolean offer(T e) {
        if (this.set.add(e)) {
            return this.queue.offer(e);
        }
        return false;
    }

    @Override
    public T remove() {
        T e = this.queue.remove();
        this.set.remove(e);
        return e;
    }

    @Override
    public T poll() {
        T e = this.queue.poll();
        if (e != null) {
            this.set.remove(e);
        }
        return e;
    }

    @Override
    public T element() {
        return this.queue.element();
    }

    @Override
    public T peek() {
        return this.queue.peek();
    }
}

