/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.metaborg.util.collection.IInverseFunction;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.tuple.Tuple2;

public interface IFunction<K, V> {
    public IInverseFunction<V, K> inverse();

    public boolean containsKey(K var1);

    public boolean containsEntry(K var1, V var2);

    public boolean containsValue(V var1);

    public Set<K> keySet();

    public Set<Map.Entry<K, V>> entrySet();

    public Set<V> valueSet();

    public Optional<V> get(K var1);

    default public Stream<Tuple2<K, V>> stream() {
        return this.stream(Tuple2::of);
    }

    default public <R> Stream<R> stream(Function2<K, V, R> converter) {
        return this.keySet().stream().map(key -> converter.apply(key, this.get(key).get()));
    }

    public static interface Immutable<K, V>
    extends IFunction<K, V> {
        @Override
        public IInverseFunction.Immutable<V, K> inverse();

        public Transient<K, V> melt();
    }

    public static interface Transient<K, V>
    extends IFunction<K, V> {
        public V put(K var1, V var2);

        public void putAll(IFunction<K, V> var1);

        public boolean remove(K var1);

        @Override
        public IInverseFunction.Transient<V, K> inverse();

        public Immutable<K, V> freeze();
    }
}

