/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.collection;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.metaborg.util.collection.Bag;
import org.metaborg.util.collection.Sets;

@Deprecated
public abstract class BagMap<K, V> {
    protected abstract Map<K, ? extends Bag<V>> backingMap();

    public abstract Bag<V> get(K var1);

    public int size() {
        return this.backingMap().values().stream().mapToInt(Collection::size).sum();
    }

    public boolean isEmpty() {
        return this.backingMap().isEmpty();
    }

    public boolean containsKey(K key) {
        return this.backingMap().containsKey(key);
    }

    public boolean containsValue(V value) {
        return this.backingMap().values().stream().anyMatch(b -> b.contains(value));
    }

    public Collection<K> keys() {
        return this.backingMap().entrySet().stream().flatMap(e -> {
            Object key = e.getKey();
            return ((Bag)e.getValue()).stream().map(v -> key);
        }).collect(Collectors.toList());
    }

    public Collection<V> values() {
        return this.backingMap().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<Map.Entry<K, V>> entries() {
        return this.backingMap().entrySet().stream().flatMap(e -> {
            Object key = e.getKey();
            return ((Bag)e.getValue()).stream().map(v -> new AbstractMap.SimpleImmutableEntry<Object, Object>(key, v));
        }).collect(Collectors.toList());
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        for (Map.Entry<K, V> entry : this.entries()) {
            action.accept(entry.getKey(), entry.getValue());
        }
    }

    @Deprecated
    public static class Immutable<K, V>
    extends BagMap<K, V> {
        private final Map<K, Bag.Transient<V>> backingMap;

        private Immutable(Map<K, Bag.Transient<V>> backingMap) {
            this.backingMap = backingMap;
        }

        public static <K, V> Immutable<K, V> of() {
            return new Immutable(Collections.emptyMap());
        }

        @Override
        protected Map<K, ? extends Bag<V>> backingMap() {
            return this.backingMap;
        }

        @Override
        public Bag.Immutable<V> get(K key) {
            return this.backingMap.get(key).freeze();
        }

        public Transient<K, V> asTransient() {
            HashMap<K, Bag.Transient<V>> transientBackingMap = new HashMap<K, Bag.Transient<V>>(Sets.hashCapacity(this.backingMap.size()));
            for (Map.Entry<K, Bag.Transient<V>> e : this.backingMap.entrySet()) {
                transientBackingMap.put(e.getKey(), e.getValue().freeze().asTransient());
            }
            return new Transient(transientBackingMap);
        }
    }

    @Deprecated
    public static class Transient<K, V>
    extends BagMap<K, V> {
        private final Map<K, Bag.Transient<V>> backingMap;
        private Immutable<K, V> frozen = null;

        private Transient(Map<K, Bag.Transient<V>> backingMap) {
            this.backingMap = backingMap;
        }

        public static <K, V> Transient<K, V> of() {
            return new Transient(new HashMap());
        }

        public static <K, V> Transient<K, V> withSizeEstimate(int initialCapacity) {
            return new Transient(new HashMap(Sets.hashCapacity(initialCapacity)));
        }

        @Override
        protected Map<K, ? extends Bag<V>> backingMap() {
            return this.backingMap;
        }

        @Override
        public Bag.Transient<V> get(K key) {
            return this.backingMap.get(key);
        }

        public void put(K key, V value) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            this.backingMap.computeIfAbsent(key, k -> Bag.Transient.of()).add(value);
        }

        public boolean remove(K key, V value) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            AtomicBoolean present = new AtomicBoolean(false);
            this.backingMap.computeIfPresent(key, (k, v) -> {
                present.set(v.remove(value));
                return v.isEmpty() ? null : v;
            });
            return present.get();
        }

        public Bag<V> removeAll(K key) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            Bag.Transient removed = this.backingMap.remove(key);
            return removed != null ? removed : Bag.Transient.of();
        }

        public boolean removeAll(Collection<K> keys, V value) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            boolean changed = false;
            for (K key : keys) {
                changed |= this.remove(key, value);
            }
            return changed;
        }

        public void putAll(Map<? extends K, ? extends V> m) {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            for (Map.Entry<K, V> entry : m.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public void clear() {
            if (this.frozen != null) {
                throw new IllegalStateException();
            }
            this.backingMap.clear();
        }

        public Immutable<K, V> freeze() {
            if (this.frozen == null) {
                this.frozen = new Immutable(Collections.unmodifiableMap(this.backingMap));
            }
            return this.frozen;
        }
    }
}

